/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.executors;

import java.util.Collection;
import java.util.Collections;
import java.util.OptionalLong;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdPutBlobSegmentCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.generic.FirebirdGenericResponsePacket;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.upload.FirebirdBlobUploadCache;

public final class FirebirdPutBlobSegmentCommandExecutor
implements CommandExecutor {
    private final FirebirdPutBlobSegmentCommandPacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket> execute() {
        FirebirdBlobUploadCache.getInstance().appendSegment(this.connectionSession.getConnectionId(), this.packet.getBlobHandle(), this.packet.getSegment());
        OptionalLong blobId = FirebirdBlobUploadCache.getInstance().getBlobId(this.connectionSession.getConnectionId(), this.packet.getBlobHandle());
        long responseBlobId = blobId.isPresent() ? blobId.getAsLong() : 0L;
        FirebirdGenericResponsePacket response = new FirebirdGenericResponsePacket().setWriteZeroStatementId(true).setId(responseBlobId);
        return Collections.singleton(response);
    }

    @Generated
    public FirebirdPutBlobSegmentCommandExecutor(FirebirdPutBlobSegmentCommandPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

