/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.fetch;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;

public final class FirebirdFetchStatementCache {
    private static final FirebirdFetchStatementCache INSTANCE = new FirebirdFetchStatementCache();
    private final Map<Integer, Map<Integer, ProxyBackendHandler>> statementRegistry = new ConcurrentHashMap<Integer, Map<Integer, ProxyBackendHandler>>();

    public static FirebirdFetchStatementCache getInstance() {
        return INSTANCE;
    }

    public void registerConnection(int connectionId) {
        this.statementRegistry.put(connectionId, new LinkedHashMap());
    }

    public void registerStatement(int connectionId, int statementId, ProxyBackendHandler proxyBackendHandler) {
        this.statementRegistry.get(connectionId).put(statementId, proxyBackendHandler);
    }

    public ProxyBackendHandler getFetchBackendHandler(int connectionId, int statementId) {
        return this.statementRegistry.get(connectionId).get(statementId);
    }

    public void unregisterStatement(int connectionId, int statementId) {
        this.statementRegistry.get(connectionId).remove(statementId);
    }

    public void unregisterConnection(int connectionId) {
        this.statementRegistry.remove(connectionId);
    }
}

