/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.fetch;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.binary.BinaryCell;
import org.apache.shardingsphere.database.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.database.protocol.binary.BinaryRow;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.FirebirdBinaryColumnType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.FirebirdFetchStatementPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.generic.FirebirdFetchResponsePacket;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.fetch.FirebirdFetchStatementCache;

public final class FirebirdFetchStatementCommandExecutor
implements CommandExecutor {
    private final FirebirdFetchStatementPacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket> execute() throws SQLException {
        LinkedList<DatabasePacket> result = new LinkedList<DatabasePacket>();
        ProxyBackendHandler proxyBackendHandler = FirebirdFetchStatementCache.getInstance().getFetchBackendHandler(this.connectionSession.getConnectionId(), this.packet.getStatementId());
        if (null == proxyBackendHandler) {
            result.add((DatabasePacket)FirebirdFetchResponsePacket.getFetchNoMoreRowsPacket());
            return result;
        }
        for (int i = 0; i < this.packet.getFetchSize(); ++i) {
            if (!proxyBackendHandler.next()) {
                this.connectionSession.getDatabaseConnectionManager().unmarkResourceInUse(proxyBackendHandler);
                result.add((DatabasePacket)FirebirdFetchResponsePacket.getFetchNoMoreRowsPacket());
                return result;
            }
            QueryResponseRow queryResponseRow = proxyBackendHandler.getRowData();
            BinaryRow row = this.createBinaryRow(queryResponseRow);
            result.add((DatabasePacket)FirebirdFetchResponsePacket.getFetchRowPacket((BinaryRow)row));
        }
        result.add((DatabasePacket)FirebirdFetchResponsePacket.getFetchEndPacket());
        return result;
    }

    private BinaryRow createBinaryRow(QueryResponseRow queryResponseRow) {
        ArrayList<BinaryCell> result = new ArrayList<BinaryCell>(queryResponseRow.getCells().size());
        for (QueryResponseCell each : queryResponseRow.getCells()) {
            result.add(new BinaryCell((BinaryColumnType)FirebirdBinaryColumnType.valueOfJDBCType((int)each.getJdbcType()), each.getData()));
        }
        return new BinaryRow(result);
    }

    @Generated
    public FirebirdFetchStatementCommandExecutor(FirebirdFetchStatementPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

