/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.transaction;

import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.transaction.FirebirdStartTransactionPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.generic.FirebirdGenericResponsePacket;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.transaction.FirebirdTransactionIdGenerator;

public final class FirebirdStartTransactionCommandExecutor
implements CommandExecutor {
    private final FirebirdStartTransactionPacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket> execute() {
        this.connectionSession.setAutoCommit(this.packet.isAutoCommit());
        this.connectionSession.setReadOnly(this.packet.isReadOnly());
        this.connectionSession.setIsolationLevel(this.packet.getIsolationLevel());
        int transactionId = FirebirdTransactionIdGenerator.getInstance().nextTransactionId(this.connectionSession.getConnectionId());
        return Collections.singleton(new FirebirdGenericResponsePacket().setHandle(transactionId));
    }

    @Generated
    public FirebirdStartTransactionCommandExecutor(FirebirdStartTransactionPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

