/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.util;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;

public final class SensitiveInfoUtils {
    private static final String FAKE_IP_SAMPLE = "ip";
    private static final Pattern IP_PATTERN = Pattern.compile("((\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)){3})");

    public static List<String> filterSensitiveIps(List<String> target) {
        HashMap fakeIpMap = new HashMap();
        AtomicInteger step = new AtomicInteger();
        return target.stream().map(input -> {
            Matcher matcher = IP_PATTERN.matcher((CharSequence)input);
            String result = input;
            while (matcher.find()) {
                String fakeIp;
                String realIp = matcher.group();
                if (fakeIpMap.containsKey(realIp)) {
                    fakeIp = (String)fakeIpMap.get(realIp);
                } else {
                    fakeIp = FAKE_IP_SAMPLE + step.incrementAndGet();
                    fakeIpMap.put(realIp, fakeIp);
                }
                result = result.replace(realIp, fakeIp);
            }
            return result;
        }).collect(Collectors.toList());
    }

    @Generated
    private SensitiveInfoUtils() {
    }
}

