/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.exception.core;

import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.exception.core.exception.SQLDialectException;
import org.apache.shardingsphere.database.exception.core.exception.protocol.DatabaseProtocolException;
import org.apache.shardingsphere.database.exception.core.mapper.SQLDialectExceptionMapper;
import org.apache.shardingsphere.infra.exception.external.server.ShardingSphereServerException;
import org.apache.shardingsphere.infra.exception.external.sql.ShardingSphereSQLException;
import org.apache.shardingsphere.infra.exception.generic.DatabaseProtocolSQLException;
import org.apache.shardingsphere.infra.exception.generic.ServerSQLException;
import org.apache.shardingsphere.infra.exception.generic.UnknownSQLException;

public final class SQLExceptionTransformEngine {
    public static SQLException toSQLException(Exception cause, DatabaseType databaseType) {
        if (cause instanceof SQLException) {
            return (SQLException)cause;
        }
        if (cause instanceof ShardingSphereSQLException) {
            return ((ShardingSphereSQLException)cause).toSQLException();
        }
        if (cause instanceof SQLDialectException) {
            if (cause instanceof DatabaseProtocolException) {
                return new DatabaseProtocolSQLException(cause.getMessage()).toSQLException();
            }
            Optional dialectExceptionMapper = DatabaseTypedSPILoader.findService(SQLDialectExceptionMapper.class, (DatabaseType)databaseType);
            if (dialectExceptionMapper.isPresent()) {
                return ((SQLDialectExceptionMapper)dialectExceptionMapper.get()).convert((SQLDialectException)((Object)cause));
            }
        }
        if (cause instanceof ShardingSphereServerException) {
            return new ServerSQLException(cause).toSQLException();
        }
        return new UnknownSQLException(cause).toSQLException();
    }

    @Generated
    private SQLExceptionTransformEngine() {
    }
}

