/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.hive.visitor.statement.type;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DMLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.HiveStatementParser;
import org.apache.shardingsphere.sql.parser.engine.hive.visitor.statement.HiveStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.enums.AggregationType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.CombineType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.JoinType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.OrderDirection;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.PartitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CaseWhenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExistsSubqueryExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionWithParamsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ValuesExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.merge.MergeWhenAndThenSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.NumberLiteralLimitValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.ParameterMarkerLimitValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.LockSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.table.MultiTableInsertIntoSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.table.MultiTableInsertType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeLengthSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParameterMarkerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WindowItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WindowSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.DeleteMultiTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.MergeStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.OtherLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.parametermarker.ParameterMarkerValue;
import org.apache.shardingsphere.sql.parser.statement.mysql.dml.MySQLLoadDataStatement;

public final class HiveDMLStatementVisitor
extends HiveStatementVisitor
implements DMLStatementVisitor {
    public HiveDMLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitSubquery(HiveStatementParser.SubqueryContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.queryExpressionParens());
    }

    @Override
    public ASTNode visitQueryExpressionParens(HiveStatementParser.QueryExpressionParensContext ctx) {
        if (null != ctx.queryExpressionParens()) {
            return (ASTNode)this.visit((ParseTree)ctx.queryExpressionParens());
        }
        SelectStatement result = (SelectStatement)this.visit((ParseTree)ctx.queryExpression());
        if (null != ctx.lockClauseList()) {
            result.setLock((LockSegment)this.visit((ParseTree)ctx.lockClauseList()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitLockClauseList(HiveStatementParser.LockClauseListContext ctx) {
        LockSegment result = new LockSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        for (HiveStatementParser.LockClauseContext each : ctx.lockClause()) {
            if (null == each.tableLockingList()) continue;
            result.getTables().addAll(this.generateTablesFromTableAliasRefList(each.tableLockingList().tableAliasRefList()));
        }
        return result;
    }

    @Override
    public ASTNode visitQueryExpression(HiveStatementParser.QueryExpressionContext ctx) {
        SelectStatement result = null != ctx.queryExpressionBody() ? (SelectStatement)this.visit((ParseTree)ctx.queryExpressionBody()) : (SelectStatement)this.visit((ParseTree)ctx.queryExpressionParens());
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        if (null != ctx.limitClause()) {
            result.setLimit((LimitSegment)this.visit((ParseTree)ctx.limitClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitSelectWithInto(HiveStatementParser.SelectWithIntoContext ctx) {
        if (null != ctx.selectWithInto()) {
            return (ASTNode)this.visit((ParseTree)ctx.selectWithInto());
        }
        SelectStatement result = (SelectStatement)this.visit((ParseTree)ctx.queryExpression());
        if (null != ctx.lockClauseList()) {
            result.setLock((LockSegment)this.visit((ParseTree)ctx.lockClauseList()));
        }
        return result;
    }

    @Override
    public ASTNode visitQueryExpressionBody(HiveStatementParser.QueryExpressionBodyContext ctx) {
        if (1 == ctx.getChildCount() && ctx.getChild(0) instanceof HiveStatementParser.QueryPrimaryContext) {
            return (ASTNode)this.visit((ParseTree)ctx.queryPrimary());
        }
        if (null != ctx.queryExpressionBody()) {
            SelectStatement result = new SelectStatement(this.getDatabaseType());
            SubquerySegment left = new SubquerySegment(ctx.queryExpressionBody().start.getStartIndex(), ctx.queryExpressionBody().stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.queryExpressionBody()), this.getOriginalText(ctx.queryExpressionBody()));
            result.setProjections(left.getSelect().getProjections());
            left.getSelect().getFrom().ifPresent(arg_0 -> ((SelectStatement)result).setFrom(arg_0));
            result.setCombine(this.createCombineSegment(ctx.combineClause(), left));
            return result;
        }
        if (null != ctx.queryExpressionParens()) {
            SelectStatement result = new SelectStatement(this.getDatabaseType());
            SubquerySegment left = new SubquerySegment(ctx.queryExpressionParens().start.getStartIndex(), ctx.queryExpressionParens().stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)ctx.queryExpressionParens()), this.getOriginalText(ctx.queryExpressionParens()));
            result.setProjections(left.getSelect().getProjections());
            left.getSelect().getFrom().ifPresent(arg_0 -> ((SelectStatement)result).setFrom(arg_0));
            result.setCombine(this.createCombineSegment(ctx.combineClause(), left));
            return result;
        }
        return (ASTNode)this.visit((ParseTree)ctx.queryExpressionParens());
    }

    private CombineSegment createCombineSegment(HiveStatementParser.CombineClauseContext ctx, SubquerySegment left) {
        CombineType combineType = null != ctx.EXCEPT() ? CombineType.EXCEPT : (null == ctx.combineOption() || null == ctx.combineOption().ALL() ? CombineType.UNION : CombineType.UNION_ALL);
        ParserRuleContext ruleContext = null == ctx.queryPrimary() ? ctx.queryExpressionParens() : ctx.queryPrimary();
        SubquerySegment right = new SubquerySegment(ruleContext.start.getStartIndex(), ruleContext.stop.getStopIndex(), (SelectStatement)this.visit((ParseTree)ruleContext), this.getOriginalText(ruleContext));
        return new CombineSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), left, combineType, right);
    }

    @Override
    public ASTNode visitQuerySpecification(HiveStatementParser.QuerySpecificationContext ctx) {
        SelectStatement result = new SelectStatement(this.getDatabaseType());
        result.setProjections((ProjectionsSegment)this.visit((ParseTree)ctx.projections()));
        if (null != ctx.selectSpecification()) {
            result.getProjections().setDistinctRow(this.isDistinct(ctx));
        }
        if (null != ctx.fromClause()) {
            TableSegment tableSource;
            if (null != ctx.fromClause().tableReferences()) {
                tableSource = (TableSegment)this.visit((ParseTree)ctx.fromClause().tableReferences());
                result.setFrom(tableSource);
            }
            if (null != ctx.fromClause().DUAL()) {
                tableSource = new SimpleTableSegment(new TableNameSegment(ctx.fromClause().DUAL().getSymbol().getStartIndex(), ctx.fromClause().DUAL().getSymbol().getStopIndex(), new IdentifierValue(ctx.fromClause().DUAL().getText())));
                result.setFrom(tableSource);
            }
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.groupByClause()) {
            result.setGroupBy((GroupBySegment)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (null != ctx.havingClause()) {
            result.setHaving((HavingSegment)this.visit((ParseTree)ctx.havingClause()));
        }
        if (null != ctx.windowClause()) {
            result.setWindow((WindowSegment)this.visit((ParseTree)ctx.windowClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitTableValueConstructor(HiveStatementParser.TableValueConstructorContext ctx) {
        SelectStatement result = new SelectStatement(this.getDatabaseType());
        int startIndex = ctx.getStart().getStartIndex();
        int stopIndex = ctx.getStop().getStopIndex();
        ValuesExpression valuesExpression = new ValuesExpression(startIndex, stopIndex);
        valuesExpression.getRowConstructorList().addAll(this.createRowConstructorList(ctx.rowConstructorList()));
        result.setProjections(new ProjectionsSegment(startIndex, stopIndex));
        result.getProjections().getProjections().add(new ExpressionProjectionSegment(startIndex, stopIndex, this.getOriginalText(ctx), (ExpressionSegment)valuesExpression));
        return result;
    }

    private Collection<InsertValuesSegment> createRowConstructorList(HiveStatementParser.RowConstructorListContext ctx) {
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        for (HiveStatementParser.AssignmentValuesContext each : ctx.assignmentValues()) {
            result.add((InsertValuesSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitTableStatement(HiveStatementParser.TableStatementContext ctx) {
        SelectStatement result = new SelectStatement(this.getDatabaseType());
        if (null != ctx.TABLE()) {
            result.setFrom((TableSegment)new SimpleTableSegment(new TableNameSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.tableName().getText()))));
        } else {
            result.setFrom((TableSegment)((SimpleTableSegment)this.visit((ParseTree)ctx.tableName())));
        }
        return result;
    }

    @Override
    public ASTNode visitWindowClause(HiveStatementParser.WindowClauseContext ctx) {
        WindowSegment result = new WindowSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        for (HiveStatementParser.WindowItemContext each : ctx.windowItem()) {
            result.getItemSegments().add((WindowItemSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitWindowItem(HiveStatementParser.WindowItemContext ctx) {
        WindowItemSegment result = new WindowItemSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        result.setWindowName(new IdentifierValue(ctx.identifier().getText()));
        if (null != ctx.windowSpecification().PARTITION()) {
            result.setPartitionListSegments(this.getExpressionsFromExprList(ctx.windowSpecification().expr()));
        }
        if (null != ctx.windowSpecification().orderByClause()) {
            result.setOrderBySegment((OrderBySegment)this.visit((ParseTree)ctx.windowSpecification().orderByClause()));
        }
        if (null != ctx.windowSpecification().frameClause()) {
            result.setFrameClause((ExpressionSegment)new CommonExpressionSegment(ctx.windowSpecification().frameClause().start.getStartIndex(), ctx.windowSpecification().frameClause().stop.getStopIndex(), ctx.windowSpecification().frameClause().getText()));
        }
        return result;
    }

    private Collection<ExpressionSegment> getExpressionsFromExprList(List<HiveStatementParser.ExprContext> exprList) {
        if (null == exprList) {
            return Collections.emptyList();
        }
        ArrayList<ExpressionSegment> result = new ArrayList<ExpressionSegment>(exprList.size());
        for (HiveStatementParser.ExprContext each : exprList) {
            result.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitHavingClause(HiveStatementParser.HavingClauseContext ctx) {
        ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
        return new HavingSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), expr);
    }

    @Override
    public ASTNode visitIntervalExpression(HiveStatementParser.IntervalExpressionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.INTERVAL().getSymbol().getStartIndex(), ctx.INTERVAL().getSymbol().getStopIndex(), ctx.INTERVAL().getText(), ctx.INTERVAL().getText());
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.intervalValue().expr()));
        result.getParameters().add(new LiteralExpressionSegment(ctx.intervalValue().intervalUnit().getStart().getStartIndex(), ctx.intervalValue().intervalUnit().getStop().getStopIndex(), (Object)ctx.intervalValue().intervalUnit().getText()));
        return result;
    }

    @Override
    public ASTNode visitFunctionCall(HiveStatementParser.FunctionCallContext ctx) {
        if (null != ctx.aggregationFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.aggregationFunction());
        }
        if (null != ctx.specialFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.specialFunction());
        }
        if (null != ctx.regularFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.regularFunction());
        }
        if (null != ctx.jsonFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.jsonFunction());
        }
        if (null != ctx.udfFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.udfFunction());
        }
        throw new IllegalStateException("FunctionCallContext must have aggregationFunction, regularFunction, specialFunction, jsonFunction or udfFunction.");
    }

    @Override
    public ASTNode visitUdfFunction(HiveStatementParser.UdfFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.getOriginalText(ctx), this.getOriginalText(ctx));
        if (null != ctx.expr()) {
            for (HiveStatementParser.ExprContext each : ctx.expr()) {
                result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAggregationFunction(HiveStatementParser.AggregationFunctionContext ctx) {
        String aggregationType = ctx.aggregationFunctionName().getText();
        return AggregationType.isAggregationType((String)aggregationType) ? this.createAggregationSegment(ctx, aggregationType) : new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitJsonFunction(HiveStatementParser.JsonFunctionContext ctx) {
        String functionName;
        HiveStatementParser.JsonFunctionNameContext functionNameContext = ctx.jsonFunctionName();
        if (null != functionNameContext) {
            functionName = functionNameContext.getText();
            for (HiveStatementParser.ExprContext each : ctx.expr()) {
                this.visit((ParseTree)each);
            }
        } else {
            functionName = null != ctx.JSON_SEPARATOR() ? ctx.JSON_SEPARATOR().getText() : ctx.JSON_UNQUOTED_SEPARATOR().getText();
        }
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), functionName, this.getOriginalText(ctx));
    }

    private ASTNode createAggregationSegment(HiveStatementParser.AggregationFunctionContext ctx, String aggregationType) {
        AggregationType type = AggregationType.valueOf((String)aggregationType.toUpperCase());
        String innerExpression = ctx.start.getInputStream().getText(new Interval(ctx.LP_().getSymbol().getStartIndex(), ctx.stop.getStopIndex()));
        if (null != ctx.distinct()) {
            AggregationDistinctProjectionSegment result = new AggregationDistinctProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, innerExpression, this.getDistinctExpression(ctx));
            result.getParameters().addAll(this.getExpressions(ctx));
            return result;
        }
        AggregationProjectionSegment result = new AggregationProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, innerExpression);
        result.getParameters().addAll(this.getExpressions(ctx));
        return result;
    }

    private Collection<ExpressionSegment> getExpressions(HiveStatementParser.AggregationFunctionContext ctx) {
        if (null == ctx.expr()) {
            return Collections.emptyList();
        }
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        for (HiveStatementParser.ExprContext each : ctx.expr()) {
            result.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    private String getDistinctExpression(HiveStatementParser.AggregationFunctionContext ctx) {
        StringBuilder result = new StringBuilder();
        for (int i = 3; i < ctx.getChildCount() - 1; ++i) {
            result.append(ctx.getChild(i).getText());
        }
        return result.toString();
    }

    @Override
    public ASTNode visitSpecialFunction(HiveStatementParser.SpecialFunctionContext ctx) {
        if (null != ctx.groupConcatFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.groupConcatFunction());
        }
        if (null != ctx.windowFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.windowFunction());
        }
        if (null != ctx.castFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.castFunction());
        }
        if (null != ctx.convertFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.convertFunction());
        }
        if (null != ctx.positionFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.positionFunction());
        }
        if (null != ctx.substringFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.substringFunction());
        }
        if (null != ctx.extractFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.extractFunction());
        }
        if (null != ctx.charFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.charFunction());
        }
        if (null != ctx.trimFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.trimFunction());
        }
        if (null != ctx.weightStringFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.weightStringFunction());
        }
        if (null != ctx.valuesFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.valuesFunction());
        }
        if (null != ctx.currentUserFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.currentUserFunction());
        }
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.getOriginalText(ctx), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitGroupConcatFunction(HiveStatementParser.GroupConcatFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.GROUP_CONCAT().getText(), this.getOriginalText(ctx));
        for (HiveStatementParser.ExprContext each : ctx.expr()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitWindowFunction(HiveStatementParser.WindowFunctionContext ctx) {
        super.visitWindowFunction(ctx);
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.funcName.getText(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitCastFunction(HiveStatementParser.CastFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CAST().getText(), this.getOriginalText(ctx));
        for (HiveStatementParser.ExprContext each : ctx.expr()) {
            ASTNode expr = (ASTNode)this.visit((ParseTree)each);
            if (expr instanceof ColumnSegment) {
                result.getParameters().add((ColumnSegment)expr);
                continue;
            }
            if (!(expr instanceof LiteralExpressionSegment)) continue;
            result.getParameters().add((LiteralExpressionSegment)expr);
        }
        if (null != ctx.castType()) {
            result.getParameters().add((DataTypeSegment)this.visit((ParseTree)ctx.castType()));
        }
        if (null != ctx.DATETIME()) {
            DataTypeSegment dataType = new DataTypeSegment();
            dataType.setDataTypeName(ctx.DATETIME().getText());
            dataType.setStartIndex(ctx.DATETIME().getSymbol().getStartIndex());
            dataType.setStopIndex(ctx.DATETIME().getSymbol().getStopIndex());
            if (null != ctx.typeDatetimePrecision()) {
                dataType.setDataLength((DataTypeLengthSegment)this.visit((ParseTree)ctx.typeDatetimePrecision()));
            }
            result.getParameters().add(dataType);
        }
        return result;
    }

    @Override
    public ASTNode visitCastType(HiveStatementParser.CastTypeContext ctx) {
        DataTypeLengthSegment dataTypeLengthSegment;
        DataTypeSegment result = new DataTypeSegment();
        result.setDataTypeName(ctx.castTypeName.getText());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.fieldLength()) {
            dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.fieldLength());
            result.setDataLength(dataTypeLengthSegment);
        }
        if (null != ctx.precision()) {
            dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.precision());
            result.setDataLength(dataTypeLengthSegment);
        }
        return result;
    }

    @Override
    public ASTNode visitConvertFunction(HiveStatementParser.ConvertFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CONVERT().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        if (null != ctx.castType()) {
            result.getParameters().add((DataTypeSegment)this.visit((ParseTree)ctx.castType()));
        } else if (null != ctx.charsetName()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.charsetName()));
        }
        return result;
    }

    @Override
    public ASTNode visitPositionFunction(HiveStatementParser.PositionFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.POSITION().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr(0)));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr(1)));
        return result;
    }

    @Override
    public ASTNode visitSubstringFunction(HiveStatementParser.SubstringFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), null == ctx.SUBSTR() ? ctx.SUBSTRING().getText() : ctx.SUBSTR().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        for (TerminalNode each : ctx.NUMBER_()) {
            result.getParameters().add(new LiteralExpressionSegment(each.getSymbol().getStartIndex(), each.getSymbol().getStopIndex(), (Object)new NumberLiteralValue(each.getText()).getValue()));
        }
        return result;
    }

    @Override
    public ASTNode visitExtractFunction(HiveStatementParser.ExtractFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.EXTRACT().getText(), this.getOriginalText(ctx));
        result.getParameters().add(new LiteralExpressionSegment(ctx.identifier().getStart().getStartIndex(), ctx.identifier().getStop().getStopIndex(), (Object)ctx.identifier().getText()));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        return result;
    }

    @Override
    public ASTNode visitCharFunction(HiveStatementParser.CharFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CHAR().getText(), this.getOriginalText(ctx));
        for (HiveStatementParser.ExprContext each : ctx.expr()) {
            ASTNode expr = (ASTNode)this.visit((ParseTree)each);
            result.getParameters().add((ExpressionSegment)expr);
        }
        return result;
    }

    @Override
    public ASTNode visitTrimFunction(HiveStatementParser.TrimFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.TRIM().getText(), this.getOriginalText(ctx));
        if (null != ctx.BOTH()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.BOTH().getSymbol().getStartIndex(), ctx.BOTH().getSymbol().getStopIndex(), (Object)new OtherLiteralValue(ctx.BOTH().getSymbol().getText()).getValue()));
        }
        if (null != ctx.TRAILING()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.TRAILING().getSymbol().getStartIndex(), ctx.TRAILING().getSymbol().getStopIndex(), (Object)new OtherLiteralValue(ctx.TRAILING().getSymbol().getText()).getValue()));
        }
        if (null != ctx.LEADING()) {
            result.getParameters().add(new LiteralExpressionSegment(ctx.LEADING().getSymbol().getStartIndex(), ctx.LEADING().getSymbol().getStopIndex(), (Object)new OtherLiteralValue(ctx.LEADING().getSymbol().getText()).getValue()));
        }
        for (HiveStatementParser.ExprContext each : ctx.expr()) {
            result.getParameters().add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitWeightStringFunction(HiveStatementParser.WeightStringFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.WEIGHT_STRING().getText(), this.getOriginalText(ctx));
        result.getParameters().add((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        return result;
    }

    @Override
    public ASTNode visitValuesFunction(HiveStatementParser.ValuesFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.VALUES().getText(), this.getOriginalText(ctx));
        if (!ctx.columnRefList().columnRef().isEmpty()) {
            ColumnSegment columnSegment = (ColumnSegment)this.visit((ParseTree)ctx.columnRefList().columnRef(0));
            result.getParameters().add(columnSegment);
        }
        return result;
    }

    @Override
    public ASTNode visitCurrentUserFunction(HiveStatementParser.CurrentUserFunctionContext ctx) {
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CURRENT_USER().getText(), this.getOriginalText(ctx));
    }

    @Override
    public ASTNode visitRegularFunction(HiveStatementParser.RegularFunctionContext ctx) {
        return null == ctx.completeRegularFunction() ? (ASTNode)this.visit((ParseTree)ctx.shorthandRegularFunction()) : (ASTNode)this.visit((ParseTree)ctx.completeRegularFunction());
    }

    @Override
    public ASTNode visitCompleteRegularFunction(HiveStatementParser.CompleteRegularFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.regularFunctionName().getText(), this.getOriginalText(ctx));
        Collection expressionSegments = ctx.expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        result.getParameters().addAll(expressionSegments);
        return result;
    }

    @Override
    public ASTNode visitShorthandRegularFunction(HiveStatementParser.ShorthandRegularFunctionContext ctx) {
        FunctionSegment result;
        String text = this.getOriginalText(ctx);
        if (null != ctx.CURRENT_TIME()) {
            result = new FunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.CURRENT_TIME().getText(), text);
            if (null != ctx.NUMBER_()) {
                result.getParameters().add(new LiteralExpressionSegment(ctx.NUMBER_().getSymbol().getStartIndex(), ctx.NUMBER_().getSymbol().getStopIndex(), (Object)new NumberLiteralValue(ctx.NUMBER_().getText())));
            }
        } else {
            result = new FunctionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.getText(), text);
        }
        return result;
    }

    @Override
    public ASTNode visitCaseExpression(HiveStatementParser.CaseExpressionContext ctx) {
        LinkedList<ExpressionSegment> whenExprs = new LinkedList<ExpressionSegment>();
        LinkedList<ExpressionSegment> thenExprs = new LinkedList<ExpressionSegment>();
        for (HiveStatementParser.CaseWhenContext each : ctx.caseWhen()) {
            whenExprs.add((ExpressionSegment)this.visit((ParseTree)each.expr(0)));
            thenExprs.add((ExpressionSegment)this.visit((ParseTree)each.expr(1)));
        }
        ExpressionSegment caseExpr = null == ctx.simpleExpr() ? null : (ExpressionSegment)this.visit((ParseTree)ctx.simpleExpr());
        ExpressionSegment elseExpr = null == ctx.caseElse() ? null : (ExpressionSegment)this.visit((ParseTree)ctx.caseElse().expr());
        return new CaseWhenExpression(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), caseExpr, whenExprs, thenExprs, elseExpr);
    }

    @Override
    public ASTNode visitVariable(HiveStatementParser.VariableContext ctx) {
        return null == ctx.systemVariable() ? (ASTNode)this.visit((ParseTree)ctx.userVariable()) : (ASTNode)this.visit((ParseTree)ctx.systemVariable());
    }

    @Override
    public ASTNode visitUserVariable(HiveStatementParser.UserVariableContext ctx) {
        return new VariableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.textOrIdentifier().getText());
    }

    @Override
    public ASTNode visitSystemVariable(HiveStatementParser.SystemVariableContext ctx) {
        VariableSegment result = new VariableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.rvalueSystemVariable().getText());
        if (null != ctx.systemVariableScope) {
            result.setScope(ctx.systemVariableScope.getText());
        }
        return result;
    }

    @Override
    public ASTNode visitMatchExpression(HiveStatementParser.MatchExpressionContext ctx) {
        this.visit((ParseTree)ctx.expr());
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), text);
    }

    @Override
    public ASTNode visitDataType(HiveStatementParser.DataTypeContext ctx) {
        DataTypeLengthSegment dataTypeLengthSegment;
        DataTypeSegment result = new DataTypeSegment();
        result.setDataTypeName(ctx.dataTypeName.getText());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.fieldLength()) {
            dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.fieldLength());
            result.setDataLength(dataTypeLengthSegment);
        }
        if (null != ctx.precision()) {
            dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.precision());
            result.setDataLength(dataTypeLengthSegment);
        }
        return result;
    }

    @Override
    public ASTNode visitFieldLength(HiveStatementParser.FieldLengthContext ctx) {
        DataTypeLengthSegment result = new DataTypeLengthSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStartIndex());
        result.setPrecision(new BigDecimal(ctx.length.getText()).intValue());
        return result;
    }

    @Override
    public ASTNode visitPrecision(HiveStatementParser.PrecisionContext ctx) {
        DataTypeLengthSegment result = new DataTypeLengthSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStartIndex());
        List<TerminalNode> numbers = ctx.NUMBER_();
        result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
        result.setScale(Integer.parseInt(numbers.get(1).getText()));
        return result;
    }

    @Override
    public ASTNode visitTypeDatetimePrecision(HiveStatementParser.TypeDatetimePrecisionContext ctx) {
        DataTypeLengthSegment result = new DataTypeLengthSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStartIndex());
        result.setPrecision(Integer.parseInt(ctx.NUMBER_().getText()));
        return result;
    }

    @Override
    public ASTNode visitOrderByClause(HiveStatementParser.OrderByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (HiveStatementParser.OrderByItemContext each : ctx.orderByItem()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new OrderBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    @Override
    public ASTNode visitOrderByItem(HiveStatementParser.OrderByItemContext ctx) {
        OrderDirection orderDirection = null != ctx.direction() ? (null == ctx.direction().DESC() ? OrderDirection.ASC : OrderDirection.DESC) : OrderDirection.ASC;
        if (null != ctx.numberLiterals()) {
            return new IndexOrderByItemSegment(ctx.numberLiterals().getStart().getStartIndex(), ctx.numberLiterals().getStop().getStopIndex(), SQLUtils.getExactlyNumber((String)ctx.numberLiterals().getText(), (int)10).intValue(), orderDirection, null);
        }
        ASTNode expr = this.visitExpr(ctx.expr());
        if (expr instanceof ColumnSegment) {
            return new ColumnOrderByItemSegment((ColumnSegment)expr, orderDirection, null);
        }
        return new ExpressionOrderByItemSegment(ctx.expr().getStart().getStartIndex(), ctx.expr().getStop().getStopIndex(), this.getOriginalText(ctx.expr()), orderDirection, null, (ExpressionSegment)expr);
    }

    @Override
    public ASTNode visitInsert(HiveStatementParser.InsertContext ctx) {
        InsertStatement result;
        if (null != ctx.insertDataIntoTablesFromQueries()) {
            return (ASTNode)this.visit((ParseTree)ctx.insertDataIntoTablesFromQueries());
        }
        if (null != ctx.writingDataIntoFileSystem()) {
            return (ASTNode)this.visit((ParseTree)ctx.writingDataIntoFileSystem());
        }
        if (null != ctx.insertingValuesIntoTables()) {
            return (ASTNode)this.visit((ParseTree)ctx.insertingValuesIntoTables());
        }
        if (null != ctx.insertValuesClause()) {
            result = (InsertStatement)this.visit((ParseTree)ctx.insertValuesClause());
        } else if (null != ctx.insertSelectClause()) {
            result = (InsertStatement)this.visit((ParseTree)ctx.insertSelectClause());
        } else {
            result = new InsertStatement(this.getDatabaseType());
            result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.setAssignmentsClause()));
        }
        if (null != ctx.onDuplicateKeyClause()) {
            result.setOnDuplicateKeyColumns((OnDuplicateKeyColumnsSegment)this.visit((ParseTree)ctx.onDuplicateKeyClause()));
        }
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitInsertDataIntoTablesFromQueries(HiveStatementParser.InsertDataIntoTablesFromQueriesContext ctx) {
        if (null != ctx.standardSyntax()) {
            return (ASTNode)this.visit((ParseTree)ctx.standardSyntax());
        }
        if (null != ctx.multipleInserts()) {
            return (ASTNode)this.visit((ParseTree)ctx.multipleInserts());
        }
        if (null != ctx.dynamicPartitionInserts()) {
            return (ASTNode)this.visit((ParseTree)ctx.dynamicPartitionInserts());
        }
        throw new IllegalStateException("InsertDataIntoTablesFromQueriesContext must have standardSyntax, multipleInserts or dynamicPartitionInserts.");
    }

    @Override
    public ASTNode visitStandardSyntax(HiveStatementParser.StandardSyntaxContext ctx) {
        return this.createHiveInsertStatement(ctx.tableName(), ctx.select(), ctx.start.getStartIndex());
    }

    @Override
    public ASTNode visitMultipleInserts(HiveStatementParser.MultipleInsertsContext ctx) {
        TableSegment sourceTable = null;
        if (null != ctx.fromClause()) {
            sourceTable = (TableSegment)this.visit((ParseTree)ctx.fromClause());
        }
        return this.visitHiveMultipleInserts(ctx.hiveMultipleInserts(), sourceTable);
    }

    @Override
    public ASTNode visitDynamicPartitionInserts(HiveStatementParser.DynamicPartitionInsertsContext ctx) {
        return this.createHiveInsertStatement(ctx.tableName(), ctx.select(), ctx.start.getStartIndex());
    }

    @Override
    public ASTNode visitHiveMultipleInserts(HiveStatementParser.HiveMultipleInsertsContext ctx) {
        return this.visitHiveMultipleInserts(ctx, null);
    }

    private ASTNode visitHiveMultipleInserts(HiveStatementParser.HiveMultipleInsertsContext ctx, TableSegment sourceTable) {
        List<HiveStatementParser.HiveInsertStatementContext> insertStatements = ctx.hiveInsertStatement();
        if (1 == insertStatements.size()) {
            InsertStatement single = (InsertStatement)this.visit((ParseTree)insertStatements.get(0));
            if (null != sourceTable) {
                single.getInsertSelect().ifPresent(subquery -> this.setFromForSelect((SubquerySegment)subquery, sourceTable));
            }
            single.addParameterMarkers(this.getParameterMarkerSegments());
            return single;
        }
        InsertStatement result = new InsertStatement(this.getDatabaseType());
        result.setMultiTableInsertType(MultiTableInsertType.ALL);
        MultiTableInsertIntoSegment multiTableInsertInto = new MultiTableInsertIntoSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        for (HiveStatementParser.HiveInsertStatementContext each : insertStatements) {
            InsertStatement insertStmt = (InsertStatement)this.visit((ParseTree)each);
            if (null != sourceTable) {
                insertStmt.getInsertSelect().ifPresent(subquery -> this.setFromForSelect((SubquerySegment)subquery, sourceTable));
            }
            insertStmt.addParameterMarkers(this.getParameterMarkerSegments());
            insertStmt.buildAttributes();
            multiTableInsertInto.getInsertStatements().add(insertStmt);
        }
        result.setMultiTableInsertInto(multiTableInsertInto);
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    private void setFromForSelect(SubquerySegment subquery, TableSegment sourceTable) {
        Optional.ofNullable(subquery.getSelect()).ifPresent(selectStmt -> selectStmt.setFrom(sourceTable));
    }

    private InsertStatement createHiveInsertStatement(HiveStatementParser.TableNameContext tableName, HiveStatementParser.SelectContext select, int startIndex) {
        InsertStatement result = new InsertStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)tableName));
        result.setInsertColumns(new InsertColumnsSegment(startIndex, startIndex, Collections.emptyList()));
        result.setInsertSelect(this.createInsertSelectSegment(select));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitHiveInsertStatement(HiveStatementParser.HiveInsertStatementContext ctx) {
        InsertStatement result = new InsertStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.setInsertColumns(new InsertColumnsSegment(ctx.start.getStartIndex(), ctx.start.getStartIndex(), Collections.emptyList()));
        if (null != ctx.select()) {
            result.setInsertSelect(this.createInsertSelectSegment(ctx.select()));
        }
        return result;
    }

    @Override
    public ASTNode visitDynamicPartitionClause(HiveStatementParser.DynamicPartitionClauseContext ctx) {
        return new PartitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue("partition"));
    }

    @Override
    public ASTNode visitDynamicPartitionKey(HiveStatementParser.DynamicPartitionKeyContext ctx) {
        return new PartitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.identifier().getText()));
    }

    @Override
    public ASTNode visitWritingDataIntoFileSystem(HiveStatementParser.WritingDataIntoFileSystemContext ctx) {
        TableSegment sourceTable;
        List<HiveStatementParser.InsertOverwriteStandardSyntaxContext> statements = ctx.insertOverwriteStandardSyntax();
        if (1 == statements.size() && null == ctx.fromClause()) {
            return (ASTNode)this.visit((ParseTree)statements.get(0));
        }
        TableSegment tableSegment = sourceTable = null != ctx.fromClause() ? (TableSegment)this.visit((ParseTree)ctx.fromClause()) : null;
        if (1 == statements.size()) {
            InsertStatement single = (InsertStatement)this.visit((ParseTree)statements.get(0));
            if (null != sourceTable) {
                single.getInsertSelect().ifPresent(subquery -> this.setFromForSelect((SubquerySegment)subquery, sourceTable));
            }
            single.addParameterMarkers(this.getParameterMarkerSegments());
            return single;
        }
        InsertStatement result = new InsertStatement(this.getDatabaseType());
        result.setMultiTableInsertType(MultiTableInsertType.ALL);
        MultiTableInsertIntoSegment multiTableInsertInto = new MultiTableInsertIntoSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        for (HiveStatementParser.InsertOverwriteStandardSyntaxContext each : statements) {
            InsertStatement insertStmt = (InsertStatement)this.visit((ParseTree)each);
            if (null != sourceTable) {
                insertStmt.getInsertSelect().ifPresent(subquery -> this.setFromForSelect((SubquerySegment)subquery, sourceTable));
            }
            insertStmt.addParameterMarkers(this.getParameterMarkerSegments());
            insertStmt.buildAttributes();
            multiTableInsertInto.getInsertStatements().add(insertStmt);
        }
        result.setMultiTableInsertInto(multiTableInsertInto);
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitInsertOverwriteStandardSyntax(HiveStatementParser.InsertOverwriteStandardSyntaxContext ctx) {
        return this.createHiveInsertStatementForDirectory(ctx.select(), ctx.start.getStartIndex());
    }

    private InsertStatement createHiveInsertStatementForDirectory(HiveStatementParser.SelectContext select, int startIndex) {
        InsertStatement result = new InsertStatement(this.getDatabaseType());
        result.setInsertColumns(new InsertColumnsSegment(startIndex, startIndex, Collections.emptyList()));
        result.setInsertSelect(this.createInsertSelectSegment(select));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitInsertingValuesIntoTables(HiveStatementParser.InsertingValuesIntoTablesContext ctx) {
        InsertStatement result = (InsertStatement)this.visit((ParseTree)ctx.insertValuesClause());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    private SubquerySegment createInsertSelectSegment(HiveStatementParser.SelectContext ctx) {
        SelectStatement selectStatement = (SelectStatement)this.visit((ParseTree)ctx);
        return new SubquerySegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), selectStatement, this.getOriginalText(ctx));
    }

    private SubquerySegment createInsertSelectSegment(HiveStatementParser.InsertSelectClauseContext ctx) {
        SelectStatement selectStatement = (SelectStatement)this.visit((ParseTree)ctx.select());
        return new SubquerySegment(ctx.select().start.getStartIndex(), ctx.select().stop.getStopIndex(), selectStatement, this.getOriginalText(ctx.select()));
    }

    @Override
    public ASTNode visitInsertSelectClause(HiveStatementParser.InsertSelectClauseContext ctx) {
        InsertStatement result = new InsertStatement(this.getDatabaseType());
        if (null != ctx.LP_()) {
            if (null != ctx.fields()) {
                result.setInsertColumns(new InsertColumnsSegment(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex(), this.createInsertColumns(ctx.fields())));
            } else {
                result.setInsertColumns(new InsertColumnsSegment(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex(), Collections.emptyList()));
            }
        } else {
            result.setInsertColumns(new InsertColumnsSegment(ctx.start.getStartIndex() - 1, ctx.start.getStartIndex() - 1, Collections.emptyList()));
        }
        result.setInsertSelect(this.createInsertSelectSegment(ctx));
        return result;
    }

    @Override
    public ASTNode visitInsertValuesClause(HiveStatementParser.InsertValuesClauseContext ctx) {
        InsertStatement result = new InsertStatement(this.getDatabaseType());
        if (null != ctx.LP_()) {
            if (null != ctx.fields()) {
                result.setInsertColumns(new InsertColumnsSegment(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex(), this.createInsertColumns(ctx.fields())));
            } else {
                result.setInsertColumns(new InsertColumnsSegment(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex(), Collections.emptyList()));
            }
        } else {
            result.setInsertColumns(new InsertColumnsSegment(ctx.start.getStartIndex() - 1, ctx.start.getStartIndex() - 1, Collections.emptyList()));
        }
        result.getValues().addAll(this.createInsertValuesSegments(ctx.assignmentValues()));
        return result;
    }

    private Collection<InsertValuesSegment> createInsertValuesSegments(Collection<HiveStatementParser.AssignmentValuesContext> assignmentValuesContexts) {
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        for (HiveStatementParser.AssignmentValuesContext each : assignmentValuesContexts) {
            result.add((InsertValuesSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitOnDuplicateKeyClause(HiveStatementParser.OnDuplicateKeyClauseContext ctx) {
        LinkedList<ColumnAssignmentSegment> columns = new LinkedList<ColumnAssignmentSegment>();
        for (HiveStatementParser.AssignmentContext each : ctx.assignment()) {
            columns.add((ColumnAssignmentSegment)this.visit((ParseTree)each));
        }
        return new OnDuplicateKeyColumnsSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columns);
    }

    private List<ColumnSegment> createInsertColumns(HiveStatementParser.FieldsContext fields) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (HiveStatementParser.InsertIdentifierContext each : fields.insertIdentifier()) {
            result.add((ColumnSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitUpdate(HiveStatementParser.UpdateContext ctx) {
        UpdateStatement result = new UpdateStatement(this.getDatabaseType());
        TableSegment tableSegment = (TableSegment)this.visit((ParseTree)ctx.tableReferences());
        result.setTable(tableSegment);
        result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.setAssignmentsClause()));
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        if (null != ctx.limitClause()) {
            result.setLimit((LimitSegment)this.visit((ParseTree)ctx.limitClause()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitSetAssignmentsClause(HiveStatementParser.SetAssignmentsClauseContext ctx) {
        LinkedList<ColumnAssignmentSegment> assignments = new LinkedList<ColumnAssignmentSegment>();
        for (HiveStatementParser.AssignmentContext each : ctx.assignment()) {
            assignments.add((ColumnAssignmentSegment)this.visit((ParseTree)each));
        }
        return new SetAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), assignments);
    }

    @Override
    public ASTNode visitAssignmentValues(HiveStatementParser.AssignmentValuesContext ctx) {
        LinkedList<ExpressionSegment> segments = new LinkedList<ExpressionSegment>();
        for (HiveStatementParser.AssignmentValueContext each : ctx.assignmentValue()) {
            segments.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return new InsertValuesSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), segments);
    }

    @Override
    public ASTNode visitAssignment(HiveStatementParser.AssignmentContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnRef());
        ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.assignmentValue());
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        columnSegments.add(column);
        return new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, value);
    }

    @Override
    public ASTNode visitAssignmentValue(HiveStatementParser.AssignmentValueContext ctx) {
        HiveStatementParser.ExprContext expr = ctx.expr();
        if (null != expr) {
            return (ASTNode)this.visit((ParseTree)expr);
        }
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitBlobValue(HiveStatementParser.BlobValueContext ctx) {
        return new StringLiteralValue(ctx.string_().getText());
    }

    @Override
    public ASTNode visitDelete(HiveStatementParser.DeleteContext ctx) {
        DeleteStatement result = new DeleteStatement(this.getDatabaseType());
        result.setTable(null == ctx.multipleTablesClause() ? (TableSegment)this.visit((ParseTree)ctx.singleTableClause()) : (TableSegment)this.visit((ParseTree)ctx.multipleTablesClause()));
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        if (null != ctx.limitClause()) {
            result.setLimit((LimitSegment)this.visit((ParseTree)ctx.limitClause()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitMerge(HiveStatementParser.MergeContext ctx) {
        TableSegment source;
        MergeStatement result = new MergeStatement(this.getDatabaseType());
        TableSegment target = (TableSegment)this.visit((ParseTree)ctx.tableName(0));
        if (null != ctx.tableNameAs(0)) {
            target.setAlias((AliasSegment)this.visit((ParseTree)ctx.tableNameAs(0).alias()));
        }
        result.setTarget(target);
        if (null != ctx.tableName(1)) {
            source = (TableSegment)this.visit((ParseTree)ctx.tableName(1));
        } else {
            SelectStatement subquery = (SelectStatement)this.visit((ParseTree)ctx.subquery());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), subquery, this.getOriginalText(ctx.subquery()));
            source = new SubqueryTableSegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), subquerySegment);
        }
        if (null != ctx.tableNameAs(1)) {
            source.setAlias((AliasSegment)this.visit((ParseTree)ctx.tableNameAs(1).alias()));
        }
        result.setSource(source);
        ExpressionWithParamsSegment onExpression = new ExpressionWithParamsSegment(ctx.expr().start.getStartIndex(), ctx.expr().stop.getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.expr()));
        result.setExpression(onExpression);
        for (HiveStatementParser.MergeWhenClauseContext each : ctx.mergeWhenClause()) {
            int start = each.getStart().getStartIndex();
            int stop = each.getStop().getStopIndex();
            MergeWhenAndThenSegment seg = new MergeWhenAndThenSegment(start, stop, this.getOriginalText(each));
            if (null != each.UPDATE()) {
                UpdateStatement upd = new UpdateStatement(this.getDatabaseType());
                upd.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)each.setAssignmentsClause()));
                seg.setUpdate(upd);
            }
            if (null != each.INSERT()) {
                InsertStatement ins = new InsertStatement(this.getDatabaseType());
                if (null != each.insertValuesClause().assignmentValues()) {
                    ins.getValues().addAll(this.createInsertValuesSegments(each.insertValuesClause().assignmentValues()));
                }
                seg.setInsert(ins);
            }
            result.getWhenAndThens().add(seg);
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitSingleTableClause(HiveStatementParser.SingleTableClauseContext ctx) {
        SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    @Override
    public ASTNode visitMultipleTablesClause(HiveStatementParser.MultipleTablesClauseContext ctx) {
        DeleteMultiTableSegment result = new DeleteMultiTableSegment();
        TableSegment relateTableSource = (TableSegment)this.visit((ParseTree)ctx.tableReferences());
        result.setRelationTable(relateTableSource);
        result.setActualDeleteTables(this.generateTablesFromTableAliasRefList(ctx.tableAliasRefList()));
        return result;
    }

    private List<SimpleTableSegment> generateTablesFromTableAliasRefList(HiveStatementParser.TableAliasRefListContext ctx) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (HiveStatementParser.TableIdentOptWildContext each : ctx.tableIdentOptWild()) {
            result.add((SimpleTableSegment)this.visit((ParseTree)each.tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitSelect(HiveStatementParser.SelectContext ctx) {
        SelectStatement result;
        if (null != ctx.queryExpression()) {
            result = (SelectStatement)this.visit((ParseTree)ctx.queryExpression());
            if (null != ctx.lockClauseList()) {
                result.setLock((LockSegment)this.visit((ParseTree)ctx.lockClauseList()));
            }
        } else {
            result = null != ctx.selectWithInto() ? (SelectStatement)this.visit((ParseTree)ctx.selectWithInto()) : (SelectStatement)this.visit(ctx.getChild(0));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        return result;
    }

    private boolean isDistinct(HiveStatementParser.QuerySpecificationContext ctx) {
        for (HiveStatementParser.SelectSpecificationContext each : ctx.selectSpecification()) {
            if (!((BooleanLiteralValue)this.visit((ParseTree)each)).getValue().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ASTNode visitSelectSpecification(HiveStatementParser.SelectSpecificationContext ctx) {
        if (null != ctx.duplicateSpecification()) {
            return (ASTNode)this.visit((ParseTree)ctx.duplicateSpecification());
        }
        return new BooleanLiteralValue(false);
    }

    @Override
    public ASTNode visitDuplicateSpecification(HiveStatementParser.DuplicateSpecificationContext ctx) {
        String text = ctx.getText();
        if ("DISTINCT".equalsIgnoreCase(text) || "DISTINCTROW".equalsIgnoreCase(text)) {
            return new BooleanLiteralValue(true);
        }
        return new BooleanLiteralValue(false);
    }

    @Override
    public ASTNode visitProjections(HiveStatementParser.ProjectionsContext ctx) {
        LinkedList<Object> projections = new LinkedList<Object>();
        if (null != ctx.unqualifiedShorthand()) {
            projections.add(new ShorthandProjectionSegment(ctx.unqualifiedShorthand().getStart().getStartIndex(), ctx.unqualifiedShorthand().getStop().getStopIndex()));
        }
        for (HiveStatementParser.ProjectionContext each : ctx.projection()) {
            projections.add((ProjectionSegment)this.visit((ParseTree)each));
        }
        ProjectionsSegment result = new ProjectionsSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        result.getProjections().addAll(projections);
        return result;
    }

    @Override
    public ASTNode visitProjection(HiveStatementParser.ProjectionContext ctx) {
        if (null != ctx.qualifiedShorthand()) {
            return this.createShorthandProjection(ctx.qualifiedShorthand());
        }
        AliasSegment alias = null == ctx.alias() ? null : (AliasSegment)this.visit((ParseTree)ctx.alias());
        ASTNode exprProjection = (ASTNode)this.visit((ParseTree)ctx.expr());
        if (exprProjection instanceof ColumnSegment) {
            ColumnProjectionSegment result = new ColumnProjectionSegment((ColumnSegment)exprProjection);
            result.setAlias(alias);
            return result;
        }
        if (exprProjection instanceof SubquerySegment) {
            SubquerySegment subquerySegment = (SubquerySegment)exprProjection;
            String text = ctx.start.getInputStream().getText(new Interval(subquerySegment.getStartIndex(), subquerySegment.getStopIndex()));
            SubqueryProjectionSegment result = new SubqueryProjectionSegment((SubquerySegment)exprProjection, text);
            result.setAlias(alias);
            return result;
        }
        if (exprProjection instanceof ExistsSubqueryExpression) {
            ExistsSubqueryExpression existsSubqueryExpression = (ExistsSubqueryExpression)exprProjection;
            String text = ctx.start.getInputStream().getText(new Interval(existsSubqueryExpression.getStartIndex(), existsSubqueryExpression.getStopIndex()));
            SubqueryProjectionSegment result = new SubqueryProjectionSegment(((ExistsSubqueryExpression)exprProjection).getSubquery(), text);
            result.setAlias(alias);
            return result;
        }
        return this.createProjection(ctx, alias, exprProjection);
    }

    private ShorthandProjectionSegment createShorthandProjection(HiveStatementParser.QualifiedShorthandContext shorthand) {
        ShorthandProjectionSegment result = new ShorthandProjectionSegment(shorthand.getStart().getStartIndex(), shorthand.getStop().getStopIndex());
        HiveStatementParser.IdentifierContext identifier = shorthand.identifier().get(shorthand.identifier().size() - 1);
        OwnerSegment owner = new OwnerSegment(identifier.getStart().getStartIndex(), identifier.getStop().getStopIndex(), new IdentifierValue(identifier.getText()));
        result.setOwner(owner);
        if (shorthand.identifier().size() > 1) {
            HiveStatementParser.IdentifierContext databaseIdentifier = shorthand.identifier().get(0);
            owner.setOwner(new OwnerSegment(databaseIdentifier.getStart().getStartIndex(), databaseIdentifier.getStop().getStopIndex(), new IdentifierValue(databaseIdentifier.getText())));
        }
        return result;
    }

    @Override
    public ASTNode visitAlias(HiveStatementParser.AliasContext ctx) {
        return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.textOrIdentifier().getText()));
    }

    private ASTNode createProjection(HiveStatementParser.ProjectionContext ctx, AliasSegment alias, ASTNode projection) {
        if (projection instanceof AggregationProjectionSegment) {
            ((AggregationProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof ExpressionProjectionSegment) {
            ((ExpressionProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof FunctionSegment) {
            FunctionSegment functionSegment = (FunctionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(functionSegment.getStartIndex(), functionSegment.getStopIndex(), functionSegment.getText(), (ExpressionSegment)functionSegment);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof CommonExpressionSegment) {
            CommonExpressionSegment segment = (CommonExpressionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText(), (ExpressionSegment)segment);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ColumnSegment) {
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx), (ExpressionSegment)((ColumnSegment)projection));
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof SubqueryExpressionSegment) {
            SubqueryExpressionSegment subqueryExpressionSegment = (SubqueryExpressionSegment)projection;
            String text = ctx.start.getInputStream().getText(new Interval(subqueryExpressionSegment.getStartIndex(), subqueryExpressionSegment.getStopIndex()));
            SubqueryProjectionSegment result = new SubqueryProjectionSegment(subqueryExpressionSegment.getSubquery(), text);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof BinaryOperationExpression) {
            int startIndex = ((BinaryOperationExpression)projection).getStartIndex();
            int stopIndex = null == alias ? ((BinaryOperationExpression)projection).getStopIndex() : alias.getStopIndex();
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(startIndex, stopIndex, ((BinaryOperationExpression)projection).getText(), (ExpressionSegment)((BinaryOperationExpression)projection));
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ParameterMarkerExpressionSegment) {
            ParameterMarkerExpressionSegment result = (ParameterMarkerExpressionSegment)projection;
            result.setAlias(alias);
            return projection;
        }
        if (projection instanceof CaseWhenExpression) {
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx.expr()), (ExpressionSegment)((CaseWhenExpression)projection));
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof VariableSegment) {
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx.expr()), (ExpressionSegment)((VariableSegment)projection));
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof BetweenExpression) {
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx.expr()), (ExpressionSegment)((BetweenExpression)projection));
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof InExpression) {
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx.expr()), (ExpressionSegment)((InExpression)projection));
            result.setAlias(alias);
            return result;
        }
        ExpressionSegment column = (ExpressionSegment)projection;
        ExpressionProjectionSegment result = null == alias ? new ExpressionProjectionSegment(column.getStartIndex(), column.getStopIndex(), String.valueOf(column.getText()), column) : new ExpressionProjectionSegment(column.getStartIndex(), ctx.alias().stop.getStopIndex(), String.valueOf(column.getText()), column);
        result.setAlias(alias);
        return result;
    }

    @Override
    public ASTNode visitFromClause(HiveStatementParser.FromClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    @Override
    public ASTNode visitTableReferences(HiveStatementParser.TableReferencesContext ctx) {
        TableSegment result = (TableSegment)this.visit((ParseTree)ctx.tableReference(0));
        if (ctx.tableReference().size() > 1) {
            for (int i = 1; i < ctx.tableReference().size(); ++i) {
                result = this.generateJoinTableSourceFromEscapedTableReference(ctx.tableReference(i), result);
            }
        }
        return result;
    }

    private JoinTableSegment generateJoinTableSourceFromEscapedTableReference(HiveStatementParser.TableReferenceContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        result.setLeft(tableSegment);
        result.setJoinType(JoinType.COMMA.name());
        result.setRight((TableSegment)this.visit((ParseTree)ctx));
        return result;
    }

    @Override
    public ASTNode visitEscapedTableReference(HiveStatementParser.EscapedTableReferenceContext ctx) {
        TableSegment left = (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        for (HiveStatementParser.JoinedTableContext each : ctx.joinedTable()) {
            left = this.visitJoinedTable(each, left);
        }
        TableSegment result = left;
        return result;
    }

    @Override
    public ASTNode visitTableReference(HiveStatementParser.TableReferenceContext ctx) {
        TableSegment left = null == ctx.tableFactor() ? (TableSegment)this.visit((ParseTree)ctx.escapedTableReference()) : (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        for (HiveStatementParser.JoinedTableContext each : ctx.joinedTable()) {
            left = this.visitJoinedTable(each, left);
        }
        TableSegment result = left;
        return result;
    }

    @Override
    public ASTNode visitTableFactor(HiveStatementParser.TableFactorContext ctx) {
        if (null != ctx.subquery()) {
            SelectStatement subquery = (SelectStatement)this.visit((ParseTree)ctx.subquery());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), subquery, this.getOriginalText(ctx.subquery()));
            SubqueryTableSegment result = new SubqueryTableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), subquerySegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.tableName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    private JoinTableSegment visitJoinedTable(HiveStatementParser.JoinedTableContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setLeft(tableSegment);
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        result.setJoinType(this.getJoinType(ctx));
        result.setNatural(null != ctx.naturalJoinType());
        TableSegment right = null == ctx.tableFactor() ? (TableSegment)this.visit((ParseTree)ctx.tableReference()) : (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        result.setRight(right);
        return null == ctx.joinSpecification() ? result : this.visitJoinSpecification(ctx.joinSpecification(), result);
    }

    private String getJoinType(HiveStatementParser.JoinedTableContext ctx) {
        if (null != ctx.innerJoinType()) {
            return JoinType.INNER.name();
        }
        if (null != ctx.outerJoinType()) {
            return null == ctx.outerJoinType().LEFT() ? JoinType.RIGHT.name() : JoinType.LEFT.name();
        }
        if (null != ctx.naturalJoinType()) {
            return this.getNaturalJoinType(ctx.naturalJoinType());
        }
        return JoinType.COMMA.name();
    }

    private String getNaturalJoinType(HiveStatementParser.NaturalJoinTypeContext ctx) {
        if (null != ctx.LEFT()) {
            return JoinType.LEFT.name();
        }
        if (null != ctx.RIGHT()) {
            return JoinType.RIGHT.name();
        }
        return JoinType.INNER.name();
    }

    private JoinTableSegment visitJoinSpecification(HiveStatementParser.JoinSpecificationContext ctx, JoinTableSegment result) {
        if (null != ctx.expr()) {
            ExpressionSegment condition = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            result.setCondition(condition);
        }
        if (null != ctx.USING()) {
            result.setUsing(ctx.columnNames().columnName().stream().map(each -> (ColumnSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
        }
        return result;
    }

    @Override
    public ASTNode visitWhereClause(HiveStatementParser.WhereClauseContext ctx) {
        ASTNode segment = (ASTNode)this.visit((ParseTree)ctx.expr());
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ExpressionSegment)segment);
    }

    @Override
    public ASTNode visitGroupByClause(HiveStatementParser.GroupByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (HiveStatementParser.OrderByItemContext each : ctx.orderByItem()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new GroupBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    @Override
    public ASTNode visitLimitClause(HiveStatementParser.LimitClauseContext ctx) {
        PaginationValueSegment offset;
        PaginationValueSegment rowCount;
        if (null == ctx.limitOffset()) {
            return new LimitSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), null, (PaginationValueSegment)this.visit((ParseTree)ctx.limitRowCount()));
        }
        if (null != ctx.OFFSET()) {
            rowCount = (PaginationValueSegment)this.visit((ParseTree)ctx.limitRowCount());
            offset = (PaginationValueSegment)this.visit((ParseTree)ctx.limitOffset());
        } else {
            offset = (PaginationValueSegment)this.visit((ParseTree)ctx.limitOffset());
            rowCount = (PaginationValueSegment)this.visit((ParseTree)ctx.limitRowCount());
        }
        return new LimitSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), offset, rowCount);
    }

    @Override
    public ASTNode visitLimitRowCount(HiveStatementParser.LimitRowCountContext ctx) {
        if (null != ctx.numberLiterals()) {
            return new NumberLiteralLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.numberLiterals())).getValue().longValue()));
        }
        ParameterMarkerLimitValueSegment result = new ParameterMarkerLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ((ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker())).getValue().intValue());
        this.getParameterMarkerSegments().add((ParameterMarkerSegment)result);
        return result;
    }

    @Override
    public ASTNode visitConstraintName(HiveStatementParser.ConstraintNameContext ctx) {
        return new ConstraintSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public ASTNode visitLimitOffset(HiveStatementParser.LimitOffsetContext ctx) {
        if (null != ctx.numberLiterals()) {
            return new NumberLiteralLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.numberLiterals())).getValue().longValue()));
        }
        ParameterMarkerLimitValueSegment result = new ParameterMarkerLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ((ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker())).getValue().intValue());
        this.getParameterMarkerSegments().add((ParameterMarkerSegment)result);
        return result;
    }

    @Override
    public ASTNode visitCollateClause(HiveStatementParser.CollateClauseContext ctx) {
        if (null != ctx.collationName()) {
            return new LiteralExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (Object)ctx.collationName().textOrIdentifier().getText());
        }
        ParameterMarkerExpressionSegment result = new ParameterMarkerExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ((ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker())).getValue().intValue());
        this.getParameterMarkerSegments().add((ParameterMarkerSegment)result);
        return result;
    }

    @Override
    public ASTNode visitLoadStatement(HiveStatementParser.LoadStatementContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.loadDataStatement());
    }

    @Override
    public ASTNode visitLoadDataStatement(HiveStatementParser.LoadDataStatementContext ctx) {
        return new MySQLLoadDataStatement(this.getDatabaseType(), (SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
    }
}

