/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.http.executor;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.http.pojo.HttpParam;
import org.apache.shardingsphere.elasticjob.kernel.infra.exception.JobExecutionException;
import org.apache.shardingsphere.elasticjob.kernel.infra.json.GsonFactory;
import org.apache.shardingsphere.elasticjob.spi.executor.item.param.JobRuntimeService;
import org.apache.shardingsphere.elasticjob.spi.executor.item.param.ShardingContext;
import org.apache.shardingsphere.elasticjob.spi.executor.item.type.TypedJobItemExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpJobExecutor
implements TypedJobItemExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpJobExecutor.class);

    public void process(ElasticJob elasticJob, JobConfiguration jobConfig, JobRuntimeService jobRuntimeService, ShardingContext shardingContext) {
        HttpParam httpParam = new HttpParam(jobConfig.getProps());
        HttpURLConnection connection = null;
        try {
            connection = this.getHttpURLConnection(httpParam, shardingContext);
            connection.connect();
            String data = httpParam.getData();
            if (httpParam.isWriteMethod() && !Strings.isNullOrEmpty((String)data)) {
                try (OutputStream outputStream = connection.getOutputStream();){
                    outputStream.write(data.getBytes(StandardCharsets.UTF_8));
                }
            }
            int responseCode = connection.getResponseCode();
            StringBuilder result = new StringBuilder();
            try (InputStream inputStream = this.getConnectionInputStream(jobConfig.getJobName(), connection, responseCode);
                 BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                String line;
                while (null != (line = bufferedReader.readLine())) {
                    result.append(line);
                }
            }
            if (this.isRequestSucceed(responseCode)) {
                log.debug("HTTP job execute result : {}", (Object)result);
            } else {
                log.warn("HTTP job {} executed with response body {}", (Object)jobConfig.getJobName(), (Object)result);
            }
        }
        catch (IOException ex) {
            throw new JobExecutionException((Throwable)ex);
        }
        finally {
            if (null != connection) {
                connection.disconnect();
            }
        }
    }

    private HttpURLConnection getHttpURLConnection(HttpParam httpParam, ShardingContext shardingContext) throws IOException {
        URL url = new URL(httpParam.getUrl());
        HttpURLConnection result = (HttpURLConnection)url.openConnection();
        result.setRequestMethod(httpParam.getMethod());
        result.setDoOutput(true);
        result.setConnectTimeout(httpParam.getConnectTimeoutMilliseconds());
        result.setReadTimeout(httpParam.getReadTimeoutMilliseconds());
        if (!Strings.isNullOrEmpty((String)httpParam.getContentType())) {
            result.setRequestProperty("Content-Type", httpParam.getContentType());
        }
        result.setRequestProperty("shardingContext", GsonFactory.getGson().toJson((Object)shardingContext));
        return result;
    }

    private InputStream getConnectionInputStream(String jobName, HttpURLConnection connection, int code) throws IOException {
        if (this.isRequestSucceed(code)) {
            return connection.getInputStream();
        }
        log.warn("HTTP job {} executed with response code {}", (Object)jobName, (Object)code);
        return connection.getErrorStream();
    }

    private boolean isRequestSucceed(int httpStatusCode) {
        return 400 > httpStatusCode;
    }

    public String getType() {
        return "HTTP";
    }
}

