/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.Method;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.ErrorResponse;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractMessageWriterResultHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ResponseEntityResultHandler
extends AbstractMessageWriterResultHandler
implements HandlerResultHandler {
    private static final Set<HttpMethod> SAFE_METHODS = Set.of(HttpMethod.GET, HttpMethod.HEAD);

    public ResponseEntityResultHandler(List<HttpMessageWriter<?>> writers, RequestedContentTypeResolver resolver) {
        this(writers, resolver, ReactiveAdapterRegistry.getSharedInstance());
    }

    public ResponseEntityResultHandler(List<HttpMessageWriter<?>> writers, RequestedContentTypeResolver resolver, ReactiveAdapterRegistry registry) {
        super(writers, resolver, registry);
        this.setOrder(0);
    }

    @Override
    public boolean supports(HandlerResult result) {
        Class<?> valueType = ResponseEntityResultHandler.resolveReturnValueType(result);
        if (this.isSupportedType(valueType)) {
            return true;
        }
        ReactiveAdapter adapter = this.getAdapter(result);
        return adapter != null && !adapter.isNoValue() && this.isSupportedType(result.getReturnType().getGeneric(new int[0]).toClass());
    }

    private static Class<?> resolveReturnValueType(HandlerResult result) {
        Class<?> valueType = result.getReturnType().toClass();
        Object value = result.getReturnValue();
        if (valueType == Object.class && value != null) {
            valueType = value.getClass();
        }
        return valueType;
    }

    private boolean isSupportedType(@Nullable Class<?> type) {
        if (type == null) {
            return false;
        }
        return HttpEntity.class.isAssignableFrom(type) && !RequestEntity.class.isAssignableFrom(type) || ErrorResponse.class.isAssignableFrom(type) || ProblemDetail.class.isAssignableFrom(type) || HttpHeaders.class.isAssignableFrom(type);
    }

    @Override
    public Mono<Void> handleResult(ServerWebExchange exchange2, HandlerResult result) {
        MethodParameter bodyParameter;
        Mono returnValueMono;
        ReactiveAdapter adapter = this.getAdapter(result);
        MethodParameter actualParameter = result.getReturnTypeSource();
        if (adapter != null) {
            Assert.isTrue((!adapter.isMultiValue() ? 1 : 0) != 0, (String)"Only a single ResponseEntity supported");
            returnValueMono = Mono.from((Publisher)adapter.toPublisher(result.getReturnValue()));
            boolean isContinuation = KotlinDetector.isSuspendingFunction((Method)actualParameter.getMethod()) && !"kotlinx.coroutines.flow.Flow".equals(actualParameter.getParameterType().getName());
            bodyParameter = isContinuation ? actualParameter.nested() : actualParameter.nested().nested();
        } else {
            returnValueMono = Mono.justOrEmpty((Object)result.getReturnValue());
            bodyParameter = actualParameter.nested();
        }
        return returnValueMono.flatMap(returnValue -> {
            HttpEntity httpEntity;
            if (returnValue instanceof HttpEntity) {
                HttpEntity he;
                httpEntity = he = (HttpEntity)returnValue;
            } else if (returnValue instanceof ErrorResponse) {
                ErrorResponse response = (ErrorResponse)returnValue;
                httpEntity = new ResponseEntity((Object)response.getBody(), (MultiValueMap)response.getHeaders(), response.getStatusCode());
            } else if (returnValue instanceof ProblemDetail) {
                ProblemDetail detail = (ProblemDetail)returnValue;
                httpEntity = ResponseEntity.of((ProblemDetail)detail).build();
            } else if (returnValue instanceof HttpHeaders) {
                HttpHeaders headers = (HttpHeaders)returnValue;
                httpEntity = new ResponseEntity((MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
            } else {
                return Mono.error(() -> new IllegalArgumentException("HttpEntity or HttpHeaders expected but got: " + returnValue.getClass()));
            }
            Object patt5875$temp = httpEntity.getBody();
            if (patt5875$temp instanceof ProblemDetail) {
                ResponseEntity responseEntity;
                ProblemDetail detail = (ProblemDetail)patt5875$temp;
                if (detail.getInstance() == null) {
                    URI path = URI.create(exchange2.getRequest().getPath().value());
                    detail.setInstance(path);
                }
                if (this.logger.isWarnEnabled() && httpEntity instanceof ResponseEntity && (responseEntity = (ResponseEntity)httpEntity).getStatusCode().value() != detail.getStatus()) {
                    this.logger.warn((Object)(actualParameter.getExecutable().toGenericString() + " returned ResponseEntity: " + responseEntity + ", but its status doesn't match the ProblemDetail status: " + detail.getStatus()));
                }
            }
            if (httpEntity instanceof ResponseEntity) {
                ResponseEntity responseEntity = (ResponseEntity)httpEntity;
                exchange2.getResponse().setStatusCode(responseEntity.getStatusCode());
            }
            HttpHeaders entityHeaders = httpEntity.getHeaders();
            HttpHeaders responseHeaders = exchange2.getResponse().getHeaders();
            if (!entityHeaders.isEmpty()) {
                responseHeaders.putAll((Map)entityHeaders);
            }
            if (httpEntity.getBody() == null || returnValue instanceof HttpHeaders) {
                return exchange2.getResponse().setComplete();
            }
            String etag = entityHeaders.getETag();
            Instant lastModified = Instant.ofEpochMilli(entityHeaders.getLastModified());
            HttpMethod httpMethod = exchange2.getRequest().getMethod();
            return SAFE_METHODS.contains(httpMethod) && exchange2.checkNotModified(etag, lastModified) ? exchange2.getResponse().setComplete() : this.writeBody(httpEntity.getBody(), bodyParameter, actualParameter, exchange2);
        });
    }
}

