/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.hierarchy;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.config.HierarchyDefinitionService;
import org.apache.skywalking.oap.server.core.hierarchy.instance.InstanceHierarchyRelation;
import org.apache.skywalking.oap.server.core.hierarchy.service.ServiceHierarchyRelation;
import org.apache.skywalking.oap.server.core.query.MetadataQueryService;
import org.apache.skywalking.oap.server.core.query.type.Service;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.RunnableWithExceptionProtection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyService
implements org.apache.skywalking.oap.server.library.module.Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HierarchyService.class);
    private final ModuleManager moduleManager;
    private final boolean isEnableHierarchy;
    private SourceReceiver sourceReceiver;
    private MetadataQueryService metadataQueryService;
    private Map<String, Map<String, HierarchyDefinitionService.MatchingRule>> hierarchyDefinition;

    public HierarchyService(ModuleManager moduleManager, CoreModuleConfig moduleConfig) {
        this.moduleManager = moduleManager;
        this.isEnableHierarchy = moduleConfig.isEnableHierarchy();
    }

    private SourceReceiver getSourceReceiver() {
        if (this.sourceReceiver == null) {
            this.sourceReceiver = (SourceReceiver)this.moduleManager.find("core").provider().getService(SourceReceiver.class);
        }
        return this.sourceReceiver;
    }

    private Map<String, Map<String, HierarchyDefinitionService.MatchingRule>> getHierarchyDefinition() {
        if (this.hierarchyDefinition == null) {
            this.hierarchyDefinition = ((HierarchyDefinitionService)this.moduleManager.find("core").provider().getService(HierarchyDefinitionService.class)).getHierarchyDefinition();
        }
        return this.hierarchyDefinition;
    }

    private MetadataQueryService getMetadataQueryService() {
        if (this.metadataQueryService == null) {
            this.metadataQueryService = (MetadataQueryService)this.moduleManager.find("core").provider().getService(MetadataQueryService.class);
        }
        return this.metadataQueryService;
    }

    public void toServiceHierarchyRelation(String upperServiceName, Layer upperServiceLayer, String lowerServiceName, Layer lowerServiceLayer) {
        if (!this.isEnableHierarchy) {
            return;
        }
        Map<String, HierarchyDefinitionService.MatchingRule> lowerLayers = this.getHierarchyDefinition().get(upperServiceLayer.name());
        if (lowerLayers == null || !lowerLayers.containsKey(lowerServiceLayer.name())) {
            log.error("upperServiceLayer " + upperServiceLayer.name() + " or lowerServiceLayer " + lowerServiceLayer.name() + " is not defined in hierarchy-definition.yml.");
            return;
        }
        this.autoMatchingServiceRelation(upperServiceName, upperServiceLayer, lowerServiceName, lowerServiceLayer);
    }

    public void toInstanceHierarchyRelation(String upperInstanceName, String upperServiceName, Layer upperServiceLayer, String lowerInstanceName, String lowerServiceName, Layer lowerServiceLayer) {
        if (!this.isEnableHierarchy) {
            return;
        }
        Map<String, HierarchyDefinitionService.MatchingRule> lowerLayers = this.getHierarchyDefinition().get(upperServiceLayer.name());
        if (lowerLayers == null || !lowerLayers.containsKey(lowerServiceLayer.name())) {
            log.error("upperServiceLayer " + upperServiceLayer.name() + " or lowerServiceLayer " + lowerServiceLayer.name() + " is not defined in hierarchy-definition.yml.");
            return;
        }
        this.buildInstanceHierarchyRelation(upperInstanceName, upperServiceName, upperServiceLayer, lowerInstanceName, lowerServiceName, lowerServiceLayer);
    }

    public void startAutoMatchingServiceHierarchy() {
        if (!this.isEnableHierarchy) {
            return;
        }
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay((Runnable)new RunnableWithExceptionProtection(this::autoMatchingServiceRelation, t -> log.error("Scheduled auto matching service hierarchy from service traffic failure.", t)), 30L, 20L, TimeUnit.SECONDS);
    }

    private void autoMatchingServiceRelation(String upperServiceName, Layer upperServiceLayer, String lowerServiceName, Layer lowerServiceLayer) {
        ServiceHierarchyRelation serviceHierarchy = new ServiceHierarchyRelation();
        serviceHierarchy.setServiceName(upperServiceName);
        serviceHierarchy.setServiceLayer(upperServiceLayer);
        serviceHierarchy.setRelatedServiceName(lowerServiceName);
        serviceHierarchy.setRelatedServiceLayer(lowerServiceLayer);
        serviceHierarchy.setTimeBucket(TimeBucket.getMinuteTimeBucket(System.currentTimeMillis()));
        this.getSourceReceiver().receive(serviceHierarchy);
    }

    private void buildInstanceHierarchyRelation(String upperInstanceName, String upperServiceName, Layer upperServiceLayer, String lowerInstanceName, String lowerServiceName, Layer lowerServiceLayer) {
        InstanceHierarchyRelation instanceHierarchy = new InstanceHierarchyRelation();
        instanceHierarchy.setInstanceName(upperInstanceName);
        instanceHierarchy.setServiceName(upperServiceName);
        instanceHierarchy.setServiceLayer(upperServiceLayer);
        instanceHierarchy.setRelatedInstanceName(lowerInstanceName);
        instanceHierarchy.setRelatedServiceName(lowerServiceName);
        instanceHierarchy.setRelatedServiceLayer(lowerServiceLayer);
        instanceHierarchy.setTimeBucket(TimeBucket.getMinuteTimeBucket(System.currentTimeMillis()));
        this.getSourceReceiver().receive(instanceHierarchy);
    }

    private void autoMatchingServiceRelation() {
        List allServices = this.getMetadataQueryService().listAllServices().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (allServices.size() > 1) {
            for (int i = 0; i < allServices.size(); ++i) {
                for (int j = i + 1; j < allServices.size(); ++j) {
                    Service service = (Service)allServices.get(i);
                    Service comparedService = (Service)allServices.get(j);
                    String serviceLayer = service.getLayers().iterator().next();
                    String comparedServiceLayer = comparedService.getLayers().iterator().next();
                    Map<String, HierarchyDefinitionService.MatchingRule> lowerLayers = this.getHierarchyDefinition().get(serviceLayer);
                    Map<String, HierarchyDefinitionService.MatchingRule> comparedLowerLayers = this.getHierarchyDefinition().get(comparedServiceLayer);
                    if (lowerLayers != null && lowerLayers.get(comparedServiceLayer) != null) {
                        try {
                            if (!((Boolean)lowerLayers.get(comparedServiceLayer).getClosure().call(new Object[]{service, comparedService})).booleanValue()) continue;
                            this.autoMatchingServiceRelation(service.getName(), Layer.nameOf(serviceLayer), comparedService.getName(), Layer.nameOf(comparedServiceLayer));
                        }
                        catch (Throwable e) {
                            log.error("Auto matching service hierarchy from service traffic failure. Upper layer {}, lower layer {}, closure{}", new Object[]{serviceLayer, comparedServiceLayer, lowerLayers.get(comparedServiceLayer).getExpression(), e});
                        }
                        continue;
                    }
                    if (comparedLowerLayers == null || comparedLowerLayers.get(serviceLayer) == null) continue;
                    try {
                        if (!((Boolean)comparedLowerLayers.get(serviceLayer).getClosure().call(new Object[]{comparedService, service})).booleanValue()) continue;
                        this.autoMatchingServiceRelation(comparedService.getName(), Layer.nameOf(comparedServiceLayer), service.getName(), Layer.nameOf(serviceLayer));
                        continue;
                    }
                    catch (Throwable e) {
                        log.error("Auto matching service hierarchy from service traffic failure. Upper layer {}, lower layer {}, closure{}", new Object[]{comparedServiceLayer, serviceLayer, comparedLowerLayers.get(serviceLayer).getExpression(), e});
                    }
                }
            }
        }
    }
}

