/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.restapi;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentReference;
import org.apache.skywalking.generator.Generator;
import org.apache.skywalking.generator.StringGenerator;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.source.Segment;
import org.apache.skywalking.restapi.SpanGenerator;
import org.apache.skywalking.restapi.TagGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class SegmentGenerator
implements Generator<SegmentContext, SegmentResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentGenerator.class);
    private Generator<String, String> segmentId;
    private Generator<String, String> endpointName;
    private Generator<Object, Long> error;
    private Generator<Object, List<TagGenerator>> tags;
    private Generator<Object, List<SpanGenerator>> spans;
    private Generator<Object, Long> now;

    @Override
    public SegmentResult next(SegmentContext ctx) {
        long n = this.now.next(null);
        String serviceName = ctx.serviceName;
        String serviceInstanceName = ctx.serviceInstanceName;
        String endpointName = this.getEndpointName().next(null);
        if (this.segmentId == null) {
            StringGenerator.Builder segmentIdBuilder = new StringGenerator.Builder();
            segmentIdBuilder.setLength(20);
            segmentIdBuilder.setNumbers(true);
            segmentIdBuilder.setLetters(true);
            this.segmentId = segmentIdBuilder.build();
        }
        SegmentReference sr = Optional.ofNullable(ctx.parentSegment).flatMap(parentSegment -> parentSegment.segmentObject.getSpansList().stream().filter(span -> !Strings.isNullOrEmpty((String)span.getPeer())).findFirst().map(span -> SegmentReference.newBuilder().setTraceId(ctx.traceId).setParentServiceInstance(parentSegment.segmentObject.getServiceInstance()).setParentService(parentSegment.segmentObject.getService()).setParentSpanId(span.getSpanId()).setParentTraceSegmentId(parentSegment.segment.getSegmentId()).setParentEndpoint(IDManager.EndpointID.analysisId((String)parentSegment.segment.getEndpointId()).getEndpointName()).setNetworkAddressUsedAtPeer(serviceInstanceName).build())).orElse(null);
        String segmentId = this.getSegmentId().next(null);
        List<SpanGenerator> spanGenerators = this.getSpans().next(null);
        int size = spanGenerators.size();
        SegmentObject segmentObj = SegmentObject.newBuilder().setTraceId(ctx.traceId).setTraceSegmentId(segmentId).addAllSpans((Iterable)IntStream.range(0, size).mapToObj(i -> {
            SpanGenerator sg = (SpanGenerator)spanGenerators.get(i);
            return sg.next(new SpanGenerator.SpanGeneratorContext(i, size, sr, ctx.peer, n));
        }).collect(Collectors.toList())).setService(serviceName).setServiceInstance(serviceInstanceName).build();
        this.getSpans().reset();
        Long latency = segmentObj.getSpansList().stream().reduce(0L, (l, span) -> l + (span.getEndTime() - span.getStartTime()), Long::sum);
        Segment segment = new Segment();
        segment.setSegmentId(segmentId);
        segment.setTraceId(ctx.traceId);
        segment.setServiceId(IDManager.ServiceID.buildId((String)serviceName, (boolean)true));
        segment.setServiceInstanceId(IDManager.ServiceInstanceID.buildId((String)segment.getServiceId(), (String)serviceInstanceName));
        segment.setEndpointId(IDManager.EndpointID.buildId((String)segment.getServiceId(), (String)endpointName));
        segment.setStartTime(n - latency);
        segment.setLatency(latency.intValue());
        segment.setIsError(this.getError().next(null).intValue());
        segment.setTimeBucket(TimeBucket.getRecordTimeBucket((long)segment.getStartTime()));
        segment.setTags(this.getTags().next(null).stream().map(tg -> tg.next((Object)null)).collect(Collectors.toList()));
        return new SegmentResult(segment, segmentObj);
    }

    @Generated
    public Generator<String, String> getSegmentId() {
        return this.segmentId;
    }

    @Generated
    public Generator<String, String> getEndpointName() {
        return this.endpointName;
    }

    @Generated
    public Generator<Object, Long> getError() {
        return this.error;
    }

    @Generated
    public Generator<Object, List<TagGenerator>> getTags() {
        return this.tags;
    }

    @Generated
    public Generator<Object, List<SpanGenerator>> getSpans() {
        return this.spans;
    }

    @Generated
    public Generator<Object, Long> getNow() {
        return this.now;
    }

    @Generated
    public void setSegmentId(Generator<String, String> segmentId) {
        this.segmentId = segmentId;
    }

    @Generated
    public void setEndpointName(Generator<String, String> endpointName) {
        this.endpointName = endpointName;
    }

    @Generated
    public void setError(Generator<Object, Long> error) {
        this.error = error;
    }

    @Generated
    public void setTags(Generator<Object, List<TagGenerator>> tags) {
        this.tags = tags;
    }

    @Generated
    public void setSpans(Generator<Object, List<SpanGenerator>> spans) {
        this.spans = spans;
    }

    @Generated
    public void setNow(Generator<Object, Long> now) {
        this.now = now;
    }

    public static class SegmentContext {
        final String traceId;
        final String serviceName;
        final String serviceInstanceName;
        String peer;
        SegmentResult parentSegment;

        @Generated
        public SegmentContext(String traceId, String serviceName, String serviceInstanceName) {
            this.traceId = traceId;
            this.serviceName = serviceName;
            this.serviceInstanceName = serviceInstanceName;
        }
    }

    public static class SegmentResult {
        final Segment segment;
        final SegmentObject segmentObject;

        @Generated
        public SegmentResult(Segment segment, SegmentObject segmentObject) {
            this.segment = segment;
            this.segmentObject = segmentObject;
        }
    }
}

