/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.grpc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.server.annotation.AnnotatedDocServicePlugin;
import com.linecorp.armeria.internal.server.grpc.GrpcDocStringExtractor;
import com.linecorp.armeria.internal.server.grpc.HttpEndpointSpecification;
import com.linecorp.armeria.internal.server.grpc.HttpEndpointSupport;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.HashMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Multimap;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RoutePathType;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.docs.DescriptionInfo;
import com.linecorp.armeria.server.docs.DescriptiveTypeInfo;
import com.linecorp.armeria.server.docs.DescriptiveTypeInfoProvider;
import com.linecorp.armeria.server.docs.DescriptiveTypeSignature;
import com.linecorp.armeria.server.docs.DocServiceFilter;
import com.linecorp.armeria.server.docs.DocServicePlugin;
import com.linecorp.armeria.server.docs.EndpointInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.FieldInfoBuilder;
import com.linecorp.armeria.server.docs.FieldLocation;
import com.linecorp.armeria.server.docs.FieldRequirement;
import com.linecorp.armeria.server.docs.MethodInfo;
import com.linecorp.armeria.server.docs.ServiceInfo;
import com.linecorp.armeria.server.docs.ServiceSpecification;
import com.linecorp.armeria.server.docs.TypeSignature;
import com.linecorp.armeria.server.grpc.GrpcService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class GrpcDocServicePlugin
implements DocServicePlugin {
    private static final String NAME = "grpc";
    @VisibleForTesting
    public static final String HTTP_SERVICE_SUFFIX = "_HTTP";
    private static final JsonFormat.Printer defaultExamplePrinter = JsonFormat.printer().includingDefaultValueFields();
    private static final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\(\\?<([\\w]+)>[^)]+\\)");
    private final GrpcDocStringExtractor docstringExtractor = new GrpcDocStringExtractor();

    public String name() {
        return NAME;
    }

    public Set<Class<? extends Service<?, ?>>> supportedServiceTypes() {
        return ImmutableSet.of(GrpcService.class);
    }

    public ServiceSpecification generateSpecification(Set<ServiceConfig> serviceConfigs, DocServiceFilter filter, DescriptiveTypeInfoProvider descriptiveTypeInfoProvider) {
        Objects.requireNonNull(serviceConfigs, "serviceConfigs");
        Objects.requireNonNull(filter, "filter");
        Objects.requireNonNull(descriptiveTypeInfoProvider, "descriptiveTypeInfoProvider");
        HashSet<GrpcService> addedService = new HashSet<GrpcService>();
        ImmutableList.Builder httpEndpoints = ImmutableList.builder();
        ServiceInfosBuilder serviceInfosBuilder = new ServiceInfosBuilder();
        for (ServiceConfig serviceConfig : serviceConfigs) {
            HttpEndpointSpecification spec;
            HttpEndpointSupport httpEndpointSupport;
            GrpcService grpcService = (GrpcService)serviceConfig.service().as(GrpcService.class);
            assert (grpcService != null);
            if (addedService.add(grpcService)) {
                GrpcDocServicePlugin.addServiceDescriptor(serviceInfosBuilder, grpcService);
            }
            if ((httpEndpointSupport = (HttpEndpointSupport)grpcService.as(HttpEndpointSupport.class)) != null && (spec = httpEndpointSupport.httpEndpointSpecification(serviceConfig.mappedRoute())) != null) {
                if (!filter.test(NAME, spec.serviceName(), spec.methodName())) continue;
                httpEndpoints.add((Object)new HttpEndpoint(serviceConfig, spec.withRoute(serviceConfig.route())));
                continue;
            }
            Route route = serviceConfig.route();
            Set<MediaType> supportedMediaTypes = GrpcDocServicePlugin.supportedMediaTypes(grpcService);
            if (route.pathType() == RoutePathType.PREFIX) {
                String pathPrefix = (String)route.paths().get(0);
                grpcService.methodsByRoute().forEach((methodRoute, method) -> {
                    EndpointInfo endpointInfo = EndpointInfo.builder((String)serviceConfig.virtualHost().hostnamePattern(), (String)ArmeriaHttpUtil.concatPaths((String)pathPrefix, (String)methodRoute.patternString())).availableMimeTypes((Iterable)supportedMediaTypes).build();
                    serviceInfosBuilder.addEndpoint(method.getMethodDescriptor(), endpointInfo);
                });
                continue;
            }
            if (route.pathType() == RoutePathType.EXACT) {
                ServerMethodDefinition<?, ?> methodDefinition = grpcService.methodsByRoute().get(serviceConfig.mappedRoute());
                assert (methodDefinition != null);
                EndpointInfo endpointInfo = EndpointInfo.builder((String)serviceConfig.virtualHost().hostnamePattern(), (String)route.patternString()).availableMimeTypes(supportedMediaTypes).build();
                serviceInfosBuilder.addEndpoint(methodDefinition.getMethodDescriptor(), endpointInfo);
                continue;
            }
            throw new Error();
        }
        return this.generate((List<ServiceInfo>)ImmutableList.builder().addAll(serviceInfosBuilder.build(filter)).addAll(GrpcDocServicePlugin.buildHttpServiceInfos((List<HttpEndpoint>)httpEndpoints.build())).build(), descriptiveTypeInfoProvider);
    }

    private static void addServiceDescriptor(ServiceInfosBuilder serviceInfosBuilder, GrpcService grpcService) {
        grpcService.services().stream().map(ServerServiceDefinition::getServiceDescriptor).filter(Objects::nonNull).filter(desc -> desc.getSchemaDescriptor() instanceof ProtoFileDescriptorSupplier).forEach(desc -> {
            String serviceName = desc.getName();
            ProtoFileDescriptorSupplier fileDescSupplier = (ProtoFileDescriptorSupplier)desc.getSchemaDescriptor();
            Descriptors.FileDescriptor fileDesc = fileDescSupplier.getFileDescriptor();
            Descriptors.ServiceDescriptor serviceDesc = fileDesc.getServices().stream().filter(sd -> sd.getFullName().equals(serviceName)).findFirst().orElseThrow(IllegalStateException::new);
            serviceInfosBuilder.addService(serviceDesc);
        });
    }

    private static Set<MediaType> supportedMediaTypes(GrpcService grpcService) {
        ImmutableSet.Builder supportedMediaTypesBuilder = ImmutableSet.builder();
        supportedMediaTypesBuilder.addAll(grpcService.supportedSerializationFormats().stream().map(SerializationFormat::mediaType)::iterator);
        if (!grpcService.isFramed()) {
            if (grpcService.supportedSerializationFormats().contains(GrpcSerializationFormats.PROTO)) {
                supportedMediaTypesBuilder.add((Object)MediaType.PROTOBUF.withParameter("protocol", "gRPC"));
            }
            if (grpcService.supportedSerializationFormats().contains(GrpcSerializationFormats.JSON)) {
                supportedMediaTypesBuilder.add((Object)MediaType.JSON_UTF_8.withParameter("protocol", "gRPC"));
            }
        }
        return supportedMediaTypesBuilder.build();
    }

    @VisibleForTesting
    static List<ServiceInfo> buildHttpServiceInfos(List<HttpEndpoint> httpEndpoints) {
        if (httpEndpoints.isEmpty()) {
            return ImmutableList.of();
        }
        HashMultimap byServiceName = HashMultimap.create();
        httpEndpoints.forEach(arg_0 -> GrpcDocServicePlugin.lambda$buildHttpServiceInfos$4((Multimap)byServiceName, arg_0));
        ImmutableList.Builder serviceInfos = ImmutableList.builder();
        byServiceName.asMap().forEach((key, value) -> serviceInfos.add((Object)GrpcDocServicePlugin.buildHttpServiceInfo(key + HTTP_SERVICE_SUFFIX, value)));
        return serviceInfos.build();
    }

    private static ServiceInfo buildHttpServiceInfo(String serviceName, Collection<HttpEndpoint> endpoints) {
        HashMultimap byMethodName = HashMultimap.create();
        endpoints.stream().sorted(Comparator.comparing(httpEndpoint -> httpEndpoint.spec().methodName() + httpEndpoint.spec().order())).forEach(arg_0 -> GrpcDocServicePlugin.lambda$buildHttpServiceInfo$7((Multimap)byMethodName, arg_0));
        ImmutableList.Builder methodInfos = ImmutableList.builder();
        byMethodName.asMap().forEach((name, httpEndpoints) -> {
            List sortedEndpoints = (List)httpEndpoints.stream().sorted(Comparator.comparingInt(ep -> ((HttpEndpoint)ep).spec.order())).collect(ImmutableList.toImmutableList());
            HttpEndpoint firstEndpoint = (HttpEndpoint)sortedEndpoints.get(0);
            HttpEndpointSpecification firstSpec = firstEndpoint.spec();
            ImmutableList.Builder fieldInfosBuilder = ImmutableList.builder();
            firstSpec.pathVariables().forEach(paramName -> {
                @Nullable HttpEndpointSpecification.Parameter parameter = firstSpec.parameters().get(paramName);
                TypeSignature typeSignature = parameter != null ? GrpcDocServicePlugin.toTypeSignature(parameter) : TypeSignature.ofBase((String)Descriptors.FieldDescriptor.JavaType.STRING.name());
                fieldInfosBuilder.add((Object)FieldInfo.builder((String)paramName, (TypeSignature)typeSignature).requirement(FieldRequirement.REQUIRED).location(FieldLocation.PATH).build());
            });
            String bodyParamName = firstSpec.httpRule().getBody();
            FieldLocation fieldLocation = Strings.isNullOrEmpty((String)bodyParamName) ? FieldLocation.QUERY : FieldLocation.BODY;
            firstSpec.parameters().forEach((paramName, parameter) -> {
                if (!firstSpec.pathVariables().contains(paramName)) {
                    FieldInfoBuilder builder = fieldLocation == FieldLocation.BODY && !"*".equals(bodyParamName) && paramName.startsWith(bodyParamName + '.') ? FieldInfo.builder((String)paramName.substring(bodyParamName.length() + 1), (TypeSignature)GrpcDocServicePlugin.toTypeSignature(parameter)) : FieldInfo.builder((String)paramName, (TypeSignature)GrpcDocServicePlugin.toTypeSignature(parameter));
                    fieldInfosBuilder.add((Object)builder.requirement(FieldRequirement.REQUIRED).location(fieldLocation).build());
                }
            });
            List endpointInfos = (List)sortedEndpoints.stream().map(httpEndpoint -> AnnotatedDocServicePlugin.endpointInfoBuilder((Route)httpEndpoint.spec().route(), (String)httpEndpoint.config().virtualHost().hostnamePattern()).availableMimeTypes(new MediaType[]{MediaType.JSON_UTF_8}).build()).collect(ImmutableList.toImmutableList());
            List examplePaths = (List)sortedEndpoints.stream().map(httpEndpoint -> {
                Route route = httpEndpoint.spec().route();
                if (route.pathType() == RoutePathType.REGEX || route.pathType() == RoutePathType.REGEX_WITH_PREFIX) {
                    return GrpcDocServicePlugin.convertRegexPath(route.patternString());
                }
                return route.patternString();
            }).collect(ImmutableList.toImmutableList());
            List exampleQueries = (List)sortedEndpoints.stream().map(httpEndpoint -> {
                HttpEndpointSpecification spec = httpEndpoint.spec();
                return spec.parameters().entrySet().stream().filter(entry -> !spec.pathVariables().contains(entry.getKey())).map(p -> (String)p.getKey() + '=' + ((HttpEndpointSpecification.Parameter)p.getValue()).type().name()).collect(Collectors.joining("&"));
            }).filter(queries -> !queries.isEmpty()).collect(ImmutableList.toImmutableList());
            methodInfos.add((Object)new MethodInfo(serviceName, firstSpec.methodName(), firstSpec.order(), GrpcDocServicePlugin.descriptiveMessageSignature(firstSpec.methodDescriptor().getOutputType()), (Iterable)fieldInfosBuilder.build(), (Iterable)endpointInfos, (Iterable)examplePaths, (Iterable)exampleQueries, firstEndpoint.httpMethod(), DescriptionInfo.empty()));
        });
        return new ServiceInfo(serviceName, (Iterable)methodInfos.build());
    }

    @VisibleForTesting
    static String convertRegexPath(String patternString) {
        return PATH_PARAM_PATTERN.matcher(patternString).replaceAll("$1");
    }

    private static TypeSignature descriptiveMessageSignature(Descriptors.Descriptor descriptor) {
        return TypeSignature.ofStruct((String)descriptor.getFullName(), (Object)descriptor);
    }

    private static TypeSignature toTypeSignature(HttpEndpointSpecification.Parameter parameter) {
        TypeSignature typeSignature = TypeSignature.ofBase((String)parameter.type().name());
        return parameter.isRepeated() ? TypeSignature.ofList((TypeSignature)typeSignature) : typeSignature;
    }

    public Map<String, DescriptionInfo> loadDocStrings(Set<ServiceConfig> serviceConfigs) {
        return (Map)serviceConfigs.stream().flatMap(c -> {
            GrpcService grpcService = (GrpcService)c.service().as(GrpcService.class);
            assert (grpcService != null);
            return grpcService.services().stream();
        }).flatMap(s -> this.docstringExtractor.getAllDocStrings(s.getClass().getClassLoader()).entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> DescriptionInfo.of((String)((String)entry.getValue())), (a, b) -> a));
    }

    public Set<Class<?>> supportedExampleRequestTypes() {
        return ImmutableSet.of(MessageOrBuilder.class);
    }

    public String serializeExampleRequest(String serviceName, String methodName, Object exampleRequest) {
        try {
            return defaultExamplePrinter.print((MessageOrBuilder)exampleRequest);
        }
        catch (InvalidProtocolBufferException e) {
            throw new UncheckedIOException("Invalid example request protobuf. Is it missing required fields?", (IOException)((Object)e));
        }
    }

    @VisibleForTesting
    ServiceSpecification generate(List<ServiceInfo> services, DescriptiveTypeInfoProvider descriptiveTypeInfoProvider) {
        return ServiceSpecification.generate(services, typeSignature -> GrpcDocServicePlugin.newDescriptiveTypeInfo(typeSignature, descriptiveTypeInfoProvider));
    }

    private static DescriptiveTypeInfo newDescriptiveTypeInfo(DescriptiveTypeSignature typeSignature, DescriptiveTypeInfoProvider descriptiveTypeInfoProvider) {
        Object descriptor = typeSignature.descriptor();
        assert (descriptor instanceof Descriptors.Descriptor || descriptor instanceof Descriptors.EnumDescriptor);
        DescriptiveTypeInfo descriptiveTypeInfo = descriptiveTypeInfoProvider.newDescriptiveTypeInfo(descriptor);
        return Objects.requireNonNull(descriptiveTypeInfo, "descriptiveTypeInfoProvider.newDescriptiveTypeInfo() returned null");
    }

    @VisibleForTesting
    static MethodInfo newMethodInfo(String serviceName, Descriptors.MethodDescriptor method, Set<EndpointInfo> endpointInfos) {
        return new MethodInfo(serviceName, method.getName(), GrpcDocServicePlugin.descriptiveMessageSignature(method.getOutputType()), (Iterable)ImmutableList.of((Object)FieldInfo.builder((String)"request", (TypeSignature)GrpcDocServicePlugin.descriptiveMessageSignature(method.getInputType())).requirement(FieldRequirement.REQUIRED).build()), true, (Iterable)ImmutableList.of(), endpointInfos, (Iterable)ImmutableList.of(), GrpcDocServicePlugin.defaultExamples(method), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), HttpMethod.POST, DescriptionInfo.empty());
    }

    private static List<String> defaultExamples(Descriptors.MethodDescriptor method) {
        try {
            DynamicMessage defaultInput = DynamicMessage.getDefaultInstance((Descriptors.Descriptor)method.getInputType());
            String serialized = defaultExamplePrinter.print((MessageOrBuilder)defaultInput).trim();
            if ("{\n}".equals(serialized) || "{}".equals(serialized)) {
                return ImmutableList.of();
            }
            return ImmutableList.of((Object)serialized);
        }
        catch (InvalidProtocolBufferException e) {
            return ImmutableList.of();
        }
    }

    @VisibleForTesting
    public String toString() {
        return GrpcDocServicePlugin.class.getSimpleName();
    }

    private static /* synthetic */ void lambda$buildHttpServiceInfo$7(Multimap byMethodName, HttpEndpoint entry) {
        byMethodName.put((Object)(entry.spec().methodName() + '/' + entry.httpMethod()), (Object)entry);
    }

    private static /* synthetic */ void lambda$buildHttpServiceInfos$4(Multimap byServiceName, HttpEndpoint httpEndpoint) {
        byServiceName.put((Object)httpEndpoint.spec().serviceName(), (Object)httpEndpoint);
    }

    @VisibleForTesting
    static final class ServiceInfosBuilder {
        private final Map<String, Descriptors.ServiceDescriptor> services = new LinkedHashMap<String, Descriptors.ServiceDescriptor>();
        private final Multimap<Descriptors.ServiceDescriptor, Descriptors.MethodDescriptor> methods = HashMultimap.create();
        private final Multimap<Descriptors.MethodDescriptor, EndpointInfo> endpoints = HashMultimap.create();

        ServiceInfosBuilder() {
        }

        ServiceInfosBuilder addService(Descriptors.ServiceDescriptor service) {
            this.services.put(service.getFullName(), service);
            return this;
        }

        ServiceInfosBuilder addEndpoint(MethodDescriptor<?, ?> grpcMethod, EndpointInfo endpointInfo) {
            Descriptors.ServiceDescriptor service = this.services.get(grpcMethod.getServiceName());
            assert (service != null);
            Descriptors.MethodDescriptor method = service.findMethodByName(grpcMethod.getBareMethodName());
            assert (method != null);
            this.methods.put((Object)service, (Object)method);
            this.endpoints.put((Object)method, (Object)endpointInfo);
            return this;
        }

        List<ServiceInfo> build(DocServiceFilter filter) {
            return (List)this.methods.asMap().entrySet().stream().map(entry -> {
                String serviceName = ((Descriptors.ServiceDescriptor)entry.getKey()).getFullName();
                List methodInfos = (List)((Collection)entry.getValue()).stream().filter(m -> filter.test(GrpcDocServicePlugin.NAME, serviceName, m.getName())).map(method -> GrpcDocServicePlugin.newMethodInfo(serviceName, method, (Set<EndpointInfo>)ImmutableSet.copyOf((Collection)this.endpoints.get(method)))).collect(ImmutableList.toImmutableList());
                if (methodInfos.isEmpty()) {
                    return null;
                }
                return new ServiceInfo(serviceName, (Iterable)methodInfos);
            }).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        }
    }

    @VisibleForTesting
    static final class HttpEndpoint {
        private final ServiceConfig config;
        private final HttpEndpointSpecification spec;

        HttpEndpoint(ServiceConfig config, HttpEndpointSpecification spec) {
            this.config = config;
            this.spec = spec;
        }

        ServiceConfig config() {
            return this.config;
        }

        HttpEndpointSpecification spec() {
            return this.spec;
        }

        HttpMethod httpMethod() {
            return (HttpMethod)this.spec.route().methods().stream().findFirst().get();
        }
    }
}

