/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc.protocol;

import com.linecorp.armeria.common.annotation.Nullable;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ByteProcessor;

public final class Base64Decoder
implements ByteProcessor {
    private static final byte EQUALS_SIGN_ENC = -1;
    private static final byte[] DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};
    private final ByteBufAllocator allocator;
    @Nullable
    private ByteBuf dest;
    private final byte[] last3 = new byte[3];
    private int pos;

    public Base64Decoder(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf decode(ByteBuf src) {
        ByteBuf dest;
        this.dest = dest = this.allocator.buffer(this.decodedBufferSize(src.readableBytes()));
        boolean success = false;
        try {
            src.forEachByte((ByteProcessor)this);
            success = true;
            ByteBuf byteBuf = dest;
            return byteBuf;
        }
        finally {
            if (!success) {
                dest.release();
            }
            src.release();
        }
    }

    private int decodedBufferSize(int len) {
        return (len + this.pos) / 4 * 3;
    }

    public boolean process(byte value) throws Exception {
        byte decodedByte = DECODABET[value & 0xFF];
        if (decodedByte < -1) {
            throw new IllegalArgumentException("invalid Base64 input character: " + (short)(value & 0xFF) + " (decimal)");
        }
        if (this.pos < 3) {
            if (this.pos < 2 && decodedByte == -1) {
                throw new IllegalArgumentException("invalid padding position: " + this.pos + " (expected: 2 or 3)");
            }
            this.last3[this.pos++] = decodedByte;
            return true;
        }
        this.pos = 0;
        byte b0 = this.last3[0];
        byte b1 = this.last3[1];
        byte b2 = this.last3[2];
        ByteBuf dest = this.dest;
        assert (dest != null);
        byte b3 = decodedByte;
        if (b2 == -1) {
            if (b3 != -1) {
                throw new IllegalArgumentException("a non padding character can't follow to a padding. character: " + b3);
            }
            dest.writeByte((b0 & 0xFF) << 2 | (b1 & 0xFF) >>> 4);
            return true;
        }
        if (b3 == -1) {
            dest.writeShort(((b0 & 0x3F) << 2 | (b1 & 0xF0) >> 4) << 8 | (b1 & 0xF) << 4 | (b2 & 0xFC) >>> 2);
            return true;
        }
        dest.writeMedium((b0 & 0x3F) << 18 | (b1 & 0xFF) << 12 | (b2 & 0xFF) << 6 | b3 & 0xFF);
        return true;
    }
}

