/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Internal;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;

@Internal
public class LockKit {

    public static class ComputedOnce {
        private volatile boolean beenComputed = false;
        private final ReentrantLock lock = new ReentrantLock();

        public boolean hasBeenComputed() {
            return this.beenComputed;
        }

        public void runOnce(Runnable codeToRunOnce) {
            if (this.beenComputed) {
                return;
            }
            this.lock.runLocked(() -> {
                if (this.beenComputed) {
                    return;
                }
                try {
                    codeToRunOnce.run();
                    this.beenComputed = true;
                }
                finally {
                    this.beenComputed = true;
                }
            });
        }
    }

    public static class ReentrantLock {
        private final Lock lock = new java.util.concurrent.locks.ReentrantLock();

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }

        public void runLocked(Runnable codeToRun) {
            this.lock.lock();
            try {
                codeToRun.run();
            }
            finally {
                this.lock.unlock();
            }
        }

        public <E> E callLocked(Supplier<E> codeToRun) {
            this.lock.lock();
            try {
                E e = codeToRun.get();
                return e;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

