/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceFieldSelector;
import io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent;
import io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluentImpl;

public class ResourceFieldSelectorBuilder
extends ResourceFieldSelectorFluentImpl<ResourceFieldSelectorBuilder>
implements VisitableBuilder<ResourceFieldSelector, ResourceFieldSelectorBuilder> {
    ResourceFieldSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceFieldSelectorBuilder() {
        this(false);
    }

    public ResourceFieldSelectorBuilder(Boolean validationEnabled) {
        this(new ResourceFieldSelector(), validationEnabled);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceFieldSelector(), validationEnabled);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent, ResourceFieldSelector instance) {
        this(fluent, instance, false);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent, ResourceFieldSelector instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withContainerName(instance.getContainerName());
            fluent.withDivisor(instance.getDivisor());
            fluent.withResource(instance.getResource());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelector instance) {
        this(instance, (Boolean)false);
    }

    public ResourceFieldSelectorBuilder(ResourceFieldSelector instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withContainerName(instance.getContainerName());
            this.withDivisor(instance.getDivisor());
            this.withResource(instance.getResource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceFieldSelector build() {
        ResourceFieldSelector buildable = new ResourceFieldSelector(this.fluent.getContainerName(), this.fluent.getDivisor(), this.fluent.getResource());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

