/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.clustering.BisectingKMeans$;
import org.apache.spark.mllib.clustering.BisectingKMeansModel;
import org.apache.spark.mllib.clustering.ClusteringTreeNode;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Seq$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r-h\u0001\u00022d\u00019D\u0001b\u001f\u0001\u0003\u0002\u0004%I\u0001 \u0005\u000b\u0003\u0003\u0001!\u00111A\u0005\n\u0005\r\u0001\"CA\b\u0001\t\u0005\t\u0015)\u0003~\u0011%\t\t\u0002\u0001BA\u0002\u0013%A\u0010\u0003\u0006\u0002\u0014\u0001\u0011\t\u0019!C\u0005\u0003+A\u0011\"!\u0007\u0001\u0005\u0003\u0005\u000b\u0015B?\t\u0015\u0005m\u0001A!a\u0001\n\u0013\ti\u0002\u0003\u0006\u0002&\u0001\u0011\t\u0019!C\u0005\u0003OA!\"a\u000b\u0001\u0005\u0003\u0005\u000b\u0015BA\u0010\u0011)\ti\u0003\u0001BA\u0002\u0013%\u0011q\u0006\u0005\u000b\u0003o\u0001!\u00111A\u0005\n\u0005e\u0002BCA\u001f\u0001\t\u0005\t\u0015)\u0003\u00022!Q\u0011q\b\u0001\u0003\u0002\u0004%I!!\u0011\t\u0015\u0005e\u0003A!a\u0001\n\u0013\tY\u0006\u0003\u0006\u0002`\u0001\u0011\t\u0011)Q\u0005\u0003\u0007Bq!!\u0019\u0001\t\u0013\t\u0019\u0007C\u0004\u0002b\u0001!\t!a\u001d\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\"1\u0011\u0011\u0013\u0001\u0005\u0002qDq!!&\u0001\t\u0003\t9\n\u0003\u0004\u0002\u001e\u0002!\t\u0001 \u0005\b\u0003C\u0003A\u0011AAR\u0011\u001d\tI\u000b\u0001C\u0001\u0003;Aq!!,\u0001\t\u0003\ty\u000bC\u0004\u00026\u0002!\t!a\f\t\u000f\u0005e\u0006\u0001\"\u0001\u0002B!9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007\u0002CAe\u0001\u0011\u0005q-a3\t\u000f\te\u0001\u0001\"\u0001\u0003\u001c!9!\u0011\u0004\u0001\u0005\u0002\t\u0015ra\u0002B\u001fG\"%!q\b\u0004\u0007E\u000eDIA!\u0011\t\u000f\u0005\u0005\u0004\u0005\"\u0001\u0003J!I!1\n\u0011C\u0002\u0013%\u0011q\u0006\u0005\t\u0005\u001b\u0002\u0003\u0015!\u0003\u00022!I!q\n\u0011C\u0002\u0013%\u0011q\u0006\u0005\t\u0005#\u0002\u0003\u0015!\u0003\u00022!I!1\u000b\u0011C\u0002\u0013%\u0011Q\u0004\u0005\t\u0005+\u0002\u0003\u0015!\u0003\u0002 !9!q\u000b\u0011\u0005\n\te\u0003b\u0002B0A\u0011%!\u0011\r\u0005\b\u0005K\u0002C\u0011\u0002B4\u0011\u001d\u0011Y\u0007\tC\u0005\u0005[2aaa\u000b!\t\r5\u0002\"CB\rY\t\u0015\r\u0011\"\u0001}\u0011%\u0019y\u0003\fB\u0001B\u0003%Q\u0010\u0003\u0006\u0002@1\u0012)\u0019!C\u0001\u0007cA!\"a\u0018-\u0005\u0003\u0005\u000b\u0011BB\u0013\u0011\u001d\t\t\u0007\fC\u0001\u0007gA\u0011ba\u000f-\u0001\u0004%I!a\f\t\u0013\ruB\u00061A\u0005\n\r}\u0002\u0002CB\"Y\u0001\u0006K!!\r\t\u0013\t\u001dE\u00061A\u0005\n\u0005u\u0001\"CB#Y\u0001\u0007I\u0011BB$\u0011!\u0011I\t\fQ!\n\u0005}\u0001\"CB&Y\t\u0007I\u0011BB'\u0011!\u0019y\u0005\fQ\u0001\n\u0005%\b\"CB)Y\u0001\u0007I\u0011BA\u000f\u0011%\u0019\u0019\u0006\fa\u0001\n\u0013\u0019)\u0006\u0003\u0005\u0004Z1\u0002\u000b\u0015BA\u0010\u0011\u001d\u0019Y\u0006\fC\u0001\u0007;Bqa!\u001a-\t\u0003\u00199\u0007C\u0004\u0004n1\"\taa\u001c\t\u000f\rE\u0004\u0005\"\u0003\u0004t!91\u0011\u0012\u0011\u0005\n\r-\u0005bBBQA\u0011%11\u0015\u0004\u0007\u0005s\u0002CIa\u001f\t\u0015\t\r5I!f\u0001\n\u0003\ty\u0003\u0003\u0006\u0003\u0006\u000e\u0013\t\u0012)A\u0005\u0003cA!Ba\"D\u0005+\u0007I\u0011AA\u000f\u0011)\u0011Ii\u0011B\tB\u0003%\u0011q\u0004\u0005\u000b\u0005\u0017\u001b%Q3A\u0005\u0002\t5\u0005B\u0003BK\u0007\nE\t\u0015!\u0003\u0003\u0010\"Q!qS\"\u0003\u0016\u0004%\t!!\b\t\u0015\te5I!E!\u0002\u0013\ty\u0002C\u0004\u0002b\r#\tAa'\t\u0013\t\u00156)!A\u0005\u0002\t\u001d\u0006\"\u0003BY\u0007F\u0005I\u0011\u0001BZ\u0011%\u00119mQI\u0001\n\u0003\u0011I\rC\u0005\u0003N\u000e\u000b\n\u0011\"\u0001\u0003P\"I!1[\"\u0012\u0002\u0013\u0005!\u0011\u001a\u0005\n\u0005+\u001c\u0015\u0011!C!\u0005/D\u0001B!:D\u0003\u0003%\t\u0001 \u0005\n\u0005O\u001c\u0015\u0011!C\u0001\u0005SD\u0011Ba=D\u0003\u0003%\tE!>\t\u0013\r\r1)!A\u0005\u0002\r\u0015\u0001\"CB\u0005\u0007\u0006\u0005I\u0011IB\u0006\u0011%\u0019iaQA\u0001\n\u0003\u001ay\u0001C\u0005\u0004\u0012\r\u000b\t\u0011\"\u0011\u0004\u0014\u001dI1\u0011\u0017\u0011\u0002\u0002#%11\u0017\u0004\n\u0005s\u0002\u0013\u0011!E\u0005\u0007kCq!!\u0019\\\t\u0003\u0019\u0019\rC\u0005\u0004\u000em\u000b\t\u0011\"\u0012\u0004\u0010!I1QY.\u0002\u0002\u0013\u00055q\u0019\u0005\n\u0007#\\\u0016\u0011!CA\u0007'D\u0011b!9\\\u0003\u0003%Iaa9\t\u0013\r\u0005\b%!A\u0005\n\r\r(a\u0004\"jg\u0016\u001cG/\u001b8h\u00176+\u0017M\\:\u000b\u0005\u0011,\u0017AC2mkN$XM]5oO*\u0011amZ\u0001\u0006[2d\u0017N\u0019\u0006\u0003Q&\fQa\u001d9be.T!A[6\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0017aA8sO\u000e\u00011c\u0001\u0001pkB\u0011\u0001o]\u0007\u0002c*\t!/A\u0003tG\u0006d\u0017-\u0003\u0002uc\n1\u0011I\\=SK\u001a\u0004\"A^=\u000e\u0003]T!\u0001_4\u0002\u0011%tG/\u001a:oC2L!A_<\u0003\u000f1{wmZ5oO\u0006\t1.F\u0001~!\t\u0001h0\u0003\u0002\u0000c\n\u0019\u0011J\u001c;\u0002\u000b-|F%Z9\u0015\t\u0005\u0015\u00111\u0002\t\u0004a\u0006\u001d\u0011bAA\u0005c\n!QK\\5u\u0011!\tiAAA\u0001\u0002\u0004i\u0018a\u0001=%c\u0005\u00111\u000eI\u0001\u000e[\u0006D\u0018\n^3sCRLwN\\:\u0002#5\f\u00070\u0013;fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005]\u0001\u0002CA\u0007\u000b\u0005\u0005\t\u0019A?\u0002\u001d5\f\u00070\u0013;fe\u0006$\u0018n\u001c8tA\u00059R.\u001b8ESZL7/\u001b2mK\u000ecWo\u001d;feNK'0Z\u000b\u0003\u0003?\u00012\u0001]A\u0011\u0013\r\t\u0019#\u001d\u0002\u0007\t>,(\r\\3\u000275Lg\u000eR5wSNL'\r\\3DYV\u001cH/\u001a:TSj,w\fJ3r)\u0011\t)!!\u000b\t\u0013\u00055\u0001\"!AA\u0002\u0005}\u0011\u0001G7j]\u0012Kg/[:jE2,7\t\\;ti\u0016\u00148+\u001b>fA\u0005!1/Z3e+\t\t\t\u0004E\u0002q\u0003gI1!!\u000er\u0005\u0011auN\\4\u0002\u0011M,W\rZ0%KF$B!!\u0002\u0002<!I\u0011QB\u0006\u0002\u0002\u0003\u0007\u0011\u0011G\u0001\u0006g\u0016,G\rI\u0001\u0010I&\u001cH/\u00198dK6+\u0017m];sKV\u0011\u00111\t\t\u0005\u0003\u000b\n\u0019F\u0004\u0003\u0002H\u0005=\u0003cAA%c6\u0011\u00111\n\u0006\u0004\u0003\u001bj\u0017A\u0002\u001fs_>$h(C\u0002\u0002RE\fa\u0001\u0015:fI\u00164\u0017\u0002BA+\u0003/\u0012aa\u0015;sS:<'bAA)c\u0006\u0019B-[:uC:\u001cW-T3bgV\u0014Xm\u0018\u0013fcR!\u0011QAA/\u0011%\tiADA\u0001\u0002\u0004\t\u0019%\u0001\teSN$\u0018M\\2f\u001b\u0016\f7/\u001e:fA\u00051A(\u001b8jiz\"B\"!\u001a\u0002j\u0005-\u0014QNA8\u0003c\u00022!a\u001a\u0001\u001b\u0005\u0019\u0007\"B>\u0011\u0001\u0004i\bBBA\t!\u0001\u0007Q\u0010C\u0004\u0002\u001cA\u0001\r!a\b\t\u000f\u00055\u0002\u00031\u0001\u00022!9\u0011q\b\tA\u0002\u0005\rCCAA3Q\u0015\t\u0012qOAB!\u0011\tI(a \u000e\u0005\u0005m$bAA?O\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u00151\u0010\u0002\u0006'&t7-Z\u0011\u0003\u0003\u000b\u000bQ!\r\u00187]A\nAa]3u\u0017R!\u00111RAG\u001b\u0005\u0001\u0001\"B>\u0013\u0001\u0004i\b&\u0002\n\u0002x\u0005\r\u0015\u0001B4fi.CSaEA<\u0003\u0007\u000b\u0001c]3u\u001b\u0006D\u0018\n^3sCRLwN\\:\u0015\t\u0005-\u0015\u0011\u0014\u0005\u0007\u0003#!\u0002\u0019A?)\u000bQ\t9(a!\u0002!\u001d,G/T1y\u0013R,'/\u0019;j_:\u001c\b&B\u000b\u0002x\u0005\r\u0015AG:fi6Kg\u000eR5wSNL'\r\\3DYV\u001cH/\u001a:TSj,G\u0003BAF\u0003KCq!a\u0007\u0017\u0001\u0004\ty\u0002K\u0003\u0017\u0003o\n\u0019)\u0001\u000ehKRl\u0015N\u001c#jm&\u001c\u0018N\u00197f\u00072,8\u000f^3s'&TX\rK\u0003\u0018\u0003o\n\u0019)A\u0004tKR\u001cV-\u001a3\u0015\t\u0005-\u0015\u0011\u0017\u0005\b\u0003[A\u0002\u0019AA\u0019Q\u0015A\u0012qOAB\u0003\u001d9W\r^*fK\u0012DS!GA<\u0003\u0007\u000b!cZ3u\t&\u001cH/\u00198dK6+\u0017m];sK\"*!$a\u001e\u0002>\u0006\u0012\u0011qX\u0001\u0006e9\"d\u0006M\u0001\u0013g\u0016$H)[:uC:\u001cW-T3bgV\u0014X\r\u0006\u0003\u0002\f\u0006\u0015\u0007bBA 7\u0001\u0007\u00111\t\u0015\u00067\u0005]\u0014QX\u0001\u000eeVtw+\u001b;i/\u0016Lw\r\u001b;\u0015\u0011\u00055\u00171[A{\u0003\u007f\u0004B!a\u001a\u0002P&\u0019\u0011\u0011[2\u0003)\tK7/Z2uS:<7*T3b]Nlu\u000eZ3m\u0011\u001d\t)\u000e\ba\u0001\u0003/\f\u0011\"\u001b8ti\u0006t7-Z:\u0011\r\u0005e\u0017q\\Ar\u001b\t\tYNC\u0002\u0002^\u001e\f1A\u001d3e\u0013\u0011\t\t/a7\u0003\u0007I#E\tE\u0004q\u0003K\fI/a\b\n\u0007\u0005\u001d\u0018O\u0001\u0004UkBdWM\r\t\u0005\u0003W\f\t0\u0004\u0002\u0002n*\u0019\u0011q^3\u0002\r1Lg.\u00197h\u0013\u0011\t\u00190!<\u0003\rY+7\r^8s\u0011\u001d\t9\u0010\ba\u0001\u0003s\f\u0011\u0003[1oI2,\u0007+\u001a:tSN$XM\\2f!\r\u0001\u00181`\u0005\u0004\u0003{\f(a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005\u0003a\u0002\u0019\u0001B\u0002\u0003\u0015Ign\u001d;s!\u0015\u0001(Q\u0001B\u0005\u0013\r\u00119!\u001d\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\t-!QC\u0007\u0003\u0005\u001bQAAa\u0004\u0003\u0012\u0005!Q\u000f^5m\u0015\r\u0011\u0019bZ\u0001\u0003[2LAAa\u0006\u0003\u000e\ty\u0011J\\:ueVlWM\u001c;bi&|g.A\u0002sk:$B!!4\u0003\u001e!9!qD\u000fA\u0002\t\u0005\u0012!B5oaV$\bCBAm\u0003?\fI\u000fK\u0003\u001e\u0003o\n\u0019\t\u0006\u0003\u0002N\n\u001d\u0002b\u0002B\u0015=\u0001\u0007!1F\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0003.\t]\u0012\u0011^\u0007\u0003\u0005_QAA!\r\u00034\u0005!!.\u0019<b\u0015\r\u0011)dZ\u0001\u0004CBL\u0017\u0002\u0002B\u001d\u0005_\u0011qAS1wCJ#E\tK\u0003\u0001\u0003o\n\u0019)A\bCSN,7\r^5oO.kU-\u00198t!\r\t9\u0007I\n\u0005A=\u0014\u0019\u0005E\u0002q\u0005\u000bJ1Aa\u0012r\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011y$\u0001\u0006S\u001f>#v,\u0013(E\u000bb\u000b1BU(P)~Ke\nR#YA\u0005YR*\u0011-`\t&3\u0016jU%C\u0019\u0016{6\tT+T)\u0016\u0013v,\u0013(E\u000bb\u000bA$T!Y?\u0012Ke+S*J\u00052+ul\u0011'V'R+%kX%O\t\u0016C\u0006%A\u0006M\u000bZ+Ej\u0018'J\u001b&#\u0016\u0001\u0004'F-\u0016cu\fT%N\u0013R\u0003\u0013A\u00047fMR\u001c\u0005.\u001b7e\u0013:$W\r\u001f\u000b\u0005\u0003c\u0011Y\u0006C\u0004\u0003^!\u0002\r!!\r\u0002\u000b%tG-\u001a=\u0002\u001fILw\r\u001b;DQ&dG-\u00138eKb$B!!\r\u0003d!9!QL\u0015A\u0002\u0005E\u0012a\u00039be\u0016tG/\u00138eKb$B!!\r\u0003j!9!Q\f\u0016A\u0002\u0005E\u0012!C:v[6\f'/\u001b>f)!\u0011yga\u0006\u0004\u001c\r\r\u0002\u0003CA#\u0005c\n\tD!\u001e\n\t\tM\u0014q\u000b\u0002\u0004\u001b\u0006\u0004\bc\u0001B<\u00076\t\u0001E\u0001\bDYV\u001cH/\u001a:Tk6l\u0017M]=\u0014\r\r{'Q\u0010B\"!\r\u0001(qP\u0005\u0004\u0005\u0003\u000b(a\u0002)s_\u0012,8\r^\u0001\u0005g&TX-A\u0003tSj,\u0007%A\u0005xK&<\u0007\u000e^*v[\u0006Qq/Z5hQR\u001cV/\u001c\u0011\u0002\r\r,g\u000e^3s+\t\u0011y\t\u0005\u0003\u0002h\tE\u0015b\u0001BJG\nqa+Z2u_J<\u0016\u000e\u001e5O_Jl\u0017aB2f]R,'\u000fI\u0001\u0005G>\u001cH/A\u0003d_N$\b\u0005\u0006\u0006\u0003v\tu%q\u0014BQ\u0005GCqAa!M\u0001\u0004\t\t\u0004C\u0004\u0003\b2\u0003\r!a\b\t\u000f\t-E\n1\u0001\u0003\u0010\"9!q\u0013'A\u0002\u0005}\u0011\u0001B2paf$\"B!\u001e\u0003*\n-&Q\u0016BX\u0011%\u0011\u0019)\u0014I\u0001\u0002\u0004\t\t\u0004C\u0005\u0003\b6\u0003\n\u00111\u0001\u0002 !I!1R'\u0011\u0002\u0003\u0007!q\u0012\u0005\n\u0005/k\u0005\u0013!a\u0001\u0003?\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00036*\"\u0011\u0011\u0007B\\W\t\u0011I\f\u0005\u0003\u0003<\n\rWB\u0001B_\u0015\u0011\u0011yL!1\u0002\u0013Ut7\r[3dW\u0016$'bAA?c&!!Q\u0019B_\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011YM\u000b\u0003\u0002 \t]\u0016AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005#TCAa$\u00038\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003ZB!!1\u001cBr\u001b\t\u0011iN\u0003\u0003\u0003`\n\u0005\u0018\u0001\u00027b]\u001eT!A!\r\n\t\u0005U#Q\\\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011YO!=\u0011\u0007A\u0014i/C\u0002\u0003pF\u00141!\u00118z\u0011!\ti\u0001VA\u0001\u0002\u0004i\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t]\bC\u0002B}\u0005\u007f\u0014Y/\u0004\u0002\u0003|*\u0019!Q`9\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004\u0002\tm(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!?\u0004\b!I\u0011Q\u0002,\u0002\u0002\u0003\u0007!1^\u0001\tQ\u0006\u001c\bnQ8eKR\tQ0\u0001\u0005u_N#(/\u001b8h)\t\u0011I.\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003s\u001c)\u0002C\u0005\u0002\u000ee\u000b\t\u00111\u0001\u0003l\"11\u0011D\u0016A\u0002u\f\u0011\u0001\u001a\u0005\b\u0007;Y\u0003\u0019AB\u0010\u0003-\t7o]5h]6,g\u000e^:\u0011\r\u0005e\u0017q\\B\u0011!\u001d\u0001\u0018Q]A\u0019\u0005\u001fCq!a\u0010,\u0001\u0004\u0019)\u0003\u0005\u0003\u0002h\r\u001d\u0012bAB\u0015G\nyA)[:uC:\u001cW-T3bgV\u0014XM\u0001\rDYV\u001cH/\u001a:Tk6l\u0017M]=BO\u001e\u0014XmZ1u_J\u001cB\u0001L8\u0003D\u0005\u0011A\rI\u000b\u0003\u0007K!ba!\u000e\u00048\re\u0002c\u0001B<Y!11\u0011D\u0019A\u0002uDq!a\u00102\u0001\u0004\u0019)#A\u0001o\u0003\u0015qw\fJ3r)\u0011\t)a!\u0011\t\u0013\u000551'!AA\u0002\u0005E\u0012A\u00018!\u000359X-[4iiN+Xn\u0018\u0013fcR!\u0011QAB%\u0011%\tiANA\u0001\u0002\u0004\ty\"A\u0002tk6,\"!!;\u0002\tM,X\u000eI\u0001\u0006gVl7+]\u0001\ngVl7+]0%KF$B!!\u0002\u0004X!I\u0011QB\u001e\u0002\u0002\u0003\u0007\u0011qD\u0001\u0007gVl7+\u001d\u0011\u0002\u0007\u0005$G\r\u0006\u0003\u0004`\r\u0005T\"\u0001\u0017\t\u000f\r\rT\b1\u0001\u0003\u0010\u0006\ta/A\u0003nKJ<W\r\u0006\u0003\u0004`\r%\u0004bBB6}\u0001\u00071QG\u0001\u0006_RDWM]\u0001\bgVlW.\u0019:z+\t\u0011)(A\u0006ta2LGoQ3oi\u0016\u0014H\u0003CB;\u0007o\u001aIha\"\u0011\u000fA\f)Oa$\u0003\u0010\"9!1\u0012!A\u0002\t=\u0005bBB>\u0001\u0002\u00071QP\u0001\u0007e\u0006tGm\\7\u0011\t\r}41Q\u0007\u0003\u0007\u0003SAAa\u0004\u0003b&!1QQBA\u0005\u0019\u0011\u0016M\u001c3p[\"9\u0011q\b!A\u0002\r\u0015\u0012!E;qI\u0006$X-Q:tS\u001etW.\u001a8ugRQ1qDBG\u0007\u001f\u001bIja(\t\u000f\ru\u0011\t1\u0001\u0004 !91\u0011S!A\u0002\rM\u0015\u0001\u00053jm&\u001c\u0018N\u00197f\u0013:$\u0017nY3t!\u0019\t)e!&\u00022%!1qSA,\u0005\r\u0019V\r\u001e\u0005\b\u00077\u000b\u0005\u0019ABO\u0003EqWm^\"mkN$XM]\"f]R,'o\u001d\t\t\u0003\u000b\u0012\t(!\r\u0003\u0010\"9\u0011qH!A\u0002\r\u0015\u0012!\u00032vS2$GK]3f)\u0019\u0019)ka+\u00040B!\u0011qMBT\u0013\r\u0019Ik\u0019\u0002\u0013\u00072,8\u000f^3sS:<GK]3f\u001d>$W\rC\u0004\u0004.\n\u0003\rAa\u001c\u0002\u0011\rdWo\u001d;feNDq!a\u0010C\u0001\u0004\u0019)#\u0001\bDYV\u001cH/\u001a:Tk6l\u0017M]=\u0011\u0007\t]4lE\u0003\\\u0007o\u0013\u0019\u0005\u0005\b\u0004:\u000e}\u0016\u0011GA\u0010\u0005\u001f\u000byB!\u001e\u000e\u0005\rm&bAB_c\u00069!/\u001e8uS6,\u0017\u0002BBa\u0007w\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85)\t\u0019\u0019,A\u0003baBd\u0017\u0010\u0006\u0006\u0003v\r%71ZBg\u0007\u001fDqAa!_\u0001\u0004\t\t\u0004C\u0004\u0003\bz\u0003\r!a\b\t\u000f\t-e\f1\u0001\u0003\u0010\"9!q\u00130A\u0002\u0005}\u0011aB;oCB\u0004H.\u001f\u000b\u0005\u0007+\u001ci\u000eE\u0003q\u0005\u000b\u00199\u000eE\u0006q\u00073\f\t$a\b\u0003\u0010\u0006}\u0011bABnc\n1A+\u001e9mKRB\u0011ba8`\u0003\u0003\u0005\rA!\u001e\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCABs!\u0011\u0011Yna:\n\t\r%(Q\u001c\u0002\u0007\u001f\nTWm\u0019;")
public class BisectingKMeans
implements Logging {
    private int k;
    private int maxIterations;
    private double minDivisibleClusterSize;
    private long seed;
    private String distanceMeasure;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private double minDivisibleClusterSize() {
        return this.minDivisibleClusterSize;
    }

    private void minDivisibleClusterSize_$eq(double x$1) {
        this.minDivisibleClusterSize = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private String distanceMeasure() {
        return this.distanceMeasure;
    }

    private void distanceMeasure_$eq(String x$1) {
        this.distanceMeasure = x$1;
    }

    public BisectingKMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("k must be positive but got ").append(k).append(".").toString());
        this.k_$eq(k);
        return this;
    }

    public int getK() {
        return this.k();
    }

    public BisectingKMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("maxIterations must be positive but got ").append(maxIterations).append(".").toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public BisectingKMeans setMinDivisibleClusterSize(double minDivisibleClusterSize) {
        Predef$.MODULE$.require(minDivisibleClusterSize > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("minDivisibleClusterSize must be positive but got ").append(minDivisibleClusterSize).append(".").toString());
        this.minDivisibleClusterSize_$eq(minDivisibleClusterSize);
        return this;
    }

    public double getMinDivisibleClusterSize() {
        return this.minDivisibleClusterSize();
    }

    public BisectingKMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public String getDistanceMeasure() {
        return this.distanceMeasure();
    }

    public BisectingKMeans setDistanceMeasure(String distanceMeasure) {
        DistanceMeasure$.MODULE$.validateDistanceMeasure(distanceMeasure);
        this.distanceMeasure_$eq(distanceMeasure);
        return this;
    }

    public BisectingKMeansModel runWithWeight(RDD<Tuple2<Vector, Object>> instances, boolean handlePersistence, Option<Instrumentation> instr) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        int d2 = BoxesRunTime.unboxToInt((Object)instances.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)BisectingKMeans.$anonfun$runWithWeight$1(x$1)), ClassTag$.MODULE$.Int()).first());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Feature dimension: ").append(d2).append(".").toString());
        DistanceMeasure dMeasure = DistanceMeasure$.MODULE$.decodeFromString(this.distanceMeasure());
        RDD norms = instances.map((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToDouble((double)Vectors$.MODULE$.norm((Vector)d._1(), 2.0)), ClassTag$.MODULE$.Double());
        RDD vectors = instances.zip(norms, ClassTag$.MODULE$.Double()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                double norm = tuple2._2$mcD$sp();
                if (tuple22 != null) {
                    Vector x = (Vector)tuple22._1();
                    double weight = tuple22._2$mcD$sp();
                    return new VectorWithNorm(x, norm, weight);
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        RDD rDD = handlePersistence ? vectors.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : norms.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        ObjectRef assignments = ObjectRef.create((Object)vectors.map((Function1 & Serializable & scala.Serializable)v -> new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX()), v), ClassTag$.MODULE$.apply(Tuple2.class)));
        ObjectRef activeClusters = ObjectRef.create(BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(d2, (RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments.elem), dMeasure));
        instr.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.logNumExamples(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((Map)activeClusters.elem).values().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            return BoxedUnit.UNIT;
        });
        instr.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.logSumOfWeights(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((Map)activeClusters.elem).values().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5.weightSum()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
            return BoxedUnit.UNIT;
        });
        ClusterSummary rootSummary = (ClusterSummary)((Map)activeClusters.elem).apply((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX()));
        long n = rootSummary.size();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Number of points: ").append(n).append(".").toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Initial cost: ").append(rootSummary.cost()).append(".").toString());
        long minSize = this.minDivisibleClusterSize() >= 1.0 ? (long)scala.math.package$.MODULE$.ceil(this.minDivisibleClusterSize()) : (long)scala.math.package$.MODULE$.ceil(this.minDivisibleClusterSize() * (double)n);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("The minimum number of points of a divisible cluster is ").append(minSize).append(".").toString());
        scala.collection.mutable.Seq inactiveClusters = (scala.collection.mutable.Seq)Seq$.MODULE$.empty();
        Random random = new Random(this.seed());
        int numLeafClustersNeeded = this.k() - 1;
        IntRef level = IntRef.create((int)1);
        RDD preIndices = null;
        RDD indices = null;
        while (((Map)activeClusters.elem).nonEmpty() && numLeafClustersNeeded > 0 && (double)level.elem < BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT()) {
            Map divisibleClusters = (Map)((Map)activeClusters.elem).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)BisectingKMeans.$anonfun$runWithWeight$13(minSize, x0$2)));
            if (divisibleClusters.size() > numLeafClustersNeeded) {
                divisibleClusters = ((TraversableOnce)((IterableLike)divisibleClusters.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToLong((long)BisectingKMeans.$anonfun$runWithWeight$14(x0$3)), (Ordering)Ordering.Long$.MODULE$)).take(numLeafClustersNeeded)).toMap(Predef$.MODULE$.$conforms());
            }
            if (divisibleClusters.nonEmpty()) {
                BoxedUnit boxedUnit3;
                Set divisibleIndices = divisibleClusters.keys().toSet();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Dividing ").append(divisibleIndices.size()).append(" clusters on level ").append(level$1.elem).append(".").toString());
                ObjectRef newClusterCenters = ObjectRef.create((Object)((Map)((TraversableLike)divisibleClusters.flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 != null) {
                        long index = tuple2._1$mcJ$sp();
                        ClusterSummary summary = (ClusterSummary)tuple2._2();
                        Tuple2<VectorWithNorm, VectorWithNorm> tuple22 = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$splitCenter(summary.center(), random, dMeasure);
                        if (tuple22 == null) {
                            throw new MatchError(tuple22);
                        }
                        VectorWithNorm left = (VectorWithNorm)tuple22._1();
                        VectorWithNorm right = (VectorWithNorm)tuple22._2();
                        Tuple2 tuple23 = new Tuple2((Object)left, (Object)right);
                        VectorWithNorm left2 = (VectorWithNorm)tuple23._1();
                        VectorWithNorm right2 = (VectorWithNorm)tuple23._2();
                        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(index)), (Object)left2), new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$rightChildIndex(index)), (Object)right2)}));
                    }
                    throw new MatchError((Object)tuple2);
                }, Map$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom())));
                ObjectRef newClusters = ObjectRef.create(null);
                ObjectRef newAssignments = ObjectRef.create(null);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.maxIterations()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                    newAssignments$1.elem = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments((RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments$1.elem), (Set<Object>)divisibleIndices, (Map<Object, VectorWithNorm>)((Map)newClusterCenters$1.elem), dMeasure).filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)BisectingKMeans.$anonfun$runWithWeight$19(divisibleIndices, x0$5)));
                    newClusters$1.elem = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(d2, (RDD<Tuple2<Object, VectorWithNorm>>)((RDD)newAssignments$1.elem), dMeasure);
                    newClusterCenters$1.elem = ((Map)((Map)newClusters$1.elem).mapValues((Function1 & Serializable & scala.Serializable)x$7 -> x$7.center()).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                });
                if (preIndices != null) {
                    RDD qual$1 = preIndices;
                    boolean x$12 = qual$1.unpersist$default$1();
                    boxedUnit3 = qual$1.unpersist(x$12);
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                preIndices = indices;
                indices = RDD$.MODULE$.rddToPairRDDFunctions(BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments((RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments.elem), (Set<Object>)divisibleIndices, (Map<Object, VectorWithNorm>)((Map)newClusterCenters.elem), dMeasure), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(VectorWithNorm.class), (Ordering)Ordering.Long$.MODULE$).keys().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
                assignments.elem = indices.zip(vectors, ClassTag$.MODULE$.apply(VectorWithNorm.class));
                inactiveClusters = (scala.collection.mutable.Seq)inactiveClusters.$plus$plus((GenTraversableOnce)((Map)activeClusters.elem), Seq$.MODULE$.canBuildFrom());
                activeClusters.elem = (Map)newClusters.elem;
                numLeafClustersNeeded -= divisibleClusters.size();
            } else {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("None active and divisible clusters left on level ").append(level$1.elem).append(". Stop iterations.").toString());
                inactiveClusters = (scala.collection.mutable.Seq)inactiveClusters.$plus$plus((GenTraversableOnce)((Map)activeClusters.elem), Seq$.MODULE$.canBuildFrom());
                activeClusters.elem = Predef$.MODULE$.Map().empty();
            }
            ++level.elem;
        }
        if (preIndices != null) {
            RDD qual$2 = preIndices;
            boolean x$22 = qual$2.unpersist$default$1();
            boxedUnit2 = qual$2.unpersist(x$22);
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (indices != null) {
            RDD qual$3 = indices;
            boolean x$3 = qual$3.unpersist$default$1();
            boxedUnit = qual$3.unpersist(x$3);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RDD rDD2 = handlePersistence ? vectors.unpersist(vectors.unpersist$default$1()) : norms.unpersist(norms.unpersist$default$1());
        Map clusters = ((Map)activeClusters.elem).$plus$plus((GenTraversableOnce)inactiveClusters);
        ClusteringTreeNode root = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$buildTree((Map<Object, ClusterSummary>)clusters, dMeasure);
        double totalCost = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root.leafNodes())).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)x$8.cost()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return new BisectingKMeansModel(root, this.distanceMeasure(), totalCost);
    }

    public BisectingKMeansModel run(RDD<Vector> input) {
        RDD instances = input.map((Function1 & Serializable & scala.Serializable)point -> new Tuple2(point, (Object)BoxesRunTime.boxToDouble((double)1.0)), ClassTag$.MODULE$.apply(Tuple2.class));
        StorageLevel storageLevel = input.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        return this.runWithWeight((RDD<Tuple2<Vector, Object>>)instances, handlePersistence, (Option<Instrumentation>)None$.MODULE$);
    }

    public BisectingKMeansModel run(JavaRDD<Vector> data) {
        return this.run((RDD<Vector>)data.rdd());
    }

    public static final /* synthetic */ int $anonfun$runWithWeight$1(Tuple2 x$1) {
        return ((Vector)x$1._1()).size();
    }

    public static final /* synthetic */ boolean $anonfun$runWithWeight$13(long minSize$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            ClusterSummary summary = (ClusterSummary)tuple2._2();
            return summary.size() >= minSize$1 && summary.cost() > MLUtils$.MODULE$.EPSILON() * (double)summary.size();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$runWithWeight$14(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            ClusterSummary summary = (ClusterSummary)tuple2._2();
            return -summary.size();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$runWithWeight$19(Set divisibleIndices$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            long index = tuple2._1$mcJ$sp();
            return divisibleIndices$1.contains((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$parentIndex(index)));
        }
        throw new MatchError((Object)tuple2);
    }

    private BisectingKMeans(int k, int maxIterations, double minDivisibleClusterSize, long seed, String distanceMeasure) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.minDivisibleClusterSize = minDivisibleClusterSize;
        this.seed = seed;
        this.distanceMeasure = distanceMeasure;
        Logging.$init$((Logging)this);
    }

    public BisectingKMeans() {
        this(4, 20, 1.0, Statics.anyHash((Object)BisectingKMeans.class.getName()), DistanceMeasure$.MODULE$.EUCLIDEAN());
    }

    private static class ClusterSummary
    implements Product,
    scala.Serializable {
        private final long size;
        private final double weightSum;
        private final VectorWithNorm center;
        private final double cost;

        public long size() {
            return this.size;
        }

        public double weightSum() {
            return this.weightSum;
        }

        public VectorWithNorm center() {
            return this.center;
        }

        public double cost() {
            return this.cost;
        }

        public ClusterSummary copy(long size, double weightSum, VectorWithNorm center, double cost) {
            return new ClusterSummary(size, weightSum, center, cost);
        }

        public long copy$default$1() {
            return this.size();
        }

        public double copy$default$2() {
            return this.weightSum();
        }

        public VectorWithNorm copy$default$3() {
            return this.center();
        }

        public double copy$default$4() {
            return this.cost();
        }

        public String productPrefix() {
            return "ClusterSummary";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.size());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this.weightSum());
                }
                case 2: {
                    return this.center();
                }
                case 3: {
                    return BoxesRunTime.boxToDouble((double)this.cost());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ClusterSummary;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.size()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.weightSum()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.center()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.cost()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ClusterSummary)) return false;
            boolean bl = true;
            if (!bl) return false;
            ClusterSummary clusterSummary = (ClusterSummary)x$1;
            if (this.size() != clusterSummary.size()) return false;
            if (this.weightSum() != clusterSummary.weightSum()) return false;
            VectorWithNorm vectorWithNorm = this.center();
            VectorWithNorm vectorWithNorm2 = clusterSummary.center();
            if (vectorWithNorm == null) {
                if (vectorWithNorm2 != null) {
                    return false;
                }
            } else if (!vectorWithNorm.equals(vectorWithNorm2)) return false;
            if (this.cost() != clusterSummary.cost()) return false;
            if (!clusterSummary.canEqual(this)) return false;
            return true;
        }

        public ClusterSummary(long size, double weightSum, VectorWithNorm center, double cost) {
            this.size = size;
            this.weightSum = weightSum;
            this.center = center;
            this.cost = cost;
            Product.$init$((Product)this);
        }
    }

    private static class ClusterSummaryAggregator
    implements scala.Serializable {
        private final int d;
        private final DistanceMeasure distanceMeasure;
        private long n;
        private double weightSum;
        private final Vector sum;
        private double sumSq;

        public int d() {
            return this.d;
        }

        public DistanceMeasure distanceMeasure() {
            return this.distanceMeasure;
        }

        private long n() {
            return this.n;
        }

        private void n_$eq(long x$1) {
            this.n = x$1;
        }

        private double weightSum() {
            return this.weightSum;
        }

        private void weightSum_$eq(double x$1) {
            this.weightSum = x$1;
        }

        private Vector sum() {
            return this.sum;
        }

        private double sumSq() {
            return this.sumSq;
        }

        private void sumSq_$eq(double x$1) {
            this.sumSq = x$1;
        }

        public ClusterSummaryAggregator add(VectorWithNorm v) {
            this.n_$eq(this.n() + 1L);
            this.weightSum_$eq(this.weightSum() + v.weight());
            this.sumSq_$eq(this.sumSq() + v.norm() * v.norm() * v.weight());
            this.distanceMeasure().updateClusterSum(v, this.sum());
            return this;
        }

        public ClusterSummaryAggregator merge(ClusterSummaryAggregator other) {
            this.n_$eq(this.n() + other.n());
            this.weightSum_$eq(this.weightSum() + other.weightSum());
            this.sumSq_$eq(this.sumSq() + other.sumSq());
            BLAS$.MODULE$.axpy(1.0, other.sum(), this.sum());
            return this;
        }

        public ClusterSummary summary() {
            VectorWithNorm center = this.distanceMeasure().centroid(this.sum().copy(), this.weightSum());
            double cost = this.distanceMeasure().clusterCost(center, new VectorWithNorm(this.sum()), this.weightSum(), this.sumSq());
            return new ClusterSummary(this.n(), this.weightSum(), center, cost);
        }

        public ClusterSummaryAggregator(int d, DistanceMeasure distanceMeasure) {
            this.d = d;
            this.distanceMeasure = distanceMeasure;
            this.n = 0L;
            this.weightSum = 0.0;
            this.sum = Vectors$.MODULE$.zeros(d);
            this.sumSq = 0.0;
        }
    }
}

