/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.BranchRow;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;
import org.apache.derby.impl.store.access.btree.WaitError;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;

public class BTreeController
extends OpenBTree
implements ConglomerateController {
    transient DataValueDescriptor[] scratch_template = null;
    boolean get_insert_row_lock;
    private static final int NO_MATCH = 0;
    private static final int MATCH_FOUND = 1;
    private static final int RESCAN_REQUIRED = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reclaim_deleted_rows(OpenBTree openBTree, long l) throws StandardException {
        boolean bl = false;
        ControlRow controlRow = null;
        try {
            controlRow = ControlRow.get(openBTree, l);
            if (controlRow == null) {
                boolean bl2 = false;
                return bl2;
            }
            LeafControlRow leafControlRow = (LeafControlRow)controlRow;
            BTreeLockingPolicy bTreeLockingPolicy = openBTree.getLockingPolicy();
            int n = leafControlRow.page.recordCount() - 1 - leafControlRow.page.nonDeletedRecordCount();
            if (n > 0) {
                Page page = leafControlRow.page;
                FetchDescriptor fetchDescriptor = RowUtil.getFetchDescriptorConstant(this.scratch_template.length - 1);
                for (int i = page.recordCount() - 1; i > 0; --i) {
                    if (!page.isDeletedAtSlot(i) || !bTreeLockingPolicy.lockScanCommittedDeletedRow(openBTree, leafControlRow, this.scratch_template, fetchDescriptor, i)) continue;
                    page.purgeAtSlot(i, 1, true);
                    bl = true;
                }
            }
        }
        catch (ClassCastException classCastException) {
        }
        finally {
            if (controlRow != null) {
                if (bl) {
                    controlRow.page.setRepositionNeeded();
                } else {
                    controlRow.release();
                }
            }
        }
        return bl;
    }

    private long start_xact_and_dosplit(boolean bl, long l, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, int n) throws StandardException {
        TransactionManager transactionManager = null;
        OpenBTree openBTree = null;
        ControlRow controlRow = null;
        transactionManager = this.init_open_user_scans.getInternalTransaction();
        boolean bl2 = true;
        if (bl) {
            ConglomerateController conglomerateController = null;
            try {
                conglomerateController = this.getConglomerate().lockTable(transactionManager, 132, 6, 4);
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            if (conglomerateController != null) {
                openBTree = new OpenBTree();
                openBTree.init(this.init_open_user_scans, transactionManager, null, transactionManager.getRawStoreXact(), false, 132, 6, this.getConglomerate().getBtreeLockingPolicy(transactionManager.getRawStoreXact(), 6, 1, 4, conglomerateController, openBTree), this.getConglomerate(), null, null);
                bl2 = !this.reclaim_deleted_rows(openBTree, l);
                openBTree.close();
            }
        }
        long l2 = l;
        if (bl2) {
            openBTree = new OpenBTree();
            openBTree.init(this.init_open_user_scans, transactionManager, null, transactionManager.getRawStoreXact(), false, this.getOpenMode(), 5, this.getConglomerate().getBtreeLockingPolicy(transactionManager.getRawStoreXact(), this.init_lock_level, 1, 4, null, openBTree), this.getConglomerate(), null, null);
            controlRow = ControlRow.get(openBTree, 1L);
            l2 = controlRow.splitFor(openBTree, dataValueDescriptorArray, null, dataValueDescriptorArray2, n);
            openBTree.close();
        }
        transactionManager.commit();
        transactionManager.destroy();
        return l2;
    }

    private int comparePreviousRecord(int n, LeafControlRow leafControlRow, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2) throws StandardException {
        RecordHandle recordHandle = null;
        boolean bl = false;
        LeafControlRow leafControlRow2 = leafControlRow;
        while (leafControlRow != null) {
            if (n == 0) {
                LeafControlRow leafControlRow3 = leafControlRow;
                try {
                    leafControlRow = (LeafControlRow)leafControlRow.getLeftSibling(this);
                    if (bl) {
                        leafControlRow3.release();
                    }
                    bl = true;
                    if (leafControlRow == null) {
                        return 0;
                    }
                    n = leafControlRow.page.recordCount() - 1;
                    continue;
                }
                catch (WaitError waitError) {
                    if (bl) {
                        leafControlRow3.release();
                    }
                    leafControlRow2.release();
                    return 2;
                }
            }
            recordHandle = leafControlRow.page.fetchFromSlot(null, n, dataValueDescriptorArray, null, true);
            if (recordHandle != null) {
                boolean bl2;
                int n2 = this.compareRowsForInsert(dataValueDescriptorArray, dataValueDescriptorArray2, leafControlRow, n);
                boolean bl3 = bl2 = n2 == 1 && leafControlRow.page.isDeletedAtSlot(n);
                if (!bl2) {
                    if (bl) {
                        if (n2 == 2) {
                            leafControlRow2.release();
                        }
                        if (n2 != 2) {
                            leafControlRow.release();
                        }
                    }
                    return n2;
                }
            }
            --n;
        }
        return 0;
    }

    private int compareNextRecord(int n, LeafControlRow leafControlRow, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2) throws StandardException {
        RecordHandle recordHandle = null;
        boolean bl = false;
        LeafControlRow leafControlRow2 = leafControlRow;
        while (leafControlRow != null) {
            if (n >= leafControlRow.page.recordCount()) {
                LeafControlRow leafControlRow3 = leafControlRow;
                leafControlRow = (LeafControlRow)leafControlRow.getRightSibling(this);
                if (bl) {
                    leafControlRow3.release();
                }
                bl = true;
                if (leafControlRow == null) {
                    return 0;
                }
                n = 1;
                continue;
            }
            recordHandle = leafControlRow.page.fetchFromSlot(null, n, dataValueDescriptorArray, null, true);
            if (recordHandle != null) {
                boolean bl2;
                int n2 = this.compareRowsForInsert(dataValueDescriptorArray, dataValueDescriptorArray2, leafControlRow, n);
                boolean bl3 = bl2 = n2 == 1 && leafControlRow.page.isDeletedAtSlot(n);
                if (!bl2) {
                    if (bl) {
                        if (n2 == 2) {
                            leafControlRow2.release();
                        }
                        if (n2 != 2) {
                            leafControlRow.release();
                        }
                    }
                    return n2;
                }
            }
            ++n;
        }
        return 0;
    }

    private int compareRowsForInsert(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, LeafControlRow leafControlRow, int n) throws StandardException {
        boolean bl;
        for (int i = 0; i < dataValueDescriptorArray.length - 1; ++i) {
            if (dataValueDescriptorArray[i].equals(dataValueDescriptorArray2[i])) continue;
            return 0;
        }
        DataValueDescriptor[] dataValueDescriptorArray3 = this.runtime_mem.get_template(this.getRawTran());
        FetchDescriptor fetchDescriptor = RowUtil.getFetchDescriptorConstant(dataValueDescriptorArray3.length - 1);
        RowLocation rowLocation = (RowLocation)this.scratch_template[this.scratch_template.length - 1];
        boolean bl2 = bl = !this.getLockingPolicy().lockNonScanRowOnPage(leafControlRow, n, fetchDescriptor, dataValueDescriptorArray3, rowLocation, 1);
        if (bl) {
            return 2;
        }
        return 1;
    }

    private int compareLeftAndRightSiblings(DataValueDescriptor[] dataValueDescriptorArray, int n, LeafControlRow leafControlRow) throws StandardException {
        if (this.getConglomerate().isUniqueWithDuplicateNulls()) {
            int n2 = dataValueDescriptorArray.length - 1;
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                if (!dataValueDescriptorArray[i].isNull()) continue;
                return 0;
            }
            if (!bl) {
                DataValueDescriptor[] dataValueDescriptorArray2 = this.runtime_mem.get_template(this.getRawTran());
                int n3 = this.comparePreviousRecord(n - 1, leafControlRow, dataValueDescriptorArray2, dataValueDescriptorArray);
                if (n3 > 0) {
                    return n3;
                }
                return this.compareNextRecord(n, leafControlRow, dataValueDescriptorArray2, dataValueDescriptorArray);
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int doIns(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        LeafControlRow leafControlRow = null;
        Object var3_3 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        if (this.scratch_template == null) {
            this.scratch_template = this.runtime_mem.get_template(this.getRawTran());
        }
        SearchParameters searchParameters = new SearchParameters(dataValueDescriptorArray, 1, this.scratch_template, this, false);
        FetchDescriptor fetchDescriptor = RowUtil.getFetchDescriptorConstant(this.scratch_template.length - 1);
        RowLocation rowLocation = (RowLocation)this.scratch_template[this.scratch_template.length - 1];
        if (this.get_insert_row_lock) {
            this.getLockingPolicy().lockNonScanRow(this.getConglomerate(), null, null, dataValueDescriptorArray, 3);
        }
        while (true) {
            int n4;
            leafControlRow = (LeafControlRow)ControlRow.get(this, 1L).search(searchParameters);
            int n5 = searchParameters.resultExact ? searchParameters.resultSlot : searchParameters.resultSlot + 1;
            boolean bl2 = false;
            boolean bl3 = bl2 = !this.getLockingPolicy().lockNonScanPreviousRow(leafControlRow, n5, fetchDescriptor, this.scratch_template, rowLocation, this, 5, 1);
            if (bl2) {
                leafControlRow = null;
                continue;
            }
            if (searchParameters.resultExact) {
                n2 = n = searchParameters.resultSlot;
                if (this.getConglomerate().nKeyFields != this.getConglomerate().nUniqueColumns) {
                    boolean bl4 = bl2 = !this.getLockingPolicy().lockNonScanRowOnPage(leafControlRow, n, fetchDescriptor, this.scratch_template, rowLocation, 1);
                    if (bl2) {
                        leafControlRow = null;
                        continue;
                    }
                }
                if (!leafControlRow.page.isDeletedAtSlot(n)) {
                    n3 = 1;
                    break;
                }
                if (this.getConglomerate().nKeyFields == this.getConglomerate().nUniqueColumns) {
                    leafControlRow.page.deleteAtSlot(n, false, this.btree_undo);
                    break;
                }
                if (this.getConglomerate().nUniqueColumns != this.getConglomerate().nKeyFields - 1) throw StandardException.newException("XSCB3.S", new Object[0]);
                leafControlRow.page.deleteAtSlot(n, false, this.btree_undo);
                n4 = 1;
                try {
                    int n6;
                    if (this.runtime_mem.hasCollatedTypes()) {
                        n6 = this.getConglomerate().nKeyFields;
                        for (int i = 0; i < n6; ++i) {
                            leafControlRow.page.updateFieldAtSlot(n, i, RowUtil.getColumn(dataValueDescriptorArray, (FormatableBitSet)null, i), this.btree_undo);
                        }
                    } else {
                        n6 = this.getConglomerate().nKeyFields - 1;
                        leafControlRow.page.updateFieldAtSlot(n, n6, RowUtil.getColumn(dataValueDescriptorArray, (FormatableBitSet)null, n6), this.btree_undo);
                    }
                }
                catch (StandardException standardException) {
                    if (!standardException.getMessageId().equals("XSDA3.S")) {
                        throw standardException;
                    }
                    n4 = 0;
                    leafControlRow.page.deleteAtSlot(n, true, this.btree_undo);
                }
                if (n4 != 0) {
                    break;
                }
            } else if (leafControlRow.page.recordCount() - 1 < BTree.maxRowsPerPage) {
                n = searchParameters.resultSlot + 1;
                n2 = n + 1;
                if (this.getConglomerate().isUniqueWithDuplicateNulls()) {
                    n4 = this.compareLeftAndRightSiblings(dataValueDescriptorArray, n, leafControlRow);
                    if (n4 == 1) {
                        n3 = 1;
                        break;
                    }
                    if (n4 == 2) continue;
                }
                if (leafControlRow.page.insertAtSlot(n, dataValueDescriptorArray, null, this.btree_undo, (byte)1, 50) != null) break;
                if (leafControlRow.page.recordCount() <= 2) {
                    throw StandardException.newException("XSCB6.S", new Object[0]);
                }
            }
            if (this.getConglomerate().isUniqueWithDuplicateNulls()) {
                n4 = this.compareLeftAndRightSiblings(dataValueDescriptorArray, n, leafControlRow);
                if (n4 == 1) {
                    n3 = 1;
                    break;
                }
                if (n4 == 2) continue;
            }
            n4 = 0;
            if (n == 1) {
                n4 |= 4;
                if (leafControlRow.isLeftmostLeaf()) {
                    n4 |= 8;
                }
            } else if (n == leafControlRow.page.recordCount()) {
                n4 |= 1;
                if (leafControlRow.isRightmostLeaf()) {
                    n4 |= 2;
                }
            }
            long l = leafControlRow.page.getPageNumber();
            if (leafControlRow.page.recordCount() - leafControlRow.page.nonDeletedRecordCount() <= 0) {
                bl = true;
            }
            BranchRow branchRow = BranchRow.createBranchRowFromOldLeafRow(dataValueDescriptorArray, l);
            leafControlRow.release();
            leafControlRow = null;
            this.start_xact_and_dosplit(!bl, l, this.scratch_template, branchRow.getRow(), n4);
            bl = true;
        }
        leafControlRow.last_search_result = n2;
        leafControlRow.release();
        return n3;
    }

    private boolean do_load_insert(DataValueDescriptor[] dataValueDescriptorArray, LeafControlRow leafControlRow, int n) throws StandardException {
        Object var4_4 = null;
        boolean bl = false;
        int n2 = leafControlRow.page.recordCount() - 1;
        if (n2 < BTree.maxRowsPerPage) {
            if (leafControlRow.page.insertAtSlot(n, dataValueDescriptorArray, null, this.btree_undo, (byte)1, 50) != null) {
                bl = true;
            } else if (leafControlRow.page.recordCount() <= 2) {
                throw StandardException.newException("XSCB6.S", new Object[0]);
            }
        }
        return bl;
    }

    private LeafControlRow do_load_split(DataValueDescriptor[] dataValueDescriptorArray, LeafControlRow leafControlRow) throws StandardException {
        LeafControlRow leafControlRow2 = null;
        BranchRow branchRow = BranchRow.createBranchRowFromOldLeafRow(dataValueDescriptorArray, leafControlRow.page.getPageNumber());
        long l = leafControlRow.page.getPageNumber();
        leafControlRow.release();
        leafControlRow = null;
        long l2 = this.start_xact_and_dosplit(false, l, this.scratch_template, branchRow.getRow(), 3);
        leafControlRow2 = (LeafControlRow)ControlRow.get(this, l2);
        return leafControlRow2;
    }

    public void init(TransactionManager transactionManager, boolean bl, ContainerHandle containerHandle, Transaction transaction, int n, int n2, BTreeLockingPolicy bTreeLockingPolicy, BTree bTree, LogicalUndo logicalUndo, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        this.get_insert_row_lock = (n & 0x4000) == 0;
        super.init(transactionManager, transactionManager, containerHandle, transaction, bl, n, n2, bTreeLockingPolicy, bTree, logicalUndo, dynamicCompiledOpenConglomInfo);
    }

    @Override
    public void close() throws StandardException {
        super.close();
        if (this.getXactMgr() != null) {
            this.getXactMgr().closeMe(this);
        }
    }

    @Override
    public boolean closeForEndTransaction(boolean bl) throws StandardException {
        super.close();
        if (!this.getHold() || bl) {
            if (this.getXactMgr() != null) {
                this.getXactMgr().closeMe(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public int insert(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        if (this.isClosed()) {
            if (this.getHold()) {
                this.reopen();
            } else {
                throw StandardException.newException("XSCB8.S", this.err_containerid);
            }
        }
        return this.doIns(dataValueDescriptorArray);
    }

    @Override
    public boolean isKeyed() {
        return true;
    }

    @Override
    public void getTableProperties(Properties properties) throws StandardException {
        if (this.container == null) {
            throw StandardException.newException("XSCB8.S", this.err_containerid);
        }
        this.container.getContainerProperties(properties);
    }

    @Override
    public Properties getInternalTablePropertySet(Properties properties) throws StandardException {
        Properties properties2 = ConglomerateUtil.createRawStorePropertySet(properties);
        this.getTableProperties(properties2);
        return properties2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long load(TransactionManager transactionManager, boolean bl, RowLocationRetRowSource rowLocationRetRowSource) throws StandardException {
        long l = 0L;
        if (this.scratch_template == null) {
            this.scratch_template = this.runtime_mem.get_template(this.getRawTran());
        }
        LeafControlRow leafControlRow = null;
        try {
            DataValueDescriptor[] dataValueDescriptorArray;
            leafControlRow = (LeafControlRow)ControlRow.get(this, 1L);
            int n = 1;
            FormatableBitSet formatableBitSet = rowLocationRetRowSource.getValidColumns();
            while ((dataValueDescriptorArray = rowLocationRetRowSource.getNextRowFromRowSource()) != null) {
                ++l;
                while (!this.do_load_insert(dataValueDescriptorArray, leafControlRow, n)) {
                    leafControlRow = this.do_load_split(dataValueDescriptorArray, leafControlRow);
                    n = leafControlRow.page.recordCount();
                }
                ++n;
            }
            leafControlRow.release();
            leafControlRow = null;
            if (!this.getConglomerate().isTemporary()) {
                this.container.flushContainer();
            }
        }
        finally {
            this.close();
        }
        return l;
    }

    @Override
    public boolean delete(RowLocation rowLocation) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public boolean fetch(RowLocation rowLocation, DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public boolean fetch(RowLocation rowLocation, DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet, boolean bl) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public void insertAndFetchLocation(DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public RowLocation newRowLocationTemplate() throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public boolean lockRow(RowLocation rowLocation, int n, boolean bl, int n2) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public boolean lockRow(long l, int n, int n2, boolean bl, int n3) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public void unlockRowAfterRead(RowLocation rowLocation, boolean bl, boolean bl2) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public boolean replace(RowLocation rowLocation, DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }
}

