/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.spark.ExceptionFailure;
import org.apache.spark.ExceptionFailure$;
import org.apache.spark.ExecutorLostFailure;
import org.apache.spark.FetchFailed;
import org.apache.spark.InternalAccumulator$;
import org.apache.spark.Resubmitted$;
import org.apache.spark.SparkException;
import org.apache.spark.Success$;
import org.apache.spark.TaskCommitDenied;
import org.apache.spark.TaskEndReason;
import org.apache.spark.TaskKilled;
import org.apache.spark.TaskKilled$;
import org.apache.spark.TaskResultLost$;
import org.apache.spark.ThrowableSerializationWrapper;
import org.apache.spark.UnknownReason$;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.executor.TaskMetrics$;
import org.apache.spark.executor.TempShuffleReadMetrics;
import org.apache.spark.metrics.ExecutorMetricType$;
import org.apache.spark.package$;
import org.apache.spark.rdd.DeterministicLevel$;
import org.apache.spark.rdd.RDDOperationScope;
import org.apache.spark.rdd.RDDOperationScope$;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.resource.ResourceInformation;
import org.apache.spark.resource.ResourceInformation$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.TaskResourceRequest;
import org.apache.spark.scheduler.AccumulableInfo;
import org.apache.spark.scheduler.JobFailed;
import org.apache.spark.scheduler.JobResult;
import org.apache.spark.scheduler.JobSucceeded$;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerLogStart;
import org.apache.spark.scheduler.SparkListenerResourceProfileAdded;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageExecutorMetrics;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import org.apache.spark.scheduler.StageInfo;
import org.apache.spark.scheduler.StageInfo$;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.scheduler.TaskLocality$;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.scheduler.cluster.ExecutorInfo;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.BlockUpdatedInfo;
import org.apache.spark.storage.RDDInfo;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.JsonProtocol;
import org.apache.spark.util.JsonProtocol$JOB_RESULT_FORMATTED_CLASS_NAMES$;
import org.apache.spark.util.JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$;
import org.apache.spark.util.JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$;
import org.apache.spark.util.JsonUtils;
import org.apache.spark.util.Utils$;
import org.json4s.jackson.JsonMethods$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.LinkedHashMap;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class JsonProtocol$
implements JsonUtils {
    public static final JsonProtocol$ MODULE$ = new JsonProtocol$();
    private static Set<String> accumulableExcludeList;
    private static ObjectMapper mapper;
    private static volatile boolean bitmap$0;

    static {
        JsonUtils.$init$((JsonUtils)MODULE$);
        MODULE$.mapper().getFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build());
    }

    public String toJsonString(Function1<JsonGenerator, BoxedUnit> block) {
        return JsonUtils.toJsonString$((JsonUtils)this, block);
    }

    public ObjectMapper mapper() {
        return mapper;
    }

    public void org$apache$spark$util$JsonUtils$_setter_$mapper_$eq(ObjectMapper x$1) {
        mapper = x$1;
    }

    public String sparkEventToJsonString(SparkListenerEvent event) {
        return this.toJsonString((Function1<JsonGenerator, BoxedUnit>)(Function1 & Serializable)generator -> {
            JsonProtocol$.MODULE$.writeSparkEventToJson(event, generator);
            return BoxedUnit.UNIT;
        });
    }

    public void writeSparkEventToJson(SparkListenerEvent event, JsonGenerator g) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerStageSubmitted) {
            SparkListenerStageSubmitted sparkListenerStageSubmitted = (SparkListenerStageSubmitted)sparkListenerEvent;
            this.stageSubmittedToJson(sparkListenerStageSubmitted, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerStageCompleted) {
            SparkListenerStageCompleted sparkListenerStageCompleted = (SparkListenerStageCompleted)sparkListenerEvent;
            this.stageCompletedToJson(sparkListenerStageCompleted, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerTaskStart) {
            SparkListenerTaskStart sparkListenerTaskStart = (SparkListenerTaskStart)sparkListenerEvent;
            this.taskStartToJson(sparkListenerTaskStart, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerTaskGettingResult) {
            SparkListenerTaskGettingResult sparkListenerTaskGettingResult = (SparkListenerTaskGettingResult)sparkListenerEvent;
            this.taskGettingResultToJson(sparkListenerTaskGettingResult, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerTaskEnd) {
            SparkListenerTaskEnd sparkListenerTaskEnd = (SparkListenerTaskEnd)sparkListenerEvent;
            this.taskEndToJson(sparkListenerTaskEnd, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerJobStart) {
            SparkListenerJobStart sparkListenerJobStart = (SparkListenerJobStart)sparkListenerEvent;
            this.jobStartToJson(sparkListenerJobStart, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerJobEnd) {
            SparkListenerJobEnd sparkListenerJobEnd = (SparkListenerJobEnd)sparkListenerEvent;
            this.jobEndToJson(sparkListenerJobEnd, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerEnvironmentUpdate) {
            SparkListenerEnvironmentUpdate sparkListenerEnvironmentUpdate = (SparkListenerEnvironmentUpdate)sparkListenerEvent;
            this.environmentUpdateToJson(sparkListenerEnvironmentUpdate, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerBlockManagerAdded) {
            SparkListenerBlockManagerAdded sparkListenerBlockManagerAdded = (SparkListenerBlockManagerAdded)sparkListenerEvent;
            this.blockManagerAddedToJson(sparkListenerBlockManagerAdded, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerBlockManagerRemoved) {
            SparkListenerBlockManagerRemoved sparkListenerBlockManagerRemoved = (SparkListenerBlockManagerRemoved)sparkListenerEvent;
            this.blockManagerRemovedToJson(sparkListenerBlockManagerRemoved, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerUnpersistRDD) {
            SparkListenerUnpersistRDD sparkListenerUnpersistRDD = (SparkListenerUnpersistRDD)sparkListenerEvent;
            this.unpersistRDDToJson(sparkListenerUnpersistRDD, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerApplicationStart) {
            SparkListenerApplicationStart sparkListenerApplicationStart = (SparkListenerApplicationStart)sparkListenerEvent;
            this.applicationStartToJson(sparkListenerApplicationStart, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerApplicationEnd) {
            SparkListenerApplicationEnd sparkListenerApplicationEnd = (SparkListenerApplicationEnd)sparkListenerEvent;
            this.applicationEndToJson(sparkListenerApplicationEnd, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerExecutorAdded) {
            SparkListenerExecutorAdded sparkListenerExecutorAdded = (SparkListenerExecutorAdded)sparkListenerEvent;
            this.executorAddedToJson(sparkListenerExecutorAdded, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerExecutorRemoved) {
            SparkListenerExecutorRemoved sparkListenerExecutorRemoved = (SparkListenerExecutorRemoved)sparkListenerEvent;
            this.executorRemovedToJson(sparkListenerExecutorRemoved, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerLogStart) {
            SparkListenerLogStart sparkListenerLogStart = (SparkListenerLogStart)sparkListenerEvent;
            this.logStartToJson(sparkListenerLogStart, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerExecutorMetricsUpdate) {
            SparkListenerExecutorMetricsUpdate sparkListenerExecutorMetricsUpdate = (SparkListenerExecutorMetricsUpdate)sparkListenerEvent;
            this.executorMetricsUpdateToJson(sparkListenerExecutorMetricsUpdate, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerStageExecutorMetrics) {
            SparkListenerStageExecutorMetrics sparkListenerStageExecutorMetrics = (SparkListenerStageExecutorMetrics)sparkListenerEvent;
            this.stageExecutorMetricsToJson(sparkListenerStageExecutorMetrics, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerBlockUpdated) {
            SparkListenerBlockUpdated sparkListenerBlockUpdated = (SparkListenerBlockUpdated)sparkListenerEvent;
            this.blockUpdateToJson(sparkListenerBlockUpdated, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerResourceProfileAdded) {
            SparkListenerResourceProfileAdded sparkListenerResourceProfileAdded = (SparkListenerResourceProfileAdded)sparkListenerEvent;
            this.resourceProfileAddedToJson(sparkListenerResourceProfileAdded, g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.mapper().writeValue(g, (Object)event);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void stageSubmittedToJson(SparkListenerStageSubmitted stageSubmitted, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.stageSubmitted());
        g.writeFieldName("Stage Info");
        this.stageInfoToJson(stageSubmitted.stageInfo(), g);
        Option$.MODULE$.apply((Object)stageSubmitted.properties()).foreach((Function1 & Serializable)properties -> {
            JsonProtocol$.$anonfun$stageSubmittedToJson$1(g, properties);
            return BoxedUnit.UNIT;
        });
        g.writeEndObject();
    }

    public void stageCompletedToJson(SparkListenerStageCompleted stageCompleted, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.stageCompleted());
        g.writeFieldName("Stage Info");
        this.stageInfoToJson(stageCompleted.stageInfo(), g);
        g.writeEndObject();
    }

    public void taskStartToJson(SparkListenerTaskStart taskStart, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.taskStart());
        g.writeNumberField("Stage ID", taskStart.stageId());
        g.writeNumberField("Stage Attempt ID", taskStart.stageAttemptId());
        g.writeFieldName("Task Info");
        this.taskInfoToJson(taskStart.taskInfo(), g);
        g.writeEndObject();
    }

    public void taskGettingResultToJson(SparkListenerTaskGettingResult taskGettingResult, JsonGenerator g) {
        TaskInfo taskInfo = taskGettingResult.taskInfo();
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.taskGettingResult());
        g.writeFieldName("Task Info");
        this.taskInfoToJson(taskInfo, g);
        g.writeEndObject();
    }

    public void taskEndToJson(SparkListenerTaskEnd taskEnd, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.taskEnd());
        g.writeNumberField("Stage ID", taskEnd.stageId());
        g.writeNumberField("Stage Attempt ID", taskEnd.stageAttemptId());
        g.writeStringField("Task Type", taskEnd.taskType());
        g.writeFieldName("Task End Reason");
        this.taskEndReasonToJson(taskEnd.reason(), g);
        g.writeFieldName("Task Info");
        this.taskInfoToJson(taskEnd.taskInfo(), g);
        g.writeFieldName("Task Executor Metrics");
        this.executorMetricsToJson(taskEnd.taskExecutorMetrics(), g);
        Option$.MODULE$.apply((Object)taskEnd.taskMetrics()).foreach((Function1 & Serializable)m -> {
            JsonProtocol$.$anonfun$taskEndToJson$1(g, m);
            return BoxedUnit.UNIT;
        });
        g.writeEndObject();
    }

    public void jobStartToJson(SparkListenerJobStart jobStart, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.jobStart());
        g.writeNumberField("Job ID", jobStart.jobId());
        g.writeNumberField("Submission Time", jobStart.time());
        g.writeArrayFieldStart("Stage Infos");
        jobStart.stageInfos().foreach((Function1 & Serializable)x$1 -> {
            JsonProtocol$.MODULE$.stageInfoToJson(x$1, g);
            return BoxedUnit.UNIT;
        });
        g.writeEndArray();
        g.writeArrayFieldStart("Stage IDs");
        jobStart.stageIds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> g.writeNumber(x$1));
        g.writeEndArray();
        Option$.MODULE$.apply((Object)jobStart.properties()).foreach((Function1 & Serializable)properties -> {
            JsonProtocol$.$anonfun$jobStartToJson$3(g, properties);
            return BoxedUnit.UNIT;
        });
        g.writeEndObject();
    }

    public void jobEndToJson(SparkListenerJobEnd jobEnd, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.jobEnd());
        g.writeNumberField("Job ID", jobEnd.jobId());
        g.writeNumberField("Completion Time", jobEnd.time());
        g.writeFieldName("Job Result");
        this.jobResultToJson(jobEnd.jobResult(), g);
        g.writeEndObject();
    }

    public void environmentUpdateToJson(SparkListenerEnvironmentUpdate environmentUpdate, JsonGenerator g) {
        Map<String, Seq<Tuple2<String, String>>> environmentDetails = environmentUpdate.environmentDetails();
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.environmentUpdate());
        this.writeMapField("JVM Information", (Map<String, String>)((IterableOnceOps)environmentDetails.apply((Object)"JVM Information")).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), g);
        this.writeMapField("Spark Properties", (Map<String, String>)((IterableOnceOps)environmentDetails.apply((Object)"Spark Properties")).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), g);
        this.writeMapField("Hadoop Properties", (Map<String, String>)((IterableOnceOps)environmentDetails.apply((Object)"Hadoop Properties")).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), g);
        this.writeMapField("System Properties", (Map<String, String>)((IterableOnceOps)environmentDetails.apply((Object)"System Properties")).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), g);
        this.writeMapField("Metrics Properties", (Map<String, String>)((IterableOnceOps)environmentDetails.apply((Object)"Metrics Properties")).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), g);
        this.writeMapField("Classpath Entries", (Map<String, String>)((IterableOnceOps)environmentDetails.apply((Object)"Classpath Entries")).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), g);
        g.writeEndObject();
    }

    public void blockManagerAddedToJson(SparkListenerBlockManagerAdded blockManagerAdded, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.blockManagerAdded());
        g.writeFieldName("Block Manager ID");
        this.blockManagerIdToJson(blockManagerAdded.blockManagerId(), g);
        g.writeNumberField("Maximum Memory", blockManagerAdded.maxMem());
        g.writeNumberField("Timestamp", blockManagerAdded.time());
        blockManagerAdded.maxOnHeapMem().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)x$2 -> g.writeNumberField("Maximum Onheap Memory", x$2));
        blockManagerAdded.maxOffHeapMem().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)x$3 -> g.writeNumberField("Maximum Offheap Memory", x$3));
        g.writeEndObject();
    }

    public void blockManagerRemovedToJson(SparkListenerBlockManagerRemoved blockManagerRemoved, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.blockManagerRemoved());
        g.writeFieldName("Block Manager ID");
        this.blockManagerIdToJson(blockManagerRemoved.blockManagerId(), g);
        g.writeNumberField("Timestamp", blockManagerRemoved.time());
        g.writeEndObject();
    }

    public void unpersistRDDToJson(SparkListenerUnpersistRDD unpersistRDD, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.unpersistRDD());
        g.writeNumberField("RDD ID", unpersistRDD.rddId());
        g.writeEndObject();
    }

    public void applicationStartToJson(SparkListenerApplicationStart applicationStart, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.applicationStart());
        g.writeStringField("App Name", applicationStart.appName());
        applicationStart.appId().foreach((Function1 & Serializable)x$4 -> {
            g.writeStringField("App ID", x$4);
            return BoxedUnit.UNIT;
        });
        g.writeNumberField("Timestamp", applicationStart.time());
        g.writeStringField("User", applicationStart.sparkUser());
        applicationStart.appAttemptId().foreach((Function1 & Serializable)x$5 -> {
            g.writeStringField("App Attempt ID", x$5);
            return BoxedUnit.UNIT;
        });
        applicationStart.driverLogs().foreach((Function1 & Serializable)x$6 -> {
            JsonProtocol$.MODULE$.writeMapField("Driver Logs", (Map<String, String>)x$6, g);
            return BoxedUnit.UNIT;
        });
        applicationStart.driverAttributes().foreach((Function1 & Serializable)x$7 -> {
            JsonProtocol$.MODULE$.writeMapField("Driver Attributes", (Map<String, String>)x$7, g);
            return BoxedUnit.UNIT;
        });
        g.writeEndObject();
    }

    public void applicationEndToJson(SparkListenerApplicationEnd applicationEnd, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.applicationEnd());
        g.writeNumberField("Timestamp", applicationEnd.time());
        g.writeEndObject();
    }

    public void resourceProfileAddedToJson(SparkListenerResourceProfileAdded profileAdded, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.resourceProfileAdded());
        g.writeNumberField("Resource Profile Id", profileAdded.resourceProfile().id());
        g.writeFieldName("Executor Resource Requests");
        this.executorResourceRequestMapToJson((Map<String, ExecutorResourceRequest>)profileAdded.resourceProfile().executorResources(), g);
        g.writeFieldName("Task Resource Requests");
        this.taskResourceRequestMapToJson((Map<String, TaskResourceRequest>)profileAdded.resourceProfile().taskResources(), g);
        g.writeEndObject();
    }

    public void executorAddedToJson(SparkListenerExecutorAdded executorAdded, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.executorAdded());
        g.writeNumberField("Timestamp", executorAdded.time());
        g.writeStringField("Executor ID", executorAdded.executorId());
        g.writeFieldName("Executor Info");
        this.executorInfoToJson(executorAdded.executorInfo(), g);
        g.writeEndObject();
    }

    public void executorRemovedToJson(SparkListenerExecutorRemoved executorRemoved, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.executorRemoved());
        g.writeNumberField("Timestamp", executorRemoved.time());
        g.writeStringField("Executor ID", executorRemoved.executorId());
        g.writeStringField("Removed Reason", executorRemoved.reason());
        g.writeEndObject();
    }

    public void logStartToJson(SparkListenerLogStart logStart, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.logStart());
        g.writeStringField("Spark Version", package$.MODULE$.SPARK_VERSION());
        g.writeEndObject();
    }

    public void executorMetricsUpdateToJson(SparkListenerExecutorMetricsUpdate metricsUpdate, JsonGenerator g) {
        String execId = metricsUpdate.execId();
        scala.collection.immutable.Seq<Tuple4<Object, Object, Object, scala.collection.immutable.Seq<AccumulableInfo>>> accumUpdates = metricsUpdate.accumUpdates();
        Map<Tuple2<Object, Object>, ExecutorMetrics> executorUpdates = metricsUpdate.executorUpdates();
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.metricsUpdate());
        g.writeStringField("Executor ID", execId);
        g.writeArrayFieldStart("Metrics Updated");
        accumUpdates.foreach((Function1 & Serializable)x0$1 -> {
            JsonProtocol$.$anonfun$executorMetricsUpdateToJson$1(g, x0$1);
            return BoxedUnit.UNIT;
        });
        g.writeEndArray();
        g.writeArrayFieldStart("Executor Metrics Updated");
        executorUpdates.foreach((Function1 & Serializable)x0$2 -> {
            JsonProtocol$.$anonfun$executorMetricsUpdateToJson$3(g, x0$2);
            return BoxedUnit.UNIT;
        });
        g.writeEndArray();
        g.writeEndObject();
    }

    public void stageExecutorMetricsToJson(SparkListenerStageExecutorMetrics metrics, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.stageExecutorMetrics());
        g.writeStringField("Executor ID", metrics.execId());
        g.writeNumberField("Stage ID", metrics.stageId());
        g.writeNumberField("Stage Attempt ID", metrics.stageAttemptId());
        g.writeFieldName("Executor Metrics");
        this.executorMetricsToJson(metrics.executorMetrics(), g);
        g.writeEndObject();
    }

    public void blockUpdateToJson(SparkListenerBlockUpdated blockUpdate, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Event", JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.blockUpdate());
        g.writeFieldName("Block Updated Info");
        this.blockUpdatedInfoToJson(blockUpdate.blockUpdatedInfo(), g);
        g.writeEndObject();
    }

    public void stageInfoToJson(StageInfo stageInfo, JsonGenerator g) {
        g.writeStartObject();
        g.writeNumberField("Stage ID", stageInfo.stageId());
        g.writeNumberField("Stage Attempt ID", stageInfo.attemptNumber());
        g.writeStringField("Stage Name", stageInfo.name());
        g.writeNumberField("Number of Tasks", stageInfo.numTasks());
        g.writeArrayFieldStart("RDD Info");
        stageInfo.rddInfos().foreach((Function1 & Serializable)x$9 -> {
            JsonProtocol$.MODULE$.rddInfoToJson(x$9, g);
            return BoxedUnit.UNIT;
        });
        g.writeEndArray();
        g.writeArrayFieldStart("Parent IDs");
        stageInfo.parentIds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> g.writeNumber(x$1));
        g.writeEndArray();
        g.writeStringField("Details", stageInfo.details());
        stageInfo.submissionTime().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)x$10 -> g.writeNumberField("Submission Time", x$10));
        stageInfo.completionTime().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)x$11 -> g.writeNumberField("Completion Time", x$11));
        stageInfo.failureReason().foreach((Function1 & Serializable)x$12 -> {
            g.writeStringField("Failure Reason", x$12);
            return BoxedUnit.UNIT;
        });
        g.writeFieldName("Accumulables");
        this.accumulablesToJson((Iterable<AccumulableInfo>)stageInfo.accumulables().values(), g);
        g.writeNumberField("Resource Profile Id", stageInfo.resourceProfileId());
        g.writeBooleanField("Shuffle Push Enabled", stageInfo.isShufflePushEnabled());
        g.writeNumberField("Shuffle Push Mergers Count", stageInfo.shuffleMergerCount());
        g.writeEndObject();
    }

    public void taskInfoToJson(TaskInfo taskInfo, JsonGenerator g) {
        g.writeStartObject();
        g.writeNumberField("Task ID", taskInfo.taskId());
        g.writeNumberField("Index", taskInfo.index());
        g.writeNumberField("Attempt", taskInfo.attemptNumber());
        g.writeNumberField("Partition ID", taskInfo.partitionId());
        g.writeNumberField("Launch Time", taskInfo.launchTime());
        g.writeStringField("Executor ID", taskInfo.executorId());
        g.writeStringField("Host", taskInfo.host());
        g.writeStringField("Locality", taskInfo.taskLocality().toString());
        g.writeBooleanField("Speculative", taskInfo.speculative());
        g.writeNumberField("Getting Result Time", taskInfo.gettingResultTime());
        g.writeNumberField("Finish Time", taskInfo.finishTime());
        g.writeBooleanField("Failed", taskInfo.failed());
        g.writeBooleanField("Killed", taskInfo.killed());
        g.writeFieldName("Accumulables");
        this.accumulablesToJson((Iterable<AccumulableInfo>)taskInfo.accumulables(), g);
        g.writeEndObject();
    }

    private Set<String> accumulableExcludeList$lzycompute() {
        JsonProtocol$ jsonProtocol$ = this;
        synchronized (jsonProtocol$) {
            if (!bitmap$0) {
                accumulableExcludeList = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"internal.metrics.updatedBlockStatuses"}));
                bitmap$0 = true;
            }
        }
        return accumulableExcludeList;
    }

    private Set<String> accumulableExcludeList() {
        return !bitmap$0 ? this.accumulableExcludeList$lzycompute() : accumulableExcludeList;
    }

    public void accumulablesToJson(Iterable<AccumulableInfo> accumulables, JsonGenerator g) {
        g.writeStartArray();
        ((List)((IterableOnceOps)accumulables.filterNot((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$accumulablesToJson$1(x$13)))).toList().sortBy((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.id()), (Ordering)Ordering.Long$.MODULE$)).foreach((Function1 & Serializable)a -> {
            JsonProtocol$.MODULE$.accumulableInfoToJson(a, g);
            return BoxedUnit.UNIT;
        });
        g.writeEndArray();
    }

    public void accumulableInfoToJson(AccumulableInfo accumulableInfo, JsonGenerator g) {
        Option<String> name = accumulableInfo.name();
        g.writeStartObject();
        g.writeNumberField("ID", accumulableInfo.id());
        name.foreach((Function1 & Serializable)x$15 -> {
            g.writeStringField("Name", x$15);
            return BoxedUnit.UNIT;
        });
        accumulableInfo.update().foreach((Function1 & Serializable)v -> {
            JsonProtocol$.MODULE$.accumValueToJson((Option<String>)name, v, g, (Option<String>)new Some((Object)"Update"));
            return BoxedUnit.UNIT;
        });
        accumulableInfo.value().foreach((Function1 & Serializable)v -> {
            JsonProtocol$.MODULE$.accumValueToJson((Option<String>)name, v, g, (Option<String>)new Some((Object)"Value"));
            return BoxedUnit.UNIT;
        });
        g.writeBooleanField("Internal", accumulableInfo.internal());
        g.writeBooleanField("Count Failed Values", accumulableInfo.countFailedValues());
        accumulableInfo.metadata().foreach((Function1 & Serializable)x$16 -> {
            g.writeStringField("Metadata", x$16);
            return BoxedUnit.UNIT;
        });
        g.writeEndObject();
    }

    public void accumValueToJson(Option<String> name, Object value, JsonGenerator g, Option<String> fieldName) {
        if (name.exists((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.startsWith(InternalAccumulator$.MODULE$.METRICS_PREFIX())))) {
            Object object = value;
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                fieldName.foreach((Function1 & Serializable)x$1 -> {
                    g.writeFieldName(x$1);
                    return BoxedUnit.UNIT;
                });
                g.writeNumber(n);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                fieldName.foreach((Function1 & Serializable)x$1 -> {
                    g.writeFieldName(x$1);
                    return BoxedUnit.UNIT;
                });
                g.writeNumber(l);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof java.util.List) {
                java.util.List list = (java.util.List)object;
                fieldName.foreach((Function1 & Serializable)x$1 -> {
                    g.writeFieldName(x$1);
                    return BoxedUnit.UNIT;
                });
                g.writeStartArray();
                ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).foreach((Function1 & Serializable)x0$1 -> {
                    JsonProtocol$.$anonfun$accumValueToJson$5(g, x0$1);
                    return BoxedUnit.UNIT;
                });
                g.writeEndArray();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            fieldName.foreach((Function1 & Serializable)x$1 -> {
                g.writeFieldName(x$1);
                return BoxedUnit.UNIT;
            });
            g.writeString(value.toString());
        }
    }

    public Option<String> accumValueToJson$default$4() {
        return None$.MODULE$;
    }

    public void taskMetricsToJson(TaskMetrics taskMetrics, JsonGenerator g) {
        g.writeStartObject();
        g.writeNumberField("Executor Deserialize Time", taskMetrics.executorDeserializeTime());
        g.writeNumberField("Executor Deserialize CPU Time", taskMetrics.executorDeserializeCpuTime());
        g.writeNumberField("Executor Run Time", taskMetrics.executorRunTime());
        g.writeNumberField("Executor CPU Time", taskMetrics.executorCpuTime());
        g.writeNumberField("Peak Execution Memory", taskMetrics.peakExecutionMemory());
        g.writeNumberField("Result Size", taskMetrics.resultSize());
        g.writeNumberField("JVM GC Time", taskMetrics.jvmGCTime());
        g.writeNumberField("Result Serialization Time", taskMetrics.resultSerializationTime());
        g.writeNumberField("Memory Bytes Spilled", taskMetrics.memoryBytesSpilled());
        g.writeNumberField("Disk Bytes Spilled", taskMetrics.diskBytesSpilled());
        g.writeFieldName("Shuffle Read Metrics");
        JsonProtocol$.writeShuffleReadMetrics$1(g, taskMetrics);
        g.writeFieldName("Shuffle Write Metrics");
        JsonProtocol$.writeShuffleWriteMetrics$1(g, taskMetrics);
        g.writeFieldName("Input Metrics");
        JsonProtocol$.writeInputMetrics$1(g, taskMetrics);
        g.writeFieldName("Output Metrics");
        JsonProtocol$.writeOutputMetrics$1(g, taskMetrics);
        g.writeFieldName("Updated Blocks");
        JsonProtocol$.writeUpdatedBlocks$1(g, taskMetrics);
        g.writeEndObject();
    }

    public void executorMetricsToJson(ExecutorMetrics executorMetrics, JsonGenerator g) {
        g.writeStartObject();
        ExecutorMetricType$.MODULE$.metricToOffset().foreach((Function1 & Serializable)x0$1 -> {
            JsonProtocol$.$anonfun$executorMetricsToJson$1(g, executorMetrics, x0$1);
            return BoxedUnit.UNIT;
        });
        g.writeEndObject();
    }

    public void taskEndReasonToJson(TaskEndReason taskEndReason, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Reason", Utils$.MODULE$.getFormattedClassName(taskEndReason));
        TaskEndReason taskEndReason2 = taskEndReason;
        if (taskEndReason2 instanceof FetchFailed) {
            FetchFailed fetchFailed = (FetchFailed)taskEndReason2;
            Option$.MODULE$.apply((Object)fetchFailed.bmAddress()).foreach((Function1 & Serializable)id -> {
                JsonProtocol$.$anonfun$taskEndReasonToJson$1(g, id);
                return BoxedUnit.UNIT;
            });
            g.writeNumberField("Shuffle ID", fetchFailed.shuffleId());
            g.writeNumberField("Map ID", fetchFailed.mapId());
            g.writeNumberField("Map Index", fetchFailed.mapIndex());
            g.writeNumberField("Reduce ID", fetchFailed.reduceId());
            g.writeStringField("Message", fetchFailed.message());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (taskEndReason2 instanceof ExceptionFailure) {
            ExceptionFailure exceptionFailure = (ExceptionFailure)taskEndReason2;
            g.writeStringField("Class Name", exceptionFailure.className());
            g.writeStringField("Description", exceptionFailure.description());
            g.writeFieldName("Stack Trace");
            this.stackTraceToJson(exceptionFailure.stackTrace(), g);
            g.writeStringField("Full Stack Trace", exceptionFailure.fullStackTrace());
            g.writeFieldName("Accumulator Updates");
            this.accumulablesToJson((Iterable<AccumulableInfo>)exceptionFailure.accumUpdates(), g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (taskEndReason2 instanceof TaskCommitDenied) {
            TaskCommitDenied taskCommitDenied = (TaskCommitDenied)taskEndReason2;
            g.writeNumberField("Job ID", taskCommitDenied.jobID());
            g.writeNumberField("Partition ID", taskCommitDenied.partitionID());
            g.writeNumberField("Attempt Number", taskCommitDenied.attemptNumber());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (taskEndReason2 instanceof ExecutorLostFailure) {
            ExecutorLostFailure executorLostFailure = (ExecutorLostFailure)taskEndReason2;
            String executorId = executorLostFailure.execId();
            boolean exitCausedByApp = executorLostFailure.exitCausedByApp();
            Option<String> reason = executorLostFailure.reason();
            g.writeStringField("Executor ID", executorId);
            g.writeBooleanField("Exit Caused By App", exitCausedByApp);
            reason.foreach((Function1 & Serializable)x$18 -> {
                g.writeStringField("Loss Reason", x$18);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (taskEndReason2 instanceof TaskKilled) {
            TaskKilled taskKilled = (TaskKilled)taskEndReason2;
            g.writeStringField("Kill Reason", taskKilled.reason());
            g.writeArrayFieldStart("Accumulator Updates");
            taskKilled.accumUpdates().foreach((Function1 & Serializable)info -> {
                JsonProtocol$.MODULE$.accumulableInfoToJson(info, g);
                return BoxedUnit.UNIT;
            });
            g.writeEndArray();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        g.writeEndObject();
    }

    public void blockManagerIdToJson(BlockManagerId blockManagerId, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Executor ID", blockManagerId.executorId());
        g.writeStringField("Host", blockManagerId.host());
        g.writeNumberField("Port", blockManagerId.port());
        g.writeEndObject();
    }

    public void jobResultToJson(JobResult jobResult, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Result", Utils$.MODULE$.getFormattedClassName(jobResult));
        JobResult jobResult2 = jobResult;
        if (jobResult2 instanceof JobFailed) {
            JobFailed jobFailed = (JobFailed)jobResult2;
            g.writeFieldName("Exception");
            this.exceptionToJson(jobFailed.exception(), g);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (JobSucceeded$.MODULE$.equals(jobResult2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)jobResult2);
        }
        g.writeEndObject();
    }

    public void rddInfoToJson(RDDInfo rddInfo, JsonGenerator g) {
        g.writeStartObject();
        g.writeNumberField("RDD ID", rddInfo.id());
        g.writeStringField("Name", rddInfo.name());
        rddInfo.scope().foreach((Function1 & Serializable)s -> {
            g.writeStringField("Scope", s.toJson());
            return BoxedUnit.UNIT;
        });
        g.writeStringField("Callsite", rddInfo.callSite());
        g.writeArrayFieldStart("Parent IDs");
        rddInfo.parentIds().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> g.writeNumber(x$1));
        g.writeEndArray();
        g.writeFieldName("Storage Level");
        this.storageLevelToJson(rddInfo.storageLevel(), g);
        g.writeBooleanField("Barrier", rddInfo.isBarrier());
        g.writeStringField("DeterministicLevel", rddInfo.outputDeterministicLevel().toString());
        g.writeNumberField("Number of Partitions", rddInfo.numPartitions());
        g.writeNumberField("Number of Cached Partitions", rddInfo.numCachedPartitions());
        g.writeNumberField("Memory Size", rddInfo.memSize());
        g.writeNumberField("Disk Size", rddInfo.diskSize());
        g.writeEndObject();
    }

    public void storageLevelToJson(StorageLevel storageLevel, JsonGenerator g) {
        g.writeStartObject();
        g.writeBooleanField("Use Disk", storageLevel.useDisk());
        g.writeBooleanField("Use Memory", storageLevel.useMemory());
        g.writeBooleanField("Use Off Heap", storageLevel.useOffHeap());
        g.writeBooleanField("Deserialized", storageLevel.deserialized());
        g.writeNumberField("Replication", storageLevel.replication());
        g.writeEndObject();
    }

    public void blockStatusToJson(BlockStatus blockStatus, JsonGenerator g) {
        g.writeStartObject();
        g.writeFieldName("Storage Level");
        this.storageLevelToJson(blockStatus.storageLevel(), g);
        g.writeNumberField("Memory Size", blockStatus.memSize());
        g.writeNumberField("Disk Size", blockStatus.diskSize());
        g.writeEndObject();
    }

    public void executorInfoToJson(ExecutorInfo executorInfo, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Host", executorInfo.executorHost());
        g.writeNumberField("Total Cores", executorInfo.totalCores());
        this.writeMapField("Log Urls", (Map<String, String>)executorInfo.logUrlMap(), g);
        this.writeMapField("Attributes", (Map<String, String>)executorInfo.attributes(), g);
        g.writeObjectFieldStart("Resources");
        executorInfo.resourcesInfo().foreach((Function1 & Serializable)x0$1 -> {
            JsonProtocol$.$anonfun$executorInfoToJson$1(g, x0$1);
            return BoxedUnit.UNIT;
        });
        g.writeEndObject();
        g.writeNumberField("Resource Profile Id", executorInfo.resourceProfileId());
        executorInfo.registrationTime().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)x$19 -> g.writeNumberField("Registration Time", x$19));
        executorInfo.requestTime().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)x$20 -> g.writeNumberField("Request Time", x$20));
        g.writeEndObject();
    }

    public void blockUpdatedInfoToJson(BlockUpdatedInfo blockUpdatedInfo, JsonGenerator g) {
        g.writeStartObject();
        g.writeFieldName("Block Manager ID");
        this.blockManagerIdToJson(blockUpdatedInfo.blockManagerId(), g);
        g.writeStringField("Block ID", blockUpdatedInfo.blockId().toString());
        g.writeFieldName("Storage Level");
        this.storageLevelToJson(blockUpdatedInfo.storageLevel(), g);
        g.writeNumberField("Memory Size", blockUpdatedInfo.memSize());
        g.writeNumberField("Disk Size", blockUpdatedInfo.diskSize());
        g.writeEndObject();
    }

    public void executorResourceRequestToJson(ExecutorResourceRequest execReq, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Resource Name", execReq.resourceName());
        g.writeNumberField("Amount", execReq.amount());
        g.writeStringField("Discovery Script", execReq.discoveryScript());
        g.writeStringField("Vendor", execReq.vendor());
        g.writeEndObject();
    }

    public void executorResourceRequestMapToJson(Map<String, ExecutorResourceRequest> m, JsonGenerator g) {
        g.writeStartObject();
        m.foreach((Function1 & Serializable)x0$1 -> {
            JsonProtocol$.$anonfun$executorResourceRequestMapToJson$1(g, x0$1);
            return BoxedUnit.UNIT;
        });
        g.writeEndObject();
    }

    public void taskResourceRequestToJson(TaskResourceRequest taskReq, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Resource Name", taskReq.resourceName());
        g.writeNumberField("Amount", taskReq.amount());
        g.writeEndObject();
    }

    public void taskResourceRequestMapToJson(Map<String, TaskResourceRequest> m, JsonGenerator g) {
        g.writeStartObject();
        m.foreach((Function1 & Serializable)x0$1 -> {
            JsonProtocol$.$anonfun$taskResourceRequestMapToJson$1(g, x0$1);
            return BoxedUnit.UNIT;
        });
        g.writeEndObject();
    }

    public void writeMapField(String name, Map<String, String> m, JsonGenerator g) {
        g.writeObjectFieldStart(name);
        m.foreach((Function1 & Serializable)x0$1 -> {
            JsonProtocol$.$anonfun$writeMapField$1(g, x0$1);
            return BoxedUnit.UNIT;
        });
        g.writeEndObject();
    }

    public void propertiesToJson(Properties properties, JsonGenerator g) {
        g.writeStartObject();
        ((IterableOnceOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala()).foreach((Function1 & Serializable)x0$1 -> {
            JsonProtocol$.$anonfun$propertiesToJson$1(g, x0$1);
            return BoxedUnit.UNIT;
        });
        g.writeEndObject();
    }

    public void UUIDToJson(UUID id, JsonGenerator g) {
        g.writeStartObject();
        g.writeNumberField("Least Significant Bits", id.getLeastSignificantBits());
        g.writeNumberField("Most Significant Bits", id.getMostSignificantBits());
        g.writeEndObject();
    }

    public void stackTraceToJson(StackTraceElement[] stackTrace, JsonGenerator g) {
        g.writeStartArray();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])stackTrace), (Function1 & Serializable)line -> {
            JsonProtocol$.$anonfun$stackTraceToJson$1(g, line);
            return BoxedUnit.UNIT;
        });
        g.writeEndArray();
    }

    public void exceptionToJson(Exception exception, JsonGenerator g) {
        g.writeStartObject();
        g.writeStringField("Message", exception.getMessage());
        g.writeFieldName("Stack Trace");
        this.stackTraceToJson(exception.getStackTrace(), g);
        g.writeEndObject();
    }

    public SparkListenerEvent sparkEventFromJson(String json) {
        return this.sparkEventFromJson(this.mapper().readTree(json));
    }

    public SparkListenerEvent sparkEventFromJson(JsonNode json) {
        SparkListenerEvent sparkListenerEvent;
        String string = json.get("Event").asText();
        String string2 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.stageSubmitted();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            sparkListenerEvent = this.stageSubmittedFromJson(json);
        } else {
            String string4 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.stageCompleted();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                sparkListenerEvent = this.stageCompletedFromJson(json);
            } else {
                String string6 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.taskStart();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    sparkListenerEvent = this.taskStartFromJson(json);
                } else {
                    String string8 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.taskGettingResult();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        sparkListenerEvent = this.taskGettingResultFromJson(json);
                    } else {
                        String string10 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.taskEnd();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            sparkListenerEvent = this.taskEndFromJson(json);
                        } else {
                            String string12 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.jobStart();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                sparkListenerEvent = this.jobStartFromJson(json);
                            } else {
                                String string14 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.jobEnd();
                                String string15 = string;
                                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                    sparkListenerEvent = this.jobEndFromJson(json);
                                } else {
                                    String string16 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.environmentUpdate();
                                    String string17 = string;
                                    if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                        sparkListenerEvent = this.environmentUpdateFromJson(json);
                                    } else {
                                        String string18 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.blockManagerAdded();
                                        String string19 = string;
                                        if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                                            sparkListenerEvent = this.blockManagerAddedFromJson(json);
                                        } else {
                                            String string20 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.blockManagerRemoved();
                                            String string21 = string;
                                            if (!(string20 != null ? !string20.equals(string21) : string21 != null)) {
                                                sparkListenerEvent = this.blockManagerRemovedFromJson(json);
                                            } else {
                                                String string22 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.unpersistRDD();
                                                String string23 = string;
                                                if (!(string22 != null ? !string22.equals(string23) : string23 != null)) {
                                                    sparkListenerEvent = this.unpersistRDDFromJson(json);
                                                } else {
                                                    String string24 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.applicationStart();
                                                    String string25 = string;
                                                    if (!(string24 != null ? !string24.equals(string25) : string25 != null)) {
                                                        sparkListenerEvent = this.applicationStartFromJson(json);
                                                    } else {
                                                        String string26 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.applicationEnd();
                                                        String string27 = string;
                                                        if (!(string26 != null ? !string26.equals(string27) : string27 != null)) {
                                                            sparkListenerEvent = this.applicationEndFromJson(json);
                                                        } else {
                                                            String string28 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.executorAdded();
                                                            String string29 = string;
                                                            if (!(string28 != null ? !string28.equals(string29) : string29 != null)) {
                                                                sparkListenerEvent = this.executorAddedFromJson(json);
                                                            } else {
                                                                String string30 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.executorRemoved();
                                                                String string31 = string;
                                                                if (!(string30 != null ? !string30.equals(string31) : string31 != null)) {
                                                                    sparkListenerEvent = this.executorRemovedFromJson(json);
                                                                } else {
                                                                    String string32 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.logStart();
                                                                    String string33 = string;
                                                                    if (!(string32 != null ? !string32.equals(string33) : string33 != null)) {
                                                                        sparkListenerEvent = this.logStartFromJson(json);
                                                                    } else {
                                                                        String string34 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.metricsUpdate();
                                                                        String string35 = string;
                                                                        if (!(string34 != null ? !string34.equals(string35) : string35 != null)) {
                                                                            sparkListenerEvent = this.executorMetricsUpdateFromJson(json);
                                                                        } else {
                                                                            String string36 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.stageExecutorMetrics();
                                                                            String string37 = string;
                                                                            if (!(string36 != null ? !string36.equals(string37) : string37 != null)) {
                                                                                sparkListenerEvent = this.stageExecutorMetricsFromJson(json);
                                                                            } else {
                                                                                String string38 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.blockUpdate();
                                                                                String string39 = string;
                                                                                if (!(string38 != null ? !string38.equals(string39) : string39 != null)) {
                                                                                    sparkListenerEvent = this.blockUpdateFromJson(json);
                                                                                } else {
                                                                                    String string40 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.resourceProfileAdded();
                                                                                    String string41 = string;
                                                                                    if (!(string40 != null ? !string40.equals(string41) : string41 != null)) {
                                                                                        sparkListenerEvent = this.resourceProfileAddedFromJson(json);
                                                                                    } else {
                                                                                        Class otherClass = Utils$.MODULE$.classForName(string, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
                                                                                        if (!SparkListenerEvent.class.isAssignableFrom(otherClass)) {
                                                                                            throw new SparkException(new StringBuilder(20).append("Unknown event type: ").append(string).toString());
                                                                                        }
                                                                                        sparkListenerEvent = (SparkListenerEvent)this.mapper().readValue(json.toString(), otherClass);
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return sparkListenerEvent;
    }

    public SparkListenerStageSubmitted stageSubmittedFromJson(JsonNode json) {
        StageInfo stageInfo = this.stageInfoFromJson(json.get("Stage Info"));
        Properties properties = this.propertiesFromJson(json.get("Properties"));
        return new SparkListenerStageSubmitted(stageInfo, properties);
    }

    public SparkListenerStageCompleted stageCompletedFromJson(JsonNode json) {
        StageInfo stageInfo = this.stageInfoFromJson(json.get("Stage Info"));
        return new SparkListenerStageCompleted(stageInfo);
    }

    public SparkListenerTaskStart taskStartFromJson(JsonNode json) {
        int stageId = this.JsonNodeImplicits(json.get("Stage ID")).extractInt();
        int stageAttemptId = BoxesRunTime.unboxToInt((Object)this.jsonOption(json.get("Stage Attempt ID")).map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$taskStartFromJson$1(x$21))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        TaskInfo taskInfo = this.taskInfoFromJson(json.get("Task Info"));
        return new SparkListenerTaskStart(stageId, stageAttemptId, taskInfo);
    }

    public SparkListenerTaskGettingResult taskGettingResultFromJson(JsonNode json) {
        TaskInfo taskInfo = this.taskInfoFromJson(json.get("Task Info"));
        return new SparkListenerTaskGettingResult(taskInfo);
    }

    public ExecutorMetrics executorMetricsFromJson(JsonNode maybeJson) {
        LinkedHashMap metrics = (LinkedHashMap)ExecutorMetricType$.MODULE$.metricToOffset().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String metric = (String)tuple2._1();
            Option metricValueJson = MODULE$.jsonOption(maybeJson).flatMap((Function1 & Serializable)json -> MODULE$.jsonOption(json.get(metric)));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)metric), metricValueJson.map((Function1 & Serializable)x$22 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$executorMetricsFromJson$3(x$22))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            return tuple22;
        });
        return new ExecutorMetrics((scala.collection.immutable.Map<String, Object>)metrics.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public SparkListenerTaskEnd taskEndFromJson(JsonNode json) {
        int stageId = this.JsonNodeImplicits(json.get("Stage ID")).extractInt();
        int stageAttemptId = BoxesRunTime.unboxToInt((Object)this.jsonOption(json.get("Stage Attempt ID")).map((Function1 & Serializable)x$23 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$taskEndFromJson$1(x$23))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        String taskType = this.JsonNodeImplicits(json.get("Task Type")).extractString();
        TaskEndReason taskEndReason = this.taskEndReasonFromJson(json.get("Task End Reason"));
        TaskInfo taskInfo = this.taskInfoFromJson(json.get("Task Info"));
        ExecutorMetrics executorMetrics = this.executorMetricsFromJson(json.get("Task Executor Metrics"));
        TaskMetrics taskMetrics = this.taskMetricsFromJson(json.get("Task Metrics"));
        return new SparkListenerTaskEnd(stageId, stageAttemptId, taskType, taskEndReason, taskInfo, executorMetrics, taskMetrics);
    }

    public SparkListenerJobStart jobStartFromJson(JsonNode json) {
        int jobId = this.JsonNodeImplicits(json.get("Job ID")).extractInt();
        long submissionTime = BoxesRunTime.unboxToLong((Object)this.jsonOption(json.get("Submission Time")).map((Function1 & Serializable)x$24 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$jobStartFromJson$1(x$24))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
        scala.collection.immutable.Seq stageIds = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps((int[])this.JsonNodeImplicits(json.get("Stage IDs")).extractElements().map((Function1 & Serializable)x$25 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$jobStartFromJson$3(x$25))).toArray((ClassTag)ClassTag$.MODULE$.Int())));
        Properties properties = this.propertiesFromJson(json.get("Properties"));
        scala.collection.immutable.Seq stageInfos = (scala.collection.immutable.Seq)this.jsonOption(json.get("Stage Infos")).map((Function1 & Serializable)x$26 -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])MODULE$.JsonNodeImplicits((JsonNode)x$26).extractElements().map((Function1 & Serializable)json -> MODULE$.stageInfoFromJson((JsonNode)json)).toArray(ClassTag$.MODULE$.apply(StageInfo.class))))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)stageIds.map((Function1 & Serializable)id -> JsonProtocol$.$anonfun$jobStartFromJson$7(BoxesRunTime.unboxToInt((Object)id))));
        return new SparkListenerJobStart(jobId, submissionTime, (scala.collection.immutable.Seq<StageInfo>)stageInfos, properties);
    }

    public SparkListenerJobEnd jobEndFromJson(JsonNode json) {
        int jobId = this.JsonNodeImplicits(json.get("Job ID")).extractInt();
        long completionTime = BoxesRunTime.unboxToLong((Object)this.jsonOption(json.get("Completion Time")).map((Function1 & Serializable)x$27 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$jobEndFromJson$1(x$27))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
        JobResult jobResult = this.jobResultFromJson(json.get("Job Result"));
        return new SparkListenerJobEnd(jobId, completionTime, jobResult);
    }

    public SparkListenerResourceProfileAdded resourceProfileAddedFromJson(JsonNode json) {
        int profId = this.JsonNodeImplicits(json.get("Resource Profile Id")).extractInt();
        Map<String, ExecutorResourceRequest> executorReqs = this.executorResourceRequestMapFromJson(json.get("Executor Resource Requests"));
        Map<String, TaskResourceRequest> taskReqs = this.taskResourceRequestMapFromJson(json.get("Task Resource Requests"));
        ResourceProfile rp = new ResourceProfile((scala.collection.immutable.Map<String, ExecutorResourceRequest>)executorReqs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (scala.collection.immutable.Map<String, TaskResourceRequest>)taskReqs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        rp.setResourceProfileId(profId);
        return new SparkListenerResourceProfileAdded(rp);
    }

    public ExecutorResourceRequest executorResourceRequestFromJson(JsonNode json) {
        String rName = this.JsonNodeImplicits(json.get("Resource Name")).extractString();
        long amount = this.JsonNodeImplicits(json.get("Amount")).extractLong();
        String discoveryScript = this.JsonNodeImplicits(json.get("Discovery Script")).extractString();
        String vendor = this.JsonNodeImplicits(json.get("Vendor")).extractString();
        return new ExecutorResourceRequest(rName, amount, discoveryScript, vendor);
    }

    public TaskResourceRequest taskResourceRequestFromJson(JsonNode json) {
        String rName = this.JsonNodeImplicits(json.get("Resource Name")).extractString();
        double amount = this.JsonNodeImplicits(json.get("Amount")).extractDouble();
        return new TaskResourceRequest(rName, amount);
    }

    public Map<String, TaskResourceRequest> taskResourceRequestMapFromJson(JsonNode json) {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(json.fields()).asScala()).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Map.Entry<String, JsonNode>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                TaskResourceRequest req = JsonProtocol$.MODULE$.taskResourceRequestFromJson(A1.getValue());
                Tuple2 tuple2 = new Tuple2((Object)A1.getKey(), (Object)req);
                return (B1)tuple2;
            }

            public final boolean isDefinedAt(Map.Entry<String, JsonNode> x1) {
                Map.Entry<String, JsonNode> entry = x1;
                boolean bl = true;
                return bl;
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, ExecutorResourceRequest> executorResourceRequestMapFromJson(JsonNode json) {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(json.fields()).asScala()).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Map.Entry<String, JsonNode>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                ExecutorResourceRequest req = JsonProtocol$.MODULE$.executorResourceRequestFromJson(A1.getValue());
                Tuple2 tuple2 = new Tuple2((Object)A1.getKey(), (Object)req);
                return (B1)tuple2;
            }

            public final boolean isDefinedAt(Map.Entry<String, JsonNode> x1) {
                Map.Entry<String, JsonNode> entry = x1;
                boolean bl = true;
                return bl;
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public SparkListenerEnvironmentUpdate environmentUpdateFromJson(JsonNode json) {
        scala.collection.immutable.Seq hadoopProperties = (scala.collection.immutable.Seq)this.jsonOption(json.get("Hadoop Properties")).map((Function1 & Serializable)x$28 -> MODULE$.mapFromJson((JsonNode)x$28).toSeq()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty());
        scala.collection.immutable.Seq metricsProperties = (scala.collection.immutable.Seq)this.jsonOption(json.get("Metrics Properties")).map((Function1 & Serializable)x$29 -> MODULE$.mapFromJson((JsonNode)x$29).toSeq()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty());
        Map environmentDetails = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JVM Information"), (Object)this.mapFromJson(json.get("JVM Information")).toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Spark Properties"), (Object)this.mapFromJson(json.get("Spark Properties")).toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Hadoop Properties"), (Object)hadoopProperties), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"System Properties"), (Object)this.mapFromJson(json.get("System Properties")).toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Metrics Properties"), (Object)metricsProperties), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Classpath Entries"), (Object)this.mapFromJson(json.get("Classpath Entries")).toSeq())}));
        return new SparkListenerEnvironmentUpdate((Map<String, Seq<Tuple2<String, String>>>)environmentDetails);
    }

    public SparkListenerBlockManagerAdded blockManagerAddedFromJson(JsonNode json) {
        BlockManagerId blockManagerId = this.blockManagerIdFromJson(json.get("Block Manager ID"));
        long maxMem = this.JsonNodeImplicits(json.get("Maximum Memory")).extractLong();
        long time = BoxesRunTime.unboxToLong((Object)this.jsonOption(json.get("Timestamp")).map((Function1 & Serializable)x$30 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$blockManagerAddedFromJson$1(x$30))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
        Option maxOnHeapMem = this.jsonOption(json.get("Maximum Onheap Memory")).map((Function1 & Serializable)x$31 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$blockManagerAddedFromJson$3(x$31)));
        Option maxOffHeapMem = this.jsonOption(json.get("Maximum Offheap Memory")).map((Function1 & Serializable)x$32 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$blockManagerAddedFromJson$4(x$32)));
        return new SparkListenerBlockManagerAdded(time, blockManagerId, maxMem, (Option<Object>)maxOnHeapMem, (Option<Object>)maxOffHeapMem);
    }

    public SparkListenerBlockManagerRemoved blockManagerRemovedFromJson(JsonNode json) {
        BlockManagerId blockManagerId = this.blockManagerIdFromJson(json.get("Block Manager ID"));
        long time = BoxesRunTime.unboxToLong((Object)this.jsonOption(json.get("Timestamp")).map((Function1 & Serializable)x$33 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$blockManagerRemovedFromJson$1(x$33))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
        return new SparkListenerBlockManagerRemoved(time, blockManagerId);
    }

    public SparkListenerUnpersistRDD unpersistRDDFromJson(JsonNode json) {
        return new SparkListenerUnpersistRDD(this.JsonNodeImplicits(json.get("RDD ID")).extractInt());
    }

    public SparkListenerApplicationStart applicationStartFromJson(JsonNode json2) {
        String appName = this.JsonNodeImplicits(json2.get("App Name")).extractString();
        Option appId = this.jsonOption(json2.get("App ID")).map((Function1 & Serializable)x$34 -> x$34.asText());
        long time = this.JsonNodeImplicits(json2.get("Timestamp")).extractLong();
        String sparkUser = this.JsonNodeImplicits(json2.get("User")).extractString();
        Option appAttemptId = this.jsonOption(json2.get("App Attempt ID")).map((Function1 & Serializable)x$35 -> x$35.asText());
        Option driverLogs = this.jsonOption(json2.get("Driver Logs")).map((Function1 & Serializable)json -> MODULE$.mapFromJson((JsonNode)json));
        Option driverAttributes = this.jsonOption(json2.get("Driver Attributes")).map((Function1 & Serializable)json -> MODULE$.mapFromJson((JsonNode)json));
        return new SparkListenerApplicationStart(appName, (Option<String>)appId, time, sparkUser, (Option<String>)appAttemptId, (Option<Map<String, String>>)driverLogs, (Option<Map<String, String>>)driverAttributes);
    }

    public SparkListenerApplicationEnd applicationEndFromJson(JsonNode json) {
        return new SparkListenerApplicationEnd(this.JsonNodeImplicits(json.get("Timestamp")).extractLong());
    }

    public SparkListenerExecutorAdded executorAddedFromJson(JsonNode json) {
        long time = this.JsonNodeImplicits(json.get("Timestamp")).extractLong();
        String executorId = this.JsonNodeImplicits(json.get("Executor ID")).extractString();
        ExecutorInfo executorInfo = this.executorInfoFromJson(json.get("Executor Info"));
        return new SparkListenerExecutorAdded(time, executorId, executorInfo);
    }

    public SparkListenerExecutorRemoved executorRemovedFromJson(JsonNode json) {
        long time = this.JsonNodeImplicits(json.get("Timestamp")).extractLong();
        String executorId = this.JsonNodeImplicits(json.get("Executor ID")).extractString();
        String reason = this.JsonNodeImplicits(json.get("Removed Reason")).extractString();
        return new SparkListenerExecutorRemoved(time, executorId, reason);
    }

    public SparkListenerLogStart logStartFromJson(JsonNode json) {
        String sparkVersion = this.JsonNodeImplicits(json.get("Spark Version")).extractString();
        return new SparkListenerLogStart(sparkVersion);
    }

    public SparkListenerExecutorMetricsUpdate executorMetricsUpdateFromJson(JsonNode json) {
        String execInfo = this.JsonNodeImplicits(json.get("Executor ID")).extractString();
        scala.collection.immutable.Seq accumUpdates = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])this.JsonNodeImplicits(json.get("Metrics Updated")).extractElements().map((Function1 & Serializable)json2 -> {
            long taskId = MODULE$.JsonNodeImplicits(json2.get("Task ID")).extractLong();
            int stageId = MODULE$.JsonNodeImplicits(json2.get("Stage ID")).extractInt();
            int stageAttemptId = MODULE$.JsonNodeImplicits(json2.get("Stage Attempt ID")).extractInt();
            scala.collection.immutable.Seq updates = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])MODULE$.JsonNodeImplicits(json2.get("Accumulator Updates")).extractElements().map((Function1 & Serializable)json -> MODULE$.accumulableInfoFromJson((JsonNode)json)).toArray(ClassTag$.MODULE$.apply(AccumulableInfo.class))));
            return new Tuple4((Object)BoxesRunTime.boxToLong((long)taskId), (Object)BoxesRunTime.boxToInteger((int)stageId), (Object)BoxesRunTime.boxToInteger((int)stageAttemptId), (Object)updates);
        }).toArray(ClassTag$.MODULE$.apply(Tuple4.class))));
        Map executorUpdates = (Map)this.jsonOption(json.get("Executor Metrics Updated")).map((Function1 & Serializable)value -> MODULE$.JsonNodeImplicits((JsonNode)value).extractElements().map((Function1 & Serializable)json -> {
            int stageId = MODULE$.JsonNodeImplicits(json.get("Stage ID")).extractInt();
            int stageAttemptId = MODULE$.JsonNodeImplicits(json.get("Stage Attempt ID")).extractInt();
            ExecutorMetrics executorMetrics = MODULE$.executorMetricsFromJson(json.get("Executor Metrics"));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(stageId, stageAttemptId)), (Object)executorMetrics);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).getOrElse((Function0 & Serializable)() -> (Map)Map$.MODULE$.empty());
        return new SparkListenerExecutorMetricsUpdate(execInfo, (scala.collection.immutable.Seq<Tuple4<Object, Object, Object, scala.collection.immutable.Seq<AccumulableInfo>>>)accumUpdates, (Map<Tuple2<Object, Object>, ExecutorMetrics>)executorUpdates);
    }

    public SparkListenerStageExecutorMetrics stageExecutorMetricsFromJson(JsonNode json) {
        String execId = this.JsonNodeImplicits(json.get("Executor ID")).extractString();
        int stageId = this.JsonNodeImplicits(json.get("Stage ID")).extractInt();
        int stageAttemptId = this.JsonNodeImplicits(json.get("Stage Attempt ID")).extractInt();
        ExecutorMetrics executorMetrics = this.executorMetricsFromJson(json.get("Executor Metrics"));
        return new SparkListenerStageExecutorMetrics(execId, stageId, stageAttemptId, executorMetrics);
    }

    public SparkListenerBlockUpdated blockUpdateFromJson(JsonNode json) {
        BlockUpdatedInfo blockUpdatedInfo = this.blockUpdatedInfoFromJson(json.get("Block Updated Info"));
        return new SparkListenerBlockUpdated(blockUpdatedInfo);
    }

    public StageInfo stageInfoFromJson(JsonNode json2) {
        SeqOps seqOps;
        int stageId = this.JsonNodeImplicits(json2.get("Stage ID")).extractInt();
        int attemptId = BoxesRunTime.unboxToInt((Object)this.jsonOption(json2.get("Stage Attempt ID")).map((Function1 & Serializable)x$36 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$stageInfoFromJson$1(x$36))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        String stageName = this.JsonNodeImplicits(json2.get("Stage Name")).extractString();
        int numTasks = this.JsonNodeImplicits(json2.get("Number of Tasks")).extractInt();
        RDDInfo[] rddInfos = (RDDInfo[])this.JsonNodeImplicits(json2.get("RDD Info")).extractElements().map((Function1 & Serializable)json -> MODULE$.rddInfoFromJson((JsonNode)json)).toArray(ClassTag$.MODULE$.apply(RDDInfo.class));
        scala.collection.immutable.Seq parentIds = (scala.collection.immutable.Seq)this.jsonOption(json2.get("Parent IDs")).map((Function1 & Serializable)l -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps((int[])MODULE$.JsonNodeImplicits((JsonNode)l).extractElements().map((Function1 & Serializable)x$37 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$stageInfoFromJson$5(x$37))).toArray((ClassTag)ClassTag$.MODULE$.Int())))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty());
        String details = (String)this.jsonOption(json2.get("Details")).map((Function1 & Serializable)x$38 -> x$38.asText()).getOrElse((Function0 & Serializable)() -> "");
        Option submissionTime = this.jsonOption(json2.get("Submission Time")).map((Function1 & Serializable)x$39 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$stageInfoFromJson$9(x$39)));
        Option completionTime = this.jsonOption(json2.get("Completion Time")).map((Function1 & Serializable)x$40 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$stageInfoFromJson$10(x$40)));
        Option failureReason = this.jsonOption(json2.get("Failure Reason")).map((Function1 & Serializable)x$41 -> x$41.asText());
        Option option = this.jsonOption(json2.get("Accumulables")).map((Function1 & Serializable)x$42 -> MODULE$.JsonNodeImplicits((JsonNode)x$42).extractElements());
        if (option instanceof Some) {
            Some some = (Some)option;
            Iterator values = (Iterator)some.value();
            seqOps = values.map((Function1 & Serializable)json -> MODULE$.accumulableInfoFromJson((JsonNode)json));
        } else if (None$.MODULE$.equals(option)) {
            seqOps = scala.package$.MODULE$.Seq().empty();
        } else {
            throw new MatchError((Object)option);
        }
        SeqOps accumulatedValues = seqOps;
        boolean isShufflePushEnabled = BoxesRunTime.unboxToBoolean((Object)this.jsonOption(json2.get("Shuffle Push Enabled")).map((Function1 & Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$stageInfoFromJson$14(x$43))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        int shufflePushMergersCount = BoxesRunTime.unboxToInt((Object)this.jsonOption(json2.get("Shuffle Push Mergers Count")).map((Function1 & Serializable)x$44 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$stageInfoFromJson$16(x$44))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        Option rpId = this.jsonOption(json2.get("Resource Profile Id")).map((Function1 & Serializable)x$45 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$stageInfoFromJson$18(x$45)));
        int stageProf = BoxesRunTime.unboxToInt((Object)rpId.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID()));
        int x$1 = stageId;
        int x$2 = attemptId;
        String x$3 = stageName;
        int x$4 = numTasks;
        IndexedSeq x$5 = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)rddInfos);
        scala.collection.immutable.Seq x$6 = parentIds;
        String x$7 = details;
        int x$8 = stageProf;
        boolean x$9 = isShufflePushEnabled;
        int x$10 = shufflePushMergersCount;
        TaskMetrics x$11 = StageInfo$.MODULE$.$lessinit$greater$default$8();
        scala.collection.immutable.Seq<scala.collection.immutable.Seq<TaskLocation>> x$12 = StageInfo$.MODULE$.$lessinit$greater$default$9();
        Option<Object> x$13 = StageInfo$.MODULE$.$lessinit$greater$default$10();
        StageInfo stageInfo = new StageInfo(x$1, x$2, x$3, x$4, (scala.collection.immutable.Seq<RDDInfo>)x$5, (scala.collection.immutable.Seq<Object>)x$6, x$7, x$11, x$12, x$13, x$8, x$9, x$10);
        stageInfo.submissionTime_$eq((Option<Object>)submissionTime);
        stageInfo.completionTime_$eq((Option<Object>)completionTime);
        stageInfo.failureReason_$eq((Option<String>)failureReason);
        ((IterableOnceOps)accumulatedValues).foreach((Function1 & Serializable)accInfo -> {
            JsonProtocol$.$anonfun$stageInfoFromJson$20(stageInfo, accInfo);
            return BoxedUnit.UNIT;
        });
        return stageInfo;
    }

    public TaskInfo taskInfoFromJson(JsonNode json2) {
        scala.collection.immutable.Seq seq;
        long taskId = this.JsonNodeImplicits(json2.get("Task ID")).extractLong();
        int index = this.JsonNodeImplicits(json2.get("Index")).extractInt();
        int attempt = BoxesRunTime.unboxToInt((Object)this.jsonOption(json2.get("Attempt")).map((Function1 & Serializable)x$46 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$taskInfoFromJson$1(x$46))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
        int partitionId = BoxesRunTime.unboxToInt((Object)this.jsonOption(json2.get("Partition ID")).map((Function1 & Serializable)x$47 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$taskInfoFromJson$3(x$47))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
        long launchTime = this.JsonNodeImplicits(json2.get("Launch Time")).extractLong();
        String executorId = Utils$.MODULE$.weakIntern(this.JsonNodeImplicits(json2.get("Executor ID")).extractString());
        String host = Utils$.MODULE$.weakIntern(this.JsonNodeImplicits(json2.get("Host")).extractString());
        Enumeration.Value taskLocality = TaskLocality$.MODULE$.withName(this.JsonNodeImplicits(json2.get("Locality")).extractString());
        boolean speculative = this.jsonOption(json2.get("Speculative")).exists((Function1 & Serializable)x$48 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$taskInfoFromJson$5(x$48)));
        long gettingResultTime = this.JsonNodeImplicits(json2.get("Getting Result Time")).extractLong();
        long finishTime = this.JsonNodeImplicits(json2.get("Finish Time")).extractLong();
        boolean failed = this.JsonNodeImplicits(json2.get("Failed")).extractBoolean();
        boolean killed = this.jsonOption(json2.get("Killed")).exists((Function1 & Serializable)x$49 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$taskInfoFromJson$6(x$49)));
        Option option = this.jsonOption(json2.get("Accumulables")).map((Function1 & Serializable)x$50 -> MODULE$.JsonNodeImplicits((JsonNode)x$50).extractElements());
        if (option instanceof Some) {
            Some some = (Some)option;
            Iterator values = (Iterator)some.value();
            seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])values.map((Function1 & Serializable)json -> MODULE$.accumulableInfoFromJson((JsonNode)json)).toArray(ClassTag$.MODULE$.apply(AccumulableInfo.class))));
        } else if (None$.MODULE$.equals(option)) {
            seq = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty();
        } else {
            throw new MatchError((Object)option);
        }
        scala.collection.immutable.Seq accumulables = seq;
        TaskInfo taskInfo = new TaskInfo(taskId, index, attempt, partitionId, launchTime, executorId, host, taskLocality, speculative);
        taskInfo.gettingResultTime_$eq(gettingResultTime);
        taskInfo.finishTime_$eq(finishTime);
        taskInfo.failed_$eq(failed);
        taskInfo.killed_$eq(killed);
        taskInfo.setAccumulables((scala.collection.immutable.Seq<AccumulableInfo>)accumulables);
        return taskInfo;
    }

    public AccumulableInfo accumulableInfoFromJson(JsonNode json) {
        long id = this.JsonNodeImplicits(json.get("ID")).extractLong();
        Option name = this.jsonOption(json.get("Name")).map((Function1 & Serializable)x$51 -> x$51.asText());
        Option update = this.jsonOption(json.get("Update")).map((Function1 & Serializable)v -> MODULE$.accumValueFromJson((Option<String>)name, (JsonNode)v));
        Option value = this.jsonOption(json.get("Value")).map((Function1 & Serializable)v -> MODULE$.accumValueFromJson((Option<String>)name, (JsonNode)v));
        boolean internal = this.jsonOption(json.get("Internal")).exists((Function1 & Serializable)x$52 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$accumulableInfoFromJson$4(x$52)));
        boolean countFailedValues = this.jsonOption(json.get("Count Failed Values")).exists((Function1 & Serializable)x$53 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$accumulableInfoFromJson$5(x$53)));
        Option metadata = this.jsonOption(json.get("Metadata")).map((Function1 & Serializable)x$54 -> x$54.asText());
        return new AccumulableInfo(id, (Option<String>)name, (Option<Object>)update, (Option<Object>)value, internal, countFailedValues, (Option<String>)metadata);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object accumValueFromJson(Option<String> name, JsonNode value) {
        Object object;
        if (name.exists((Function1 & Serializable)x$55 -> BoxesRunTime.boxToBoolean((boolean)x$55.startsWith(InternalAccumulator$.MODULE$.METRICS_PREFIX())))) {
            if (value.isIntegralNumber()) {
                object = BoxesRunTime.boxToLong((long)this.JsonNodeImplicits(value).extractLong());
                return object;
            } else {
                if (!value.isArray()) throw new IllegalArgumentException(new StringBuilder(12).append(new StringBuilder(27).append("unexpected json value ").append(value).append(" for ").toString()).append("accumulator ").append(name.get()).toString());
                object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])this.JsonNodeImplicits(value).extractElements().map((Function1 & Serializable)blockJson -> {
                    BlockId id = BlockId$.MODULE$.apply(MODULE$.JsonNodeImplicits(blockJson.get("Block ID")).extractString());
                    BlockStatus status = MODULE$.blockStatusFromJson(blockJson.get("Status"));
                    return new Tuple2((Object)id, (Object)status);
                }).toArray(ClassTag$.MODULE$.apply(Tuple2.class))))).asJava();
            }
            return object;
        } else {
            object = value.asText();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public TaskMetrics taskMetricsFromJson(JsonNode json) {
        void var2_2;
        TaskMetrics metrics = TaskMetrics$.MODULE$.empty();
        if (json == null || json.isNull()) {
            return metrics;
        }
        metrics.setExecutorDeserializeTime(this.JsonNodeImplicits(json.get("Executor Deserialize Time")).extractLong());
        metrics.setExecutorDeserializeCpuTime(BoxesRunTime.unboxToLong((Object)this.jsonOption(json.get("Executor Deserialize CPU Time")).map((Function1 & Serializable)x$56 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$1(x$56))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        metrics.setExecutorRunTime(this.JsonNodeImplicits(json.get("Executor Run Time")).extractLong());
        metrics.setExecutorCpuTime(BoxesRunTime.unboxToLong((Object)this.jsonOption(json.get("Executor CPU Time")).map((Function1 & Serializable)x$57 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$3(x$57))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        metrics.setPeakExecutionMemory(BoxesRunTime.unboxToLong((Object)this.jsonOption(json.get("Peak Execution Memory")).map((Function1 & Serializable)x$58 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$5(x$58))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        metrics.setResultSize(this.JsonNodeImplicits(json.get("Result Size")).extractLong());
        metrics.setJvmGCTime(this.JsonNodeImplicits(json.get("JVM GC Time")).extractLong());
        metrics.setResultSerializationTime(this.JsonNodeImplicits(json.get("Result Serialization Time")).extractLong());
        metrics.incMemoryBytesSpilled(this.JsonNodeImplicits(json.get("Memory Bytes Spilled")).extractLong());
        metrics.incDiskBytesSpilled(this.JsonNodeImplicits(json.get("Disk Bytes Spilled")).extractLong());
        this.jsonOption(json.get("Shuffle Read Metrics")).foreach((Function1 & Serializable)readJson -> {
            JsonProtocol$.$anonfun$taskMetricsFromJson$7(metrics, readJson);
            return BoxedUnit.UNIT;
        });
        this.jsonOption(json.get("Shuffle Write Metrics")).foreach((Function1 & Serializable)writeJson -> {
            JsonProtocol$.$anonfun$taskMetricsFromJson$34(metrics, writeJson);
            return BoxedUnit.UNIT;
        });
        this.jsonOption(json.get("Output Metrics")).foreach((Function1 & Serializable)outJson -> {
            JsonProtocol$.$anonfun$taskMetricsFromJson$37(metrics, outJson);
            return BoxedUnit.UNIT;
        });
        this.jsonOption(json.get("Input Metrics")).foreach((Function1 & Serializable)inJson -> {
            JsonProtocol$.$anonfun$taskMetricsFromJson$40(metrics, inJson);
            return BoxedUnit.UNIT;
        });
        this.jsonOption(json.get("Updated Blocks")).foreach((Function1 & Serializable)blocksJson -> {
            metrics.setUpdatedBlockStatuses((scala.collection.immutable.Seq<Tuple2<BlockId, BlockStatus>>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])JsonProtocol$.MODULE$.JsonNodeImplicits(blocksJson).extractElements().map((Function1 & Serializable)blockJson -> {
                BlockId id = BlockId$.MODULE$.apply(JsonProtocol$.MODULE$.JsonNodeImplicits(blockJson.get("Block ID")).extractString());
                BlockStatus status = JsonProtocol$.MODULE$.blockStatusFromJson(blockJson.get("Status"));
                return new Tuple2((Object)id, (Object)status);
            }).toArray(ClassTag$.MODULE$.apply(Tuple2.class)))));
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public TaskEndReason taskEndReasonFromJson(JsonNode json) {
        Product product;
        String string = this.JsonNodeImplicits(json.get("Reason")).extractString();
        String string2 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.success();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            product = Success$.MODULE$;
        } else {
            String string4 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.resubmitted();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                product = Resubmitted$.MODULE$;
            } else {
                String string6 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.fetchFailed();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    BlockManagerId blockManagerAddress = this.blockManagerIdFromJson(json.get("Block Manager Address"));
                    int shuffleId = this.JsonNodeImplicits(json.get("Shuffle ID")).extractInt();
                    long mapId = this.JsonNodeImplicits(json.get("Map ID")).extractLong();
                    int mapIndex = BoxesRunTime.unboxToInt((Object)this.jsonOption(json.get("Map Index")).map((Function1 & Serializable)x$74 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$taskEndReasonFromJson$1(x$74))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.MIN_VALUE));
                    int reduceId = this.JsonNodeImplicits(json.get("Reduce ID")).extractInt();
                    Option message = this.jsonOption(json.get("Message")).map((Function1 & Serializable)x$75 -> x$75.asText());
                    product = new FetchFailed(blockManagerAddress, shuffleId, mapId, mapIndex, reduceId, (String)message.getOrElse((Function0 & Serializable)() -> "Unknown reason"));
                } else {
                    String string8 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.exceptionFailure();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        String className = this.JsonNodeImplicits(json.get("Class Name")).extractString();
                        String description = this.JsonNodeImplicits(json.get("Description")).extractString();
                        StackTraceElement[] stackTrace = this.stackTraceFromJson(json.get("Stack Trace"));
                        String fullStackTrace = (String)this.jsonOption(json.get("Full Stack Trace")).map((Function1 & Serializable)x$76 -> x$76.asText()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                        scala.collection.immutable.Seq accumUpdates = (scala.collection.immutable.Seq)this.jsonOption(json.get("Accumulator Updates")).map((Function1 & Serializable)x$77 -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])MODULE$.JsonNodeImplicits((JsonNode)x$77).extractElements().map((Function1 & Serializable)json -> MODULE$.accumulableInfoFromJson((JsonNode)json)).toArray(ClassTag$.MODULE$.apply(AccumulableInfo.class))))).getOrElse((Function0 & Serializable)() -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)MODULE$.taskMetricsFromJson(json.get("Metrics")).accumulators().map((Function1 & Serializable)acc -> acc.toInfoUpdate())).toArray(ClassTag$.MODULE$.apply(AccumulableInfo.class)))));
                        product = new ExceptionFailure(className, description, stackTrace, fullStackTrace, (Option<ThrowableSerializationWrapper>)None$.MODULE$, (scala.collection.immutable.Seq<AccumulableInfo>)accumUpdates, ExceptionFailure$.MODULE$.apply$default$7(), ExceptionFailure$.MODULE$.apply$default$8());
                    } else {
                        String string10 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.taskResultLost();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            product = TaskResultLost$.MODULE$;
                        } else {
                            String string12 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.taskKilled();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                String killReason = (String)this.jsonOption(json.get("Kill Reason")).map((Function1 & Serializable)x$78 -> x$78.asText()).getOrElse((Function0 & Serializable)() -> "unknown reason");
                                scala.collection.immutable.Seq accumUpdates = (scala.collection.immutable.Seq)this.jsonOption(json.get("Accumulator Updates")).map((Function1 & Serializable)x$79 -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])MODULE$.JsonNodeImplicits((JsonNode)x$79).extractElements().map((Function1 & Serializable)json -> MODULE$.accumulableInfoFromJson((JsonNode)json)).toArray(ClassTag$.MODULE$.apply(AccumulableInfo.class))))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$));
                                product = new TaskKilled(killReason, (scala.collection.immutable.Seq<AccumulableInfo>)accumUpdates, TaskKilled$.MODULE$.apply$default$3(), TaskKilled$.MODULE$.apply$default$4());
                            } else {
                                String string14 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.taskCommitDenied();
                                String string15 = string;
                                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                    int jobId = BoxesRunTime.unboxToInt((Object)this.jsonOption(json.get("Job ID")).map((Function1 & Serializable)x$80 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$taskEndReasonFromJson$15(x$80))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
                                    int partitionId = BoxesRunTime.unboxToInt((Object)this.jsonOption(json.get("Partition ID")).map((Function1 & Serializable)x$81 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$taskEndReasonFromJson$17(x$81))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
                                    int attemptNo = BoxesRunTime.unboxToInt((Object)this.jsonOption(json.get("Attempt Number")).map((Function1 & Serializable)x$82 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$taskEndReasonFromJson$19(x$82))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
                                    product = new TaskCommitDenied(jobId, partitionId, attemptNo);
                                } else {
                                    String string16 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.executorLostFailure();
                                    String string17 = string;
                                    if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                        Option exitCausedByApp = this.jsonOption(json.get("Exit Caused By App")).map((Function1 & Serializable)x$83 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$taskEndReasonFromJson$21(x$83)));
                                        Option executorId = this.jsonOption(json.get("Executor ID")).map((Function1 & Serializable)x$84 -> x$84.asText());
                                        Option reason = this.jsonOption(json.get("Loss Reason")).map((Function1 & Serializable)x$85 -> x$85.asText());
                                        product = new ExecutorLostFailure((String)executorId.getOrElse((Function0 & Serializable)() -> "Unknown"), BoxesRunTime.unboxToBoolean((Object)exitCausedByApp.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true)), (Option<String>)reason);
                                    } else {
                                        String string18 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.unknownReason();
                                        String string19 = string;
                                        if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                                            product = UnknownReason$.MODULE$;
                                        } else {
                                            throw new MatchError((Object)string);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return product;
    }

    public BlockManagerId blockManagerIdFromJson(JsonNode json) {
        if (json == null || json.isNull()) {
            return null;
        }
        String executorId = Utils$.MODULE$.weakIntern(this.JsonNodeImplicits(json.get("Executor ID")).extractString());
        String host = Utils$.MODULE$.weakIntern(this.JsonNodeImplicits(json.get("Host")).extractString());
        int port = this.JsonNodeImplicits(json.get("Port")).extractInt();
        return BlockManagerId$.MODULE$.apply(executorId, host, port, BlockManagerId$.MODULE$.apply$default$4());
    }

    public JobResult jobResultFromJson(JsonNode json) {
        Product product;
        String string = this.JsonNodeImplicits(json.get("Result")).extractString();
        String string2 = JsonProtocol$JOB_RESULT_FORMATTED_CLASS_NAMES$.MODULE$.jobSucceeded();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            product = JobSucceeded$.MODULE$;
        } else {
            String string4 = JsonProtocol$JOB_RESULT_FORMATTED_CLASS_NAMES$.MODULE$.jobFailed();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                Exception exception = this.exceptionFromJson(json.get("Exception"));
                product = new JobFailed(exception);
            } else {
                throw new MatchError((Object)string);
            }
        }
        return product;
    }

    public RDDInfo rddInfoFromJson(JsonNode json) {
        int rddId = this.JsonNodeImplicits(json.get("RDD ID")).extractInt();
        String name = this.JsonNodeImplicits(json.get("Name")).extractString();
        Option scope = this.jsonOption(json.get("Scope")).map((Function1 & Serializable)x$86 -> x$86.asText()).map((Function1 & Serializable)s -> RDDOperationScope$.MODULE$.fromJson((String)s));
        String callsite = (String)this.jsonOption(json.get("Callsite")).map((Function1 & Serializable)x$87 -> x$87.asText()).getOrElse((Function0 & Serializable)() -> "");
        scala.collection.immutable.Seq parentIds = (scala.collection.immutable.Seq)this.jsonOption(json.get("Parent IDs")).map((Function1 & Serializable)l -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps((int[])MODULE$.JsonNodeImplicits((JsonNode)l).extractElements().map((Function1 & Serializable)x$88 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$rddInfoFromJson$6(x$88))).toArray((ClassTag)ClassTag$.MODULE$.Int())))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty());
        StorageLevel storageLevel = this.storageLevelFromJson(json.get("Storage Level"));
        boolean isBarrier = BoxesRunTime.unboxToBoolean((Object)this.jsonOption(json.get("Barrier")).map((Function1 & Serializable)x$89 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$rddInfoFromJson$8(x$89))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        int numPartitions = this.JsonNodeImplicits(json.get("Number of Partitions")).extractInt();
        int numCachedPartitions = this.JsonNodeImplicits(json.get("Number of Cached Partitions")).extractInt();
        long memSize = this.JsonNodeImplicits(json.get("Memory Size")).extractLong();
        long diskSize = this.JsonNodeImplicits(json.get("Disk Size")).extractLong();
        Enumeration.Value outputDeterministicLevel = DeterministicLevel$.MODULE$.withName((String)this.jsonOption(json.get("DeterministicLevel")).map((Function1 & Serializable)x$90 -> x$90.asText()).getOrElse((Function0 & Serializable)() -> "DETERMINATE"));
        RDDInfo rddInfo = new RDDInfo(rddId, name, numPartitions, storageLevel, isBarrier, (scala.collection.immutable.Seq<Object>)parentIds, callsite, (Option<RDDOperationScope>)scope, outputDeterministicLevel);
        rddInfo.numCachedPartitions_$eq(numCachedPartitions);
        rddInfo.memSize_$eq(memSize);
        rddInfo.diskSize_$eq(diskSize);
        return rddInfo;
    }

    public StorageLevel storageLevelFromJson(JsonNode json) {
        boolean bl;
        boolean useDisk = this.JsonNodeImplicits(json.get("Use Disk")).extractBoolean();
        boolean useMemory = this.JsonNodeImplicits(json.get("Use Memory")).extractBoolean();
        Option<JsonNode> option = this.jsonOption(json.get("Use Off Heap"));
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonNode value = (JsonNode)some.value();
            bl = this.JsonNodeImplicits(value).extractBoolean();
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        boolean useOffHeap = bl;
        boolean deserialized = this.JsonNodeImplicits(json.get("Deserialized")).extractBoolean();
        int replication = this.JsonNodeImplicits(json.get("Replication")).extractInt();
        return StorageLevel$.MODULE$.apply(useDisk, useMemory, useOffHeap, deserialized, replication);
    }

    public BlockStatus blockStatusFromJson(JsonNode json) {
        StorageLevel storageLevel = this.storageLevelFromJson(json.get("Storage Level"));
        long memorySize = this.JsonNodeImplicits(json.get("Memory Size")).extractLong();
        long diskSize = this.JsonNodeImplicits(json.get("Disk Size")).extractLong();
        return new BlockStatus(storageLevel, memorySize, diskSize);
    }

    public ExecutorInfo executorInfoFromJson(JsonNode json) {
        int n;
        Map map;
        Map map2;
        String executorHost = this.JsonNodeImplicits(json.get("Host")).extractString();
        int totalCores = this.JsonNodeImplicits(json.get("Total Cores")).extractInt();
        scala.collection.immutable.Map logUrls = this.mapFromJson(json.get("Log Urls")).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option<JsonNode> option = this.jsonOption(json.get("Attributes"));
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonNode attr = (JsonNode)some.value();
            map2 = this.mapFromJson(attr).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        } else if (None$.MODULE$.equals(option)) {
            map2 = (Map)Map$.MODULE$.empty();
        } else {
            throw new MatchError(option);
        }
        Map attributes = map2;
        Option<JsonNode> option2 = this.jsonOption(json.get("Resources"));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            JsonNode resources = (JsonNode)some.value();
            map = this.resourcesMapFromJson(resources).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        } else if (None$.MODULE$.equals(option2)) {
            map = (Map)Map$.MODULE$.empty();
        } else {
            throw new MatchError(option2);
        }
        Map resources = map;
        Option<JsonNode> option3 = this.jsonOption(json.get("Resource Profile Id"));
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            JsonNode id = (JsonNode)some.value();
            n = this.JsonNodeImplicits(id).extractInt();
        } else if (None$.MODULE$.equals(option3)) {
            n = ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
        } else {
            throw new MatchError(option3);
        }
        int resourceProfileId = n;
        Option registrationTs = this.jsonOption(json.get("Registration Time")).map((Function1 & Serializable)ts -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$executorInfoFromJson$1(ts)));
        Option requestTs = this.jsonOption(json.get("Request Time")).map((Function1 & Serializable)ts -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$executorInfoFromJson$2(ts)));
        return new ExecutorInfo(executorHost, totalCores, (scala.collection.immutable.Map<String, String>)logUrls, (scala.collection.immutable.Map<String, String>)attributes.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (scala.collection.immutable.Map<String, ResourceInformation>)resources.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), resourceProfileId, (Option<Object>)registrationTs, (Option<Object>)requestTs);
    }

    public BlockUpdatedInfo blockUpdatedInfoFromJson(JsonNode json) {
        BlockManagerId blockManagerId = this.blockManagerIdFromJson(json.get("Block Manager ID"));
        BlockId blockId = BlockId$.MODULE$.apply(this.JsonNodeImplicits(json.get("Block ID")).extractString());
        StorageLevel storageLevel = this.storageLevelFromJson(json.get("Storage Level"));
        long memorySize = this.JsonNodeImplicits(json.get("Memory Size")).extractLong();
        long diskSize = this.JsonNodeImplicits(json.get("Disk Size")).extractLong();
        return new BlockUpdatedInfo(blockManagerId, blockId, storageLevel, memorySize, diskSize);
    }

    public Map<String, ResourceInformation> resourcesMapFromJson(JsonNode json) {
        Predef$.MODULE$.assert(json.isObject(), (Function0 & Serializable)() -> new StringBuilder(21).append("expected object, got ").append(json.getNodeType()).toString());
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(json.fields()).asScala()).map((Function1 & Serializable)field -> {
            ResourceInformation resourceInfo = ResourceInformation$.MODULE$.parseJson(field.getValue().toString());
            return new Tuple2(field.getKey(), (Object)resourceInfo);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, String> mapFromJson(JsonNode json) {
        Predef$.MODULE$.assert(json.isObject(), (Function0 & Serializable)() -> new StringBuilder(21).append("expected object, got ").append(json.getNodeType()).toString());
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(json.fields()).asScala()).map((Function1 & Serializable)field -> new Tuple2(field.getKey(), (Object)MODULE$.JsonNodeImplicits((JsonNode)field.getValue()).extractString())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Properties propertiesFromJson(JsonNode json) {
        return (Properties)this.jsonOption(json).map((Function1 & Serializable)value -> {
            void var1_1;
            Properties properties = new Properties();
            MODULE$.mapFromJson((JsonNode)value).foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                Object object = properties.setProperty(k, v);
                return object;
            });
            return var1_1;
        }).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public UUID UUIDFromJson(JsonNode json) {
        long leastSignificantBits = this.JsonNodeImplicits(json.get("Least Significant Bits")).extractLong();
        long mostSignificantBits = this.JsonNodeImplicits(json.get("Most Significant Bits")).extractLong();
        return new UUID(leastSignificantBits, mostSignificantBits);
    }

    public StackTraceElement[] stackTraceFromJson(JsonNode json) {
        return (StackTraceElement[])this.jsonOption(json).map((Function1 & Serializable)x$91 -> (StackTraceElement[])MODULE$.JsonNodeImplicits((JsonNode)x$91).extractElements().map((Function1 & Serializable)line -> {
            String declaringClass = MODULE$.JsonNodeImplicits(line.get("Declaring Class")).extractString();
            String methodName = MODULE$.JsonNodeImplicits(line.get("Method Name")).extractString();
            String fileName = (String)MODULE$.jsonOption(line.get("File Name")).map((Function1 & Serializable)x$92 -> MODULE$.JsonNodeImplicits((JsonNode)x$92).extractString()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            int lineNumber = MODULE$.JsonNodeImplicits(line.get("Line Number")).extractInt();
            return new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
        }).toArray(ClassTag$.MODULE$.apply(StackTraceElement.class))).getOrElse((Function0 & Serializable)() -> (StackTraceElement[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(StackTraceElement.class)));
    }

    /*
     * WARNING - void declaration
     */
    public Exception exceptionFromJson(JsonNode json) {
        void var3_3;
        String message = (String)this.jsonOption(json.get("Message")).map((Function1 & Serializable)x$93 -> MODULE$.JsonNodeImplicits((JsonNode)x$93).extractString()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Exception e = new Exception(message);
        e.setStackTrace(this.stackTraceFromJson(json.get("Stack Trace")));
        return var3_3;
    }

    private Option<JsonNode> jsonOption(JsonNode json) {
        return json == null || json.isNull() ? None$.MODULE$ : new Some((Object)json);
    }

    private JsonProtocol.JsonNodeImplicits JsonNodeImplicits(JsonNode json) {
        return new JsonProtocol.JsonNodeImplicits(json);
    }

    public static final /* synthetic */ void $anonfun$stageSubmittedToJson$1(JsonGenerator g$1, Properties properties) {
        g$1.writeFieldName("Properties");
        MODULE$.propertiesToJson(properties, g$1);
    }

    public static final /* synthetic */ void $anonfun$taskEndToJson$1(JsonGenerator g$2, TaskMetrics m) {
        g$2.writeFieldName("Task Metrics");
        MODULE$.taskMetricsToJson(m, g$2);
    }

    public static final /* synthetic */ void $anonfun$jobStartToJson$3(JsonGenerator g$3, Properties properties) {
        g$3.writeFieldName("Properties");
        MODULE$.propertiesToJson(properties, g$3);
    }

    public static final /* synthetic */ void $anonfun$executorMetricsUpdateToJson$1(JsonGenerator g$6, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        long taskId = BoxesRunTime.unboxToLong((Object)tuple4._1());
        int stageId = BoxesRunTime.unboxToInt((Object)tuple4._2());
        int stageAttemptId = BoxesRunTime.unboxToInt((Object)tuple4._3());
        scala.collection.immutable.Seq updates = (scala.collection.immutable.Seq)tuple4._4();
        g$6.writeStartObject();
        g$6.writeNumberField("Task ID", taskId);
        g$6.writeNumberField("Stage ID", stageId);
        g$6.writeNumberField("Stage Attempt ID", stageAttemptId);
        g$6.writeArrayFieldStart("Accumulator Updates");
        updates.foreach((Function1 & Serializable)x$8 -> {
            JsonProtocol$.MODULE$.accumulableInfoToJson(x$8, g$6);
            return BoxedUnit.UNIT;
        });
        g$6.writeEndArray();
        g$6.writeEndObject();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$executorMetricsUpdateToJson$3(JsonGenerator g$6, Tuple2 x0$2) {
        ExecutorMetrics metrics;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$2;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                metrics = (ExecutorMetrics)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        int stageId = tuple2._1$mcI$sp();
        int stageAttemptId = tuple2._2$mcI$sp();
        g$6.writeStartObject();
        g$6.writeNumberField("Stage ID", stageId);
        g$6.writeNumberField("Stage Attempt ID", stageAttemptId);
        g$6.writeFieldName("Executor Metrics");
        MODULE$.executorMetricsToJson(metrics, g$6);
        g$6.writeEndObject();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$accumulablesToJson$2(String elem) {
        return MODULE$.accumulableExcludeList().contains((Object)elem);
    }

    public static final /* synthetic */ boolean $anonfun$accumulablesToJson$1(AccumulableInfo x$13) {
        return x$13.name().exists((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$accumulablesToJson$2(elem)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$accumValueToJson$5(JsonGenerator g$10, Object x0$1) {
        Object object = x0$1;
        if (object instanceof Tuple2) {
            Tuple2 tuple2 = (Tuple2)object;
            Object id = tuple2._1();
            Object status = tuple2._2();
            if (id instanceof BlockId) {
                BlockId blockId = (BlockId)id;
                if (status instanceof BlockStatus) {
                    BlockStatus blockStatus = (BlockStatus)status;
                    g$10.writeStartObject();
                    g$10.writeStringField("Block ID", blockId.toString());
                    g$10.writeFieldName("Status");
                    MODULE$.blockStatusToJson(blockStatus, g$10);
                    g$10.writeEndObject();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void writeShufflePushReadMetrics$1(JsonGenerator g$11, TaskMetrics taskMetrics$1) {
        g$11.writeStartObject();
        g$11.writeNumberField("Corrupt Merged Block Chunks", taskMetrics$1.shuffleReadMetrics().corruptMergedBlockChunks());
        g$11.writeNumberField("Merged Fetch Fallback Count", taskMetrics$1.shuffleReadMetrics().mergedFetchFallbackCount());
        g$11.writeNumberField("Merged Remote Blocks Fetched", taskMetrics$1.shuffleReadMetrics().remoteMergedBlocksFetched());
        g$11.writeNumberField("Merged Local Blocks Fetched", taskMetrics$1.shuffleReadMetrics().localMergedBlocksFetched());
        g$11.writeNumberField("Merged Remote Chunks Fetched", taskMetrics$1.shuffleReadMetrics().remoteMergedChunksFetched());
        g$11.writeNumberField("Merged Local Chunks Fetched", taskMetrics$1.shuffleReadMetrics().localMergedChunksFetched());
        g$11.writeNumberField("Merged Remote Bytes Read", taskMetrics$1.shuffleReadMetrics().remoteMergedBytesRead());
        g$11.writeNumberField("Merged Local Bytes Read", taskMetrics$1.shuffleReadMetrics().localMergedBytesRead());
        g$11.writeNumberField("Merged Remote Requests Duration", taskMetrics$1.shuffleReadMetrics().remoteMergedReqsDuration());
        g$11.writeEndObject();
    }

    private static final void writeShuffleReadMetrics$1(JsonGenerator g$11, TaskMetrics taskMetrics$1) {
        g$11.writeStartObject();
        g$11.writeNumberField("Remote Blocks Fetched", taskMetrics$1.shuffleReadMetrics().remoteBlocksFetched());
        g$11.writeNumberField("Local Blocks Fetched", taskMetrics$1.shuffleReadMetrics().localBlocksFetched());
        g$11.writeNumberField("Fetch Wait Time", taskMetrics$1.shuffleReadMetrics().fetchWaitTime());
        g$11.writeNumberField("Remote Bytes Read", taskMetrics$1.shuffleReadMetrics().remoteBytesRead());
        g$11.writeNumberField("Remote Bytes Read To Disk", taskMetrics$1.shuffleReadMetrics().remoteBytesReadToDisk());
        g$11.writeNumberField("Local Bytes Read", taskMetrics$1.shuffleReadMetrics().localBytesRead());
        g$11.writeNumberField("Total Records Read", taskMetrics$1.shuffleReadMetrics().recordsRead());
        g$11.writeNumberField("Remote Requests Duration", taskMetrics$1.shuffleReadMetrics().remoteReqsDuration());
        g$11.writeFieldName("Push Based Shuffle");
        JsonProtocol$.writeShufflePushReadMetrics$1(g$11, taskMetrics$1);
        g$11.writeEndObject();
    }

    private static final void writeShuffleWriteMetrics$1(JsonGenerator g$11, TaskMetrics taskMetrics$1) {
        g$11.writeStartObject();
        g$11.writeNumberField("Shuffle Bytes Written", taskMetrics$1.shuffleWriteMetrics().bytesWritten());
        g$11.writeNumberField("Shuffle Write Time", taskMetrics$1.shuffleWriteMetrics().writeTime());
        g$11.writeNumberField("Shuffle Records Written", taskMetrics$1.shuffleWriteMetrics().recordsWritten());
        g$11.writeEndObject();
    }

    private static final void writeInputMetrics$1(JsonGenerator g$11, TaskMetrics taskMetrics$1) {
        g$11.writeStartObject();
        g$11.writeNumberField("Bytes Read", taskMetrics$1.inputMetrics().bytesRead());
        g$11.writeNumberField("Records Read", taskMetrics$1.inputMetrics().recordsRead());
        g$11.writeEndObject();
    }

    private static final void writeOutputMetrics$1(JsonGenerator g$11, TaskMetrics taskMetrics$1) {
        g$11.writeStartObject();
        g$11.writeNumberField("Bytes Written", taskMetrics$1.outputMetrics().bytesWritten());
        g$11.writeNumberField("Records Written", taskMetrics$1.outputMetrics().recordsWritten());
        g$11.writeEndObject();
    }

    public static final /* synthetic */ void $anonfun$taskMetricsToJson$1(JsonGenerator g$11, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BlockId id = (BlockId)tuple2._1();
        BlockStatus status = (BlockStatus)tuple2._2();
        g$11.writeStartObject();
        g$11.writeStringField("Block ID", id.toString());
        g$11.writeFieldName("Status");
        MODULE$.blockStatusToJson(status, g$11);
        g$11.writeEndObject();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void writeUpdatedBlocks$1(JsonGenerator g$11, TaskMetrics taskMetrics$1) {
        g$11.writeStartArray();
        taskMetrics$1.updatedBlockStatuses().foreach((Function1 & Serializable)x0$1 -> {
            JsonProtocol$.$anonfun$taskMetricsToJson$1(g$11, x0$1);
            return BoxedUnit.UNIT;
        });
        g$11.writeEndArray();
    }

    public static final /* synthetic */ void $anonfun$executorMetricsToJson$1(JsonGenerator g$12, ExecutorMetrics executorMetrics$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String m = (String)tuple2._1();
        g$12.writeNumberField(m, executorMetrics$1.getMetricValue(m));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$taskEndReasonToJson$1(JsonGenerator g$13, BlockManagerId id) {
        g$13.writeFieldName("Block Manager Address");
        MODULE$.blockManagerIdToJson(id, g$13);
    }

    public static final /* synthetic */ void $anonfun$executorInfoToJson$1(JsonGenerator g$15, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        ResourceInformation v = (ResourceInformation)tuple2._2();
        g$15.writeFieldName(k);
        g$15.writeRawValue(JsonMethods$.MODULE$.compact(v.toJson()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$executorResourceRequestMapToJson$1(JsonGenerator g$16, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        ExecutorResourceRequest execReq = (ExecutorResourceRequest)tuple2._2();
        g$16.writeFieldName(k);
        MODULE$.executorResourceRequestToJson(execReq, g$16);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$taskResourceRequestMapToJson$1(JsonGenerator g$17, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        TaskResourceRequest taskReq = (TaskResourceRequest)tuple2._2();
        g$17.writeFieldName(k);
        MODULE$.taskResourceRequestToJson(taskReq, g$17);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$writeMapField$1(JsonGenerator g$18, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        g$18.writeStringField(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$propertiesToJson$1(JsonGenerator g$19, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        g$19.writeStringField(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$stackTraceToJson$1(JsonGenerator g$20, StackTraceElement line) {
        g$20.writeStartObject();
        g$20.writeStringField("Declaring Class", line.getClassName());
        g$20.writeStringField("Method Name", line.getMethodName());
        g$20.writeStringField("File Name", line.getFileName());
        g$20.writeNumberField("Line Number", line.getLineNumber());
        g$20.writeEndObject();
    }

    public static final /* synthetic */ int $anonfun$taskStartFromJson$1(JsonNode x$21) {
        return MODULE$.JsonNodeImplicits(x$21).extractInt();
    }

    public static final /* synthetic */ long $anonfun$executorMetricsFromJson$3(JsonNode x$22) {
        return MODULE$.JsonNodeImplicits(x$22).extractLong();
    }

    public static final /* synthetic */ int $anonfun$taskEndFromJson$1(JsonNode x$23) {
        return MODULE$.JsonNodeImplicits(x$23).extractInt();
    }

    public static final /* synthetic */ long $anonfun$jobStartFromJson$1(JsonNode x$24) {
        return MODULE$.JsonNodeImplicits(x$24).extractLong();
    }

    public static final /* synthetic */ int $anonfun$jobStartFromJson$3(JsonNode x$25) {
        return MODULE$.JsonNodeImplicits(x$25).extractInt();
    }

    public static final /* synthetic */ StageInfo $anonfun$jobStartFromJson$7(int id) {
        int x$1 = id;
        boolean x$2 = false;
        String x$3 = "unknown";
        boolean x$4 = false;
        scala.collection.immutable.Seq x$5 = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty();
        scala.collection.immutable.Seq x$6 = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty();
        String x$7 = "unknown";
        int x$8 = ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
        TaskMetrics x$9 = StageInfo$.MODULE$.$lessinit$greater$default$8();
        scala.collection.immutable.Seq<scala.collection.immutable.Seq<TaskLocation>> x$10 = StageInfo$.MODULE$.$lessinit$greater$default$9();
        Option<Object> x$11 = StageInfo$.MODULE$.$lessinit$greater$default$10();
        boolean x$12 = StageInfo$.MODULE$.$lessinit$greater$default$12();
        int x$13 = StageInfo$.MODULE$.$lessinit$greater$default$13();
        return new StageInfo(x$1, 0, "unknown", 0, (scala.collection.immutable.Seq<RDDInfo>)x$5, (scala.collection.immutable.Seq<Object>)x$6, "unknown", x$9, x$10, x$11, x$8, x$12, x$13);
    }

    public static final /* synthetic */ long $anonfun$jobEndFromJson$1(JsonNode x$27) {
        return MODULE$.JsonNodeImplicits(x$27).extractLong();
    }

    public static final /* synthetic */ long $anonfun$blockManagerAddedFromJson$1(JsonNode x$30) {
        return MODULE$.JsonNodeImplicits(x$30).extractLong();
    }

    public static final /* synthetic */ long $anonfun$blockManagerAddedFromJson$3(JsonNode x$31) {
        return MODULE$.JsonNodeImplicits(x$31).extractLong();
    }

    public static final /* synthetic */ long $anonfun$blockManagerAddedFromJson$4(JsonNode x$32) {
        return MODULE$.JsonNodeImplicits(x$32).extractLong();
    }

    public static final /* synthetic */ long $anonfun$blockManagerRemovedFromJson$1(JsonNode x$33) {
        return MODULE$.JsonNodeImplicits(x$33).extractLong();
    }

    public static final /* synthetic */ int $anonfun$stageInfoFromJson$1(JsonNode x$36) {
        return MODULE$.JsonNodeImplicits(x$36).extractInt();
    }

    public static final /* synthetic */ int $anonfun$stageInfoFromJson$5(JsonNode x$37) {
        return MODULE$.JsonNodeImplicits(x$37).extractInt();
    }

    public static final /* synthetic */ long $anonfun$stageInfoFromJson$9(JsonNode x$39) {
        return MODULE$.JsonNodeImplicits(x$39).extractLong();
    }

    public static final /* synthetic */ long $anonfun$stageInfoFromJson$10(JsonNode x$40) {
        return MODULE$.JsonNodeImplicits(x$40).extractLong();
    }

    public static final /* synthetic */ boolean $anonfun$stageInfoFromJson$14(JsonNode x$43) {
        return MODULE$.JsonNodeImplicits(x$43).extractBoolean();
    }

    public static final /* synthetic */ int $anonfun$stageInfoFromJson$16(JsonNode x$44) {
        return MODULE$.JsonNodeImplicits(x$44).extractInt();
    }

    public static final /* synthetic */ int $anonfun$stageInfoFromJson$18(JsonNode x$45) {
        return MODULE$.JsonNodeImplicits(x$45).extractInt();
    }

    public static final /* synthetic */ void $anonfun$stageInfoFromJson$20(StageInfo stageInfo$1, AccumulableInfo accInfo) {
        stageInfo$1.accumulables().update((Object)BoxesRunTime.boxToLong((long)accInfo.id()), (Object)accInfo);
    }

    public static final /* synthetic */ int $anonfun$taskInfoFromJson$1(JsonNode x$46) {
        return MODULE$.JsonNodeImplicits(x$46).extractInt();
    }

    public static final /* synthetic */ int $anonfun$taskInfoFromJson$3(JsonNode x$47) {
        return MODULE$.JsonNodeImplicits(x$47).extractInt();
    }

    public static final /* synthetic */ boolean $anonfun$taskInfoFromJson$5(JsonNode x$48) {
        return MODULE$.JsonNodeImplicits(x$48).extractBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$taskInfoFromJson$6(JsonNode x$49) {
        return MODULE$.JsonNodeImplicits(x$49).extractBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$accumulableInfoFromJson$4(JsonNode x$52) {
        return MODULE$.JsonNodeImplicits(x$52).extractBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$accumulableInfoFromJson$5(JsonNode x$53) {
        return MODULE$.JsonNodeImplicits(x$53).extractBoolean();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$1(JsonNode x$56) {
        return MODULE$.JsonNodeImplicits(x$56).extractLong();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$3(JsonNode x$57) {
        return MODULE$.JsonNodeImplicits(x$57).extractLong();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$5(JsonNode x$58) {
        return MODULE$.JsonNodeImplicits(x$58).extractLong();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$9(JsonNode x$59) {
        return MODULE$.JsonNodeImplicits(x$59).extractLong();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$11(JsonNode x$60) {
        return MODULE$.JsonNodeImplicits(x$60).extractLong();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$13(JsonNode x$61) {
        return MODULE$.JsonNodeImplicits(x$61).extractLong();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$16(JsonNode x$62) {
        return MODULE$.JsonNodeImplicits(x$62).extractLong();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$18(JsonNode x$63) {
        return MODULE$.JsonNodeImplicits(x$63).extractLong();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$20(JsonNode x$64) {
        return MODULE$.JsonNodeImplicits(x$64).extractLong();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$22(JsonNode x$65) {
        return MODULE$.JsonNodeImplicits(x$65).extractLong();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$24(JsonNode x$66) {
        return MODULE$.JsonNodeImplicits(x$66).extractLong();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$26(JsonNode x$67) {
        return MODULE$.JsonNodeImplicits(x$67).extractLong();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$28(JsonNode x$68) {
        return MODULE$.JsonNodeImplicits(x$68).extractLong();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$30(JsonNode x$69) {
        return MODULE$.JsonNodeImplicits(x$69).extractLong();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$32(JsonNode x$70) {
        return MODULE$.JsonNodeImplicits(x$70).extractLong();
    }

    public static final /* synthetic */ void $anonfun$taskMetricsFromJson$15(TempShuffleReadMetrics readMetrics$1, JsonNode shufflePushReadJson) {
        readMetrics$1.incCorruptMergedBlockChunks(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(shufflePushReadJson.get("Corrupt Merged Block Chunks")).map((Function1 & Serializable)x$62 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$16(x$62))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        readMetrics$1.incMergedFetchFallbackCount(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(shufflePushReadJson.get("Merged Fallback Count")).map((Function1 & Serializable)x$63 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$18(x$63))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        readMetrics$1.incRemoteMergedBlocksFetched(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(shufflePushReadJson.get("Merged Remote Blocks Fetched")).map((Function1 & Serializable)x$64 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$20(x$64))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        readMetrics$1.incLocalMergedBlocksFetched(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(shufflePushReadJson.get("Merged Local Blocks Fetched")).map((Function1 & Serializable)x$65 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$22(x$65))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        readMetrics$1.incRemoteMergedChunksFetched(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(shufflePushReadJson.get("Merged Remote Chunks Fetched")).map((Function1 & Serializable)x$66 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$24(x$66))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        readMetrics$1.incLocalMergedChunksFetched(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(shufflePushReadJson.get("Merged Local Chunks Fetched")).map((Function1 & Serializable)x$67 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$26(x$67))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        readMetrics$1.incRemoteMergedBytesRead(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(shufflePushReadJson.get("Merged Remote Bytes Read")).map((Function1 & Serializable)x$68 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$28(x$68))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        readMetrics$1.incLocalMergedBytesRead(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(shufflePushReadJson.get("Merged Local Bytes Read")).map((Function1 & Serializable)x$69 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$30(x$69))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        readMetrics$1.incRemoteMergedReqsDuration(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(shufflePushReadJson.get("Merged Remote Requests Duration")).map((Function1 & Serializable)x$70 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$32(x$70))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
    }

    public static final /* synthetic */ void $anonfun$taskMetricsFromJson$7(TaskMetrics metrics$1, JsonNode readJson) {
        TempShuffleReadMetrics readMetrics = metrics$1.createTempShuffleReadMetrics();
        readMetrics.incRemoteBlocksFetched(MODULE$.JsonNodeImplicits(readJson.get("Remote Blocks Fetched")).extractInt());
        readMetrics.incLocalBlocksFetched(MODULE$.JsonNodeImplicits(readJson.get("Local Blocks Fetched")).extractInt());
        readMetrics.incRemoteBytesRead(MODULE$.JsonNodeImplicits(readJson.get("Remote Bytes Read")).extractLong());
        MODULE$.jsonOption(readJson.get("Remote Bytes Read To Disk")).foreach((Function1 & Serializable)v -> {
            readMetrics.incRemoteBytesReadToDisk(JsonProtocol$.MODULE$.JsonNodeImplicits(v).extractLong());
            return BoxedUnit.UNIT;
        });
        readMetrics.incLocalBytesRead(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(readJson.get("Local Bytes Read")).map((Function1 & Serializable)x$59 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$9(x$59))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        readMetrics.incFetchWaitTime(MODULE$.JsonNodeImplicits(readJson.get("Fetch Wait Time")).extractLong());
        readMetrics.incRecordsRead(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(readJson.get("Total Records Read")).map((Function1 & Serializable)x$60 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$11(x$60))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        readMetrics.incRemoteReqsDuration(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(readJson.get("Remote Requests Duration")).map((Function1 & Serializable)x$61 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$13(x$61))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        MODULE$.jsonOption(readJson.get("Shuffle Push Read Metrics")).foreach((Function1 & Serializable)shufflePushReadJson -> {
            JsonProtocol$.$anonfun$taskMetricsFromJson$15(readMetrics, shufflePushReadJson);
            return BoxedUnit.UNIT;
        });
        metrics$1.mergeShuffleReadMetrics();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$35(JsonNode x$71) {
        return MODULE$.JsonNodeImplicits(x$71).extractLong();
    }

    public static final /* synthetic */ void $anonfun$taskMetricsFromJson$34(TaskMetrics metrics$1, JsonNode writeJson) {
        ShuffleWriteMetrics writeMetrics = metrics$1.shuffleWriteMetrics();
        writeMetrics.incBytesWritten(MODULE$.JsonNodeImplicits(writeJson.get("Shuffle Bytes Written")).extractLong());
        writeMetrics.incRecordsWritten(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(writeJson.get("Shuffle Records Written")).map((Function1 & Serializable)x$71 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$35(x$71))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        writeMetrics.incWriteTime(MODULE$.JsonNodeImplicits(writeJson.get("Shuffle Write Time")).extractLong());
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$38(JsonNode x$72) {
        return MODULE$.JsonNodeImplicits(x$72).extractLong();
    }

    public static final /* synthetic */ void $anonfun$taskMetricsFromJson$37(TaskMetrics metrics$1, JsonNode outJson) {
        OutputMetrics outputMetrics = metrics$1.outputMetrics();
        outputMetrics.setBytesWritten(MODULE$.JsonNodeImplicits(outJson.get("Bytes Written")).extractLong());
        outputMetrics.setRecordsWritten(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(outJson.get("Records Written")).map((Function1 & Serializable)x$72 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$38(x$72))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$41(JsonNode x$73) {
        return MODULE$.JsonNodeImplicits(x$73).extractLong();
    }

    public static final /* synthetic */ void $anonfun$taskMetricsFromJson$40(TaskMetrics metrics$1, JsonNode inJson) {
        InputMetrics inputMetrics = metrics$1.inputMetrics();
        inputMetrics.incBytesRead(MODULE$.JsonNodeImplicits(inJson.get("Bytes Read")).extractLong());
        inputMetrics.incRecordsRead(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(inJson.get("Records Read")).map((Function1 & Serializable)x$73 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$41(x$73))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
    }

    public static final /* synthetic */ int $anonfun$taskEndReasonFromJson$1(JsonNode x$74) {
        return MODULE$.JsonNodeImplicits(x$74).extractInt();
    }

    public static final /* synthetic */ int $anonfun$taskEndReasonFromJson$15(JsonNode x$80) {
        return MODULE$.JsonNodeImplicits(x$80).extractInt();
    }

    public static final /* synthetic */ int $anonfun$taskEndReasonFromJson$17(JsonNode x$81) {
        return MODULE$.JsonNodeImplicits(x$81).extractInt();
    }

    public static final /* synthetic */ int $anonfun$taskEndReasonFromJson$19(JsonNode x$82) {
        return MODULE$.JsonNodeImplicits(x$82).extractInt();
    }

    public static final /* synthetic */ boolean $anonfun$taskEndReasonFromJson$21(JsonNode x$83) {
        return MODULE$.JsonNodeImplicits(x$83).extractBoolean();
    }

    public static final /* synthetic */ int $anonfun$rddInfoFromJson$6(JsonNode x$88) {
        return MODULE$.JsonNodeImplicits(x$88).extractInt();
    }

    public static final /* synthetic */ boolean $anonfun$rddInfoFromJson$8(JsonNode x$89) {
        return MODULE$.JsonNodeImplicits(x$89).extractBoolean();
    }

    public static final /* synthetic */ long $anonfun$executorInfoFromJson$1(JsonNode ts) {
        return MODULE$.JsonNodeImplicits(ts).extractLong();
    }

    public static final /* synthetic */ long $anonfun$executorInfoFromJson$2(JsonNode ts) {
        return MODULE$.JsonNodeImplicits(ts).extractLong();
    }

    private JsonProtocol$() {
    }
}

