/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Contains;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StringBinaryPredicateExpressionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Option;
import scala.collection.immutable.Seq;

@ExpressionDescription(usage="\n    _FUNC_(left, right) - Returns a boolean. The value is True if right is found inside left.\n    Returns NULL if either input expression is NULL. Otherwise, returns False.\n    Both left or right must be of STRING or BINARY type.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL', 'Spark');\n       true\n      > SELECT _FUNC_('Spark SQL', 'SPARK');\n       false\n      > SELECT _FUNC_('Spark SQL', null);\n       NULL\n      > SELECT _FUNC_(x'537061726b2053514c', x'537061726b');\n       true\n  ", since="3.3.0", group="string_funcs")
public final class ContainsExpressionBuilder$
implements StringBinaryPredicateExpressionBuilderBase {
    public static final ContainsExpressionBuilder$ MODULE$ = new ContainsExpressionBuilder$();

    static {
        FunctionBuilderBase.$init$(MODULE$);
        StringBinaryPredicateExpressionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        return StringBinaryPredicateExpressionBuilderBase.build$(this, funcName, expressions);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return FunctionBuilderBase.functionSignature$(this);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    @Override
    public Expression createStringPredicate(Expression left, Expression right) {
        return new Contains(left, right);
    }

    private ContainsExpressionBuilder$() {
    }
}

