/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.MergedBlockMetaResponseCallback;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.StreamCallbackWithID;
import org.apache.spark.network.client.StreamInterceptor;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.protocol.ChunkFetchRequest;
import org.apache.spark.network.protocol.Encodable;
import org.apache.spark.network.protocol.MergedBlockMetaRequest;
import org.apache.spark.network.protocol.MergedBlockMetaSuccess;
import org.apache.spark.network.protocol.OneWayMessage;
import org.apache.spark.network.protocol.RequestMessage;
import org.apache.spark.network.protocol.RpcFailure;
import org.apache.spark.network.protocol.RpcRequest;
import org.apache.spark.network.protocol.RpcResponse;
import org.apache.spark.network.protocol.StreamFailure;
import org.apache.spark.network.protocol.StreamRequest;
import org.apache.spark.network.protocol.StreamResponse;
import org.apache.spark.network.protocol.UploadStream;
import org.apache.spark.network.server.BlockPushNonFatalFailure;
import org.apache.spark.network.server.ChunkFetchRequestHandler;
import org.apache.spark.network.server.MessageHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.util.NettyUtils;
import org.apache.spark.network.util.TransportFrameDecoder;
import org.sparkproject.guava.base.Throwables;

public class TransportRequestHandler
extends MessageHandler<RequestMessage> {
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(TransportRequestHandler.class);
    private final Channel channel;
    private final TransportClient reverseClient;
    private final RpcHandler rpcHandler;
    private final StreamManager streamManager;
    private final long maxChunksBeingTransferred;
    private final ChunkFetchRequestHandler chunkFetchRequestHandler;

    public TransportRequestHandler(Channel channel, TransportClient reverseClient, RpcHandler rpcHandler, Long maxChunksBeingTransferred, ChunkFetchRequestHandler chunkFetchRequestHandler) {
        this.channel = channel;
        this.reverseClient = reverseClient;
        this.rpcHandler = rpcHandler;
        this.streamManager = rpcHandler.getStreamManager();
        this.maxChunksBeingTransferred = maxChunksBeingTransferred;
        this.chunkFetchRequestHandler = chunkFetchRequestHandler;
    }

    @Override
    public void exceptionCaught(Throwable cause) {
        this.rpcHandler.exceptionCaught(cause, this.reverseClient);
    }

    @Override
    public void channelActive() {
        this.rpcHandler.channelActive(this.reverseClient);
    }

    @Override
    public void channelInactive() {
        if (this.streamManager != null) {
            try {
                this.streamManager.connectionTerminated(this.channel);
            }
            catch (RuntimeException e) {
                logger.error("StreamManager connectionTerminated() callback failed.", (Throwable)e);
            }
        }
        this.rpcHandler.channelInactive(this.reverseClient);
    }

    @Override
    public void handle(RequestMessage request) throws Exception {
        if (request instanceof ChunkFetchRequest) {
            ChunkFetchRequest chunkFetchRequest = (ChunkFetchRequest)request;
            this.chunkFetchRequestHandler.processFetchRequest(this.channel, chunkFetchRequest);
        } else if (request instanceof RpcRequest) {
            RpcRequest rpcRequest = (RpcRequest)request;
            this.processRpcRequest(rpcRequest);
        } else if (request instanceof OneWayMessage) {
            OneWayMessage oneWayMessage = (OneWayMessage)request;
            this.processOneWayMessage(oneWayMessage);
        } else if (request instanceof StreamRequest) {
            StreamRequest streamRequest = (StreamRequest)request;
            this.processStreamRequest(streamRequest);
        } else if (request instanceof UploadStream) {
            UploadStream uploadStream = (UploadStream)request;
            this.processStreamUpload(uploadStream);
        } else if (request instanceof MergedBlockMetaRequest) {
            MergedBlockMetaRequest mergedBlockMetaRequest = (MergedBlockMetaRequest)request;
            this.processMergedBlockMetaRequest(mergedBlockMetaRequest);
        } else {
            throw new IllegalArgumentException("Unknown request type: " + String.valueOf(request));
        }
    }

    private void processStreamRequest(StreamRequest req) {
        ManagedBuffer buf;
        long chunksBeingTransferred;
        if (logger.isTraceEnabled()) {
            logger.trace("Received req from {} to fetch stream {}", (Object)NettyUtils.getRemoteAddress(this.channel), (Object)req.streamId);
        }
        if (this.maxChunksBeingTransferred < Long.MAX_VALUE && (chunksBeingTransferred = this.streamManager.chunksBeingTransferred()) >= this.maxChunksBeingTransferred) {
            logger.warn("The number of chunks being transferred {} is above {}, close the connection.", new MDC[]{MDC.of((LogKey)LogKeys.NUM_CHUNKS$.MODULE$, (Object)chunksBeingTransferred), MDC.of((LogKey)LogKeys.MAX_NUM_CHUNKS$.MODULE$, (Object)this.maxChunksBeingTransferred)});
            this.channel.close();
            return;
        }
        try {
            buf = this.streamManager.openStream(req.streamId);
        }
        catch (Exception e) {
            logger.error("Error opening stream {} for request from {}", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.STREAM_ID$.MODULE$, (Object)req.streamId), MDC.of((LogKey)LogKeys.HOST_PORT$.MODULE$, (Object)NettyUtils.getRemoteAddress(this.channel))});
            this.respond(new StreamFailure(req.streamId, Throwables.getStackTraceAsString(e)));
            return;
        }
        if (buf != null) {
            this.streamManager.streamBeingSent(req.streamId);
            this.respond(new StreamResponse(req.streamId, buf.size(), buf)).addListener(future -> this.streamManager.streamSent(req.streamId));
        } else {
            this.respond(new StreamFailure(req.streamId, String.format("Stream '%s' was not found.", req.streamId)));
        }
    }

    private void processRpcRequest(final RpcRequest req) {
        try {
            this.rpcHandler.receive(this.reverseClient, req.body().nioByteBuffer(), new RpcResponseCallback(){

                @Override
                public void onSuccess(ByteBuffer response) {
                    TransportRequestHandler.this.respond(new RpcResponse(req.requestId, new NioManagedBuffer(response)));
                }

                @Override
                public void onFailure(Throwable e) {
                    TransportRequestHandler.this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString(e)));
                }
            });
        }
        catch (Exception e) {
            logger.error("Error while invoking RpcHandler#receive() on RPC id {} from {}", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.REQUEST_ID$.MODULE$, (Object)req.requestId), MDC.of((LogKey)LogKeys.HOST_PORT$.MODULE$, (Object)NettyUtils.getRemoteAddress(this.channel))});
            this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString(e)));
        }
        finally {
            req.body().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStreamUpload(final UploadStream req) {
        assert (req.body() == null);
        try {
            final RpcResponseCallback callback = new RpcResponseCallback(){

                @Override
                public void onSuccess(ByteBuffer response) {
                    TransportRequestHandler.this.respond(new RpcResponse(req.requestId, new NioManagedBuffer(response)));
                }

                @Override
                public void onFailure(Throwable e) {
                    TransportRequestHandler.this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString(e)));
                }
            };
            TransportFrameDecoder frameDecoder = (TransportFrameDecoder)this.channel.pipeline().get("frameDecoder");
            ByteBuffer meta = req.meta.nioByteBuffer();
            final StreamCallbackWithID streamHandler = this.rpcHandler.receiveStream(this.reverseClient, meta, callback);
            if (streamHandler == null) {
                throw new NullPointerException("rpcHandler returned a null streamHandler");
            }
            StreamCallbackWithID wrappedCallback = new StreamCallbackWithID(){

                @Override
                public void onData(String streamId, ByteBuffer buf) throws IOException {
                    streamHandler.onData(streamId, buf);
                }

                @Override
                public void onComplete(String streamId) throws IOException {
                    try {
                        streamHandler.onComplete(streamId);
                        callback.onSuccess(streamHandler.getCompletionResponse());
                    }
                    catch (BlockPushNonFatalFailure ex) {
                        callback.onSuccess(ex.getResponse());
                        streamHandler.onFailure(streamId, ex);
                    }
                    catch (Exception ex) {
                        IOException ioExc = new IOException("Failure post-processing complete stream; failing this rpc and leaving channel active", ex);
                        callback.onFailure(ioExc);
                        streamHandler.onFailure(streamId, ioExc);
                    }
                }

                @Override
                public void onFailure(String streamId, Throwable cause) throws IOException {
                    callback.onFailure(new IOException("Destination failed while reading stream", cause));
                    streamHandler.onFailure(streamId, cause);
                }

                @Override
                public String getID() {
                    return streamHandler.getID();
                }
            };
            if (req.bodyByteCount > 0L) {
                StreamInterceptor<RequestMessage> interceptor = new StreamInterceptor<RequestMessage>(this, wrappedCallback.getID(), req.bodyByteCount, wrappedCallback);
                frameDecoder.setInterceptor(interceptor);
            } else {
                wrappedCallback.onComplete(wrappedCallback.getID());
            }
        }
        catch (Exception e) {
            if (e instanceof BlockPushNonFatalFailure) {
                BlockPushNonFatalFailure blockPushNonFatalFailure = (BlockPushNonFatalFailure)e;
                this.respond(new RpcResponse(req.requestId, new NioManagedBuffer(blockPushNonFatalFailure.getResponse())));
            } else {
                logger.error("Error while invoking RpcHandler#receive() on RPC id {} from {}", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.REQUEST_ID$.MODULE$, (Object)req.requestId), MDC.of((LogKey)LogKeys.HOST_PORT$.MODULE$, (Object)NettyUtils.getRemoteAddress(this.channel))});
                this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString(e)));
            }
            this.channel.pipeline().fireExceptionCaught((Throwable)e);
        }
        finally {
            req.meta.release();
        }
    }

    private void processOneWayMessage(OneWayMessage req) {
        try {
            this.rpcHandler.receive(this.reverseClient, req.body().nioByteBuffer());
        }
        catch (Exception e) {
            logger.error("Error while invoking RpcHandler#receive() for one-way message from {}.", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.HOST_PORT$.MODULE$, (Object)NettyUtils.getRemoteAddress(this.channel))});
        }
        finally {
            req.body().release();
        }
    }

    private void processMergedBlockMetaRequest(final MergedBlockMetaRequest req) {
        try {
            this.rpcHandler.getMergedBlockMetaReqHandler().receiveMergeBlockMetaReq(this.reverseClient, req, new MergedBlockMetaResponseCallback(){

                @Override
                public void onSuccess(int numChunks, ManagedBuffer buffer) {
                    logger.trace("Sending meta for request {} numChunks {}", (Object)req, (Object)numChunks);
                    TransportRequestHandler.this.respond(new MergedBlockMetaSuccess(req.requestId, numChunks, buffer));
                }

                @Override
                public void onFailure(Throwable e) {
                    logger.trace("Failed to send meta for {}", (Object)req);
                    TransportRequestHandler.this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString(e)));
                }
            });
        }
        catch (Exception e) {
            logger.error("Error while invoking receiveMergeBlockMetaReq() for appId {} shuffleId {} reduceId {} from {}", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.APP_ID$.MODULE$, (Object)req.appId), MDC.of((LogKey)LogKeys.SHUFFLE_ID$.MODULE$, (Object)req.shuffleId), MDC.of((LogKey)LogKeys.REDUCE_ID$.MODULE$, (Object)req.reduceId), MDC.of((LogKey)LogKeys.HOST_PORT$.MODULE$, (Object)NettyUtils.getRemoteAddress(this.channel))});
            this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString(e)));
        }
    }

    private ChannelFuture respond(Encodable result) {
        SocketAddress remoteAddress = this.channel.remoteAddress();
        return this.channel.writeAndFlush((Object)result).addListener(future -> {
            if (future.isSuccess()) {
                logger.trace("Sent result {} to client {}", (Object)result, (Object)remoteAddress);
            } else {
                logger.error("Error sending result {} to {}; closing connection", future.cause(), new MDC[]{MDC.of((LogKey)LogKeys.RESULT$.MODULE$, (Object)result), MDC.of((LogKey)LogKeys.HOST_PORT$.MODULE$, (Object)remoteAddress)});
                this.channel.close();
            }
        });
    }
}

