/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.network.shuffledb.StoreVersion;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.CompressionType;
import org.rocksdb.Filter;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Logger;
import org.rocksdb.LoggerInterface;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.Status;
import org.rocksdb.TableFormatConfig;
import org.sparkproject.guava.annotations.VisibleForTesting;

public class RocksDBProvider {
    private static final SparkLogger logger;

    public static RocksDB initRockDB(File dbFile, StoreVersion version, ObjectMapper mapper) throws IOException {
        RocksDB tmpDb = null;
        if (dbFile != null) {
            BloomFilter fullFilter = new BloomFilter(10.0, false);
            BlockBasedTableConfig tableFormatConfig = new BlockBasedTableConfig().setFilterPolicy((Filter)fullFilter).setEnableIndexCompression(false).setIndexBlockRestartInterval(8).setFormatVersion(5);
            Options dbOptions = new Options();
            RocksDBLogger rocksDBLogger = new RocksDBLogger(dbOptions);
            dbOptions.setCreateIfMissing(false);
            dbOptions.setBottommostCompressionType(CompressionType.ZSTD_COMPRESSION);
            dbOptions.setCompressionType(CompressionType.LZ4_COMPRESSION);
            dbOptions.setTableFormatConfig((TableFormatConfig)tableFormatConfig);
            dbOptions.setLogger((LoggerInterface)rocksDBLogger);
            try {
                tmpDb = RocksDB.open((Options)dbOptions, (String)dbFile.toString());
            }
            catch (RocksDBException e) {
                if (e.getStatus().getCode() == Status.Code.NotFound) {
                    logger.info("Creating state database at {}", new MDC[]{MDC.of((LogKey)LogKeys.PATH$.MODULE$, (Object)dbFile)});
                    dbOptions.setCreateIfMissing(true);
                    try {
                        tmpDb = RocksDB.open((Options)dbOptions, (String)dbFile.toString());
                    }
                    catch (RocksDBException dbExc) {
                        throw new IOException("Unable to create state store", dbExc);
                    }
                }
                logger.error("error opening rocksdb file {}. Creating new file, will not be able to recover state for existing applications", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.PATH$.MODULE$, (Object)dbFile)});
                if (dbFile.isDirectory()) {
                    for (File f : Objects.requireNonNull(dbFile.listFiles())) {
                        if (f.delete()) continue;
                        logger.warn("error deleting {}", new MDC[]{MDC.of((LogKey)LogKeys.PATH$.MODULE$, (Object)f.getPath())});
                    }
                }
                if (!dbFile.delete()) {
                    logger.warn("error deleting {}", new MDC[]{MDC.of((LogKey)LogKeys.PATH$.MODULE$, (Object)dbFile.getPath())});
                }
                dbOptions.setCreateIfMissing(true);
                try {
                    tmpDb = RocksDB.open((Options)dbOptions, (String)dbFile.toString());
                }
                catch (RocksDBException dbExc) {
                    throw new IOException("Unable to create state store", dbExc);
                }
            }
            try {
                RocksDBProvider.checkVersion(tmpDb, version, mapper);
            }
            catch (RocksDBException e) {
                tmpDb.close();
                throw new IOException(e.getMessage(), e);
            }
            catch (IOException ioe) {
                tmpDb.close();
                throw ioe;
            }
        }
        return tmpDb;
    }

    @VisibleForTesting
    static RocksDB initRocksDB(File file) throws IOException {
        BloomFilter fullFilter = new BloomFilter(10.0, false);
        BlockBasedTableConfig tableFormatConfig = new BlockBasedTableConfig().setFilterPolicy((Filter)fullFilter).setEnableIndexCompression(false).setIndexBlockRestartInterval(8).setFormatVersion(5);
        Options dbOptions = new Options();
        dbOptions.setCreateIfMissing(true);
        dbOptions.setBottommostCompressionType(CompressionType.ZSTD_COMPRESSION);
        dbOptions.setCompressionType(CompressionType.LZ4_COMPRESSION);
        dbOptions.setTableFormatConfig((TableFormatConfig)tableFormatConfig);
        try {
            return RocksDB.open((Options)dbOptions, (String)file.toString());
        }
        catch (RocksDBException e) {
            throw new IOException("Unable to open state store", e);
        }
    }

    public static void checkVersion(RocksDB db, StoreVersion newversion, ObjectMapper mapper) throws IOException, RocksDBException {
        byte[] bytes = db.get(StoreVersion.KEY);
        if (bytes == null) {
            RocksDBProvider.storeVersion(db, newversion, mapper);
        } else {
            StoreVersion version = (StoreVersion)mapper.readValue(bytes, StoreVersion.class);
            if (version.major != newversion.major) {
                throw new IOException("cannot read state DB with version " + String.valueOf(version) + ", incompatible with current version " + String.valueOf(newversion));
            }
            RocksDBProvider.storeVersion(db, newversion, mapper);
        }
    }

    public static void storeVersion(RocksDB db, StoreVersion version, ObjectMapper mapper) throws IOException, RocksDBException {
        db.put(StoreVersion.KEY, mapper.writeValueAsBytes((Object)version));
    }

    static {
        RocksDB.loadLibrary();
        logger = SparkLoggerFactory.getLogger(RocksDBProvider.class);
    }

    private static class RocksDBLogger
    extends Logger {
        private static final SparkLogger LOG = SparkLoggerFactory.getLogger(RocksDBLogger.class);

        RocksDBLogger(Options options) {
            super(options.infoLogLevel());
        }

        protected void log(InfoLogLevel infoLogLevel, String message) {
            if (infoLogLevel == InfoLogLevel.INFO_LEVEL) {
                LOG.info(message);
            }
        }
    }
}

