/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.UnresolvedHaving;
import org.apache.spark.sql.catalyst.analysis.resolver.AutoGeneratedAliasProvider;
import org.apache.spark.sql.catalyst.analysis.resolver.ExplicitlyUnsupportedResolverFeature;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionIdAssigner;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.GroupingAndAggregateExpressionsExtractor;
import org.apache.spark.sql.catalyst.analysis.resolver.NameScopeStack;
import org.apache.spark.sql.catalyst.analysis.resolver.Resolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvesNameByHiddenOutput;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ValidatesFilter;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001B\u0007\u000f\u0001uA\u0001b\u0004\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!)\u0011\t\u0001C\u0001\u0005\"9a\t\u0001b\u0001\n\u00139\u0005BB&\u0001A\u0003%\u0001\nC\u0004M\u0001\t\u0007I\u0011B'\t\rE\u0003\u0001\u0015!\u0003O\u0011\u001d\u0011\u0006A1A\u0005\nMCaa\u0016\u0001!\u0002\u0013!\u0006\"\u0002-\u0001\t\u0003J\u0006\"\u0002/\u0001\t\u0013i\u0006\"B?\u0001\t\u0013q(A\u0004%bm&twMU3t_24XM\u001d\u0006\u0003\u001fA\t\u0001B]3t_24XM\u001d\u0006\u0003#I\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003'Q\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003+Y\t1a]9m\u0015\t9\u0002$A\u0003ta\u0006\u00148N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0006\u0001y!Cg\u000e\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\t\u00152\u0003\u0006L\u0007\u0002\u001d%\u0011qE\u0004\u0002\u0011)J,WMT8eKJ+7o\u001c7wKJ\u0004\"!\u000b\u0016\u000e\u0003AI!a\u000b\t\u0003!Us'/Z:pYZ,G\rS1wS:<\u0007CA\u00173\u001b\u0005q#BA\u00181\u0003\u001dawnZ5dC2T!!\r\n\u0002\u000bAd\u0017M\\:\n\u0005Mr#a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"!J\u001b\n\u0005Yr!A\u0007*fg>dg/Z:OC6,')\u001f%jI\u0012,gnT;uaV$\bCA\u00139\u0013\tIdBA\bWC2LG-\u0019;fg\u001aKG\u000e^3s!\t)3(\u0003\u0002=\u001d\tA!+Z:pYZ,'/\u0001\nfqB\u0014Xm]:j_:\u0014Vm]8mm\u0016\u0014\bCA\u0013@\u0013\t\u0001eB\u0001\nFqB\u0014Xm]:j_:\u0014Vm]8mm\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0002D\t\u0016\u0003\"!\n\u0001\t\u000b=\u0019\u0001\u0019\u0001\u001e\t\u000bu\u001a\u0001\u0019\u0001 \u0002\rM\u001cw\u000e]3t+\u0005A\u0005CA\u0013J\u0013\tQeB\u0001\bOC6,7kY8qKN#\u0018mY6\u0002\u000fM\u001cw\u000e]3tA\u0005!R\r\u001f9sKN\u001c\u0018n\u001c8JI\u0006\u001b8/[4oKJ,\u0012A\u0014\t\u0003K=K!\u0001\u0015\b\u0003)\u0015C\bO]3tg&|g.\u00133BgNLwM\\3s\u0003U)\u0007\u0010\u001d:fgNLwN\\%e\u0003N\u001c\u0018n\u001a8fe\u0002\n!$Y;u_\u001e+g.\u001a:bi\u0016$\u0017\t\\5bgB\u0013xN^5eKJ,\u0012\u0001\u0016\t\u0003KUK!A\u0016\b\u00035\u0005+Ho\\$f]\u0016\u0014\u0018\r^3e\u00032L\u0017m\u001d)s_ZLG-\u001a:\u00027\u0005,Ho\\$f]\u0016\u0014\u0018\r^3e\u00032L\u0017m\u001d)s_ZLG-\u001a:!\u0003\u001d\u0011Xm]8mm\u0016$\"\u0001\f.\t\u000bmS\u0001\u0019\u0001\u0015\u0002!Ut'/Z:pYZ,G\rS1wS:<\u0017A\u00075b]\u0012dW-Q4he\u0016<\u0017\r^3CK2|w\u000fS1wS:<Gc\u00010wwB!qdX1h\u0013\t\u0001\u0007E\u0001\u0004UkBdWM\r\t\u0003E\u0016l\u0011a\u0019\u0006\u0003IJ\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011am\u0019\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007c\u00015qg:\u0011\u0011N\u001c\b\u0003U6l\u0011a\u001b\u0006\u0003Yr\ta\u0001\u0010:p_Rt\u0014\"A\u0011\n\u0005=\u0004\u0013a\u00029bG.\fw-Z\u0005\u0003cJ\u00141aU3r\u0015\ty\u0007\u0005\u0005\u0002ci&\u0011Qo\u0019\u0002\u0010\u001d\u0006lW\rZ#yaJ,7o]5p]\")qo\u0003a\u0001q\u0006I\u0011mZ4sK\u001e\fG/\u001a\t\u0003[eL!A\u001f\u0018\u0003\u0013\u0005;wM]3hCR,\u0007\"\u0002?\f\u0001\u0004\t\u0017!\u0005:fg>dg/\u001a3D_:$\u0017\u000e^5p]\u0006\u0001T\r\u001f;sC\u000e$(+\u001a4fe\u0016t7-\u001a3He>,\b/\u001b8h\u0003:$\u0017iZ4sK\u001e\fG/Z#yaJ,7o]5p]N$BAX@\u0002\u0004!1\u0011\u0011\u0001\u0007A\u0002\u0005\f\u0011bY8oI&$\u0018n\u001c8\t\u000f\u0005\u0015A\u00021\u0001\u0002\b\u0005AsM]8va&tw-\u00118e\u0003\u001e<'/Z4bi\u0016,\u0005\u0010\u001d:fgNLwN\\:FqR\u0014\u0018m\u0019;peB\u0019Q%!\u0003\n\u0007\u0005-aB\u0001\u0015He>,\b/\u001b8h\u0003:$\u0017iZ4sK\u001e\fG/Z#yaJ,7o]5p]N,\u0005\u0010\u001e:bGR|'\u000f")
public class HavingResolver
implements TreeNodeResolver<UnresolvedHaving, LogicalPlan>,
ResolvesNameByHiddenOutput,
ValidatesFilter {
    private final Resolver resolver;
    private final ExpressionResolver expressionResolver;
    private final NameScopeStack scopes;
    private final ExpressionIdAssigner expressionIdAssigner;
    private final AutoGeneratedAliasProvider autoGeneratedAliasProvider;

    @Override
    public void validateFilter(Seq<Expression> invalidExpressions, LogicalPlan unresolvedOperator, Filter resolvedFilter) {
        ValidatesFilter.validateFilter$(this, invalidExpressions, unresolvedOperator, resolvedFilter);
    }

    @Override
    public LogicalPlan insertMissingExpressions(LogicalPlan operator, Seq<NamedExpression> missingExpressions) {
        return ResolvesNameByHiddenOutput.insertMissingExpressions$(this, operator, missingExpressions);
    }

    @Override
    public LogicalPlan retainOriginalOutput(LogicalPlan operator, Seq<NamedExpression> missingExpressions, Seq<Attribute> output, Seq<Attribute> hiddenOutput) {
        return ResolvesNameByHiddenOutput.retainOriginalOutput$(this, operator, missingExpressions, output, hiddenOutput);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private NameScopeStack scopes() {
        return this.scopes;
    }

    private ExpressionIdAssigner expressionIdAssigner() {
        return this.expressionIdAssigner;
    }

    private AutoGeneratedAliasProvider autoGeneratedAliasProvider() {
        return this.autoGeneratedAliasProvider;
    }

    @Override
    public LogicalPlan resolve(UnresolvedHaving unresolvedHaving) {
        LogicalPlan resolvedChildWithMissingAttributes;
        LogicalPlan resolvedChild = this.resolver.resolve(unresolvedHaving.child());
        Filter partiallyResolvedHaving = new Filter(unresolvedHaving.havingCondition(), resolvedChild);
        Expression resolvedCondition = this.expressionResolver.resolveExpressionTreeInOperator(partiallyResolvedHaving.condition(), partiallyResolvedHaving);
        LogicalPlan logicalPlan = resolvedChild;
        if (this.scopes().current().hasLcaInAggregate()) {
            throw new ExplicitlyUnsupportedResolverFeature("Lateral column alias in Aggregate below HAVING");
        }
        if (!(logicalPlan instanceof Aggregate)) {
            throw SparkException$.MODULE$.internalError("Unexpected operator " + logicalPlan.getClass().getSimpleName() + " under HAVING");
        }
        Aggregate aggregate = (Aggregate)logicalPlan;
        Tuple2<Expression, Seq<NamedExpression>> tuple2 = this.handleAggregateBelowHaving(aggregate, resolvedCondition);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression finalCondition = (Expression)tuple2._1();
        Seq missingExpressions = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)finalCondition, (Object)missingExpressions);
        Expression finalCondition2 = (Expression)tuple22._1();
        Seq missingExpressions2 = (Seq)tuple22._2();
        LogicalPlan x$1 = resolvedChildWithMissingAttributes = this.insertMissingExpressions(resolvedChild, (Seq<NamedExpression>)missingExpressions2.toSeq());
        Expression x$2 = finalCondition2;
        Filter resolvedHaving = partiallyResolvedHaving.copy(x$2, x$1);
        this.validateFilter(this.expressionResolver.getLastInvalidExpressionsInTheContextOfOperator(), unresolvedHaving, resolvedHaving);
        return this.retainOriginalOutput(resolvedHaving, (Seq<NamedExpression>)missingExpressions2.toSeq(), this.scopes().current().output(), this.scopes().current().hiddenOutput());
    }

    private Tuple2<Expression, Seq<NamedExpression>> handleAggregateBelowHaving(Aggregate aggregate, Expression resolvedCondition) {
        GroupingAndAggregateExpressionsExtractor groupingAndAggregateExpressionsExtractor = new GroupingAndAggregateExpressionsExtractor(aggregate, this.autoGeneratedAliasProvider());
        Tuple2<Expression, Seq<NamedExpression>> tuple2 = this.extractReferencedGroupingAndAggregateExpressions(resolvedCondition, groupingAndAggregateExpressionsExtractor);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression finalCondition = (Expression)tuple2._1();
        Seq extractedExpressions = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)finalCondition, (Object)extractedExpressions);
        Expression finalCondition2 = (Expression)tuple22._1();
        Seq extractedExpressions2 = (Seq)tuple22._2();
        Seq lowerAliasedAggregateExpressions = (Seq)this.resolver.getSubqueryRegistry().currentScope().getLowerOuterAggregateExpressionAliases().map((Function1 & Serializable)alias -> this.expressionIdAssigner().mapExpression(alias, this.expressionIdAssigner().mapExpression$default$2(), this.expressionIdAssigner().mapExpression$default$3(), this.expressionIdAssigner().mapExpression$default$4()));
        Seq lowerAliasedAggregateExpressionsFiltered = (Seq)lowerAliasedAggregateExpressions.filterNot((Function1 & Serializable)alias -> BoxesRunTime.boxToBoolean((boolean)groupingAndAggregateExpressionsExtractor.exists(alias.child())));
        return new Tuple2((Object)finalCondition2, extractedExpressions2.$plus$plus((IterableOnce)lowerAliasedAggregateExpressionsFiltered));
    }

    private Tuple2<Expression, Seq<NamedExpression>> extractReferencedGroupingAndAggregateExpressions(Expression condition, GroupingAndAggregateExpressionsExtractor groupingAndAggregateExpressionsExtractor) {
        ArrayBuffer referencedGroupingExpressions = new ArrayBuffer();
        ArrayBuffer extractedAggregateExpressionAliases = new ArrayBuffer();
        Expression resolvedCondition = (Expression)condition.transformDown(new Serializable(null, groupingAndAggregateExpressionsExtractor, referencedGroupingExpressions, extractedAggregateExpressionAliases){
            private static final long serialVersionUID = 0L;
            private final GroupingAndAggregateExpressionsExtractor groupingAndAggregateExpressionsExtractor$2;
            private final ArrayBuffer referencedGroupingExpressions$1;
            private final ArrayBuffer extractedAggregateExpressionAliases$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                return (B1)this.groupingAndAggregateExpressionsExtractor$2.extractReferencedGroupingAndAggregateExpressions(A1, (ArrayBuffer<NamedExpression>)this.referencedGroupingExpressions$1, (ArrayBuffer<Alias>)this.extractedAggregateExpressionAliases$1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                return true;
            }
            {
                this.groupingAndAggregateExpressionsExtractor$2 = groupingAndAggregateExpressionsExtractor$2;
                this.referencedGroupingExpressions$1 = referencedGroupingExpressions$1;
                this.extractedAggregateExpressionAliases$1 = extractedAggregateExpressionAliases$1;
            }
        });
        return new Tuple2((Object)resolvedCondition, extractedAggregateExpressionAliases.toSeq().$plus$plus((IterableOnce)referencedGroupingExpressions.toSeq()));
    }

    public HavingResolver(Resolver resolver, ExpressionResolver expressionResolver) {
        this.resolver = resolver;
        this.expressionResolver = expressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        ResolvesNameByHiddenOutput.$init$(this);
        ValidatesFilter.$init$(this);
        this.scopes = resolver.getNameScopes();
        this.expressionIdAssigner = expressionResolver.getExpressionIdAssigner();
        this.autoGeneratedAliasProvider = new AutoGeneratedAliasProvider(this.expressionIdAssigner());
    }
}

