/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayBinaryLike;
import org.apache.spark.sql.catalyst.expressions.ArrayExcept$;
import org.apache.spark.sql.catalyst.expressions.ArraySetLike;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.util.SQLOpenHashSet;
import org.apache.spark.sql.util.SQLOpenHashSet$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="\n  _FUNC_(array1, array2) - Returns an array of the elements in array1 but not in array2,\n    without duplicates.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(1, 3, 5));\n       [2]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001\u0002\u0010 \u00012B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011!1\u0006\u0001#b\u0001\n\u00139\u0006\"\u00020\u0001\t\u0003:\u0006\u0002C0\u0001\u0011\u000b\u0007I\u0011\u00011\t\u000b9\u0004A\u0011I8\t\u000b]\u0004A\u0011\t=\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u0011\u0011\u0005\u0001\u0005R\u0005\r\u0002\"CA\u0017\u0001\u0005\u0005I\u0011AA\u0018\u0011%\t)\u0004AI\u0001\n\u0003\t9\u0004C\u0005\u0002N\u0001\t\n\u0011\"\u0001\u00028!I\u0011q\n\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u000b\u0005\n\u0003C\u0002\u0011\u0011!C\u0001\u0003GB\u0011\"a\u001b\u0001\u0003\u0003%\t!!\u001c\t\u0013\u0005M\u0004!!A\u0005B\u0005U\u0004\"CAB\u0001\u0005\u0005I\u0011AAC\u0011%\ty\tAA\u0001\n\u0003\n\t\nC\u0005\u0002\u0016\u0002\t\t\u0011\"\u0011\u0002\u0018\u001eI\u00111X\u0010\u0002\u0002#\u0005\u0011Q\u0018\u0004\t=}\t\t\u0011#\u0001\u0002@\"1\u0011\u000b\u0007C\u0001\u0003/D\u0011\"!7\u0019\u0003\u0003%)%a7\t\u0013\u0005u\u0007$!A\u0005\u0002\u0006}\u0007\"CAs1\u0005\u0005I\u0011QAt\u0011%\tI\u0010GA\u0001\n\u0013\tYPA\u0006BeJ\f\u00170\u0012=dKB$(B\u0001\u0011\"\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\t\u001a\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0011*\u0013aA:rY*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001i\u0013\u0007N\u001c>!\tqs&D\u0001 \u0013\t\u0001tD\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011aFM\u0005\u0003g}\u0011q\"\u0011:sCf\u0014\u0015N\\1ss2K7.\u001a\t\u0003]UJ!AN\u0010\u00039\r{W\u000e\u001d7fqRK\b/Z'fe\u001eLgnZ#yaJ,7o]5p]B\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t9\u0001K]8ek\u000e$\bC\u0001 G\u001d\tyDI\u0004\u0002A\u00076\t\u0011I\u0003\u0002CW\u00051AH]8pizJ\u0011AO\u0005\u0003\u000bf\nq\u0001]1dW\u0006<W-\u0003\u0002H\u0011\na1+\u001a:jC2L'0\u00192mK*\u0011Q)O\u0001\u0005Y\u00164G/F\u0001L!\tqC*\u0003\u0002N?\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u00191\u000bV+\u0011\u00059\u0002\u0001\"B%\u0006\u0001\u0004Y\u0005\"B(\u0006\u0001\u0004Y\u0015\u0001E5oi\u0016\u0014h.\u00197ECR\fG+\u001f9f+\u0005A\u0006CA-]\u001b\u0005Q&BA.$\u0003\u0015!\u0018\u0010]3t\u0013\ti&L\u0001\u0005ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,\u0017AC3wC2,\u0005pY3qiV\t\u0011\rE\u00039E\u0012$G-\u0003\u0002ds\tIa)\u001e8di&|gN\r\t\u0003K\"l\u0011A\u001a\u0006\u0003O\u0006\nA!\u001e;jY&\u0011\u0011N\u001a\u0002\n\u0003J\u0014\u0018-\u001f#bi\u0006D#\u0001C6\u0011\u0005ab\u0017BA7:\u0005%!(/\u00198tS\u0016tG/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002qgV\u0004\"\u0001O9\n\u0005IL$aA!os\")A/\u0003a\u0001a\u00061\u0011N\u001c9viFBQA^\u0005A\u0002A\fa!\u001b8qkR\u0014\u0014!\u00033p\u000f\u0016t7i\u001c3f)\u0011Ix0!\u0003\u0011\u0005ilX\"A>\u000b\u0005q|\u0012aB2pI\u0016<WM\\\u0005\u0003}n\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u0003Q\u0001\u0019AA\u0002\u0003\r\u0019G\u000f\u001f\t\u0004u\u0006\u0015\u0011bAA\u0004w\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bBBA\u0006\u0015\u0001\u0007\u00110\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005E\u0001\u0003BA\n\u00037qA!!\u0006\u0002\u0018A\u0011\u0001)O\u0005\u0004\u00033I\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001e\u0005}!AB*ue&twMC\u0002\u0002\u001ae\nqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000bM\u000b)#!\u000b\t\r\u0005\u001dB\u00021\u0001L\u0003\u001dqWm\u001e'fMRDa!a\u000b\r\u0001\u0004Y\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0006'\u0006E\u00121\u0007\u0005\b\u00136\u0001\n\u00111\u0001L\u0011\u001dyU\u0002%AA\u0002-\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002:)\u001a1*a\u000f,\u0005\u0005u\u0002\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0012:\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\n\tEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003'\u0002B!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&\u0001\u0003mC:<'BAA/\u0003\u0011Q\u0017M^1\n\t\u0005u\u0011qK\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003K\u00022\u0001OA4\u0013\r\tI'\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004a\u0006=\u0004\"CA9%\u0005\u0005\t\u0019AA3\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u000f\t\u0006\u0003s\ny\b]\u0007\u0003\u0003wR1!! :\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0003\u000bYH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAD\u0003\u001b\u00032\u0001OAE\u0013\r\tY)\u000f\u0002\b\u0005>|G.Z1o\u0011!\t\t\bFA\u0001\u0002\u0004\u0001\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0015\u0002\u0014\"I\u0011\u0011O\u000b\u0002\u0002\u0003\u0007\u0011QM\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u001d\u0015\u0011\u0014\u0005\t\u0003c2\u0012\u0011!a\u0001a\"\u001a\u0002!!(\u0002$\u0006\u0015\u0016\u0011VAV\u0003_\u000b\t,!.\u00028B\u0019a&a(\n\u0007\u0005\u0005vDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u001d\u0016\u0001\u001e\u0006!A}3UKT\"`Q\u0005\u0014(/Y=2Y\u0001\n'O]1ze%\u0002S\u0006\t*fiV\u0014hn\u001d\u0011b]\u0002\n'O]1zA=4\u0007\u0005\u001e5fA\u0015dW-\\3oiN\u0004\u0013N\u001c\u0011beJ\f\u00170\r\u0011ckR\u0004cn\u001c;!S:\u0004\u0013M\u001d:bsJb#\u0002\t\u0011!A]LG\u000f[8vi\u0002\"W\u000f\u001d7jG\u0006$Xm\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003[\u000b1K\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0019-AIb\u0003eM\u0015-A\u0005\u0014(/Y=)c1\u00023\u0007\f\u00116S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u001a^\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAZ\u0003-\t'O]1z?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005e\u0016!\u0002\u001a/i9\u0002\u0014aC!se\u0006LX\t_2faR\u0004\"A\f\r\u0014\u000ba\t\t-!4\u0011\u000f\u0005\r\u0017\u0011Z&L'6\u0011\u0011Q\u0019\u0006\u0004\u0003\u000fL\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u0017\f)MA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\fY&\u0001\u0002j_&\u0019q)!5\u0015\u0005\u0005u\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0013!B1qa2LH#B*\u0002b\u0006\r\b\"B%\u001c\u0001\u0004Y\u0005\"B(\u001c\u0001\u0004Y\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003S\f)\u0010E\u00039\u0003W\fy/C\u0002\u0002nf\u0012aa\u00149uS>t\u0007#\u0002\u001d\u0002r.[\u0015bAAzs\t1A+\u001e9mKJB\u0001\"a>\u001d\u0003\u0003\u0005\raU\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA\u007f!\u0011\t)&a@\n\t\t\u0005\u0011q\u000b\u0002\u0007\u001f\nTWm\u0019;")
public class ArrayExcept
extends BinaryExpression
implements ArrayBinaryLike,
ComplexTypeMergingExpression,
Serializable {
    private DataType internalDataType;
    private transient Function2<ArrayData, ArrayData, ArrayData> evalExcept;
    private final Expression left;
    private final Expression right;
    private transient scala.collection.immutable.Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private transient boolean canUseSpecializedHashSet;
    private transient Ordering<Object> ordering;
    private Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$69;
    private transient String hsPostFix;
    private transient String hsTypeName;
    private transient String hsValueCast;
    private transient String nullValueHolder;
    private transient DataType elementType;
    private volatile byte bitmap$0;
    private volatile transient int bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayExcept x$0) {
        return ArrayExcept$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayExcept> tupled() {
        return ArrayExcept$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayExcept>> curried() {
        return ArrayExcept$.MODULE$.curried();
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$ArrayBinaryLike$$super$checkInputDataTypes() {
        return BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullIntolerant() {
        return ArrayBinaryLike.nullIntolerant$(this);
    }

    @Override
    public DataType dt() {
        return ArrayBinaryLike.dt$(this);
    }

    @Override
    public DataType et() {
        return ArrayBinaryLike.et$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ArrayBinaryLike.checkInputDataTypes$(this);
    }

    @Override
    public boolean resultArrayElementNullable() {
        return ArraySetLike.resultArrayElementNullable$(this);
    }

    @Override
    public String genGetValue(String array, String i) {
        return ArraySetLike.genGetValue$(this, array, i);
    }

    @Override
    public String withResultArrayNullCheck(String body, String value, String nullElementIndex) {
        return ArraySetLike.withResultArrayNullCheck$(this, body, value, nullElementIndex);
    }

    @Override
    public String buildResultArray(String builder, String value, String size, String nullElementIndex, String functionName) {
        return ArraySetLike.buildResultArray$(this, builder, value, size, nullElementIndex, functionName);
    }

    @Override
    public scala.collection.immutable.Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    @Override
    public boolean leftArrayElementNullable() {
        return BinaryArrayExpressionWithImplicitCast.leftArrayElementNullable$(this);
    }

    @Override
    public boolean rightArrayElementNullable() {
        return BinaryArrayExpressionWithImplicitCast.rightArrayElementNullable$(this);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(scala.collection.immutable.Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    private scala.collection.immutable.Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayExcept arrayExcept = this;
        synchronized (arrayExcept) {
            if ((this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 |= 2;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public scala.collection.immutable.Seq<DataType> inputTypesForMerging() {
        if ((this.bitmap$trans$0 & 2) == 0) {
            return this.inputTypesForMerging$lzycompute();
        }
        return this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        ArrayExcept arrayExcept = this;
        synchronized (arrayExcept) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    private boolean canUseSpecializedHashSet$lzycompute() {
        ArrayExcept arrayExcept = this;
        synchronized (arrayExcept) {
            if ((this.bitmap$trans$0 & 4) == 0) {
                this.canUseSpecializedHashSet = ArraySetLike.canUseSpecializedHashSet$(this);
                this.bitmap$trans$0 |= 4;
            }
        }
        return this.canUseSpecializedHashSet;
    }

    @Override
    public boolean canUseSpecializedHashSet() {
        if ((this.bitmap$trans$0 & 4) == 0) {
            return this.canUseSpecializedHashSet$lzycompute();
        }
        return this.canUseSpecializedHashSet;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayExcept arrayExcept = this;
        synchronized (arrayExcept) {
            if ((this.bitmap$trans$0 & 8) == 0) {
                this.ordering = ArraySetLike.ordering$(this);
                this.bitmap$trans$0 |= 8;
            }
        }
        return this.ordering;
    }

    @Override
    public Ordering<Object> ordering() {
        if ((this.bitmap$trans$0 & 8) == 0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    private Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$69$lzycompute() {
        ArrayExcept arrayExcept = this;
        synchronized (arrayExcept) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$69 = ArraySetLike.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$69$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$69;
    }

    @Override
    public /* synthetic */ Tuple2 org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$69() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$69$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$69;
    }

    private String hsPostFix$lzycompute() {
        ArrayExcept arrayExcept = this;
        synchronized (arrayExcept) {
            if ((this.bitmap$trans$0 & 0x10) == 0) {
                this.hsPostFix = ArraySetLike.hsPostFix$(this);
                this.bitmap$trans$0 |= 0x10;
            }
        }
        return this.hsPostFix;
    }

    @Override
    public String hsPostFix() {
        if ((this.bitmap$trans$0 & 0x10) == 0) {
            return this.hsPostFix$lzycompute();
        }
        return this.hsPostFix;
    }

    private String hsTypeName$lzycompute() {
        ArrayExcept arrayExcept = this;
        synchronized (arrayExcept) {
            if ((this.bitmap$trans$0 & 0x20) == 0) {
                this.hsTypeName = ArraySetLike.hsTypeName$(this);
                this.bitmap$trans$0 |= 0x20;
            }
        }
        return this.hsTypeName;
    }

    @Override
    public String hsTypeName() {
        if ((this.bitmap$trans$0 & 0x20) == 0) {
            return this.hsTypeName$lzycompute();
        }
        return this.hsTypeName;
    }

    private String hsValueCast$lzycompute() {
        ArrayExcept arrayExcept = this;
        synchronized (arrayExcept) {
            if ((this.bitmap$trans$0 & 0x40) == 0) {
                this.hsValueCast = ArraySetLike.hsValueCast$(this);
                this.bitmap$trans$0 |= 0x40;
            }
        }
        return this.hsValueCast;
    }

    @Override
    public String hsValueCast() {
        if ((this.bitmap$trans$0 & 0x40) == 0) {
            return this.hsValueCast$lzycompute();
        }
        return this.hsValueCast;
    }

    private String nullValueHolder$lzycompute() {
        ArrayExcept arrayExcept = this;
        synchronized (arrayExcept) {
            if ((this.bitmap$trans$0 & 0x80) == 0) {
                this.nullValueHolder = ArraySetLike.nullValueHolder$(this);
                this.bitmap$trans$0 |= 0x80;
            }
        }
        return this.nullValueHolder;
    }

    @Override
    public String nullValueHolder() {
        if ((this.bitmap$trans$0 & 0x80) == 0) {
            return this.nullValueHolder$lzycompute();
        }
        return this.nullValueHolder;
    }

    private DataType elementType$lzycompute() {
        ArrayExcept arrayExcept = this;
        synchronized (arrayExcept) {
            if ((this.bitmap$trans$0 & 0x100) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 |= 0x100;
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        if ((this.bitmap$trans$0 & 0x100) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private DataType internalDataType$lzycompute() {
        ArrayExcept arrayExcept = this;
        synchronized (arrayExcept) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dataTypeCheck();
                this.internalDataType = this.left().dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.internalDataType;
    }

    private DataType internalDataType() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.internalDataType$lzycompute();
        }
        return this.internalDataType;
    }

    @Override
    public DataType dataType() {
        return this.internalDataType();
    }

    private Function2<ArrayData, ArrayData, ArrayData> evalExcept$lzycompute() {
        ArrayExcept arrayExcept = this;
        synchronized (arrayExcept) {
            if ((this.bitmap$trans$0 & 1) == 0) {
                this.evalExcept = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable)(array1, array2) -> {
                    int i;
                    SQLOpenHashSet<Object> hs = new SQLOpenHashSet<Object>(ClassTag$.MODULE$.Any());
                    ArrayBuffer arrayBuffer = new ArrayBuffer();
                    Function1<Object, BoxedUnit> withArray2NaNCheckFunc = SQLOpenHashSet$.MODULE$.withNaNCheckFunc(this.elementType(), hs, (Function1<Object, BoxedUnit>)(Function1 & Serializable)value -> {
                        hs.add(value);
                        return BoxedUnit.UNIT;
                    }, (Function1<Object, BoxedUnit>)(Function1 & Serializable)valueNaN -> {
                        ArrayExcept.$anonfun$evalExcept$3(valueNaN);
                        return BoxedUnit.UNIT;
                    });
                    Function2<ArrayData, Object, BoxedUnit> withArray2NullCheckFunc = SQLOpenHashSet$.MODULE$.withNullCheckFunc(this.elementType(), hs, (Function1<Object, BoxedUnit>)(Function1 & Serializable)value -> {
                        withArray2NaNCheckFunc.apply(value);
                        return BoxedUnit.UNIT;
                    }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {});
                    Function1<Object, BoxedUnit> withArray1NaNCheckFunc = SQLOpenHashSet$.MODULE$.withNaNCheckFunc(this.elementType(), hs, (Function1<Object, BoxedUnit>)(Function1 & Serializable)value -> {
                        ArrayExcept.$anonfun$evalExcept$6(hs, arrayBuffer, value);
                        return BoxedUnit.UNIT;
                    }, (Function1<Object, BoxedUnit>)(Function1 & Serializable)valueNaN -> {
                        arrayBuffer.$plus$eq(valueNaN);
                        return BoxedUnit.UNIT;
                    });
                    Function2<ArrayData, Object, BoxedUnit> withArray1NullCheckFunc = SQLOpenHashSet$.MODULE$.withNullCheckFunc(this.elementType(), hs, (Function1<Object, BoxedUnit>)(Function1 & Serializable)value -> {
                        withArray1NaNCheckFunc.apply(value);
                        return BoxedUnit.UNIT;
                    }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> arrayBuffer.$plus$eq(null));
                    for (i = 0; i < array2.numElements(); ++i) {
                        withArray2NullCheckFunc.apply(array2, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                    for (i = 0; i < array1.numElements(); ++i) {
                        withArray1NullCheckFunc.apply(array1, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                    return new GenericArrayData((Seq<Object>)arrayBuffer);
                } : (Function2 & Serializable)(array1, array2) -> {
                    ArrayBuffer arrayBuffer = new ArrayBuffer();
                    boolean scannedNullElements = false;
                    for (int i = 0; i < array1.numElements(); ++i) {
                        boolean found = false;
                        Object elem1 = array1.get(i, this.elementType());
                        if (elem1 == null) {
                            if (!scannedNullElements) {
                                for (int j = 0; !found && j < array2.numElements(); ++j) {
                                    found = array2.isNullAt(j);
                                }
                                scannedNullElements = true;
                            } else {
                                found = true;
                            }
                        } else {
                            for (int j = 0; !found && j < array2.numElements(); ++j) {
                                Object elem2 = array2.get(j, this.elementType());
                                if (elem2 == null) continue;
                                found = this.ordering().equiv(elem1, elem2);
                            }
                            if (!found) {
                                for (int k = 0; !found && k < arrayBuffer.size(); ++k) {
                                    Object va = arrayBuffer.apply(k);
                                    found = va != null && this.ordering().equiv(va, elem1);
                                }
                            }
                        }
                        Object object = !found ? arrayBuffer.$plus$eq(elem1) : BoxedUnit.UNIT;
                    }
                    return new GenericArrayData((Seq<Object>)arrayBuffer);
                };
                this.bitmap$trans$0 |= 1;
            }
        }
        return this.evalExcept;
    }

    public Function2<ArrayData, ArrayData, ArrayData> evalExcept() {
        if ((this.bitmap$trans$0 & 1) == 0) {
            return this.evalExcept$lzycompute();
        }
        return this.evalExcept;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        ArrayData array1 = (ArrayData)input1;
        ArrayData array2 = (ArrayData)input2;
        return this.evalExcept().apply((Object)array1, (Object)array2);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String i = ctx.freshName("i");
        String value = ctx.freshName("value");
        String size = ctx.freshName("size");
        if (this.canUseSpecializedHashSet()) {
            String jt = CodeGenerator$.MODULE$.javaType(this.elementType());
            String ptName = CodeGenerator$.MODULE$.primitiveTypeName(jt);
            return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(array1, array2) -> {
                String nullElementIndex = ctx.freshName("nullElementIndex");
                String builder = ctx.freshName("builder");
                String openHashSet = SQLOpenHashSet.class.getName();
                String classTag = "scala.reflect.ClassTag$.MODULE$." + this.hsTypeName() + "()";
                String hashSet = ctx.freshName("hashSet");
                String arrayBuilder = ArrayBuilder.class.getName();
                String arrayBuilderClass = arrayBuilder + "$of" + ptName;
                Function2 & Serializable withArray2NaNCheckCodeGenerator = (Function2 & Serializable)(array, index) -> jt + " " + value + " = " + this.genGetValue((String)array, i) + ";" + SQLOpenHashSet$.MODULE$.withNaNCheckCode(this.elementType(), value, hashSet, hashSet + ".add" + this.hsPostFix() + "(" + this.hsValueCast() + value + ");", (Function1<String, String>)(Function1 & Serializable)valueNaN -> "");
                String writeArray2ToHashSet = SQLOpenHashSet$.MODULE$.withNullCheckCode(this.rightArrayElementNullable(), this.leftArrayElementNullable(), (String)array2, i, hashSet, (Function2<String, String, String>)withArray2NaNCheckCodeGenerator, "");
                String body = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |if (!" + hashSet + ".contains(" + this.hsValueCast() + value + ")) {\n             |  if (++" + size + " > " + 0x7FFFFFF0 + ") {\n             |    break;\n             |  }\n             |  " + hashSet + ".add" + this.hsPostFix() + "(" + this.hsValueCast() + value + ");\n             |  " + builder + ".$plus$eq(" + value + ");\n             |}\n           "));
                Function2 & Serializable withArray1NaNCheckCodeGenerator = (Function2 & Serializable)(array, index) -> jt + " " + value + " = " + this.genGetValue((String)array, (String)index) + ";" + SQLOpenHashSet$.MODULE$.withNaNCheckCode(this.elementType(), value, hashSet, body, (Function1<String, String>)(Function1 & Serializable)valueNaN -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                     |" + size + "++;\n                     |" + builder + ".$plus$eq(" + valueNaN + ");\n                 ")));
                String processArray1 = SQLOpenHashSet$.MODULE$.withNullCheckCode(this.leftArrayElementNullable(), this.leftArrayElementNullable(), (String)array1, i, hashSet, (Function2<String, String, String>)withArray1NaNCheckCodeGenerator, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |" + nullElementIndex + " = " + size + ";\n             |" + size + "++;\n             |" + builder + ".$plus$eq(" + this.nullValueHolder() + ");\n           ")));
                String declareNullTrackVariables = this.leftArrayElementNullable() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |int " + nullElementIndex + " = -1;\n           ")) : "";
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |" + openHashSet + " " + hashSet + " = new " + openHashSet + this.hsPostFix() + "(" + classTag + ");\n           |" + declareNullTrackVariables + "\n           |for (int " + i + " = 0; " + i + " < " + array2 + ".numElements(); " + i + "++) {\n           |  " + writeArray2ToHashSet + "\n           |}\n           |" + arrayBuilderClass + " " + builder + " = new " + arrayBuilderClass + "();\n           |int " + size + " = 0;\n           |for (int " + i + " = 0; " + i + " < " + array1 + ".numElements(); " + i + "++) {\n           |  " + processArray1 + "\n           |}\n           |" + this.buildResultArray(builder, ExprValue$.MODULE$.exprValueToString(ev.value()), size, nullElementIndex, this.prettyName()) + "\n         "));
            });
        }
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(array1, array2) -> {
            String expr = ctx.addReferenceObj("arrayExceptExpr", this, ctx.addReferenceObj$default$3());
            return ev.value() + " = (ArrayData)" + expr + ".nullSafeEval(" + array1 + ", " + array2 + ");";
        });
    }

    @Override
    public String prettyName() {
        return "array_except";
    }

    @Override
    public ArrayExcept withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayExcept copy(Expression left, Expression right) {
        return new ArrayExcept(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayExcept";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayExcept;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayExcept)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayExcept arrayExcept = (ArrayExcept)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayExcept.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayExcept.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayExcept.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$evalExcept$3(Object valueNaN) {
    }

    public static final /* synthetic */ void $anonfun$evalExcept$6(SQLOpenHashSet hs$4, ArrayBuffer arrayBuffer$6, Object value) {
        if (!hs$4.contains(value)) {
            arrayBuffer$6.$plus$eq(value);
            hs$4.add(value);
            return;
        }
    }

    public ArrayExcept(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
        ArraySetLike.$init$(this);
        ArrayBinaryLike.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
    }
}

