/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.optimizer.Cost;
import org.apache.spark.sql.catalyst.optimizer.JoinGraphInfo;
import org.apache.spark.sql.catalyst.optimizer.JoinReorderDP;
import org.apache.spark.sql.catalyst.optimizer.JoinReorderDPFilters$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.internal.SQLConf;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class JoinReorderDP$
implements PredicateHelper {
    public static final JoinReorderDP$ MODULE$ = new JoinReorderDP$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        AliasHelper.$init$(MODULE$);
        Logging.$init$((Logging)MODULE$);
        PredicateHelper.$init$(MODULE$);
    }

    @Override
    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$(this, condition);
    }

    @Override
    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan2) {
        return PredicateHelper.findExpressionAndTrackLineageDown$(this, exp, plan2);
    }

    @Override
    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$(this, condition);
    }

    @Override
    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$(this, expressions, op);
    }

    @Override
    public boolean canEvaluate(Expression expr, LogicalPlan plan2) {
        return PredicateHelper.canEvaluate$(this, expr, plan2);
    }

    @Override
    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$(this, expr);
    }

    @Override
    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$(this, condition, outputSet);
    }

    @Override
    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$(this, expr);
    }

    @Override
    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$(this, output, nonNullAttrExprIds);
    }

    @Override
    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$(this, e);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Project plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Aggregate plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    @Override
    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$(this, expr, aliasMap);
    }

    @Override
    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$(this, expr, aliasMap);
    }

    @Override
    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$(this, e);
    }

    @Override
    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$(this, e);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public LogicalPlan search(SQLConf conf, Seq<LogicalPlan> items, ExpressionSet conditions, Seq<Attribute> output) {
        long startTime = System.nanoTime();
        Seq itemIndex = (Seq)items.zipWithIndex();
        LinkedHashMap[] linkedHashMapArray = new LinkedHashMap[1];
        LinkedHashMap joinPlanMap = new LinkedHashMap();
        itemIndex.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LogicalPlan item = (LogicalPlan)tuple2._1();
                int id = tuple2._2$mcI$sp();
                return joinPlanMap.put(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id})), (Object)new JoinReorderDP.JoinPlan((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id}))), item, ExpressionSet$.MODULE$.apply(), new Cost(BigInt$.MODULE$.int2bigInt(0), BigInt$.MODULE$.int2bigInt(0))));
            }
            throw new MatchError((Object)tuple2);
        });
        linkedHashMapArray[0] = joinPlanMap;
        Buffer foundPlans = (Buffer)Buffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])linkedHashMapArray));
        Option<JoinGraphInfo> filters = JoinReorderDPFilters$.MODULE$.buildJoinGraphInfo(conf, items, conditions, (Seq<Tuple2<LogicalPlan, Object>>)itemIndex);
        AttributeSet topOutputSet = AttributeSet$.MODULE$.apply((Iterable<Expression>)output);
        while (foundPlans.size() < items.length()) {
            foundPlans.$plus$eq(this.searchLevel((Seq<LinkedHashMap<Set<Object>, JoinReorderDP.JoinPlan>>)foundPlans.toSeq(), conf, conditions, topOutputSet, filters));
        }
        long durationInMs = (System.nanoTime() - startTime) / 1000000L;
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Join reordering finished. Duration: " + durationInMs + " ms, number of items: " + items.length() + ", number of plans in memo: " + ((IterableOnceOps)foundPlans.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Predef$.MODULE$.assert(foundPlans.size() == items.length() && ((LinkedHashMap)foundPlans.last()).size() == 1);
        LogicalPlan logicalPlan = ((JoinReorderDP.JoinPlan)((LinkedHashMap)foundPlans.last()).head()._2()).plan();
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            Seq<NamedExpression> projectList = project.projectList();
            LogicalPlan j = project.child();
            if (j instanceof Join) {
                Seq<NamedExpression> seq = projectList;
                Seq<Attribute> seq2 = output;
                if (seq == null ? seq2 != null : !seq.equals(seq2)) {
                    AttributeSet attributeSet = topOutputSet;
                    AttributeSet attributeSet2 = project.outputSet();
                    Predef$.MODULE$.assert(!(attributeSet != null ? !((Object)attributeSet).equals(attributeSet2) : attributeSet2 != null));
                    return project.copy(output, project.copy$default$2());
                }
            }
        }
        if (!this.sameOutput(logicalPlan, output)) {
            return new Project(output, logicalPlan);
        }
        return logicalPlan;
    }

    private boolean sameOutput(LogicalPlan plan2, Seq<Attribute> expectedOutput) {
        Seq<Attribute> thisOutput = plan2.output();
        return thisOutput.length() == expectedOutput.length() && ((IterableOnceOps)thisOutput.zip(expectedOutput)).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)JoinReorderDP$.$anonfun$sameOutput$1(x0$1)));
    }

    private LinkedHashMap<Set<Object>, JoinReorderDP.JoinPlan> searchLevel(Seq<LinkedHashMap<Set<Object>, JoinReorderDP.JoinPlan>> existingLevels, SQLConf conf, ExpressionSet conditions, AttributeSet topOutput, Option<JoinGraphInfo> filters) {
        LinkedHashMap nextLevel = new LinkedHashMap();
        IntRef k = IntRef.create((int)0);
        int lev = existingLevels.length() - 1;
        while (k.elem <= lev - k.elem) {
            Seq oneSideCandidates = ((MapOps)existingLevels.apply(k.elem)).values().toSeq();
            oneSideCandidates.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                JoinReorderDP.JoinPlan oneSidePlan = (JoinReorderDP.JoinPlan)oneSideCandidates.apply(i);
                Seq otherSideCandidates = k$1.elem == lev - k$1.elem ? (Seq)oneSideCandidates.drop(i) : ((MapOps)existingLevels.apply(lev - k$1.elem)).values().toSeq();
                otherSideCandidates.foreach((Function1 & Serializable)otherSidePlan -> {
                    JoinReorderDP$.$anonfun$searchLevel$2(oneSidePlan, conf, conditions, topOutput, filters, nextLevel, otherSidePlan);
                    return BoxedUnit.UNIT;
                });
            });
            ++k.elem;
        }
        return nextLevel;
    }

    private Option<JoinReorderDP.JoinPlan> buildJoin(JoinReorderDP.JoinPlan oneJoinPlan, JoinReorderDP.JoinPlan otherJoinPlan, SQLConf conf, ExpressionSet conditions, AttributeSet topOutput, Option<JoinGraphInfo> filters) {
        Tuple2 tuple2;
        boolean isValidJoinCombination;
        if (oneJoinPlan.itemIds().intersect(otherJoinPlan.itemIds()).nonEmpty()) {
            return None$.MODULE$;
        }
        if (filters.isDefined() && !(isValidJoinCombination = JoinReorderDPFilters$.MODULE$.starJoinFilter(oneJoinPlan.itemIds(), otherJoinPlan.itemIds(), (JoinGraphInfo)filters.get()))) {
            return None$.MODULE$;
        }
        LogicalPlan onePlan = oneJoinPlan.plan();
        LogicalPlan otherPlan = otherJoinPlan.plan();
        Object joinConds = ((ExpressionSet)((ExpressionSet)conditions.filterNot((Function1 & Serializable)l -> BoxesRunTime.boxToBoolean((boolean)JoinReorderDP$.MODULE$.canEvaluate(l, onePlan)))).filterNot((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)JoinReorderDP$.MODULE$.canEvaluate(r, otherPlan)))).filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)JoinReorderDP$.$anonfun$buildJoin$3(onePlan, otherPlan, e)));
        if (((ExpressionSet)joinConds).isEmpty()) {
            return None$.MODULE$;
        }
        Tuple2 tuple22 = tuple2 = oneJoinPlan.itemIds().size() >= otherJoinPlan.itemIds().size() ? new Tuple2((Object)onePlan, (Object)otherPlan) : new Tuple2((Object)otherPlan, (Object)onePlan);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LogicalPlan left = (LogicalPlan)tuple2._1();
        LogicalPlan right = (LogicalPlan)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)left, (Object)right);
        LogicalPlan left2 = (LogicalPlan)tuple23._1();
        LogicalPlan right2 = (LogicalPlan)tuple23._2();
        Join newJoin = new Join(left2, right2, Inner$.MODULE$, ((ExpressionSet)joinConds).reduceOption(And$.MODULE$), JoinHint$.MODULE$.NONE());
        ExpressionSet collectedJoinConds = (ExpressionSet)((ExpressionSet)joinConds).$plus$plus((IterableOnce)oneJoinPlan.joinConds()).$plus$plus((IterableOnce)otherJoinPlan.joinConds());
        ExpressionSet remainingConds = conditions.$minus$minus((IterableOnce<Expression>)collectedJoinConds);
        AttributeSet neededAttr = AttributeSet$.MODULE$.apply((Iterable<Expression>)remainingConds.flatMap((Function1 & Serializable)x$10 -> x$10.references())).$plus$plus(topOutput);
        Seq neededFromNewJoin = (Seq)newJoin.output().filter((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)neededAttr.contains(elem)));
        LogicalPlan newPlan = newJoin.outputSet().$minus$minus((Iterable<NamedExpression>)neededFromNewJoin).nonEmpty() ? new Project((Seq<NamedExpression>)neededFromNewJoin, newJoin) : newJoin;
        Set itemIds = (Set)oneJoinPlan.itemIds().union(otherJoinPlan.itemIds());
        Cost newPlanCost = oneJoinPlan.planCost().$plus(oneJoinPlan.rootCost(conf)).$plus(otherJoinPlan.planCost()).$plus(otherJoinPlan.rootCost(conf));
        return new Some((Object)new JoinReorderDP.JoinPlan((Set<Object>)itemIds, newPlan, collectedJoinConds, newPlanCost));
    }

    public static final /* synthetic */ boolean $anonfun$sameOutput$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Attribute a1 = (Attribute)tuple2._1();
            Attribute a2 = (Attribute)tuple2._2();
            return a1.semanticEquals(a2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$searchLevel$2(JoinReorderDP.JoinPlan oneSidePlan$1, SQLConf conf$1, ExpressionSet conditions$1, AttributeSet topOutput$1, Option filters$1, LinkedHashMap nextLevel$1, JoinReorderDP.JoinPlan otherSidePlan) {
        Option<JoinReorderDP.JoinPlan> option = MODULE$.buildJoin(oneSidePlan$1, otherSidePlan, conf$1, conditions$1, topOutput$1, (Option<JoinGraphInfo>)filters$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            JoinReorderDP.JoinPlan newJoinPlan = (JoinReorderDP.JoinPlan)some.value();
            Option existingPlan = nextLevel$1.get(newJoinPlan.itemIds());
            if (existingPlan.isEmpty() || newJoinPlan.betterThan((JoinReorderDP.JoinPlan)existingPlan.get(), conf$1)) {
                nextLevel$1.update(newJoinPlan.itemIds(), (Object)newJoinPlan);
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$buildJoin$3(LogicalPlan onePlan$1, LogicalPlan otherPlan$1, Expression e) {
        return e.references().subsetOf(onePlan$1.outputSet().$plus$plus(otherPlan$1.outputSet()));
    }

    private JoinReorderDP$() {
    }
}

