/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.artifact;

import jakarta.ws.rs.core.UriBuilder;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Cleaner;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.spark.JobArtifactSet$;
import org.apache.spark.JobArtifactState;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException$;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.sql.Artifact;
import org.apache.spark.sql.artifact.ArtifactManager$;
import org.apache.spark.sql.artifact.ArtifactManager$SparkContextResourceType$;
import org.apache.spark.sql.artifact.ArtifactStateForCleanup;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.internal.NonClosableMutableURLClassLoader;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.util.ArtifactUtils$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.CacheId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.ChildFirstURLClassLoader;
import org.apache.spark.util.StubClassLoader$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rMc\u0001\u0002(P\u0001iC\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0006q\u0002!\t\"\u001f\u0005\f\u0003\u000b\u0001\u0001R1A\u0005\u0002=\u000b9\u0001\u0003\u0007\u0002$\u0001\u0001\n\u0011aA!\u0002\u0013\t)\u0003C\u0005\u0002.\u0001\u0011\r\u0011\"\u0005Ps\"9\u0011q\u0006\u0001!\u0002\u0013Q\bBCA\u0019\u0001\t\u0007I\u0011C(\u0002\b!A\u00111\u0007\u0001!\u0002\u0013\tI\u0001\u0003\u0007\u00026\u0001\u0001\n\u0011aA!\u0002\u0013\t)\u0003C\u0005\u00028\u0001\u0011\r\u0011\"\u0005Ps\"9\u0011\u0011\b\u0001!\u0002\u0013Q\bBCA\u001e\u0001\t\u0007I\u0011C(\u0002\b!A\u0011Q\b\u0001!\u0002\u0013\tI\u0001\u0003\u0006\u0002@\u0001A)\u0019!C\u0005\u0003\u0003B!\"!\u0013\u0001\u0011\u000b\u0007I\u0011BA!\u0011-\tY\u0005\u0001EC\u0002\u0013E\u0011+!\u0014\t\u0013\u0005]\u0003A1A\u0005\u0012\u0005e\u0003\u0002CA8\u0001\u0001\u0006I!a\u0017\t\u0013\u0005E\u0004\u00011A\u0005\u0012\u0005M\u0004\"CAA\u0001\u0001\u0007I\u0011CAB\u0011!\ti\t\u0001Q!\n\u0005U\u0004bBAL\u0001\u0011%\u0011\u0011\u0014\u0005\b\u0003{\u0003A\u0011AA`\u0011%\tY\r\u0001b\u0001\n#\ti\r\u0003\u0005\u0002d\u0002\u0001\u000b\u0011BAh\u0011%\t)\u000f\u0001b\u0001\n#\t9\u000f\u0003\u0005\u0002l\u0002\u0001\u000b\u0011BAu\u0011%\ti\u000f\u0001b\u0001\n#\ty\u000f\u0003\u0005\u0002t\u0002\u0001\u000b\u0011BAy\u0011%\t)\u0010\u0001b\u0001\n#\t9\u0010\u0003\u0005\u0003\f\u0002\u0001\u000b\u0011BA}\u0011\u001d\u0011i\t\u0001C\u0001\u0005\u001fCqAa,\u0001\t\u0003\u0011\t\fC\u0004\u00036\u0002!IAa.\t\u0013\t%\u0007!%A\u0005\n\t-\u0007\"\u0003Bq\u0001E\u0005I\u0011\u0002Bf\u0011\u001d\u0011\u0019\u000f\u0001C\u0005\u0005KDqAa;\u0001\t\u0003\u0011i\u000fC\u0005\u0003\u0000\u0002\t\n\u0011\"\u0001\u0003L\"A1\u0011\u0001\u0001\u0005\u0002E\u001b\u0019\u0001C\u0004\u0004\u0014\u0001!\ta!\u0006\t\u000f\r]\u0001\u0001\"\u0003\u0004\u0016!A1\u0011\u0004\u0001\u0005\u0002E\u001bY\u0002C\u0005\u0004\"\u0001\u0011\r\u0011\"\u0003\u0004$!A1Q\u0005\u0001!\u0002\u0013\u0011\u0019\tC\u0004\u0004(\u0001!Ia!\u000b\t\u0013\re\u0002\u00011A\u0005\n\r%\u0002\"CB\u001e\u0001\u0001\u0007I\u0011BB\u001f\u0011!\u0019\t\u0005\u0001Q!\n\r-\u0002bBB\"\u0001\u0011%1Q\t\u0005\b\u0007\u000f\u0002A\u0011IB#\u0011!\u0019I\u0005\u0001C\u0001#\u000e\u0015\u0003bBB&\u0001\u0011\u00051QJ\u0004\b\u0005\u000fy\u0005\u0012\u0001B\u0005\r\u0019qu\n#\u0001\u0003\f!11\u000f\u000fC\u0001\u0005'A\u0011B!\u00069\u0005\u0004%\tAa\u0006\t\u0011\tu\u0001\b)A\u0005\u00053A\u0011Ba\b9\u0005\u0004%\tAa\u0006\t\u0011\t\u0005\u0002\b)A\u0005\u00053A!Ba\t9\u0011\u000b\u0007I\u0011A(z\u000f!\u0011)\u0003\u000fE\u0001\u001f\n\u001db\u0001\u0003B\u0016q!\u0005qJ!\f\t\rM\u0004E\u0011\u0001B\u001b\u000b\u0019\u00119\u0004\u0011\u0001\u0003:!I!\u0011\t!C\u0002\u0013\u0005!1\t\u0005\t\u0005\u000b\u0002\u0005\u0015!\u0003\u0003:!I!q\t!C\u0002\u0013\u0005!1\t\u0005\t\u0005\u0013\u0002\u0005\u0015!\u0003\u0003:!I!1\n!C\u0002\u0013\u0005!1\t\u0005\t\u0005\u001b\u0002\u0005\u0015!\u0003\u0003:!I!q\n!\u0002\u0002\u0013%!\u0011\u000b\u0005\b\u0005'BD\u0011\u0002B+\u0011%\u0011I\u0007\u000fb\u0001\n\u0013\u0011Y\u0007\u0003\u0005\u0003za\u0002\u000b\u0011\u0002B7\u0011\u001d\u0011Y\b\u000fC\u0005\u0005{\u0012q\"\u0011:uS\u001a\f7\r^'b]\u0006<WM\u001d\u0006\u0003!F\u000b\u0001\"\u0019:uS\u001a\f7\r\u001e\u0006\u0003%N\u000b1a]9m\u0015\t!V+A\u0003ta\u0006\u00148N\u0003\u0002W/\u00061\u0011\r]1dQ\u0016T\u0011\u0001W\u0001\u0004_J<7\u0001A\n\u0005\u0001m\u001bg\r\u0005\u0002]C6\tQL\u0003\u0002_?\u0006!A.\u00198h\u0015\u0005\u0001\u0017\u0001\u00026bm\u0006L!AY/\u0003\r=\u0013'.Z2u!\taF-\u0003\u0002f;\ni\u0011)\u001e;p\u00072|7/Z1cY\u0016\u0004\"a\u001a6\u000e\u0003!T!![*\u0002\u0011%tG/\u001a:oC2L!a\u001b5\u0003\u000f1{wmZ5oO\u000691/Z:tS>t\u0007C\u00018r\u001b\u0005y'B\u00019R\u0003\u001d\u0019G.Y:tS\u000eL!A]8\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\rqJg.\u001b;?)\t)x\u000f\u0005\u0002w\u00015\tq\nC\u0003m\u0005\u0001\u0007Q.\u0001\tbeRLg-Y2u%>|G\u000fU1uQV\t!\u0010E\u0002|\u0003\u0003i\u0011\u0001 \u0006\u0003{z\fAAZ5mK*\u0011qpX\u0001\u0004]&|\u0017bAA\u0002y\n!\u0001+\u0019;i\u0003=\t'\u000f^5gC\u000e$(k\\8u+JKUCAA\u0005!\u0011\tY!!\b\u000f\t\u00055\u0011\u0011\u0004\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111C-\u0002\rq\u0012xn\u001c;?\u0015\t\t9\"A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u001c\u0005U\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002 \u0005\u0005\"AB*ue&twM\u0003\u0003\u0002\u001c\u0005U\u0011a\u0001=%cA9\u0011qEA\u0015u\u0006%QBAA\u000b\u0013\u0011\tY#!\u0006\u0003\rQ+\b\u000f\\33\u00031\t'\u000f^5gC\u000e$\b+\u0019;i\u00035\t'\u000f^5gC\u000e$\b+\u0019;iA\u0005Y\u0011M\u001d;jM\u0006\u001cG/\u0016*J\u00031\t'\u000f^5gC\u000e$XKU%!\u0003\rAHEM\u0001\tG2\f7o\u001d#je\u0006I1\r\\1tg\u0012K'\u000fI\u0001\re\u0016\u0004Hn\u00117bgN,&+S\u0001\u000ee\u0016\u0004Hn\u00117bgN,&+\u0013\u0011\u0002-\u0005dw/Y=t\u0003B\u0004H._\"mCN\u001cHj\\1eKJ,\"!a\u0011\u0011\t\u0005\u001d\u0012QI\u0005\u0005\u0003\u000f\n)BA\u0004C_>dW-\u00198\u0002\u001fM,7o]5p]&\u001bx\u000e\\1uK\u0012\fQa\u001d;bi\u0016,\"!a\u0014\u0011\t\u0005E\u00131K\u0007\u0002'&\u0019\u0011QK*\u0003!){'-\u0011:uS\u001a\f7\r^*uCR,\u0017\u0001F:fgNLwN\\!si&4\u0017m\u0019;BI\u0012,G-\u0006\u0002\u0002\\A!\u0011QLA6\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014AB1u_6L7M\u0003\u0003\u0002f\u0005\u001d\u0014AC2p]\u000e,(O]3oi*\u0019\u0011\u0011N0\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003[\nyFA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u0016g\u0016\u001c8/[8o\u0003J$\u0018NZ1di\u0006#G-\u001a3!\u0003E\u0019\u0017m\u00195fI\u000ec\u0017m]:M_\u0006$WM]\u000b\u0003\u0003k\u0002b!a\n\u0002x\u0005m\u0014\u0002BA=\u0003+\u0011aa\u00149uS>t\u0007c\u0001/\u0002~%\u0019\u0011qP/\u0003\u0017\rc\u0017m]:M_\u0006$WM]\u0001\u0016G\u0006\u001c\u0007.\u001a3DY\u0006\u001c8\u000fT8bI\u0016\u0014x\fJ3r)\u0011\t))a#\u0011\t\u0005\u001d\u0012qQ\u0005\u0005\u0003\u0013\u000b)B\u0001\u0003V]&$\b\"CA\u0012+\u0005\u0005\t\u0019AA;\u0003I\u0019\u0017m\u00195fI\u000ec\u0017m]:M_\u0006$WM\u001d\u0011)\u0007Y\t\t\n\u0005\u0003\u0002(\u0005M\u0015\u0002BAK\u0003+\u0011\u0001B^8mCRLG.Z\u0001\u0018o&$\bn\u00117bgNdu.\u00193fe&3g*Z3eK\u0012,B!a'\u0002\"R!\u0011QTAZ!\u0011\ty*!)\r\u0001\u00119\u00111U\fC\u0002\u0005\u0015&!\u0001+\u0012\t\u0005\u001d\u0016Q\u0016\t\u0005\u0003O\tI+\u0003\u0003\u0002,\u0006U!a\u0002(pi\"Lgn\u001a\t\u0005\u0003O\ty+\u0003\u0003\u00022\u0006U!aA!os\"A\u0011QW\f\u0005\u0002\u0004\t9,A\u0001g!\u0019\t9#!/\u0002\u001e&!\u00111XA\u000b\u0005!a$-\u001f8b[\u0016t\u0014!D<ji\"\u0014Vm]8ve\u000e,7/\u0006\u0003\u0002B\u0006\u0015G\u0003BAb\u0003\u000f\u0004B!a(\u0002F\u00129\u00111\u0015\rC\u0002\u0005\u0015\u0006\u0002CA[1\u0011\u0005\r!!3\u0011\r\u0005\u001d\u0012\u0011XAb\u0003E\u0019\u0017m\u00195fI\ncwnY6JI2K7\u000f^\u000b\u0003\u0003\u001f\u0004b!!5\u0002T\u0006]WBAA2\u0013\u0011\t).a\u0019\u0003)\r{\u0007/_(o/JLG/Z!se\u0006LH*[:u!\u0011\tI.a8\u000e\u0005\u0005m'bAAo'\u000691\u000f^8sC\u001e,\u0017\u0002BAq\u00037\u0014qaQ1dQ\u0016LE-\u0001\ndC\u000eDW\r\u001a\"m_\u000e\\\u0017\n\u001a'jgR\u0004\u0013\u0001\u00036beNd\u0015n\u001d;\u0016\u0005\u0005%\b#BAi\u0003'T\u0018!\u00036beNd\u0015n\u001d;!\u0003E\u0001\u0018\u0010\u001e5p]&s7\r\\;eK2K7\u000f^\u000b\u0003\u0003c\u0004b!!5\u0002T\u0006%\u0011A\u00059zi\"|g.\u00138dYV$W\rT5ti\u0002\n\u0011d\u001d9be.\u001cuN\u001c;fqR\u0014V\r\\1uSZ,\u0007+\u0019;igV\u0011\u0011\u0011 \t\u0007\u0003#\f\u0019.a?\u0011\u0013\u0005\u001d\u0012Q B\u0001u\n%\u0015\u0002BA\u0000\u0003+\u0011a\u0001V;qY\u0016\u001c\u0004c\u0001B\u0002\u0005:\u0019!QA \u000f\u0005Y<\u0014aD!si&4\u0017m\u0019;NC:\fw-\u001a:\u0011\u0005YD4\u0003\u0002\u001d\u0003\u000e\u0019\u0004B!a\n\u0003\u0010%!!\u0011CA\u000b\u0005\u0019\te.\u001f*fMR\u0011!\u0011B\u0001\u0012M>\u0014x/\u0019:e)>45\u000b\u0015:fM&DXC\u0001B\r!\ra&1D\u0005\u0004\u0003?i\u0016A\u00054pe^\f'\u000f\u001a+p\rN\u0003&/\u001a4jq\u0002\n\u0011$\u0011*U\u0013\u001a\u000b5\tV0E\u0013J+5\tV(S3~\u0003&+\u0012$J1\u0006Q\u0012I\u0015+J\r\u0006\u001bEk\u0018#J%\u0016\u001bEk\u0014*Z?B\u0013VIR%YA\u0005)\u0012M\u001d;jM\u0006\u001cGOU8pi\u0012K'/Z2u_JL\u0018\u0001G*qCJ\\7i\u001c8uKb$(+Z:pkJ\u001cW\rV=qKB\u0019!\u0011\u0006!\u000e\u0003a\u0012\u0001d\u00159be.\u001cuN\u001c;fqR\u0014Vm]8ve\u000e,G+\u001f9f'\r\u0001%q\u0006\t\u0005\u0003O\u0011\t$\u0003\u0003\u00034\u0005U!aC#ok6,'/\u0019;j_:$\"Aa\n\u0003\u0019I+7o\\;sG\u0016$\u0016\u0010]3\u0011\t\tm\"QH\u0007\u0002\u0001&!!q\bB\u0019\u0005\u00151\u0016\r\\;f\u0003\rQ\u0015IU\u000b\u0003\u0005s\tAAS!SA\u0005!a)\u0013'F\u0003\u00151\u0015\nT#!\u0003\u001d\t%k\u0011%J-\u0016\u000b\u0001\"\u0011*D\u0011&3V\tI\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u00027\u0006I1m\u001c9z\u00052|7m\u001b\u000b\t\u0003/\u00149Fa\u0017\u0003`!9!\u0011\f&A\u0002\u0005]\u0017A\u00024s_6LE\rC\u0004\u0003^)\u0003\r!a6\u0002\tQ|\u0017\n\u001a\u0005\b\u0005CR\u0005\u0019\u0001B2\u00031\u0011Gn\\2l\u001b\u0006t\u0017mZ3s!\u0011\tIN!\u001a\n\t\t\u001d\u00141\u001c\u0002\r\u00052|7m['b]\u0006<WM]\u0001\bG2,\u0017M\\3s+\t\u0011i\u0007\u0005\u0003\u0003p\tUTB\u0001B9\u0015\r\u0011\u0019(X\u0001\u0004e\u00164\u0017\u0002\u0002B<\u0005c\u0012qa\u00117fC:,'/\u0001\u0005dY\u0016\fg.\u001a:!\u0003Y\u0019G.Z1o+B<En\u001c2bYJ+7o\\;sG\u0016\u001cH\u0003BAC\u0005\u007fBqA!!N\u0001\u0004\u0011\u0019)\u0001\u0007dY\u0016\fg.\u001e9Ti\u0006$X\rE\u0002w\u0005\u000bK1Aa\"P\u0005]\t%\u000f^5gC\u000e$8\u000b^1uK\u001a{'o\u00117fC:,\b\u000f\u0005\u0004\u0002(\u0005]\u0014\u0011B\u0001\u001bgB\f'o[\"p]R,\u0007\u0010\u001e*fY\u0006$\u0018N^3QCRD7\u000fI\u0001\rO\u0016$\u0018\t\u001a3fI*\u000b'o]\u000b\u0003\u0005#\u0003bAa%\u0003\u001e\n\rf\u0002\u0002BK\u00053sA!a\u0004\u0003\u0018&\u0011\u0011qC\u0005\u0005\u00057\u000b)\"A\u0004qC\u000e\\\u0017mZ3\n\t\t}%\u0011\u0015\u0002\u0004'\u0016\f(\u0002\u0002BN\u0003+\u0001BA!*\u0003,6\u0011!q\u0015\u0006\u0004\u0005S{\u0016a\u00018fi&!!Q\u0016BT\u0005\r)&\u000bT\u0001\u0012O\u0016$\b+\u001f;i_:Len\u00197vI\u0016\u001cXC\u0001BZ!\u0019\u0011\u0019J!(\u0002\n\u0005aAO]1og\u001a,'OR5mKRQ\u0011Q\u0011B]\u0005{\u0013\tM!2\t\r\tm6\u00051\u0001{\u0003\u0019\u0019x.\u001e:dK\"1!qX\u0012A\u0002i\fa\u0001^1sO\u0016$\b\"\u0003BbGA\u0005\t\u0019AA\"\u00039\tG\u000e\\8x\u001fZ,'o\u001e:ji\u0016D\u0011Ba2$!\u0003\u0005\r!a\u0011\u0002\u0019\u0011,G.\u001a;f'>,(oY3\u0002-Q\u0014\u0018M\\:gKJ4\u0015\u000e\\3%I\u00164\u0017-\u001e7uIM*\"A!4+\t\u0005\r#qZ\u0016\u0003\u0005#\u0004BAa5\u0003^6\u0011!Q\u001b\u0006\u0005\u0005/\u0014I.A\u0005v]\u000eDWmY6fI*!!1\\A\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005?\u0014)NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa\u0003\u001e:b]N4WM\u001d$jY\u0016$C-\u001a4bk2$H\u0005N\u0001\u000e]>\u0014X.\u00197ju\u0016\u0004\u0016\r\u001e5\u0015\u0007i\u00149\u000f\u0003\u0004\u0003j\u001a\u0002\rA_\u0001\u0005a\u0006$\b.A\u0006bI\u0012\f%\u000f^5gC\u000e$HCCAC\u0005_\u0014\u0019Pa>\u0003|\"1!\u0011_\u0014A\u0002i\f!C]3n_R,'+\u001a7bi&4X\rU1uQ\"1!Q_\u0014A\u0002i\fac]3sm\u0016\u0014Hj\\2bYN#\u0018mZ5oOB\u000bG\u000f\u001b\u0005\b\u0005s<\u0003\u0019\u0001BE\u0003!1'/Y4nK:$\b\"\u0003B\u007fOA\u0005\t\u0019AA\"\u0003A!W\r\\3uKN#\u0018mZ3e\r&dW-A\u000bbI\u0012\f%\u000f^5gC\u000e$H\u0005Z3gCVdG\u000f\n\u001b\u0002#\u0005$G\rT8dC2\f%\u000f^5gC\u000e$8\u000f\u0006\u0003\u0002\u0006\u000e\u0015\u0001bBB\u0004S\u0001\u00071\u0011B\u0001\nCJ$\u0018NZ1diN\u0004bAa%\u0003\u001e\u000e-\u0001\u0003BB\u0007\u0007\u001fi\u0011!U\u0005\u0004\u0007#\t&\u0001C!si&4\u0017m\u0019;\u0002\u0017\rd\u0017m]:m_\u0006$WM]\u000b\u0003\u0003w\n\u0001CY;jY\u0012\u001cE.Y:t\u0019>\fG-\u001a:\u0002\u000b\rdwN\\3\u0015\u0007U\u001ci\u0002\u0003\u0004\u0004 1\u0002\r!\\\u0001\u000b]\u0016<8+Z:tS>t\u0017AH2mK\u0006tW\u000b]*uCR,gi\u001c:HY>\u0014\u0017\r\u001c*fg>,(oY3t+\t\u0011\u0019)A\u0010dY\u0016\fg.\u00169Ti\u0006$XMR8s\u000f2|'-\u00197SKN|WO]2fg\u0002\nAbZ3u\u00072,\u0017M\\1cY\u0016,\"aa\u000b\u0011\t\r521\u0007\b\u0005\u0005_\u001ay#\u0003\u0003\u00042\tE\u0014aB\"mK\u0006tWM]\u0005\u0005\u0007k\u00199DA\u0005DY\u0016\fg.\u00192mK*!1\u0011\u0007B9\u0003%\u0019G.Z1oC\ndW-A\u0007dY\u0016\fg.\u00192mK~#S-\u001d\u000b\u0005\u0003\u000b\u001by\u0004C\u0005\u0002$E\n\t\u00111\u0001\u0004,\u0005Q1\r\\3b]\u0006\u0014G.\u001a\u0011\u0002!\rdW-\u00198VaJ+7o\\;sG\u0016\u001cHCAAC\u0003\u0015\u0019Gn\\:f\u0003i\u0019G.Z1o+B\u0014Vm]8ve\u000e,7OR8s)\u0016\u001cH/\u001b8h\u0003I)\b\u000f\\8bI\u0006\u0013H/\u001b4bGR$vNR:\u0015\r\u0005\u00155qJB)\u0011\u0019\u0011\tP\u000ea\u0001u\"1!Q\u001f\u001cA\u0002i\u0004")
public class ArtifactManager
implements AutoCloseable,
Logging {
    private String artifactRootURI;
    private boolean alwaysApplyClassLoader;
    private boolean sessionIsolated;
    private JobArtifactState state;
    private final SparkSession session;
    private final /* synthetic */ Tuple2 x$1;
    private final Path artifactPath;
    private final String artifactURI;
    private final /* synthetic */ Tuple2 x$2;
    private final Path classDir;
    private final String replClassURI;
    private final AtomicBoolean sessionArtifactAdded;
    private volatile Option<ClassLoader> cachedClassLoader;
    private final CopyOnWriteArrayList<CacheId> cachedBlockIdList;
    private final CopyOnWriteArrayList<Path> jarsList;
    private final CopyOnWriteArrayList<String> pythonIncludeList;
    private final CopyOnWriteArrayList<Tuple3<Enumeration.Value, Path, Option<String>>> sparkContextRelativePaths;
    private final ArtifactStateForCleanup cleanUpStateForGlobalResources;
    private Cleaner.Cleanable cleanable;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static String ARTIFACT_DIRECTORY_PREFIX() {
        return ArtifactManager$.MODULE$.ARTIFACT_DIRECTORY_PREFIX();
    }

    public static String forwardToFSPrefix() {
        return ArtifactManager$.MODULE$.forwardToFSPrefix();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Path artifactRootPath() {
        return ArtifactManager$.MODULE$.artifactRootDirectory();
    }

    private String artifactRootURI$lzycompute() {
        ArtifactManager artifactManager = this;
        synchronized (artifactManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.artifactRootURI = SparkEnv$.MODULE$.get().rpcEnv().fileServer().addDirectoryIfAbsent(ArtifactManager$.MODULE$.ARTIFACT_DIRECTORY_PREFIX(), this.artifactRootPath().toFile());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.artifactRootURI;
    }

    public String artifactRootURI() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.artifactRootURI$lzycompute();
        }
        return this.artifactRootURI;
    }

    public Path artifactPath() {
        return this.artifactPath;
    }

    public String artifactURI() {
        return this.artifactURI;
    }

    public Path classDir() {
        return this.classDir;
    }

    public String replClassURI() {
        return this.replClassURI;
    }

    private boolean alwaysApplyClassLoader$lzycompute() {
        ArtifactManager artifactManager = this;
        synchronized (artifactManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.alwaysApplyClassLoader = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(this.session.conf().get(SQLConf$.MODULE$.ARTIFACTS_SESSION_ISOLATION_ALWAYS_APPLY_CLASSLOADER().key())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.alwaysApplyClassLoader;
    }

    private boolean alwaysApplyClassLoader() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.alwaysApplyClassLoader$lzycompute();
        }
        return this.alwaysApplyClassLoader;
    }

    private boolean sessionIsolated$lzycompute() {
        ArtifactManager artifactManager = this;
        synchronized (artifactManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.sessionIsolated = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(this.session.conf().get(SQLConf$.MODULE$.ARTIFACTS_SESSION_ISOLATION_ENABLED().key())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.sessionIsolated;
    }

    private boolean sessionIsolated() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.sessionIsolated$lzycompute();
        }
        return this.sessionIsolated;
    }

    private JobArtifactState state$lzycompute() {
        ArtifactManager artifactManager = this;
        synchronized (artifactManager) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.state = this.sessionIsolated() ? new JobArtifactState(this.session.sessionUUID(), (Option)new Some((Object)this.replClassURI())) : null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.state;
    }

    public JobArtifactState state() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.state$lzycompute();
        }
        return this.state;
    }

    public AtomicBoolean sessionArtifactAdded() {
        return this.sessionArtifactAdded;
    }

    public Option<ClassLoader> cachedClassLoader() {
        return this.cachedClassLoader;
    }

    public void cachedClassLoader_$eq(Option<ClassLoader> x$1) {
        this.cachedClassLoader = x$1;
    }

    private <T> T withClassLoaderIfNeeded(Function0<T> f) {
        String log = " classloader for session " + this.session.sessionUUID() + " because alwaysApplyClassLoader=" + this.alwaysApplyClassLoader() + ", sessionArtifactAdded=" + this.sessionArtifactAdded().get() + ".";
        if (this.alwaysApplyClassLoader() || this.sessionArtifactAdded().get()) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Applying " + log);
            return (T)Utils$.MODULE$.withContextClassLoader(this.classloader(), f);
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Not applying " + log);
        return (T)f.apply();
    }

    public <T> T withResources(Function0<T> f) {
        return this.withClassLoaderIfNeeded((Function0 & Serializable)() -> JobArtifactSet$.MODULE$.withActiveJobArtifactState(this.state(), f));
    }

    public CopyOnWriteArrayList<CacheId> cachedBlockIdList() {
        return this.cachedBlockIdList;
    }

    public CopyOnWriteArrayList<Path> jarsList() {
        return this.jarsList;
    }

    public CopyOnWriteArrayList<String> pythonIncludeList() {
        return this.pythonIncludeList;
    }

    public CopyOnWriteArrayList<Tuple3<Enumeration.Value, Path, Option<String>>> sparkContextRelativePaths() {
        return this.sparkContextRelativePaths;
    }

    public Seq<URL> getAddedJars() {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jarsList()).asScala().map((Function1 & Serializable)x$3 -> ArtifactUtils$.MODULE$.concatenatePaths(this.artifactPath(), x$3))).map((Function1 & Serializable)x$4 -> x$4.toUri().toURL())).toSeq();
    }

    public Seq<String> getPythonIncludes() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.pythonIncludeList()).asScala().toSeq();
    }

    private void transferFile(Path source, Path target, boolean allowOverwrite, boolean deleteSource) {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        if (allowOverwrite) {
            ArtifactManager.execute$1(source, target, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING}), deleteSource);
            return;
        }
        ArtifactManager.execute$1(source, target, (Seq)Nil$.MODULE$, deleteSource);
    }

    private boolean transferFile$default$3() {
        return false;
    }

    private boolean transferFile$default$4() {
        return true;
    }

    private Path normalizePath(Path path) {
        String normalizedPathString = ((Object)path).toString().replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return Paths.get(normalizedPathString, new String[0]).normalize();
    }

    public void addArtifact(Path remoteRelativePath, Path serverLocalStagingPath, Option<String> fragment, boolean deleteStagedFile) {
        Object object = new Object();
        try {
            JobArtifactSet$.MODULE$.withActiveJobArtifactState(this.state(), (Function0 & Serializable)() -> {
                Predef$.MODULE$.require(!remoteRelativePath.isAbsolute());
                Path normalizedRemoteRelativePath = this.normalizePath(remoteRelativePath);
                if (normalizedRemoteRelativePath.startsWith("cache" + File.separator)) {
                    File tmpFile = serverLocalStagingPath.toFile();
                    JFunction0.mcZ.sp & Serializable x$12 = (JFunction0.mcZ.sp & Serializable)() -> {
                        BlockManager blockManager = $this.session.sparkContext().env().blockManager();
                        CacheId blockId = new CacheId($this.session.sessionUUID(), StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(((Object)normalizedRemoteRelativePath).toString()), "cache" + File.separator));
                        BlockManager.TempFileBasedBlockStoreUpdater updater = new BlockManager.TempFileBasedBlockStoreUpdater(blockManager, (BlockId)blockId, StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), tmpFile, tmpFile.length(), false, blockManager.TempFileBasedBlockStoreUpdater().apply$default$7());
                        updater.save();
                        return this.cachedBlockIdList().add(blockId);
                    };
                    JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> tmpFile.delete();
                    JFunction0.mcV.sp & Serializable x$3 = () -> ArtifactManager.$anonfun$addArtifact$4((Function0)x$12);
                    return Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0)x$12, (Function0)x$3, (Function0)x$2);
                }
                if (normalizedRemoteRelativePath.startsWith("classes" + File.separator)) {
                    Path target = ArtifactUtils$.MODULE$.concatenatePaths(this.classDir(), StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(((Object)normalizedRemoteRelativePath).toString()), "classes" + File.separator));
                    this.transferFile(serverLocalStagingPath, target, true, deleteStagedFile);
                    this.sessionArtifactAdded().set(true);
                    this.cachedClassLoader_$eq((Option<ClassLoader>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                }
                Path target = ArtifactUtils$.MODULE$.concatenatePaths(this.artifactPath(), normalizedRemoteRelativePath);
                if (Files.exists(target, new LinkOption[0])) {
                    if (FileUtils.contentEquals((File)target.toFile(), (File)serverLocalStagingPath.toFile())) {
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    throw new SparkRuntimeException("ARTIFACT_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"normalizedRemoteRelativePath"), (Object)((Object)normalizedRemoteRelativePath).toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
                }
                Path x$4 = serverLocalStagingPath;
                Path x$5 = target;
                boolean x$6 = deleteStagedFile;
                boolean x$7 = this.transferFile$default$3();
                this.transferFile(x$4, x$5, x$7, x$6);
                String uri = this.artifactURI() + "/" + Utils$.MODULE$.encodeRelativeUnixPathToURIRawPath(FilenameUtils.separatorsToUnix((String)((Object)normalizedRemoteRelativePath).toString()));
                if (normalizedRemoteRelativePath.startsWith("jars" + File.separator)) {
                    $this.session.sparkContext().addJar(uri);
                    this.sparkContextRelativePaths().add((Tuple3<Enumeration.Value, Path, Option<String>>)new Tuple3((Object)ArtifactManager$SparkContextResourceType$.MODULE$.JAR(), (Object)normalizedRemoteRelativePath, (Object)fragment));
                    this.jarsList().add(normalizedRemoteRelativePath);
                    this.sessionArtifactAdded().set(true);
                    this.cachedClassLoader_$eq((Option<ClassLoader>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                }
                if (normalizedRemoteRelativePath.startsWith("pyfiles" + File.separator)) {
                    $this.session.sparkContext().addFile(uri);
                    this.sparkContextRelativePaths().add((Tuple3<Enumeration.Value, Path, Option<String>>)new Tuple3((Object)ArtifactManager$SparkContextResourceType$.MODULE$.FILE(), (Object)normalizedRemoteRelativePath, (Object)fragment));
                    String stringRemotePath = ((Object)normalizedRemoteRelativePath).toString();
                    if (stringRemotePath.endsWith(".zip") || stringRemotePath.endsWith(".egg") || stringRemotePath.endsWith(".jar")) {
                        return BoxesRunTime.boxToBoolean((boolean)this.pythonIncludeList().add(((Object)target.getFileName()).toString()));
                    }
                    return BoxedUnit.UNIT;
                }
                if (normalizedRemoteRelativePath.startsWith("archives" + File.separator)) {
                    UriBuilder uriBuilder = Utils$.MODULE$.getUriBuilder(new URI(uri));
                    Object canonicalUri = fragment.map((Function1 & Serializable)x$1 -> uriBuilder.fragment(x$1)).getOrElse((Function0 & Serializable)() -> new URI(uri));
                    $this.session.sparkContext().addArchive(canonicalUri.toString());
                    return BoxesRunTime.boxToBoolean((boolean)this.sparkContextRelativePaths().add((Tuple3<Enumeration.Value, Path, Option<String>>)new Tuple3((Object)ArtifactManager$SparkContextResourceType$.MODULE$.ARCHIVE(), (Object)normalizedRemoteRelativePath, (Object)fragment)));
                }
                if (normalizedRemoteRelativePath.startsWith("files" + File.separator)) {
                    $this.session.sparkContext().addFile(uri);
                    return BoxesRunTime.boxToBoolean((boolean)this.sparkContextRelativePaths().add((Tuple3<Enumeration.Value, Path, Option<String>>)new Tuple3((Object)ArtifactManager$SparkContextResourceType$.MODULE$.FILE(), (Object)normalizedRemoteRelativePath, (Object)fragment)));
                }
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public boolean addArtifact$default$4() {
        return true;
    }

    public void addLocalArtifacts(Seq<Artifact> artifacts) {
        artifacts.foreach((Function1 & Serializable)artifact -> {
            ArtifactManager.$anonfun$addLocalArtifacts$1(this, artifact);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized ClassLoader classloader() {
        return (ClassLoader)this.cachedClassLoader().getOrElse((Function0 & Serializable)() -> {
            ClassLoader loader = this.buildClassLoader();
            this.cachedClassLoader_$eq((Option<ClassLoader>)new Some((Object)loader));
            return loader;
        });
    }

    private ClassLoader buildClassLoader() {
        URL[] urls = (URL[])((IterableOnceOps)this.getAddedJars().$colon$plus((Object)this.classDir().toUri().toURL())).toArray(ClassTag$.MODULE$.apply(URL.class));
        Seq prefixes = (Seq)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.CONNECT_SCALA_UDF_STUB_PREFIXES());
        boolean userClasspathFirst = BoxesRunTime.unboxToBoolean((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.EXECUTOR_USER_CLASS_PATH_FIRST()));
        NonClosableMutableURLClassLoader fallbackClassLoader = this.session.sharedState().jarClassLoader();
        Object loader = prefixes.nonEmpty() ? (userClasspathFirst ? new ChildFirstURLClassLoader(urls, (ClassLoader)StubClassLoader$.MODULE$.apply((ClassLoader)((Object)fallbackClassLoader), prefixes)) : new ChildFirstURLClassLoader(urls, (ClassLoader)StubClassLoader$.MODULE$.apply(null, prefixes), (ClassLoader)((Object)fallbackClassLoader))) : (userClasspathFirst ? new ChildFirstURLClassLoader(urls, (ClassLoader)((Object)fallbackClassLoader)) : new URLClassLoader(urls, (ClassLoader)((Object)fallbackClassLoader)));
        this.logDebug((Function0<String>)((Function0 & Serializable)() -> ArtifactManager.$anonfun$buildClassLoader$1((URLClassLoader)loader, urls)));
        return loader;
    }

    public ArtifactManager clone(SparkSession newSession) {
        SparkContext sparkContext = this.session.sparkContext();
        ArtifactManager newArtifactManager = new ArtifactManager(newSession);
        if (this.artifactPath().toFile().exists()) {
            FileUtils.copyDirectory((File)this.artifactPath().toFile(), (File)newArtifactManager.artifactPath().toFile());
        }
        BlockManager blockManager = sparkContext.env().blockManager();
        Buffer newBlockIds = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.cachedBlockIdList()).asScala().map((Function1 & Serializable)blockId -> {
            CacheId newBlockId = blockId.copy(newSession.sessionUUID(), blockId.copy$default$2());
            return ArtifactManager$.MODULE$.org$apache$spark$sql$artifact$ArtifactManager$$copyBlock((CacheId)blockId, newBlockId, blockManager);
        });
        JobArtifactSet$.MODULE$.withActiveJobArtifactState(newArtifactManager.state(), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.sparkContextRelativePaths().forEach((Consumer<Tuple3<Enumeration.Value, Path, Option<String>>>)((Consumer<Tuple3>)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                Enumeration.Value resourceType = (Enumeration.Value)tuple3._1();
                Path relativePath = (Path)tuple3._2();
                Option fragment = (Option)tuple3._3();
                String uri = newArtifactManager.artifactURI() + "/" + Utils$.MODULE$.encodeRelativeUnixPathToURIRawPath(FilenameUtils.separatorsToUnix((String)((Object)relativePath).toString()));
                Enumeration.Value value = resourceType;
                Enumeration.Value value2 = ArtifactManager$SparkContextResourceType$.MODULE$.JAR();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    sparkContext.addJar(uri);
                } else {
                    Enumeration.Value value4 = ArtifactManager$SparkContextResourceType$.MODULE$.FILE();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        sparkContext.addFile(uri);
                    } else {
                        Enumeration.Value value6 = ArtifactManager$SparkContextResourceType$.MODULE$.ARCHIVE();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            UriBuilder uriBuilder = Utils$.MODULE$.getUriBuilder(new URI(uri));
                            Object canonicalUri = fragment.map((Function1 & Serializable)x$1 -> uriBuilder.fragment(x$1)).getOrElse((Function0 & Serializable)() -> new URI(uri));
                            sparkContext.addArchive(canonicalUri.toString());
                        } else {
                            throw SparkException$.MODULE$.internalError("Unsupported resource type: " + resourceType);
                        }
                    }
                }
                return;
            }
            throw new MatchError((Object)tuple3);
        })));
        newArtifactManager.cachedBlockIdList().addAll(CollectionConverters$.MODULE$.BufferHasAsJava(newBlockIds).asJava());
        newArtifactManager.jarsList().addAll(this.jarsList());
        newArtifactManager.pythonIncludeList().addAll(this.pythonIncludeList());
        newArtifactManager.sparkContextRelativePaths().addAll(this.sparkContextRelativePaths());
        return newArtifactManager;
    }

    private ArtifactStateForCleanup cleanUpStateForGlobalResources() {
        return this.cleanUpStateForGlobalResources;
    }

    private Cleaner.Cleanable getCleanable() {
        return ArtifactManager$.MODULE$.org$apache$spark$sql$artifact$ArtifactManager$$cleaner().register(this, () -> ArtifactManager$.MODULE$.org$apache$spark$sql$artifact$ArtifactManager$$cleanUpGlobalResources(this.cleanUpStateForGlobalResources()));
    }

    private Cleaner.Cleanable cleanable() {
        return this.cleanable;
    }

    private void cleanable_$eq(Cleaner.Cleanable x$1) {
        this.cleanable = x$1;
    }

    private void cleanUpResources() {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Cleaning up resources for session with sessionUUID " + $this.session.sessionUUID());
        this.cleanable().clean();
        this.jarsList().clear();
        this.pythonIncludeList().clear();
        this.cachedBlockIdList().clear();
        this.sparkContextRelativePaths().clear();
        this.cachedClassLoader_$eq((Option<ClassLoader>)None$.MODULE$);
    }

    @Override
    public void close() {
        this.cleanUpResources();
    }

    public void cleanUpResourcesForTesting() {
        this.cleanUpResources();
        this.cleanable_$eq(this.getCleanable());
    }

    public void uploadArtifactToFs(Path remoteRelativePath, Path serverLocalStagingPath) {
        boolean allowDestLocalConf;
        Path normalizedRemoteRelativePath = this.normalizePath(remoteRelativePath);
        Configuration hadoopConf = this.session.sparkContext().hadoopConfiguration();
        Predef$.MODULE$.assert(normalizedRemoteRelativePath.startsWith(ArtifactManager$.MODULE$.forwardToFSPrefix() + File.separator));
        org.apache.hadoop.fs.Path destFSPath = new org.apache.hadoop.fs.Path(((Object)Paths.get(File.separator, new String[0]).resolve(normalizedRemoteRelativePath.subpath(1, normalizedRemoteRelativePath.getNameCount()))).toString());
        Path localPath = serverLocalStagingPath;
        FileSystem fs = destFSPath.getFileSystem(hadoopConf);
        if (fs instanceof LocalFileSystem && !(allowDestLocalConf = BoxesRunTime.unboxToBoolean((Object)this.session.sessionState().conf().getConf(SQLConf$.MODULE$.ARTIFACT_COPY_FROM_LOCAL_TO_FS_ALLOW_DEST_LOCAL()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.session.conf().get("spark.connect.copyFromLocalToFs.allowDestLocal").contains("true"))))) {
            throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3161");
        }
        fs.copyFromLocalFile(false, true, new org.apache.hadoop.fs.Path(((Object)localPath).toString()), destFSPath);
    }

    private static final Path execute$1(Path s, Path t, Seq opt, boolean deleteSource$1) {
        if (deleteSource$1) {
            return Files.move(s, t, (CopyOption[])opt.toArray(ClassTag$.MODULE$.apply(CopyOption.class)));
        }
        return Files.copy(s, t, (CopyOption[])opt.toArray(ClassTag$.MODULE$.apply(CopyOption.class)));
    }

    public static final /* synthetic */ void $anonfun$addArtifact$4(Function0 x$1$1) {
        Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$2(x$1$1);
    }

    public static final /* synthetic */ void $anonfun$addLocalArtifacts$4(Function0 x$1$2) {
        Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$2(x$1$2);
    }

    public static final /* synthetic */ void $anonfun$addLocalArtifacts$1(ArtifactManager $this, Artifact artifact) {
        Artifact.LocalData localData = artifact.storage();
        if (localData instanceof Artifact.LocalFile) {
            Artifact.LocalFile localFile = (Artifact.LocalFile)localData;
            $this.addArtifact(artifact.path(), localFile.path(), (Option<String>)None$.MODULE$, false);
            return;
        }
        if (localData instanceof Artifact.InMemory) {
            Artifact.InMemory inMemory = (Artifact.InMemory)localData;
            Path tempDir = Utils$.MODULE$.createTempDir().toPath();
            Path tempFile = tempDir.resolve(artifact.path().getFileName());
            OutputStream outStream = Files.newOutputStream(tempFile, new OpenOption[0]);
            JFunction0.mcV.sp & Serializable x$1 = (JFunction0.mcV.sp & Serializable)() -> {
                inMemory.stream().transferTo(outStream);
                $this.addArtifact(artifact.path(), tempFile, (Option<String>)None$.MODULE$, $this.addArtifact$default$4());
            };
            JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> outStream.close();
            JFunction0.mcV.sp & Serializable x$3 = () -> ArtifactManager.$anonfun$addLocalArtifacts$4((Function0)x$1);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0)x$1, (Function0)x$3, (Function0)x$2);
            return;
        }
        throw SparkException$.MODULE$.internalError("Unsupported artifact storage: " + artifact.storage());
    }

    public static final /* synthetic */ String $anonfun$buildClassLoader$1(URLClassLoader loader$1, URL[] urls$1) {
        return "Using class loader: " + loader$1 + ", containing urls: " + urls$1;
    }

    public ArtifactManager(SparkSession session) {
        this.session = session;
        Logging.$init$((Logging)this);
        Tuple2 tuple2 = new Tuple2((Object)ArtifactUtils$.MODULE$.concatenatePaths(this.artifactRootPath(), session.sessionUUID()), (Object)(this.artifactRootURI() + "/" + session.sessionUUID()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path artifactPath = (Path)tuple2._1();
        String artifactURI = (String)tuple2._2();
        this.x$1 = new Tuple2((Object)artifactPath, (Object)artifactURI);
        this.artifactPath = (Path)this.x$1._1();
        this.artifactURI = (String)this.x$1._2();
        Tuple2 tuple22 = new Tuple2((Object)ArtifactUtils$.MODULE$.concatenatePaths(this.artifactPath(), "classes"), (Object)(this.artifactURI() + "/classes/"));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Path classDir = (Path)tuple22._1();
        String replClassURI = (String)tuple22._2();
        this.x$2 = new Tuple2((Object)classDir, (Object)replClassURI);
        this.classDir = (Path)this.x$2._1();
        this.replClassURI = (String)this.x$2._2();
        this.sessionArtifactAdded = new AtomicBoolean(false);
        this.cachedClassLoader = None$.MODULE$;
        this.cachedBlockIdList = new CopyOnWriteArrayList();
        this.jarsList = new CopyOnWriteArrayList();
        this.pythonIncludeList = new CopyOnWriteArrayList();
        this.sparkContextRelativePaths = new CopyOnWriteArrayList();
        this.cleanUpStateForGlobalResources = new ArtifactStateForCleanup(session.sessionUUID(), session.sparkContext(), this.state(), this.artifactPath());
        this.cleanable = this.getCleanable();
    }
}

