/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.worker.WorkerWatcher;
import org.apache.spark.deploy.worker.WorkerWatcher$;
import org.apache.spark.executor.CoarseGrainedExecutorBackend;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnv$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class CoarseGrainedExecutorBackend$
implements Logging {
    public static final CoarseGrainedExecutorBackend$ MODULE$ = new CoarseGrainedExecutorBackend$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void main(String[] args) {
        Function4 & Serializable createFn = (Function4 & Serializable)(x0$1, x1$1, x2$1, x3$1) -> {
            Tuple4 tuple4 = new Tuple4(x0$1, x1$1, x2$1, x3$1);
            if (tuple4 != null) {
                RpcEnv rpcEnv = (RpcEnv)tuple4._1();
                CoarseGrainedExecutorBackend.Arguments arguments = (CoarseGrainedExecutorBackend.Arguments)tuple4._2();
                SparkEnv env = (SparkEnv)tuple4._3();
                ResourceProfile resourceProfile = (ResourceProfile)tuple4._4();
                return new CoarseGrainedExecutorBackend(rpcEnv, arguments.driverUrl(), arguments.executorId(), arguments.bindAddress(), arguments.hostname(), arguments.cores(), env, arguments.resourcesFileOpt(), resourceProfile);
            }
            throw new MatchError((Object)tuple4);
        };
        this.run(this.parseArguments(args, StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.getClass().getCanonicalName()), "$")), (Function4<RpcEnv, CoarseGrainedExecutorBackend.Arguments, SparkEnv, ResourceProfile, CoarseGrainedExecutorBackend>)createFn);
        System.exit(0);
    }

    public void run(CoarseGrainedExecutorBackend.Arguments arguments, Function4<RpcEnv, CoarseGrainedExecutorBackend.Arguments, SparkEnv, ResourceProfile, CoarseGrainedExecutorBackend> backendCreateFn) {
        Utils$.MODULE$.resetStructuredLogging();
        Utils$.MODULE$.initDaemon(this.log());
        SparkHadoopUtil$.MODULE$.get().runAsSparkUser((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Utils$.MODULE$.checkHost(arguments.hostname());
            SparkConf executorConf = new SparkConf();
            RpcEnv fetcher = RpcEnv$.MODULE$.create("driverPropsFetcher", arguments.bindAddress(), arguments.hostname(), -1, executorConf, new SecurityManager(executorConf, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), 0, true);
            ObjectRef driver = ObjectRef.create(null);
            int nTries = 3;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nTries).withFilter((Function1)(JFunction1.mcZI.sp & Serializable)i -> (RpcEndpointRef)driver$1.elem == null).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                block2: {
                    try {
                        driver$1.elem = fetcher.setupEndpointRefByURI(arguments.driverUrl());
                    }
                    catch (Throwable e) {
                        if (i != nTries - 1) break block2;
                        throw e;
                    }
                }
            });
            CoarseGrainedClusterMessages.SparkAppConfig cfg = (CoarseGrainedClusterMessages.SparkAppConfig)((RpcEndpointRef)driver.elem).askSync(new CoarseGrainedClusterMessages.RetrieveSparkAppConfig(arguments.resourceProfileId()), ClassTag$.MODULE$.apply(CoarseGrainedClusterMessages.SparkAppConfig.class));
            Seq props = (Seq)cfg.sparkProperties().$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple2((Object)"spark.app.id", (Object)arguments.appId()), (List)Nil$.MODULE$));
            fetcher.shutdown();
            SparkConf driverConf = new SparkConf();
            props.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CoarseGrainedExecutorBackend$.$anonfun$run$10(check$ifrefutable$1))).foreach((Function1 & Serializable)x$4 -> {
                Tuple2 tuple2 = x$4;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    if (SparkConf$.MODULE$.isExecutorStartupConf(key)) {
                        return driverConf.setIfMissing(key, value);
                    }
                    return driverConf.set(key, value);
                }
                throw new MatchError((Object)tuple2);
            });
            Utils$.MODULE$.resetStructuredLogging(driverConf);
            Logging$.MODULE$.uninitialize();
            cfg.hadoopDelegationCreds().foreach((Function1 & Serializable)tokens -> {
                CoarseGrainedExecutorBackend$.$anonfun$run$12(driverConf, tokens);
                return BoxedUnit.UNIT;
            });
            driverConf.set(package$.MODULE$.EXECUTOR_ID(), arguments.executorId());
            cfg.logLevel().foreach((Function1 & Serializable)logLevel -> {
                Utils$.MODULE$.setLogLevelIfNeeded(logLevel);
                return BoxedUnit.UNIT;
            });
            if (cfg.resourceProfile().id() != ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID()) {
                cfg.resourceProfile().executorResources().foreach((Function1 & Serializable)x0$1 -> {
                    CoarseGrainedExecutorBackend$.$anonfun$run$14(driverConf, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            SparkEnv env = SparkEnv$.MODULE$.createExecutorEnv(driverConf, arguments.executorId(), arguments.bindAddress(), arguments.hostname(), arguments.cores(), cfg.ioEncryptionKey(), false);
            Option appAttemptId = (Option)env.conf().get(package$.MODULE$.APP_ATTEMPT_ID());
            appAttemptId.foreach((Function1 & Serializable)attemptId -> {
                CoarseGrainedExecutorBackend$.$anonfun$run$19(env, attemptId);
                return BoxedUnit.UNIT;
            });
            CoarseGrainedExecutorBackend backend = (CoarseGrainedExecutorBackend)backendCreateFn.apply((Object)env.rpcEnv(), (Object)arguments, (Object)env, (Object)cfg.resourceProfile());
            env.rpcEnv().setupEndpoint("Executor", backend);
            arguments.workerUrl().foreach((Function1 & Serializable)url -> {
                RpcEnv x$1 = env.rpcEnv();
                String x$2 = url;
                AtomicBoolean x$3 = backend.stopping();
                boolean x$4 = WorkerWatcher$.MODULE$.$lessinit$greater$default$3();
                return env.rpcEnv().setupEndpoint("WorkerWatcher", new WorkerWatcher(x$1, x$2, x$4, x$3));
            });
            env.rpcEnv().awaitTermination();
        });
    }

    public CoarseGrainedExecutorBackend.Arguments parseArguments(String[] args, String classNameForEntry) {
        String driverUrl = null;
        String executorId = null;
        String bindAddress = null;
        String hostname = null;
        int cores = 0;
        None$ resourcesFileOpt = None$.MODULE$;
        String appId = null;
        None$ workerUrl = None$.MODULE$;
        int resourceProfileId = ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
        List argv = Predef$.MODULE$.wrapRefArray((Object[])args).toList();
        while (!argv.isEmpty()) {
            boolean bl = false;
            .colon.colon colon2 = null;
            List list = argv;
            if (list instanceof .colon.colon) {
                bl = true;
                colon2 = (.colon.colon)list;
                String string = (String)colon2.head();
                List list2 = colon2.next$access$1();
                if ("--driver-url".equals(string) && list2 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list2;
                    String value = (String)colon3.head();
                    List tail = colon3.next$access$1();
                    driverUrl = value;
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list3 = colon2.next$access$1();
                if ("--executor-id".equals(string) && list3 instanceof .colon.colon) {
                    .colon.colon colon4 = (.colon.colon)list3;
                    String value = (String)colon4.head();
                    List tail = colon4.next$access$1();
                    executorId = value;
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list4 = colon2.next$access$1();
                if ("--bind-address".equals(string) && list4 instanceof .colon.colon) {
                    .colon.colon colon5 = (.colon.colon)list4;
                    String value = (String)colon5.head();
                    List tail = colon5.next$access$1();
                    bindAddress = value;
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list5 = colon2.next$access$1();
                if ("--hostname".equals(string) && list5 instanceof .colon.colon) {
                    .colon.colon colon6 = (.colon.colon)list5;
                    String value = (String)colon6.head();
                    List tail = colon6.next$access$1();
                    hostname = value;
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list6 = colon2.next$access$1();
                if ("--cores".equals(string) && list6 instanceof .colon.colon) {
                    .colon.colon colon7 = (.colon.colon)list6;
                    String value = (String)colon7.head();
                    List tail = colon7.next$access$1();
                    cores = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value));
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list7 = colon2.next$access$1();
                if ("--resourcesFile".equals(string) && list7 instanceof .colon.colon) {
                    .colon.colon colon8 = (.colon.colon)list7;
                    String value = (String)colon8.head();
                    List tail = colon8.next$access$1();
                    resourcesFileOpt = new Some((Object)value);
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list8 = colon2.next$access$1();
                if ("--app-id".equals(string) && list8 instanceof .colon.colon) {
                    .colon.colon colon9 = (.colon.colon)list8;
                    String value = (String)colon9.head();
                    List tail = colon9.next$access$1();
                    appId = value;
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list9 = colon2.next$access$1();
                if ("--worker-url".equals(string) && list9 instanceof .colon.colon) {
                    .colon.colon colon10 = (.colon.colon)list9;
                    String value = (String)colon10.head();
                    List tail = colon10.next$access$1();
                    workerUrl = new Some((Object)value);
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list10 = colon2.next$access$1();
                if ("--resourceProfileId".equals(string) && list10 instanceof .colon.colon) {
                    .colon.colon colon11 = (.colon.colon)list10;
                    String value = (String)colon11.head();
                    List tail = colon11.next$access$1();
                    resourceProfileId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value));
                    argv = tail;
                    continue;
                }
            }
            if (Nil$.MODULE$.equals(list)) {
                continue;
            }
            System.err.println("Unrecognized options: " + list.mkString(" "));
            this.printUsageAndExit(classNameForEntry);
        }
        if (hostname == null) {
            hostname = Utils$.MODULE$.localHostName();
            this.log().info("Executor hostname is not provided, will use '" + hostname + "' to advertise itself");
        }
        if (driverUrl == null || executorId == null || cores <= 0 || appId == null) {
            this.printUsageAndExit(classNameForEntry);
        }
        if (bindAddress == null) {
            bindAddress = hostname;
        }
        return new CoarseGrainedExecutorBackend.Arguments(driverUrl, executorId, bindAddress, hostname, cores, appId, (Option<String>)workerUrl, (Option<String>)resourcesFileOpt, resourceProfileId);
    }

    private void printUsageAndExit(String classNameForEntry) {
        System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |Usage: " + classNameForEntry + " [options]\n      |\n      | Options are:\n      |   --driver-url <driverUrl>\n      |   --executor-id <executorId>\n      |   --bind-address <bindAddress>\n      |   --hostname <hostname>\n      |   --cores <cores>\n      |   --resourcesFile <fileWithJSONResourceInformation>\n      |   --app-id <appid>\n      |   --worker-url <workerUrl>\n      |   --resourceProfileId <id>\n      |")));
        System.exit(1);
    }

    public static final /* synthetic */ boolean $anonfun$run$10(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$run$12(SparkConf driverConf$1, byte[] tokens) {
        SparkHadoopUtil$.MODULE$.get().addDelegationTokens(tokens, driverConf$1);
    }

    public static final /* synthetic */ void $anonfun$run$14(SparkConf driverConf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            ExecutorResourceRequest request = (ExecutorResourceRequest)tuple2._2();
            String string2 = ResourceProfile$.MODULE$.OFFHEAP_MEM();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                driverConf$1.set(package$.MODULE$.MEMORY_OFFHEAP_SIZE().key(), Long.toString(request.amount()) + "m");
                MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Set executor off-heap memory to "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTOR_MEMORY_OFFHEAP$.MODULE$, (Object)request)})))));
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            ExecutorResourceRequest request = (ExecutorResourceRequest)tuple2._2();
            String string4 = ResourceProfile$.MODULE$.MEMORY();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                driverConf$1.set(package$.MODULE$.EXECUTOR_MEMORY().key(), Long.toString(request.amount()) + "m");
                MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Set executor memory to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTOR_MEMORY_SIZE$.MODULE$, (Object)request)}))));
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            ExecutorResourceRequest request = (ExecutorResourceRequest)tuple2._2();
            String string6 = ResourceProfile$.MODULE$.OVERHEAD_MEM();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                driverConf$1.set(package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD().key(), Long.toString(request.amount()) + "m");
                MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Set executor memory_overhead to "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTOR_MEMORY_OVERHEAD_SIZE$.MODULE$, (Object)request)})))));
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            ExecutorResourceRequest request = (ExecutorResourceRequest)tuple2._2();
            String string8 = ResourceProfile$.MODULE$.CORES();
            String string9 = string;
            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                driverConf$1.set(package$.MODULE$.EXECUTOR_CORES().key(), Long.toString(request.amount()));
                MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Set executor cores to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_EXECUTOR_CORES$.MODULE$, (Object)request)}))));
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$run$19(SparkEnv env$1, String attemptId) {
        env$1.blockManager().blockStoreClient().setAppAttemptId(attemptId);
    }

    private CoarseGrainedExecutorBackend$() {
    }
}

