/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rdd;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.ReliableCheckpointRDD;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.SerializableConfiguration$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class ReliableCheckpointRDD$
implements Logging,
Serializable {
    public static final ReliableCheckpointRDD$ MODULE$ = new ReliableCheckpointRDD$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <T> Option<Partitioner> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public String org$apache$spark$rdd$ReliableCheckpointRDD$$checkpointFileName(int partitionIndex) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("part-%05d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionIndex)}));
    }

    private String checkpointPartitionerFileName() {
        return "_partitioner";
    }

    public <T> ReliableCheckpointRDD<T> writeRDDToCheckpointDirectory(RDD<T> originalRDD, String checkpointDir, int blockSize, ClassTag<T> evidence$2) {
        long checkpointStartTimeNs = System.nanoTime();
        Path checkpointDirPath = new Path(checkpointDir);
        SparkContext sc = originalRDD.sparkContext();
        FileSystem fs = checkpointDirPath.getFileSystem(sc.hadoopConfiguration());
        if (!fs.mkdirs(checkpointDirPath)) {
            throw SparkCoreErrors$.MODULE$.failToCreateCheckpointPathError(checkpointDirPath);
        }
        Broadcast<SerializableConfiguration> broadcastedConf = SerializableConfiguration$.MODULE$.broadcast(sc);
        String string = checkpointDirPath.toString();
        int n = this.writePartitionToCheckpointFile$default$3();
        sc.runJob(originalRDD, (Function2 & Serializable)(ctx, iterator) -> {
            ReliableCheckpointRDD$.MODULE$.writePartitionToCheckpointFile(string, broadcastedConf, n, ctx, iterator, evidence$2);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.Unit());
        if (originalRDD.partitioner().nonEmpty()) {
            this.writePartitionerToCheckpointDir(sc, (Partitioner)originalRDD.partitioner().get(), checkpointDirPath);
        }
        long checkpointDurationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - checkpointStartTimeNs);
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpointing took ", " ms."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TOTAL_TIME$.MODULE$, (Object)BoxesRunTime.boxToLong((long)checkpointDurationMs))}))));
        ReliableCheckpointRDD<T> newRDD = new ReliableCheckpointRDD<T>(sc, checkpointDirPath.toString(), originalRDD.partitioner(), evidence$2);
        if (newRDD.partitions().length != originalRDD.partitions().length) {
            throw SparkCoreErrors$.MODULE$.checkpointRDDHasDifferentNumberOfPartitionsFromOriginalRDDError(originalRDD.id(), originalRDD.partitions().length, newRDD.id(), newRDD.partitions().length);
        }
        return newRDD;
    }

    public <T> int writeRDDToCheckpointDirectory$default$3() {
        return -1;
    }

    public <T> void writePartitionToCheckpointFile(String path, Broadcast<SerializableConfiguration> broadcastedConf, int blockSize, TaskContext ctx, Iterator<T> iterator, ClassTag<T> evidence$3) {
        Object object;
        SparkEnv env = SparkEnv$.MODULE$.get();
        Path outputDir = new Path(path);
        FileSystem fs = outputDir.getFileSystem(broadcastedConf.value().value());
        String finalOutputName = this.org$apache$spark$rdd$ReliableCheckpointRDD$$checkpointFileName(ctx.partitionId());
        Path finalOutputPath = new Path(outputDir, finalOutputName);
        Path tempOutputPath = new Path(outputDir, "." + finalOutputName + "-attempt-" + ctx.taskAttemptId());
        int bufferSize = BoxesRunTime.unboxToInt((Object)env.conf().get(package$.MODULE$.BUFFER_SIZE()));
        if (blockSize < 0) {
            FSDataOutputStream fileStream = fs.create(tempOutputPath, false, bufferSize);
            object = BoxesRunTime.unboxToBoolean((Object)env.conf().get(package$.MODULE$.CHECKPOINT_COMPRESS())) ? CompressionCodec$.MODULE$.createCodec(env.conf()).compressedOutputStream((OutputStream)fileStream) : fileStream;
        } else {
            object = fs.create(tempOutputPath, false, bufferSize, fs.getDefaultReplication(fs.getWorkingDirectory()), (long)blockSize);
        }
        FSDataOutputStream fileOutputStream = object;
        SerializerInstance serializer = env.serializer().newInstance();
        SerializationStream serializeStream = serializer.serializeStream((OutputStream)fileOutputStream);
        Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0 & Serializable)() -> serializeStream.writeAll(iterator, evidence$3), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            boolean deleted = fs.delete(tempOutputPath, false);
            if (!deleted) {
                MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete tempOutputPath ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TEMP_OUTPUT_PATH$.MODULE$, (Object)tempOutputPath)}))));
                return;
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> serializeStream.close());
        if (!fs.rename(tempOutputPath, finalOutputPath)) {
            if (!fs.exists(finalOutputPath)) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting tempOutputPath ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TEMP_OUTPUT_PATH$.MODULE$, (Object)tempOutputPath)}))));
                fs.delete(tempOutputPath, false);
                throw SparkCoreErrors$.MODULE$.checkpointFailedToSaveError(ctx.attemptNumber(), finalOutputPath);
            }
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Final output path"}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" ", " already exists; not overwriting it"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FINAL_OUTPUT_PATH$.MODULE$, (Object)finalOutputPath)})))));
            if (!fs.delete(tempOutputPath, false)) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)tempOutputPath)}))));
                return;
            }
            return;
        }
    }

    public <T> int writePartitionToCheckpointFile$default$3() {
        return -1;
    }

    private void writePartitionerToCheckpointDir(SparkContext sc, Partitioner partitioner, Path checkpointDirPath) {
        try {
            Path partitionerFilePath = new Path(checkpointDirPath, this.checkpointPartitionerFileName());
            int bufferSize = BoxesRunTime.unboxToInt((Object)sc.conf().get(package$.MODULE$.BUFFER_SIZE()));
            FileSystem fs = partitionerFilePath.getFileSystem(sc.hadoopConfiguration());
            FSDataOutputStream fileOutputStream = fs.create(partitionerFilePath, false, bufferSize);
            SerializerInstance serializer = SparkEnv$.MODULE$.get().serializer().newInstance();
            SerializationStream serializeStream = serializer.serializeStream((OutputStream)fileOutputStream);
            Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable)() -> serializeStream.writeObject(partitioner, ClassTag$.MODULE$.apply(Partitioner.class)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> serializeStream.close());
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Written partitioner to " + partitionerFilePath);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error writing partitioner ", " to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PARTITIONER$.MODULE$, (Object)partitioner)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)checkpointDirPath)})))));
            }
            throw throwable;
        }
    }

    public Option<Partitioner> org$apache$spark$rdd$ReliableCheckpointRDD$$readCheckpointedPartitionerFile(SparkContext sc, String checkpointDirPath) {
        None$ none$;
        try {
            int bufferSize = BoxesRunTime.unboxToInt((Object)sc.conf().get(package$.MODULE$.BUFFER_SIZE()));
            Path partitionerFilePath = new Path(checkpointDirPath, this.checkpointPartitionerFileName());
            FileSystem fs = partitionerFilePath.getFileSystem(sc.hadoopConfiguration());
            FSDataInputStream fileInputStream = fs.open(partitionerFilePath, bufferSize);
            SerializerInstance serializer = SparkEnv$.MODULE$.get().serializer().newInstance();
            Partitioner partitioner = (Partitioner)Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable)() -> {
                DeserializationStream deserializeStream = serializer.deserializeStream((InputStream)fileInputStream);
                return (Partitioner)Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable)() -> (Partitioner)deserializeStream.readObject(ClassTag$.MODULE$.apply(Partitioner.class)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> deserializeStream.close());
            }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> fileInputStream.close());
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Read partitioner from " + partitionerFilePath);
            none$ = new Some((Object)partitioner);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 instanceof FileNotFoundException) {
                FileNotFoundException fileNotFoundException = (FileNotFoundException)throwable3;
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "No partitioner file", (Throwable)fileNotFoundException);
                none$ = None$.MODULE$;
            }
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading partitioner from ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)checkpointDirPath)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partitioner will not be recovered which may lead to performance loss"}))).log((Seq)Nil$.MODULE$))), throwable2);
                none$ = None$.MODULE$;
            }
            throw throwable;
        }
        return none$;
    }

    public <T> Iterator<T> readCheckpointFile(Path path, Broadcast<SerializableConfiguration> broadcastedConf, TaskContext context2) {
        SparkEnv env = SparkEnv$.MODULE$.get();
        FileSystem fs = path.getFileSystem(broadcastedConf.value().value());
        int bufferSize = BoxesRunTime.unboxToInt((Object)env.conf().get(package$.MODULE$.BUFFER_SIZE()));
        FSDataInputStream fileStream = fs.open(path, bufferSize);
        FSDataInputStream fileInputStream = BoxesRunTime.unboxToBoolean((Object)env.conf().get(package$.MODULE$.CHECKPOINT_COMPRESS())) ? CompressionCodec$.MODULE$.createCodec(env.conf()).compressedInputStream((InputStream)fileStream) : fileStream;
        SerializerInstance serializer = env.serializer().newInstance();
        DeserializationStream deserializeStream = serializer.deserializeStream((InputStream)fileInputStream);
        context2.addTaskCompletionListener((Function1 & Serializable)context -> {
            deserializeStream.close();
            return BoxedUnit.UNIT;
        });
        return deserializeStream.asIterator();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ReliableCheckpointRDD$.class);
    }

    private ReliableCheckpointRDD$() {
    }
}

