/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005m4aa\u0005\u000b\u0002\u0002aq\u0002\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u000bE\u0002A\u0011\u0001\u001a\t\u000b\u0011\u0003a\u0011C#\t\u000b)\u0003a\u0011C&\t\u000b=\u0003A\u0011\u0003)\t\u000bQ\u0003A\u0011C+\t\rY\u0003\u0001\u0015!\u0003X\u0011\u0019Q\u0006\u0001)A\u0005#\"11\f\u0001Q\u0001\n]Ca\u0001\u0018\u0001!B\u00139\u0006BB1\u0001A\u0003&\u0011\u000b\u0003\u0004c\u0001\u0001\u0006Ka\u0016\u0005\rI\u0002!\t\u0011!B\u0001\u0002\u0003\u0006K!\u0015\u0005\u0006K\u0002!\tB\u001a\u0005\u0006\t\u0002!\tE\u001b\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0006c\u0002!\t!\u0016\u0005\u0006e\u0002!Ia\u001d\u0002\n'BLG\u000e\\1cY\u0016T!!\u0006\f\u0002\u0015\r|G\u000e\\3di&|gN\u0003\u0002\u00181\u0005!Q\u000f^5m\u0015\tI\"$A\u0003ta\u0006\u00148N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<WCA\u00108'\r\u0001\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0003Ga\ta!\\3n_JL\u0018BA\u0013#\u00059iU-\\8ss\u000e{gn];nKJ\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\r\u0002\u0011%tG/\u001a:oC2L!a\u000b\u0015\u0003\u000f1{wmZ5oO\u0006\tB/Y:l\u001b\u0016lwN]=NC:\fw-\u001a:\u0004\u0001A\u0011\u0011eL\u0005\u0003a\t\u0012\u0011\u0003V1tW6+Wn\u001c:z\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Q\u00111g\u0011\t\u0004i\u0001)T\"\u0001\u000b\u0011\u0005Y:D\u0002\u0001\u0003\u0006q\u0001\u0011\r!\u000f\u0002\u0002\u0007F\u0011!\b\u0011\t\u0003wyj\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\b\u001d>$\b.\u001b8h!\tY\u0014)\u0003\u0002Cy\t\u0019\u0011I\\=\t\u000b1\u0012\u0001\u0019\u0001\u0018\u0002\u000bM\u0004\u0018\u000e\u001c7\u0015\u0005\u0019K\u0005CA\u001eH\u0013\tAEH\u0001\u0003V]&$\b\"B\u000b\u0004\u0001\u0004)\u0014A\u00034pe\u000e,7\u000b]5mYR\tA\n\u0005\u0002<\u001b&\u0011a\n\u0010\u0002\b\u0005>|G.Z1o\u00031)G.Z7f]R\u001c(+Z1e+\u0005\t\u0006CA\u001eS\u0013\t\u0019FHA\u0002J]R\fq\"\u00193e\u000b2,W.\u001a8ugJ+\u0017\r\u001a\u000b\u0002\r\u00061\u0012N\\5uS\u0006dW*Z7pef$\u0006N]3tQ>dG\r\u0005\u0002<1&\u0011\u0011\f\u0010\u0002\u0005\u0019>tw-\u0001\u0010ok6,E.Z7f]R\u001chi\u001c:dKN\u0003\u0018\u000e\u001c7UQJ,7\u000f[8mI\u0006QR.\u0019=TSj,gi\u001c:dKN\u0003\u0018\u000e\u001c7UQJ,7\u000f[8mI\u0006\tR._'f[>\u0014\u0018\u0010\u00165sKNDw\u000e\u001c3)\u0005)q\u0006CA\u001e`\u0013\t\u0001GH\u0001\u0005w_2\fG/\u001b7f\u00035yV\r\\3nK:$8OU3bI\u0006\u0019r,\\3n_JL()\u001f;fgN\u0003\u0018\u000e\u001c7fI\"\u0012ABX\u00018_J<G%\u00199bG\",Ge\u001d9be.$S\u000f^5mI\r|G\u000e\\3di&|g\u000eJ*qS2d\u0017M\u00197fI\u0011z6\u000f]5mY\u000e{WO\u001c;\u0002\u00155\f\u0017PY3Ta&dG\u000eF\u0002MO\"DQ!\u0006\bA\u0002UBQ!\u001b\bA\u0002]\u000bQbY;se\u0016tG/T3n_JLHcA,l[\")An\u0004a\u0001/\u0006!1/\u001b>f\u0011\u0015qw\u00021\u0001!\u0003\u001d!(/[4hKJ\f!#\\3n_JL()\u001f;fgN\u0003\u0018\u000e\u001c7fIV\tq+A\u0007sK2,\u0017m]3NK6|'/_\u0001\fY><7\u000b]5mY\u0006<W\rF\u0002GiVDQ\u0001\u001c\nA\u0002]CQA\u001e\nA\u0002E\u000b\u0001\"\u001a7f[\u0016tGo\u001d\u0015\u0003%a\u0004\"aO=\n\u0005id$AB5oY&tW\r")
public abstract class Spillable<C>
extends MemoryConsumer
implements Logging {
    private final TaskMemoryManager taskMemoryManager;
    private final long initialMemoryThreshold;
    private final int numElementsForceSpillThreshold;
    private final long maxSizeForceSpillThreshold;
    private volatile long myMemoryThreshold;
    private int _elementsRead;
    private volatile long _memoryBytesSpilled;
    public int org$apache$spark$util$collection$Spillable$$_spillCount;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract void spill(C var1);

    public abstract boolean forceSpill();

    public int elementsRead() {
        return this._elementsRead;
    }

    public void addElementsRead() {
        ++this._elementsRead;
    }

    public boolean maybeSpill(C collection, long currentMemory) {
        boolean shouldSpill;
        block4: {
            if (this._elementsRead > this.numElementsForceSpillThreshold || currentMemory > this.maxSizeForceSpillThreshold) {
                v0 = true;
            } else if (this._elementsRead % 32 == 0 && currentMemory >= this.myMemoryThreshold) {
                long amountToRequest = 2L * currentMemory - this.myMemoryThreshold;
                long granted = this.acquireMemory(amountToRequest);
                this.myMemoryThreshold += granted;
                v0 = currentMemory >= this.myMemoryThreshold;
            } else {
                v0 = shouldSpill = false;
            }
            if (!shouldSpill) break block4;
            ++this.org$apache$spark$util$collection$Spillable$$_spillCount;
            this.logSpillage(currentMemory, this._elementsRead);
            this.spill(collection);
            this._elementsRead = 0;
            this._memoryBytesSpilled += currentMemory;
            this.releaseMemory();
        }
        return shouldSpill;
    }

    @Override
    public long spill(long size, MemoryConsumer trigger) {
        MemoryConsumer memoryConsumer = trigger;
        Spillable spillable = this;
        if (memoryConsumer == null ? spillable != null : !memoryConsumer.equals(spillable)) {
            MemoryMode memoryMode = this.taskMemoryManager.getTungstenMemoryMode();
            MemoryMode memoryMode2 = MemoryMode.ON_HEAP;
            if (!(memoryMode != null ? !memoryMode.equals(memoryMode2) : memoryMode2 != null)) {
                boolean isSpilled = this.forceSpill();
                if (!isSpilled) {
                    return 0L;
                }
                long freeMemory = this.myMemoryThreshold - this.initialMemoryThreshold;
                this._memoryBytesSpilled += freeMemory;
                this.releaseMemory();
                return freeMemory;
            }
        }
        return 0L;
    }

    public long memoryBytesSpilled() {
        return this._memoryBytesSpilled;
    }

    public void releaseMemory() {
        this.freeMemory(this.myMemoryThreshold - this.initialMemoryThreshold);
        this.myMemoryThreshold = this.initialMemoryThreshold;
    }

    private void logSpillage(long size, int elements) {
        long threadId = Thread.currentThread().getId();
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Thread ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.THREAD_ID$.MODULE$, (Object)BoxesRunTime.boxToLong((long)threadId))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spilling in-memory map of ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BYTE_SIZE$.MODULE$, (Object)Utils$.MODULE$.bytesToString(size))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(elements: ", ") to disk "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_ELEMENTS_SPILL_RECORDS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)elements))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(", " times so far)"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_SPILLS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)$this.org$apache$spark$util$collection$Spillable$$_spillCount))})))));
    }

    public Spillable(TaskMemoryManager taskMemoryManager) {
        this.taskMemoryManager = taskMemoryManager;
        super(taskMemoryManager, MemoryMode.ON_HEAP);
        Logging.$init$((Logging)this);
        this.initialMemoryThreshold = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.SHUFFLE_SPILL_INITIAL_MEM_THRESHOLD()));
        this.numElementsForceSpillThreshold = BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.SHUFFLE_SPILL_NUM_ELEMENTS_FORCE_SPILL_THRESHOLD()));
        this.maxSizeForceSpillThreshold = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.SHUFFLE_SPILL_MAX_SIZE_FORCE_SPILL_THRESHOLD()));
        this.myMemoryThreshold = this.initialMemoryThreshold;
        this._elementsRead = 0;
        this._memoryBytesSpilled = 0L;
        this.org$apache$spark$util$collection$Spillable$$_spillCount = 0;
    }
}

