/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes;

import coursierapi.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.Document;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.EntitiesData;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.parser.CharacterReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;

public class Entities {
    private static final char[] codeDelims = new char[]{',', ';'};
    private static final HashMap<String, String> multipoints = new HashMap();
    private static final ArrayList<String> baseSorted = new ArrayList(106);
    private static final ThreadLocal<char[]> charBuf = ThreadLocal.withInitial(() -> new char[2]);
    private static final ThreadLocal<CharsetEncoder> LocalEncoder = new ThreadLocal();

    public static boolean isNamedEntity(String name) {
        return EscapeMode.extended.codepointForName(name) != -1;
    }

    public static boolean isBaseNamedEntity(String name) {
        return EscapeMode.base.codepointForName(name) != -1;
    }

    public static int codepointsForName(String name, int[] codepoints) {
        String val = multipoints.get(name);
        if (val != null) {
            codepoints[0] = val.codePointAt(0);
            codepoints[1] = val.codePointAt(1);
            return 2;
        }
        int codepoint = EscapeMode.extended.codepointForName(name);
        if (codepoint != -1) {
            codepoints[0] = codepoint;
            return 1;
        }
        return 0;
    }

    public static String findPrefix(String input) {
        for (String name : baseSorted) {
            if (!input.startsWith(name)) continue;
            return name;
        }
        return "";
    }

    static void escape(Appendable accum2, String data, Document.OutputSettings out, int options) throws IOException {
        Entities.doEscape(data, accum2, out.escapeMode(), out.syntax(), out.charset(), options);
    }

    private static void doEscape(String data, Appendable accum2, EscapeMode mode, Document.OutputSettings.Syntax syntax, Charset charset, int options) throws IOException {
        int codePoint;
        CoreCharset coreCharset = CoreCharset.byName(charset.name());
        CharsetEncoder fallback = Entities.encoderFor(charset);
        int length = data.length();
        boolean lastWasWhite = false;
        boolean reachedNonWhite = false;
        boolean skipped = false;
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = data.codePointAt(offset);
            if ((options & 4) != 0) {
                if (StringUtil.isWhitespace(codePoint)) {
                    if ((options & 8) != 0 && !reachedNonWhite || lastWasWhite) continue;
                    if ((options & 0x10) != 0) {
                        skipped = true;
                        continue;
                    }
                    accum2.append(' ');
                    lastWasWhite = true;
                    continue;
                }
                lastWasWhite = false;
                reachedNonWhite = true;
                if (skipped) {
                    accum2.append(' ');
                    skipped = false;
                }
            }
            Entities.appendEscaped(codePoint, accum2, options, mode, syntax, coreCharset, fallback);
        }
    }

    private static void appendEscaped(int codePoint, Appendable accum2, int options, EscapeMode escapeMode, Document.OutputSettings.Syntax syntax, CoreCharset coreCharset, CharsetEncoder fallback) throws IOException {
        char c = (char)codePoint;
        if (codePoint < 65536) {
            switch (c) {
                case '&': {
                    accum2.append("&amp;");
                    break;
                }
                case '\u00a0': {
                    Entities.appendNbsp(accum2, escapeMode);
                    break;
                }
                case '<': {
                    Entities.appendLt(accum2, options, escapeMode, syntax);
                    break;
                }
                case '>': {
                    if ((options & 1) != 0) {
                        accum2.append("&gt;");
                        break;
                    }
                    accum2.append(c);
                    break;
                }
                case '\"': {
                    if ((options & 2) != 0) {
                        accum2.append("&quot;");
                        break;
                    }
                    accum2.append(c);
                    break;
                }
                case '\'': {
                    Entities.appendApos(accum2, options, escapeMode);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    accum2.append(c);
                    break;
                }
                default: {
                    if (c < ' ' || !Entities.canEncode(coreCharset, c, fallback)) {
                        Entities.appendEncoded(accum2, escapeMode, codePoint);
                        break;
                    }
                    accum2.append(c);
                    break;
                }
            }
        } else if (Entities.canEncode(coreCharset, c, fallback)) {
            char[] chars = charBuf.get();
            int len = Character.toChars(codePoint, chars, 0);
            if (accum2 instanceof StringBuilder) {
                ((StringBuilder)accum2).append(chars, 0, len);
            } else {
                accum2.append(new String(chars, 0, len));
            }
        } else {
            Entities.appendEncoded(accum2, escapeMode, codePoint);
        }
    }

    private static void appendNbsp(Appendable accum2, EscapeMode escapeMode) throws IOException {
        if (escapeMode != EscapeMode.xhtml) {
            accum2.append("&nbsp;");
        } else {
            accum2.append("&#xa0;");
        }
    }

    private static void appendLt(Appendable accum2, int options, EscapeMode escapeMode, Document.OutputSettings.Syntax syntax) throws IOException {
        if ((options & 1) != 0 || escapeMode == EscapeMode.xhtml || syntax == Document.OutputSettings.Syntax.xml) {
            accum2.append("&lt;");
        } else {
            accum2.append('<');
        }
    }

    private static void appendApos(Appendable accum2, int options, EscapeMode escapeMode) throws IOException {
        if ((options & 2) != 0 && (options & 1) != 0) {
            if (escapeMode == EscapeMode.xhtml) {
                accum2.append("&#x27;");
            } else {
                accum2.append("&apos;");
            }
        } else {
            accum2.append('\'');
        }
    }

    private static void appendEncoded(Appendable accum2, EscapeMode escapeMode, int codePoint) throws IOException {
        String name = escapeMode.nameForCodepoint(codePoint);
        if (!"".equals(name)) {
            accum2.append('&').append(name).append(';');
        } else {
            accum2.append("&#x").append(Integer.toHexString(codePoint)).append(';');
        }
    }

    private static boolean canEncode(CoreCharset charset, char c, CharsetEncoder fallback) {
        switch (charset) {
            case ascii: {
                return c < '\u0080';
            }
            case utf: {
                return c < '\ud800' || c >= '\ue000';
            }
        }
        return fallback.canEncode(c);
    }

    private static CharsetEncoder encoderFor(Charset charset) {
        CharsetEncoder encoder = LocalEncoder.get();
        if (encoder == null || !encoder.charset().equals(charset)) {
            encoder = charset.newEncoder();
            LocalEncoder.set(encoder);
        }
        return encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(EscapeMode e, String pointsData, int size) {
        EscapeMode.access$202(e, new String[size]);
        EscapeMode.access$302(e, new int[size]);
        EscapeMode.access$402(e, new int[size]);
        EscapeMode.access$502(e, new String[size]);
        int i = 0;
        try (CharacterReader reader = new CharacterReader(pointsData);){
            while (!reader.isEmpty()) {
                int cp2;
                String name = reader.consumeTo('=');
                reader.advance();
                int cp1 = Integer.parseInt(reader.consumeToAny(codeDelims), 36);
                char codeDelim = reader.current();
                reader.advance();
                if (codeDelim == ',') {
                    cp2 = Integer.parseInt(reader.consumeTo(';'), 36);
                    reader.advance();
                } else {
                    cp2 = -1;
                }
                String indexS = reader.consumeTo('&');
                int index = Integer.parseInt(indexS, 36);
                reader.advance();
                ((EscapeMode)e).nameKeys[i] = name;
                ((EscapeMode)e).codeVals[i] = cp1;
                ((EscapeMode)e).codeKeys[index] = cp1;
                ((EscapeMode)e).nameVals[index] = name;
                if (cp2 != -1) {
                    multipoints.put(name, new String(new int[]{cp1, cp2}, 0, 2));
                }
                ++i;
            }
            Validate.isTrue(i == size, "Unexpected count of entities loaded");
        }
    }

    public static final class EscapeMode
    extends Enum<EscapeMode> {
        public static final /* enum */ EscapeMode xhtml = new EscapeMode(EntitiesData.xmlPoints, 4);
        public static final /* enum */ EscapeMode base = new EscapeMode(EntitiesData.basePoints, 106);
        public static final /* enum */ EscapeMode extended = new EscapeMode(EntitiesData.fullPoints, 2125);
        private String[] nameKeys;
        private int[] codeVals;
        private int[] codeKeys;
        private String[] nameVals;
        private static final /* synthetic */ EscapeMode[] $VALUES;

        public static EscapeMode valueOf(String name) {
            return Enum.valueOf(EscapeMode.class, name);
        }

        private EscapeMode(String file, int size) {
            Entities.load(this, file, size);
        }

        int codepointForName(String name) {
            int index = Arrays.binarySearch(this.nameKeys, name);
            return index >= 0 ? this.codeVals[index] : -1;
        }

        String nameForCodepoint(int codepoint) {
            int index = Arrays.binarySearch(this.codeKeys, codepoint);
            if (index >= 0) {
                return index < this.nameVals.length - 1 && this.codeKeys[index + 1] == codepoint ? this.nameVals[index + 1] : this.nameVals[index];
            }
            return "";
        }

        private static /* synthetic */ EscapeMode[] $values() {
            return new EscapeMode[]{xhtml, base, extended};
        }

        static /* synthetic */ String[] access$202(EscapeMode x0, String[] x1) {
            x0.nameKeys = x1;
            return x1;
        }

        static /* synthetic */ int[] access$302(EscapeMode x0, int[] x1) {
            x0.codeVals = x1;
            return x1;
        }

        static /* synthetic */ int[] access$402(EscapeMode x0, int[] x1) {
            x0.codeKeys = x1;
            return x1;
        }

        static /* synthetic */ String[] access$502(EscapeMode x0, String[] x1) {
            x0.nameVals = x1;
            return x1;
        }

        static {
            $VALUES = EscapeMode.$values();
            Collections.addAll(baseSorted, EscapeMode.base.nameKeys);
            baseSorted.sort((a, b) -> b.length() - a.length());
        }
    }

    static final class CoreCharset
    extends Enum<CoreCharset> {
        public static final /* enum */ CoreCharset ascii = new CoreCharset();
        public static final /* enum */ CoreCharset utf = new CoreCharset();
        public static final /* enum */ CoreCharset fallback = new CoreCharset();
        private static final /* synthetic */ CoreCharset[] $VALUES;

        public static CoreCharset[] values() {
            return (CoreCharset[])$VALUES.clone();
        }

        static CoreCharset byName(String name) {
            if (name.equals("US-ASCII")) {
                return ascii;
            }
            if (name.startsWith("UTF-")) {
                return utf;
            }
            return fallback;
        }

        private static /* synthetic */ CoreCharset[] $values() {
            return new CoreCharset[]{ascii, utf, fallback};
        }

        static {
            $VALUES = CoreCharset.$values();
        }
    }
}

