/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.FMRegressorWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.regression.FMRegressor;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class FMRegressorWrapper$
implements MLReadable<FMRegressorWrapper> {
    public static final FMRegressorWrapper$ MODULE$ = new FMRegressorWrapper$();

    static {
        MLReadable.$init$(MODULE$);
    }

    @Override
    public Object load(String path) {
        return MLReadable.load$(this, path);
    }

    public FMRegressorWrapper fit(Dataset<Row> data, String formula, int factorSize, boolean fitLinear, double regParam, double miniBatchFraction, double initStd, int maxIter, double stepSize, double tol, String solver, String seed, String stringIndexerOrderType) {
        RFormula rFormula = new RFormula().setFormula(formula).setStringIndexerOrderType(stringIndexerOrderType);
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        boolean fitIntercept = rFormula.hasIntercept();
        StructType schema = ((RFormulaModel)rFormulaModel).transform(data).schema();
        Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(((RFormulaModel)rFormulaModel).getFeaturesCol())).attributes().get();
        String[] features = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])featureAttrs), (Function1 & Serializable)x$1 -> (String)x$1.name().get(), ClassTag$.MODULE$.apply(String.class));
        FMRegressor fmr = (FMRegressor)new FMRegressor().setFactorSize(factorSize).setFitIntercept(fitIntercept).setFitLinear(fitLinear).setRegParam(regParam).setMiniBatchFraction(miniBatchFraction).setInitStd(initStd).setMaxIter(maxIter).setStepSize(stepSize).setTol(tol).setSolver(solver).setFeaturesCol(rFormula.getFeaturesCol());
        Object object = seed != null && seed.length() > 0 ? fmr.setSeed(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(seed))) : BoxedUnit.UNIT;
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, fmr})).fit((Dataset)data);
        return new FMRegressorWrapper((PipelineModel)pipeline, features);
    }

    @Override
    public MLReader<FMRegressorWrapper> read() {
        return new FMRegressorWrapper.FMRegressorWrapperReader();
    }

    private FMRegressorWrapper$() {
    }
}

