/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfDoublesSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfNumbersSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArrayOfDecimalsSerDe;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopK;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class ApproxTopK$
implements Serializable {
    public static final ApproxTopK$ MODULE$ = new ApproxTopK$();
    private static final int DEFAULT_K = 5;
    private static final int DEFAULT_MAX_ITEMS_TRACKED = 10000;
    private static final int MAX_ITEMS_TRACKED_LIMIT = 1000000;
    private static final int VOID_MAX_ITEMS_TRACKED = -1;

    public int $lessinit$greater$default$4() {
        return 0;
    }

    public int $lessinit$greater$default$5() {
        return 0;
    }

    public int DEFAULT_K() {
        return DEFAULT_K;
    }

    public int DEFAULT_MAX_ITEMS_TRACKED() {
        return DEFAULT_MAX_ITEMS_TRACKED;
    }

    public int MAX_ITEMS_TRACKED_LIMIT() {
        return MAX_ITEMS_TRACKED_LIMIT;
    }

    public int VOID_MAX_ITEMS_TRACKED() {
        return VOID_MAX_ITEMS_TRACKED;
    }

    public void checkExpressionNotNull(Expression expr, String exprName) {
        if (expr == null || expr.eval(expr.eval$default$1()) == null) {
            throw QueryExecutionErrors$.MODULE$.approxTopKNullArg(exprName);
        }
    }

    public void checkK(int k) {
        if (k <= 0) {
            throw QueryExecutionErrors$.MODULE$.approxTopKNonPositiveValue("k", k);
        }
    }

    public void checkMaxItemsTracked(int maxItemsTracked) {
        if (maxItemsTracked > this.MAX_ITEMS_TRACKED_LIMIT()) {
            throw QueryExecutionErrors$.MODULE$.approxTopKMaxItemsTrackedExceedsLimit(maxItemsTracked, this.MAX_ITEMS_TRACKED_LIMIT());
        }
        if (maxItemsTracked <= 0) {
            throw QueryExecutionErrors$.MODULE$.approxTopKNonPositiveValue("maxItemsTracked", maxItemsTracked);
        }
    }

    public void checkMaxItemsTracked(int maxItemsTracked, int k) {
        this.checkMaxItemsTracked(maxItemsTracked);
        if (maxItemsTracked < k) {
            throw QueryExecutionErrors$.MODULE$.approxTopKMaxItemsTrackedLessThanK(maxItemsTracked, k);
        }
    }

    public DataType getResultDataType(DataType itemDataType) {
        StructField structField = new StructField("item", itemDataType, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("count", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructType resultEntryType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
        return new ArrayType((DataType)resultEntryType, false);
    }

    public boolean isDataTypeSupported(DataType itemType) {
        DataType dataType = itemType;
        return dataType instanceof BooleanType ? true : (dataType instanceof ByteType ? true : (dataType instanceof ShortType ? true : (dataType instanceof IntegerType ? true : (dataType instanceof LongType ? true : (dataType instanceof FloatType ? true : (dataType instanceof DoubleType ? true : (dataType instanceof DateType ? true : (dataType instanceof TimestampType ? true : (dataType instanceof TimestampNTZType ? true : (dataType instanceof StringType ? true : dataType instanceof DecimalType))))))))));
    }

    public int calMaxMapSize(int maxItemsTracked) {
        int ceilMaxMapSize = (int)package$.MODULE$.ceil((double)maxItemsTracked / 0.75);
        return (int)package$.MODULE$.pow(2.0, package$.MODULE$.ceil(package$.MODULE$.log((double)ceilMaxMapSize) / package$.MODULE$.log(2.0)));
    }

    public ItemsSketch<Object> createItemsSketch(Expression itemExpression, int maxMapSize) {
        DataType dataType = itemExpression.dataType();
        if (dataType instanceof BooleanType) {
            return new ItemsSketch(maxMapSize);
        }
        if (dataType instanceof ByteType ? true : (dataType instanceof ShortType ? true : (dataType instanceof IntegerType ? true : (dataType instanceof FloatType ? true : dataType instanceof DateType)))) {
            return new ItemsSketch(maxMapSize);
        }
        if (dataType instanceof LongType ? true : (dataType instanceof TimestampType ? true : dataType instanceof TimestampNTZType)) {
            return new ItemsSketch(maxMapSize);
        }
        if (dataType instanceof DoubleType) {
            return new ItemsSketch(maxMapSize);
        }
        if (dataType instanceof StringType) {
            return new ItemsSketch(maxMapSize);
        }
        if (dataType instanceof DecimalType) {
            return new ItemsSketch(maxMapSize);
        }
        throw new MatchError((Object)dataType);
    }

    public ArrayOfItemsSerDe<Object> genSketchSerDe(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof BooleanType) {
            return new ArrayOfBooleansSerDe();
        }
        if (dataType2 instanceof ByteType ? true : (dataType2 instanceof ShortType ? true : (dataType2 instanceof IntegerType ? true : (dataType2 instanceof FloatType ? true : dataType2 instanceof DateType)))) {
            return new ArrayOfNumbersSerDe();
        }
        if (dataType2 instanceof LongType ? true : (dataType2 instanceof TimestampType ? true : dataType2 instanceof TimestampNTZType)) {
            return new ArrayOfLongsSerDe();
        }
        if (dataType2 instanceof DoubleType) {
            return new ArrayOfDoublesSerDe();
        }
        if (dataType2 instanceof StringType) {
            return new ArrayOfStringsSerDe();
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return new ArrayOfDecimalsSerDe(decimalType);
        }
        throw new MatchError((Object)dataType2);
    }

    public StructType getSketchStateDataType(DataType itemDataType) {
        StructField structField = new StructField("sketch", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("maxItemsTracked", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("itemDataType", itemDataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("itemDataTypeDDL", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        return StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
    }

    public String dataTypeToDDL(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof StringType) {
            return "item string not null";
        }
        return new StructField("item", dataType2, false, StructField$.MODULE$.apply$default$4()).toDDL();
    }

    public DataType DDLToDataType(String ddl) {
        return ((StructField)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])StructType$.MODULE$.fromDDL(ddl).fields()))).dataType();
    }

    public TypeCheckResult checkStateFieldAndType(Expression state) {
        StructType stateStructType = (StructType)state.dataType();
        if (stateStructType.length() != 4) {
            return new TypeCheckResult.TypeCheckFailure("State must be a struct with 4 fields. Expected struct: struct<sketch:binary,maxItemsTracked:int,itemDataType:any,itemDataTypeDDL:string>. Got: " + state.dataType().simpleString());
        }
        DataType fieldType1 = ((StructField)stateStructType.head()).dataType();
        DataType fieldType2 = stateStructType.apply(1).dataType();
        DataType fieldType3 = stateStructType.apply(2).dataType();
        DataType fieldType4 = stateStructType.apply(3).dataType();
        DataType dataType = fieldType1;
        BinaryType$ binaryType$ = BinaryType$.MODULE$;
        if (dataType == null ? binaryType$ != null : !dataType.equals(binaryType$)) {
            return new TypeCheckResult.TypeCheckFailure("State struct must have the first field to be binary. Got: " + fieldType1.simpleString());
        }
        DataType dataType2 = fieldType2;
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        if (dataType2 == null ? integerType$ != null : !dataType2.equals(integerType$)) {
            return new TypeCheckResult.TypeCheckFailure("State struct must have the second field to be int. Got: " + fieldType2.simpleString());
        }
        if (!this.isDataTypeSupported(fieldType3)) {
            return new TypeCheckResult.TypeCheckFailure("State struct must have the third field to be a supported data type. Got: " + fieldType3.simpleString());
        }
        DataType dataType3 = fieldType4;
        StringType$ stringType$ = StringType$.MODULE$;
        if (dataType3 == null ? stringType$ != null : !dataType3.equals(stringType$)) {
            return new TypeCheckResult.TypeCheckFailure("State struct must have the fourth field to be string. Got: " + fieldType4.simpleString());
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    public ApproxTopK apply(Expression expr, Expression k, Expression maxItemsTracked, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproxTopK(expr, k, maxItemsTracked, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public int apply$default$4() {
        return 0;
    }

    public int apply$default$5() {
        return 0;
    }

    public Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproxTopK x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)x$0.expr(), (Object)x$0.k(), (Object)x$0.maxItemsTracked(), (Object)BoxesRunTime.boxToInteger((int)x$0.mutableAggBufferOffset()), (Object)BoxesRunTime.boxToInteger((int)x$0.inputAggBufferOffset())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ApproxTopK$.class);
    }

    private ApproxTopK$() {
    }
}

