/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import java.util.Map;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;

final class BufferHolder {
    private static final int ARRAY_MAX = 0x7FFFFFF0;
    private byte[] buffer;
    private int cursor = Platform.BYTE_ARRAY_OFFSET;
    private final UnsafeRow row;
    private final int fixedSize;

    BufferHolder(UnsafeRow row) {
        this(row, 64);
    }

    BufferHolder(UnsafeRow row, int initialSize) {
        int bitsetWidthInBytes = UnsafeRow.calculateBitSetWidthInBytes(row.numFields());
        if (row.numFields() > (0x7FFFFFF0 - initialSize - bitsetWidthInBytes) / 8) {
            throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3130", Map.of("numFields", String.valueOf(row.numFields())));
        }
        this.fixedSize = bitsetWidthInBytes + 8 * row.numFields();
        int roundedSize = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)(this.fixedSize + initialSize));
        this.buffer = new byte[roundedSize];
        this.row = row;
        this.row.pointTo(this.buffer, this.buffer.length);
    }

    void grow(int neededSize) {
        if (neededSize < 0) {
            throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3198", Map.of("neededSize", String.valueOf(neededSize)));
        }
        if (neededSize > 0x7FFFFFF0 - this.totalSize()) {
            throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3199", Map.of("neededSize", String.valueOf(neededSize), "arrayMax", String.valueOf(0x7FFFFFF0)));
        }
        int length = this.totalSize() + neededSize;
        if (this.buffer.length < length) {
            int newLength = length < 0x3FFFFFF8 ? length * 2 : 0x7FFFFFF0;
            int roundedSize = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)newLength);
            byte[] tmp = new byte[roundedSize];
            Platform.copyMemory((Object)this.buffer, (long)Platform.BYTE_ARRAY_OFFSET, (Object)tmp, (long)Platform.BYTE_ARRAY_OFFSET, (long)this.totalSize());
            this.buffer = tmp;
            this.row.pointTo(this.buffer, this.buffer.length);
        }
    }

    byte[] getBuffer() {
        return this.buffer;
    }

    int getCursor() {
        return this.cursor;
    }

    void increaseCursor(int val) {
        this.cursor += val;
    }

    void reset() {
        this.cursor = Platform.BYTE_ARRAY_OFFSET + this.fixedSize;
    }

    int totalSize() {
        return this.cursor - Platform.BYTE_ARRAY_OFFSET;
    }
}

