/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HouseKeeperService;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HouseKeeperServiceBase
implements HouseKeeperService {
    private static final Logger LOG = LoggerFactory.getLogger(HouseKeeperServiceBase.class);
    private ScheduledExecutorService pool = null;
    protected final AtomicInteger isAliveCounter = new AtomicInteger(Integer.MIN_VALUE);
    protected HiveConf hiveConf;

    public void start(HiveConf hiveConf) throws Exception {
        this.hiveConf = hiveConf;
        HiveTxnManager mgr = TxnManagerFactory.getTxnManagerFactory().getTxnManager(hiveConf);
        if (!mgr.supportsAcid()) {
            LOG.info(this.getClass().getName() + " not started since " + mgr.getClass().getName() + " does not support Acid.");
            return;
        }
        this.pool = Executors.newScheduledThreadPool(1, new ThreadFactory(){
            private final AtomicInteger threadCounter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, HouseKeeperServiceBase.this.getClass().getName() + "-" + this.threadCounter.getAndIncrement());
            }
        });
        TimeUnit tu = TimeUnit.MILLISECONDS;
        this.pool.scheduleAtFixedRate(this.getScheduedAction(hiveConf, this.isAliveCounter), this.getStartDelayMs(), this.getIntervalMs(), tu);
        LOG.info("Started " + this.getClass().getName() + " with delay/interval = " + this.getStartDelayMs() + "/" + this.getIntervalMs() + " " + (Object)((Object)tu));
    }

    public void stop() {
        if (this.pool != null && !this.pool.isShutdown()) {
            this.pool.shutdown();
        }
        this.pool = null;
    }

    public int getIsAliveCounter() {
        return this.isAliveCounter.get();
    }

    protected abstract long getStartDelayMs();

    protected abstract long getIntervalMs();

    protected abstract Runnable getScheduedAction(HiveConf var1, AtomicInteger var2);
}

