/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.Serializable;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.UnresolvedAttribute$;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class MetadataUtils$ {
    public static final MetadataUtils$ MODULE$ = new MetadataUtils$();

    public Option<Object> getNumClasses(StructField labelSchema) {
        Attribute attribute = Attribute$.MODULE$.fromStructField(labelSchema);
        if (attribute instanceof BinaryAttribute) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)2));
        }
        if (attribute instanceof NominalAttribute) {
            NominalAttribute nominalAttribute = (NominalAttribute)attribute;
            return nominalAttribute.getNumValues();
        }
        if (attribute instanceof NumericAttribute ? true : UnresolvedAttribute$.MODULE$.equals(attribute)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)attribute);
    }

    public Option<Object> getNumFeatures(StructField vectorSchema) {
        DataType dataType = vectorSchema.dataType();
        VectorUDT vectorUDT = new VectorUDT();
        if (!(dataType != null ? !dataType.equals((Object)vectorUDT) : vectorUDT != null)) {
            AttributeGroup group = AttributeGroup$.MODULE$.fromStructField(vectorSchema);
            int size = group.size();
            if (size >= 0) {
                return new Some((Object)BoxesRunTime.boxToInteger((int)size));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Map<Object, Object> getCategoricalFeatures(StructField featuresSchema) {
        AttributeGroup metadata = AttributeGroup$.MODULE$.fromStructField(featuresSchema);
        if (metadata.attributes().isEmpty()) {
            return HashMap$.MODULE$.empty();
        }
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])metadata.attributes().get()))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Attribute attr = (Attribute)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (attr == null) {
                    return package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                }
                Attribute attribute = attr;
                if (attribute instanceof NumericAttribute ? true : UnresolvedAttribute$.MODULE$.equals(attribute)) {
                    return package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                }
                if (attribute instanceof BinaryAttribute) {
                    return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)idx)), (Object)BoxesRunTime.boxToInteger((int)2))}));
                }
                if (attribute instanceof NominalAttribute) {
                    NominalAttribute nominalAttribute = (NominalAttribute)attribute;
                    Option<Object> option = nominalAttribute.getNumValues();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int numValues = BoxesRunTime.unboxToInt((Object)some.value());
                        if (true) {
                            int n = numValues;
                            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)idx)), (Object)BoxesRunTime.boxToInteger((int)n))}));
                        }
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalArgumentException("Feature " + idx + " is marked as Nominal (categorical), but it does not have the number of values specified.");
                    }
                    throw new MatchError(option);
                }
                throw new MatchError((Object)attribute);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public int[] getFeatureIndicesFromNames(StructField col, String[] names) {
        Predef$.MODULE$.require(col.dataType() instanceof VectorUDT, (Function0 & Serializable)() -> "getFeatureIndicesFromNames expected column " + col + " to be Vector type, but it was type " + col.dataType() + " instead.");
        AttributeGroup inputAttr = AttributeGroup$.MODULE$.fromStructField(col);
        return (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])names), (Function1 & Serializable)name -> BoxesRunTime.boxToInteger((int)MetadataUtils$.$anonfun$getFeatureIndicesFromNames$2(inputAttr, col, name)), (ClassTag)ClassTag$.MODULE$.Int());
    }

    public static final /* synthetic */ int $anonfun$getFeatureIndicesFromNames$2(AttributeGroup inputAttr$1, StructField col$1, String name) {
        Predef$.MODULE$.require(inputAttr$1.hasAttr(name), (Function0 & Serializable)() -> "getFeatureIndicesFromNames found no feature with name " + name + " in column " + col$1 + ".");
        return BoxesRunTime.unboxToInt((Object)inputAttr$1.getAttr(name).index().get());
    }

    private MetadataUtils$() {
    }
}

