/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.security;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.Python$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00154QAD\b\u0001#]A\u0001B\b\u0001\u0003\u0006\u0004%\t\u0001\t\u0005\tK\u0001\u0011\t\u0011)A\u0005C!)a\u0005\u0001C\u0001O!91\u0006\u0001b\u0001\n\u0003a\u0003B\u0002\u0019\u0001A\u0003%Q\u0006\u0003\u00052\u0001!\u0015\r\u0011\"\u00013\u0011\u001dq\u0004A1A\u0005\u0002IBaa\u0010\u0001!\u0002\u0013\u0019\u0004\"\u0002!\u0001\t\u0003\t\u0005\"\u0002!\u0001\t\u0003\t\u0006\"\u0002.\u0001\t\u0003Y\u0006\"B/\u0001\t#q\u0006\"\u00021\u0001\t#\t'\u0001E*pG.,G/Q;uQ\"+G\u000e]3s\u0015\t\u0001\u0012#\u0001\u0005tK\u000e,(/\u001b;z\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7C\u0001\u0001\u0019!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fM\u0006!1m\u001c8g\u0007\u0001)\u0012!\t\t\u0003E\rj\u0011!E\u0005\u0003IE\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\u000b\r|gN\u001a\u0011\u0002\rqJg.\u001b;?)\tA#\u0006\u0005\u0002*\u00015\tq\u0002C\u0003\u001f\u0007\u0001\u0007\u0011%\u0001\tjgVs\u0017\u000e\u001f#p[\u0006LgnU8dWV\tQ\u0006\u0005\u0002\u001a]%\u0011qF\u0007\u0002\b\u0005>|G.Z1o\u0003EI7/\u00168jq\u0012{W.Y5o'>\u001c7\u000eI\u0001\bg>\u001c7\u000eR5s+\u0005\u0019\u0004C\u0001\u001b<\u001d\t)\u0014\b\u0005\u0002755\tqG\u0003\u00029?\u00051AH]8pizJ!A\u000f\u000e\u0002\rA\u0013X\rZ3g\u0013\taTH\u0001\u0004TiJLgn\u001a\u0006\u0003ui\taa]3de\u0016$\u0018aB:fGJ,G\u000fI\u0001\u000bCV$\bn\u00117jK:$HC\u0001\"F!\tI2)\u0003\u0002E5\t!QK\\5u\u0011\u00151\u0015\u00021\u0001H\u0003\u0019\u0019xnY6fiB\u0011\u0001jT\u0007\u0002\u0013*\u0011!jS\u0001\tG\"\fgN\\3mg*\u0011A*T\u0001\u0004]&|'\"\u0001(\u0002\t)\fg/Y\u0005\u0003!&\u0013QbU8dW\u0016$8\t[1o]\u0016dGC\u0001\"S\u0011\u0015\u0019&\u00021\u0001U\u0003\u0005\u0019\bCA+Y\u001b\u00051&BA,N\u0003\rqW\r^\u0005\u00033Z\u0013aaU8dW\u0016$\u0018\u0001D1vi\"$vnU3sm\u0016\u0014HC\u0001\"]\u0011\u001515\u00021\u0001H\u0003!\u0011X-\u00193Vi\u001aDDCA\u001a`\u0011\u0015\u0019F\u00021\u0001U\u0003%9(/\u001b;f+R4\u0007\bF\u0002CE\u0012DQaY\u0007A\u0002M\n1a\u001d;s\u0011\u0015\u0019V\u00021\u0001U\u0001")
public class SocketAuthHelper {
    private String sockDir;
    private final SparkConf conf;
    private final boolean isUnixDomainSock;
    private final String secret;
    private volatile boolean bitmap$0;

    public SparkConf conf() {
        return this.conf;
    }

    public boolean isUnixDomainSock() {
        return this.isUnixDomainSock;
    }

    private String sockDir$lzycompute() {
        SocketAuthHelper socketAuthHelper = this;
        synchronized (socketAuthHelper) {
            if (!this.bitmap$0) {
                this.sockDir = (String)((Option)this.conf().get(Python$.MODULE$.PYTHON_UNIX_DOMAIN_SOCKET_DIR())).getOrElse((Function0 & Serializable)() -> System.getProperty("java.io.tmpdir"));
                this.bitmap$0 = true;
            }
        }
        return this.sockDir;
    }

    public String sockDir() {
        if (!this.bitmap$0) {
            return this.sockDir$lzycompute();
        }
        return this.sockDir;
    }

    public String secret() {
        return this.secret;
    }

    public void authClient(SocketChannel socket) {
        if (this.isUnixDomainSock()) {
            return;
        }
        this.authClient(socket.socket());
    }

    public void authClient(Socket s) {
        block8: {
            boolean shouldClose = true;
            try {
                int currentTimeout = s.getSoTimeout();
                try {
                    s.setSoTimeout(10000);
                    String clientSecret = this.readUtf8(s);
                    String string = this.secret();
                    String string2 = clientSecret;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.writeUtf8("ok", s);
                        shouldClose = false;
                        break block8;
                    }
                    this.writeUtf8("err", s);
                    throw new IllegalArgumentException("Authentication failed.");
                }
                finally {
                    s.setSoTimeout(currentTimeout);
                }
            }
            finally {
                if (shouldClose) {
                    JavaUtils.closeQuietly((Closeable)s);
                }
            }
        }
    }

    public void authToServer(SocketChannel socket) {
        if (this.isUnixDomainSock()) {
            return;
        }
        Socket s = socket.socket();
        boolean shouldClose = true;
        try {
            String reply;
            this.writeUtf8(this.secret(), s);
            String string = reply = this.readUtf8(s);
            String string2 = "ok";
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new IllegalArgumentException("Authentication failed.");
            }
            shouldClose = false;
        }
        finally {
            if (shouldClose) {
                JavaUtils.closeQuietly((Closeable)s);
            }
        }
    }

    public String readUtf8(Socket s) {
        DataInputStream din = new DataInputStream(s.getInputStream());
        int len = din.readInt();
        byte[] bytes = new byte[len];
        din.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public void writeUtf8(String str, Socket s) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        DataOutputStream dout = new DataOutputStream(s.getOutputStream());
        dout.writeInt(bytes.length);
        dout.write(bytes, 0, bytes.length);
        dout.flush();
    }

    public SocketAuthHelper(SparkConf conf) {
        this.conf = conf;
        this.isUnixDomainSock = BoxesRunTime.unboxToBoolean((Object)conf.get(Python$.MODULE$.PYTHON_UNIX_DOMAIN_SOCKET_ENABLED()));
        this.secret = Utils$.MODULE$.createSecret(conf);
    }
}

