/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import java.util.Arrays;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;

final class HeapArrayOfDoublesSketchIterator
implements ArrayOfDoublesSketchIterator {
    private long[] keys_;
    private double[] values_;
    private int numValues_;
    private int i_;

    HeapArrayOfDoublesSketchIterator(long[] keys, double[] values, int numValues) {
        this.keys_ = keys;
        this.values_ = values;
        this.numValues_ = numValues;
        this.i_ = -1;
    }

    @Override
    public boolean next() {
        if (this.keys_ == null) {
            return false;
        }
        ++this.i_;
        while (this.i_ < this.keys_.length) {
            if (this.keys_[this.i_] != 0L) {
                return true;
            }
            ++this.i_;
        }
        return false;
    }

    @Override
    public long getKey() {
        return this.keys_[this.i_];
    }

    @Override
    public double[] getValues() {
        if (this.numValues_ == 1) {
            return new double[]{this.values_[this.i_]};
        }
        return Arrays.copyOfRange(this.values_, this.i_ * this.numValues_, (this.i_ + 1) * this.numValues_);
    }
}

