/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.types;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.unsafe.Platform;

public final class ByteArray {
    public static final byte[] EMPTY_BYTE = new byte[0];
    private static final boolean IS_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;

    public static void writeToMemory(byte[] src, Object target, long targetOffset) {
        Platform.copyMemory(src, Platform.BYTE_ARRAY_OFFSET, target, targetOffset, src.length);
    }

    public static long getPrefix(byte[] bytes) {
        if (bytes == null) {
            return 0L;
        }
        return ByteArray.getPrefix(bytes, Platform.BYTE_ARRAY_OFFSET, bytes.length);
    }

    static long getPrefix(Object base, long offset, int numBytes) {
        long mask;
        long p;
        if (numBytes >= 8) {
            p = Platform.getLong(base, offset);
            mask = 0L;
        } else if (numBytes > 4) {
            p = Platform.getLong(base, offset);
            mask = (1L << (8 - numBytes) * 8) - 1L;
        } else if (numBytes > 0) {
            long pRaw = Platform.getInt(base, offset);
            p = IS_LITTLE_ENDIAN ? pRaw : pRaw << 32;
            mask = (1L << (8 - numBytes) * 8) - 1L;
        } else {
            p = 0L;
            mask = 0L;
        }
        return (IS_LITTLE_ENDIAN ? Long.reverseBytes(p) : p) & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int compareBinary(byte[] leftBase, byte[] rightBase) {
        return ByteArray.compareBinary(leftBase, Platform.BYTE_ARRAY_OFFSET, leftBase.length, rightBase, Platform.BYTE_ARRAY_OFFSET, rightBase.length);
    }

    static int compareBinary(Object leftBase, long leftOffset, int leftNumBytes, Object rightBase, long rightOffset, int rightNumBytes) {
        int i;
        int len = Math.min(leftNumBytes, rightNumBytes);
        int wordMax = len / 8 * 8;
        for (i = 0; i < wordMax; i += 8) {
            long right;
            long left = Platform.getLong(leftBase, leftOffset + (long)i);
            if (left == (right = Platform.getLong(rightBase, rightOffset + (long)i))) continue;
            if (IS_LITTLE_ENDIAN) {
                return Long.compareUnsigned(Long.reverseBytes(left), Long.reverseBytes(right));
            }
            return Long.compareUnsigned(left, right);
        }
        for (i = wordMax; i < len; ++i) {
            int res = (Platform.getByte(leftBase, leftOffset + (long)i) & 0xFF) - (Platform.getByte(rightBase, rightOffset + (long)i) & 0xFF);
            if (res == 0) continue;
            return res;
        }
        return leftNumBytes - rightNumBytes;
    }

    public static byte[] subStringSQL(byte[] bytes, int pos, int len) {
        if (pos > bytes.length) {
            return EMPTY_BYTE;
        }
        int start = 0;
        if (pos > 0) {
            start = pos - 1;
        } else if (pos < 0) {
            start = bytes.length + pos;
        }
        int end = bytes.length - start < len ? bytes.length : start + len;
        start = Math.max(start, 0);
        if (start >= end) {
            return EMPTY_BYTE;
        }
        return Arrays.copyOfRange(bytes, start, end);
    }

    public static byte[] concat(byte[] ... inputs) {
        return ByteArray.concatWS(EMPTY_BYTE, inputs);
    }

    public static byte[] concatWS(byte[] delimiter, byte[] ... inputs) {
        if (delimiter == null) {
            return null;
        }
        long totalLength = 0L;
        for (byte[] input : inputs) {
            if (input != null) {
                totalLength += (long)(input.length + delimiter.length);
                continue;
            }
            return null;
        }
        if (totalLength > 0L) {
            totalLength -= (long)delimiter.length;
        }
        byte[] result = new byte[JavaUtils.checkedCast((long)totalLength)];
        int offset = 0;
        for (int i = 0; i < inputs.length; ++i) {
            byte[] input;
            input = inputs[i];
            int len = input.length;
            Platform.copyMemory(input, Platform.BYTE_ARRAY_OFFSET, result, Platform.BYTE_ARRAY_OFFSET + offset, len);
            offset += len;
            if (delimiter.length <= 0 || i >= inputs.length - 1) continue;
            Platform.copyMemory(delimiter, Platform.BYTE_ARRAY_OFFSET, result, Platform.BYTE_ARRAY_OFFSET + offset, delimiter.length);
            offset += delimiter.length;
        }
        return result;
    }

    private static byte[] padWithEmptyPattern(byte[] bytes, int len) {
        len = Math.min(bytes.length, len);
        byte[] result = new byte[len];
        Platform.copyMemory(bytes, Platform.BYTE_ARRAY_OFFSET, result, Platform.BYTE_ARRAY_OFFSET, len);
        return result;
    }

    private static void fillWithPattern(byte[] result, int firstPos, int beyondPos, byte[] pad) {
        for (int pos = firstPos; pos < beyondPos; pos += pad.length) {
            int jMax = Math.min(pad.length, beyondPos - pos);
            for (int j = 0; j < jMax; ++j) {
                result[pos + j] = pad[j];
            }
        }
    }

    public static byte[] lpad(byte[] bytes, int len, byte[] pad) {
        if (bytes == null || pad == null) {
            return null;
        }
        if (len == 0) {
            return EMPTY_BYTE;
        }
        if (pad.length == 0) {
            return ByteArray.padWithEmptyPattern(bytes, len);
        }
        byte[] result = new byte[len];
        int minLen = Math.min(len, bytes.length);
        Platform.copyMemory(bytes, Platform.BYTE_ARRAY_OFFSET, result, Platform.BYTE_ARRAY_OFFSET + len - minLen, minLen);
        if (bytes.length < len) {
            ByteArray.fillWithPattern(result, 0, len - bytes.length, pad);
        }
        return result;
    }

    public static byte[] rpad(byte[] bytes, int len, byte[] pad) {
        if (bytes == null || pad == null) {
            return null;
        }
        if (len == 0) {
            return EMPTY_BYTE;
        }
        if (pad.length == 0) {
            return ByteArray.padWithEmptyPattern(bytes, len);
        }
        byte[] result = new byte[len];
        Platform.copyMemory(bytes, Platform.BYTE_ARRAY_OFFSET, result, Platform.BYTE_ARRAY_OFFSET, Math.min(len, bytes.length));
        if (bytes.length < len) {
            ByteArray.fillWithPattern(result, bytes.length, len, pad);
        }
        return result;
    }
}

