/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.storage.CSIDriverSpec;
import io.fabric8.kubernetes.api.model.storage.TokenRequest;
import io.fabric8.kubernetes.api.model.storage.TokenRequestBuilder;
import io.fabric8.kubernetes.api.model.storage.TokenRequestFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CSIDriverSpecFluent<A extends CSIDriverSpecFluent<A>>
extends BaseFluent<A> {
    private Boolean attachRequired;
    private String fsGroupPolicy;
    private Long nodeAllocatableUpdatePeriodSeconds;
    private Boolean podInfoOnMount;
    private Boolean requiresRepublish;
    private Boolean seLinuxMount;
    private Boolean storageCapacity;
    private ArrayList<TokenRequestBuilder> tokenRequests = new ArrayList();
    private List<String> volumeLifecycleModes = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public CSIDriverSpecFluent() {
    }

    public CSIDriverSpecFluent(CSIDriverSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CSIDriverSpec instance) {
        CSIDriverSpec cSIDriverSpec = instance = instance != null ? instance : new CSIDriverSpec();
        if (instance != null) {
            this.withAttachRequired(instance.getAttachRequired());
            this.withFsGroupPolicy(instance.getFsGroupPolicy());
            this.withNodeAllocatableUpdatePeriodSeconds(instance.getNodeAllocatableUpdatePeriodSeconds());
            this.withPodInfoOnMount(instance.getPodInfoOnMount());
            this.withRequiresRepublish(instance.getRequiresRepublish());
            this.withSeLinuxMount(instance.getSeLinuxMount());
            this.withStorageCapacity(instance.getStorageCapacity());
            this.withTokenRequests(instance.getTokenRequests());
            this.withVolumeLifecycleModes(instance.getVolumeLifecycleModes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAttachRequired() {
        return this.attachRequired;
    }

    public A withAttachRequired(Boolean attachRequired) {
        this.attachRequired = attachRequired;
        return (A)((Object)this);
    }

    public boolean hasAttachRequired() {
        return this.attachRequired != null;
    }

    public String getFsGroupPolicy() {
        return this.fsGroupPolicy;
    }

    public A withFsGroupPolicy(String fsGroupPolicy) {
        this.fsGroupPolicy = fsGroupPolicy;
        return (A)((Object)this);
    }

    public boolean hasFsGroupPolicy() {
        return this.fsGroupPolicy != null;
    }

    public Long getNodeAllocatableUpdatePeriodSeconds() {
        return this.nodeAllocatableUpdatePeriodSeconds;
    }

    public A withNodeAllocatableUpdatePeriodSeconds(Long nodeAllocatableUpdatePeriodSeconds) {
        this.nodeAllocatableUpdatePeriodSeconds = nodeAllocatableUpdatePeriodSeconds;
        return (A)((Object)this);
    }

    public boolean hasNodeAllocatableUpdatePeriodSeconds() {
        return this.nodeAllocatableUpdatePeriodSeconds != null;
    }

    public Boolean getPodInfoOnMount() {
        return this.podInfoOnMount;
    }

    public A withPodInfoOnMount(Boolean podInfoOnMount) {
        this.podInfoOnMount = podInfoOnMount;
        return (A)((Object)this);
    }

    public boolean hasPodInfoOnMount() {
        return this.podInfoOnMount != null;
    }

    public Boolean getRequiresRepublish() {
        return this.requiresRepublish;
    }

    public A withRequiresRepublish(Boolean requiresRepublish) {
        this.requiresRepublish = requiresRepublish;
        return (A)((Object)this);
    }

    public boolean hasRequiresRepublish() {
        return this.requiresRepublish != null;
    }

    public Boolean getSeLinuxMount() {
        return this.seLinuxMount;
    }

    public A withSeLinuxMount(Boolean seLinuxMount) {
        this.seLinuxMount = seLinuxMount;
        return (A)((Object)this);
    }

    public boolean hasSeLinuxMount() {
        return this.seLinuxMount != null;
    }

    public Boolean getStorageCapacity() {
        return this.storageCapacity;
    }

    public A withStorageCapacity(Boolean storageCapacity) {
        this.storageCapacity = storageCapacity;
        return (A)((Object)this);
    }

    public boolean hasStorageCapacity() {
        return this.storageCapacity != null;
    }

    public A addToTokenRequests(int index, TokenRequest item) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        TokenRequestBuilder builder = new TokenRequestBuilder(item);
        if (index < 0 || index >= this.tokenRequests.size()) {
            this._visitables.get((Object)"tokenRequests").add(builder);
            this.tokenRequests.add(builder);
        } else {
            this._visitables.get((Object)"tokenRequests").add(builder);
            this.tokenRequests.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTokenRequests(int index, TokenRequest item) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        TokenRequestBuilder builder = new TokenRequestBuilder(item);
        if (index < 0 || index >= this.tokenRequests.size()) {
            this._visitables.get((Object)"tokenRequests").add(builder);
            this.tokenRequests.add(builder);
        } else {
            this._visitables.get((Object)"tokenRequests").add(builder);
            this.tokenRequests.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTokenRequests(TokenRequest ... items) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        for (TokenRequest item : items) {
            TokenRequestBuilder builder = new TokenRequestBuilder(item);
            this._visitables.get((Object)"tokenRequests").add(builder);
            this.tokenRequests.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTokenRequests(Collection<TokenRequest> items) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        for (TokenRequest item : items) {
            TokenRequestBuilder builder = new TokenRequestBuilder(item);
            this._visitables.get((Object)"tokenRequests").add(builder);
            this.tokenRequests.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTokenRequests(TokenRequest ... items) {
        if (this.tokenRequests == null) {
            return (A)((Object)this);
        }
        for (TokenRequest item : items) {
            TokenRequestBuilder builder = new TokenRequestBuilder(item);
            this._visitables.get((Object)"tokenRequests").remove((Object)builder);
            this.tokenRequests.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTokenRequests(Collection<TokenRequest> items) {
        if (this.tokenRequests == null) {
            return (A)((Object)this);
        }
        for (TokenRequest item : items) {
            TokenRequestBuilder builder = new TokenRequestBuilder(item);
            this._visitables.get((Object)"tokenRequests").remove((Object)builder);
            this.tokenRequests.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTokenRequests(Predicate<TokenRequestBuilder> predicate) {
        if (this.tokenRequests == null) {
            return (A)((Object)this);
        }
        Iterator<TokenRequestBuilder> each = this.tokenRequests.iterator();
        List visitables = this._visitables.get((Object)"tokenRequests");
        while (each.hasNext()) {
            TokenRequestBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TokenRequest> buildTokenRequests() {
        return this.tokenRequests != null ? CSIDriverSpecFluent.build(this.tokenRequests) : null;
    }

    public TokenRequest buildTokenRequest(int index) {
        return this.tokenRequests.get(index).build();
    }

    public TokenRequest buildFirstTokenRequest() {
        return this.tokenRequests.get(0).build();
    }

    public TokenRequest buildLastTokenRequest() {
        return this.tokenRequests.get(this.tokenRequests.size() - 1).build();
    }

    public TokenRequest buildMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate) {
        for (TokenRequestBuilder item : this.tokenRequests) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate) {
        for (TokenRequestBuilder item : this.tokenRequests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTokenRequests(List<TokenRequest> tokenRequests) {
        if (this.tokenRequests != null) {
            this._visitables.get((Object)"tokenRequests").clear();
        }
        if (tokenRequests != null) {
            this.tokenRequests = new ArrayList();
            for (TokenRequest item : tokenRequests) {
                this.addToTokenRequests(item);
            }
        } else {
            this.tokenRequests = null;
        }
        return (A)((Object)this);
    }

    public A withTokenRequests(TokenRequest ... tokenRequests) {
        if (this.tokenRequests != null) {
            this.tokenRequests.clear();
            this._visitables.remove((Object)"tokenRequests");
        }
        if (tokenRequests != null) {
            for (TokenRequest item : tokenRequests) {
                this.addToTokenRequests(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTokenRequests() {
        return this.tokenRequests != null && !this.tokenRequests.isEmpty();
    }

    public A addNewTokenRequest(String audience, Long expirationSeconds) {
        return this.addToTokenRequests(new TokenRequest(audience, expirationSeconds));
    }

    public TokenRequestsNested<A> addNewTokenRequest() {
        return new TokenRequestsNested(-1, null);
    }

    public TokenRequestsNested<A> addNewTokenRequestLike(TokenRequest item) {
        return new TokenRequestsNested(-1, item);
    }

    public TokenRequestsNested<A> setNewTokenRequestLike(int index, TokenRequest item) {
        return new TokenRequestsNested(index, item);
    }

    public TokenRequestsNested<A> editTokenRequest(int index) {
        if (this.tokenRequests.size() <= index) {
            throw new RuntimeException("Can't edit tokenRequests. Index exceeds size.");
        }
        return this.setNewTokenRequestLike(index, this.buildTokenRequest(index));
    }

    public TokenRequestsNested<A> editFirstTokenRequest() {
        if (this.tokenRequests.size() == 0) {
            throw new RuntimeException("Can't edit first tokenRequests. The list is empty.");
        }
        return this.setNewTokenRequestLike(0, this.buildTokenRequest(0));
    }

    public TokenRequestsNested<A> editLastTokenRequest() {
        int index = this.tokenRequests.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tokenRequests. The list is empty.");
        }
        return this.setNewTokenRequestLike(index, this.buildTokenRequest(index));
    }

    public TokenRequestsNested<A> editMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tokenRequests.size(); ++i) {
            if (!predicate.test(this.tokenRequests.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tokenRequests. No match found.");
        }
        return this.setNewTokenRequestLike(index, this.buildTokenRequest(index));
    }

    public A addToVolumeLifecycleModes(int index, String item) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        this.volumeLifecycleModes.add(index, item);
        return (A)((Object)this);
    }

    public A setToVolumeLifecycleModes(int index, String item) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        this.volumeLifecycleModes.set(index, item);
        return (A)((Object)this);
    }

    public A addToVolumeLifecycleModes(String ... items) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumeLifecycleModes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumeLifecycleModes(Collection<String> items) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumeLifecycleModes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumeLifecycleModes(String ... items) {
        if (this.volumeLifecycleModes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.volumeLifecycleModes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumeLifecycleModes(Collection<String> items) {
        if (this.volumeLifecycleModes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.volumeLifecycleModes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getVolumeLifecycleModes() {
        return this.volumeLifecycleModes;
    }

    public String getVolumeLifecycleMode(int index) {
        return this.volumeLifecycleModes.get(index);
    }

    public String getFirstVolumeLifecycleMode() {
        return this.volumeLifecycleModes.get(0);
    }

    public String getLastVolumeLifecycleMode() {
        return this.volumeLifecycleModes.get(this.volumeLifecycleModes.size() - 1);
    }

    public String getMatchingVolumeLifecycleMode(Predicate<String> predicate) {
        for (String item : this.volumeLifecycleModes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVolumeLifecycleMode(Predicate<String> predicate) {
        for (String item : this.volumeLifecycleModes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeLifecycleModes(List<String> volumeLifecycleModes) {
        if (volumeLifecycleModes != null) {
            this.volumeLifecycleModes = new ArrayList<String>();
            for (String item : volumeLifecycleModes) {
                this.addToVolumeLifecycleModes(item);
            }
        } else {
            this.volumeLifecycleModes = null;
        }
        return (A)((Object)this);
    }

    public A withVolumeLifecycleModes(String ... volumeLifecycleModes) {
        if (this.volumeLifecycleModes != null) {
            this.volumeLifecycleModes.clear();
            this._visitables.remove((Object)"volumeLifecycleModes");
        }
        if (volumeLifecycleModes != null) {
            for (String item : volumeLifecycleModes) {
                this.addToVolumeLifecycleModes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumeLifecycleModes() {
        return this.volumeLifecycleModes != null && !this.volumeLifecycleModes.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSIDriverSpecFluent that = (CSIDriverSpecFluent)((Object)o);
        if (!Objects.equals(this.attachRequired, that.attachRequired)) {
            return false;
        }
        if (!Objects.equals(this.fsGroupPolicy, that.fsGroupPolicy)) {
            return false;
        }
        if (!Objects.equals(this.nodeAllocatableUpdatePeriodSeconds, that.nodeAllocatableUpdatePeriodSeconds)) {
            return false;
        }
        if (!Objects.equals(this.podInfoOnMount, that.podInfoOnMount)) {
            return false;
        }
        if (!Objects.equals(this.requiresRepublish, that.requiresRepublish)) {
            return false;
        }
        if (!Objects.equals(this.seLinuxMount, that.seLinuxMount)) {
            return false;
        }
        if (!Objects.equals(this.storageCapacity, that.storageCapacity)) {
            return false;
        }
        if (!Objects.equals(this.tokenRequests, that.tokenRequests)) {
            return false;
        }
        if (!Objects.equals(this.volumeLifecycleModes, that.volumeLifecycleModes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attachRequired, this.fsGroupPolicy, this.nodeAllocatableUpdatePeriodSeconds, this.podInfoOnMount, this.requiresRepublish, this.seLinuxMount, this.storageCapacity, this.tokenRequests, this.volumeLifecycleModes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachRequired != null) {
            sb.append("attachRequired:");
            sb.append(this.attachRequired + ",");
        }
        if (this.fsGroupPolicy != null) {
            sb.append("fsGroupPolicy:");
            sb.append(this.fsGroupPolicy + ",");
        }
        if (this.nodeAllocatableUpdatePeriodSeconds != null) {
            sb.append("nodeAllocatableUpdatePeriodSeconds:");
            sb.append(this.nodeAllocatableUpdatePeriodSeconds + ",");
        }
        if (this.podInfoOnMount != null) {
            sb.append("podInfoOnMount:");
            sb.append(this.podInfoOnMount + ",");
        }
        if (this.requiresRepublish != null) {
            sb.append("requiresRepublish:");
            sb.append(this.requiresRepublish + ",");
        }
        if (this.seLinuxMount != null) {
            sb.append("seLinuxMount:");
            sb.append(this.seLinuxMount + ",");
        }
        if (this.storageCapacity != null) {
            sb.append("storageCapacity:");
            sb.append(this.storageCapacity + ",");
        }
        if (this.tokenRequests != null && !this.tokenRequests.isEmpty()) {
            sb.append("tokenRequests:");
            sb.append(String.valueOf(this.tokenRequests) + ",");
        }
        if (this.volumeLifecycleModes != null && !this.volumeLifecycleModes.isEmpty()) {
            sb.append("volumeLifecycleModes:");
            sb.append(String.valueOf(this.volumeLifecycleModes) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAttachRequired() {
        return this.withAttachRequired(true);
    }

    public A withPodInfoOnMount() {
        return this.withPodInfoOnMount(true);
    }

    public A withRequiresRepublish() {
        return this.withRequiresRepublish(true);
    }

    public A withSeLinuxMount() {
        return this.withSeLinuxMount(true);
    }

    public A withStorageCapacity() {
        return this.withStorageCapacity(true);
    }

    public class TokenRequestsNested<N>
    extends TokenRequestFluent<TokenRequestsNested<N>>
    implements Nested<N> {
        TokenRequestBuilder builder;
        int index;

        TokenRequestsNested(int index, TokenRequest item) {
            this.index = index;
            this.builder = new TokenRequestBuilder(this, item);
        }

        public N and() {
            return (N)CSIDriverSpecFluent.this.setToTokenRequests(this.index, this.builder.build());
        }

        public N endTokenRequest() {
            return this.and();
        }
    }
}

