/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.io.parquet.convert.ConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveGroupConverter;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.PrimitiveType;

public interface Repeated
extends ConverterParent {
    public void parentStart();

    public void parentEnd();

    public static class RepeatedGroupConverter
    extends HiveGroupConverter
    implements Repeated {
        private final GroupType groupType;
        private final HiveGroupConverter wrapped;
        private final ConverterParent parent;
        private final int index;
        private final List<Writable> list = new ArrayList<Writable>();
        private final Map<String, String> metadata = new HashMap<String, String>();

        public RepeatedGroupConverter(GroupType groupType, ConverterParent parent, int index, TypeInfo hiveTypeInfo) {
            this.setMetadata(parent.getMetadata());
            this.groupType = groupType;
            this.parent = parent;
            this.index = index;
            this.wrapped = HiveGroupConverter.getConverterFromDescription(groupType, 0, (ConverterParent)this, hiveTypeInfo);
        }

        @Override
        public void set(int fieldIndex, Writable value) {
            this.list.add(value);
        }

        public Converter getConverter(int fieldIndex) {
            return this.wrapped.getConverter(fieldIndex);
        }

        public void start() {
            this.wrapped.start();
        }

        public void end() {
            this.wrapped.end();
        }

        @Override
        public void parentStart() {
            this.list.clear();
        }

        @Override
        public void parentEnd() {
            this.parent.set(this.index, (Writable)new ArrayWritable(Writable.class, this.list.toArray(new Writable[this.list.size()])));
        }
    }

    public static class RepeatedPrimitiveConverter
    extends RepeatedConverterParent {
        private final PrimitiveType primitiveType;
        private final PrimitiveConverter wrapped;
        private final ConverterParent parent;
        private final int index;
        private final List<Writable> list = new ArrayList<Writable>();

        public RepeatedPrimitiveConverter(PrimitiveType primitiveType, ConverterParent parent, int index, TypeInfo hiveTypeInfo) {
            this.setMetadata(parent.getMetadata());
            this.primitiveType = primitiveType;
            this.parent = parent;
            this.index = index;
            this.wrapped = HiveGroupConverter.getConverterFromDescription(primitiveType, 0, (ConverterParent)this, hiveTypeInfo);
        }

        public boolean hasDictionarySupport() {
            return this.wrapped.hasDictionarySupport();
        }

        public void setDictionary(Dictionary dictionary) {
            this.wrapped.setDictionary(dictionary);
        }

        public void addValueFromDictionary(int dictionaryId) {
            this.wrapped.addValueFromDictionary(dictionaryId);
        }

        public void addBinary(Binary value) {
            this.wrapped.addBinary(value);
        }

        public void addBoolean(boolean value) {
            this.wrapped.addBoolean(value);
        }

        public void addDouble(double value) {
            this.wrapped.addDouble(value);
        }

        public void addFloat(float value) {
            this.wrapped.addFloat(value);
        }

        public void addInt(int value) {
            this.wrapped.addInt(value);
        }

        public void addLong(long value) {
            this.wrapped.addLong(value);
        }

        @Override
        public void parentStart() {
            this.list.clear();
        }

        @Override
        public void parentEnd() {
            this.parent.set(this.index, (Writable)new ArrayWritable(Writable.class, this.list.toArray(new Writable[this.list.size()])));
        }

        @Override
        public void set(int index, Writable value) {
            this.list.add(value);
        }
    }

    public static abstract class RepeatedConverterParent
    extends PrimitiveConverter
    implements Repeated {
        private Map<String, String> metadata;

        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        @Override
        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }
}

