/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.v2.state.FromSnapshotOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StatePartitionReaderBase;
import org.apache.spark.sql.execution.datasources.v2.state.StateStoreInputPartition;
import org.apache.spark.sql.execution.datasources.v2.state.utils.SchemaUtil$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateVariableInfo;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.ReadStateStore;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.SupportsFineGrainedReplay;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015b\u0001\u0002\b\u0010\u0001\u0001B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011Q\u0003!\u0011!Q\u0001\nUC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\t=\u0002\u0011\t\u0011)A\u0005?\")1\u000e\u0001C\u0001Y\"Aq\u000f\u0001EC\u0002\u0013%\u0001\u0010\u0003\u0005}\u0001!\u0015\r\u0011\"\u0011~\u0011\u001d\tY\u0002\u0001C!\u0003;\u0011Ac\u0015;bi\u0016\u0004\u0016M\u001d;ji&|gNU3bI\u0016\u0014(B\u0001\t\u0012\u0003\u0015\u0019H/\u0019;f\u0015\t\u00112#\u0001\u0002we)\u0011A#F\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u0017/\u0005IQ\r_3dkRLwN\u001c\u0006\u00031e\t1a]9m\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0012\u000e\u0003=I!\u0001J\b\u00031M#\u0018\r^3QCJ$\u0018\u000e^5p]J+\u0017\rZ3s\u0005\u0006\u001cX-A\u0005ti>\u0014XmQ8oMB\u0011qeK\u0007\u0002Q)\u0011\u0001#\u000b\u0006\u0003UU\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\u00051B#AD*uCR,7\u000b^8sK\u000e{gNZ\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007CA\u00183\u001b\u0005\u0001$BA\u0019\u001a\u0003\u0011)H/\u001b7\n\u0005M\u0002$!G*fe&\fG.\u001b>bE2,7i\u001c8gS\u001e,(/\u0019;j_:\f\u0011\u0002]1si&$\u0018n\u001c8\u0011\u0005\t2\u0014BA\u001c\u0010\u0005a\u0019F/\u0019;f'R|'/Z%oaV$\b+\u0019:uSRLwN\\\u0001\u0007g\u000eDW-\\1\u0011\u0005ijT\"A\u001e\u000b\u0005q:\u0012!\u0002;za\u0016\u001c\u0018B\u0001 <\u0005)\u0019FO];diRK\b/Z\u0001\u0014W\u0016L8\u000b^1uK\u0016s7m\u001c3feN\u0003Xm\u0019\t\u0003O\u0005K!A\u0011\u0015\u0003'-+\u0017p\u0015;bi\u0016,enY8eKJ\u001c\u0006/Z2\u0002)M$\u0018\r^3WCJL\u0017M\u00197f\u0013:4wn\u00149u!\r)\u0005JS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n1q\n\u001d;j_:\u0004\"a\u0013*\u000e\u00031S!!\u0014(\u0002%Q\u0014\u0018M\\:g_Jlw/\u001b;igR\fG/\u001a\u0006\u0003\u001fB\u000b\u0001b\u001d;bi\u00164W\u000f\u001c\u0006\u0003#&\n\u0011b\u001c9fe\u0006$xN]:\n\u0005Mc%A\b+sC:\u001chm\u001c:n/&$\bn\u0015;bi\u00164\u0016M]5bE2,\u0017J\u001c4p\u0003q\u0019H/\u0019;f'R|'/Z\"pY\u001a\u000bW.\u001b7z'\u000eDW-\\1PaR\u00042!\u0012%W!\t9s+\u0003\u0002YQ\tI2\u000b^1uKN#xN]3D_24\u0015-\\5msN\u001b\u0007.Z7b\u0003Y\u0019H/\u0019;f'\u000eDW-\\1Qe>4\u0018\u000eZ3s\u001fB$\bcA#I7B\u0011q\u0005X\u0005\u0003;\"\u00121c\u0015;bi\u0016\u001c6\r[3nCB\u0013xN^5eKJ\f\u0001C[8j]\u000e{GNR1nS2Lx\n\u001d;\u0011\u0007\u0015C\u0005\r\u0005\u0002bQ:\u0011!M\u001a\t\u0003G\u001ak\u0011\u0001\u001a\u0006\u0003K~\ta\u0001\u0010:p_Rt\u0014BA4G\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011N\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d4\u0015A\u0002\u001fj]&$h\b\u0006\u0006n]>\u0004\u0018O]:ukZ\u0004\"A\t\u0001\t\u000b\u0015R\u0001\u0019\u0001\u0014\t\u000b5R\u0001\u0019\u0001\u0018\t\u000bQR\u0001\u0019A\u001b\t\u000baR\u0001\u0019A\u001d\t\u000b}R\u0001\u0019\u0001!\t\u000b\rS\u0001\u0019\u0001#\t\u000bQS\u0001\u0019A+\t\u000beS\u0001\u0019\u0001.\t\u000byS\u0001\u0019A0\u0002\u000bM$xN]3\u0016\u0003e\u0004\"a\n>\n\u0005mD#A\u0004*fC\u0012\u001cF/\u0019;f'R|'/Z\u0001\u0005SR,'/F\u0001\u007f!\u0015y\u0018\u0011BA\b\u001d\u0011\t\t!!\u0002\u000f\u0007\r\f\u0019!C\u0001H\u0013\r\t9AR\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY!!\u0004\u0003\u0011%#XM]1u_JT1!a\u0002G!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b/\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002\u001a\u0005M!aC%oi\u0016\u0014h.\u00197S_^\fQa\u00197pg\u0016$\"!a\b\u0011\u0007\u0015\u000b\t#C\u0002\u0002$\u0019\u0013A!\u00168ji\u0002")
public class StatePartitionReader
extends StatePartitionReaderBase {
    private ReadStateStore store;
    private Iterator<InternalRow> iter;
    private final StateStoreInputPartition partition;
    private final Option<TransformWithStateVariableInfo> stateVariableInfoOpt;
    private final Option<StateStoreColFamilySchema> stateStoreColFamilySchemaOpt;
    private final Option<String> joinColFamilyOpt;
    private volatile byte bitmap$0;

    private ReadStateStore store$lzycompute() {
        StatePartitionReader statePartitionReader = this;
        synchronized (statePartitionReader) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                ReadStateStore readStateStore;
                Option<FromSnapshotOptions> option = this.partition.sourceOptions().fromSnapshotOptions();
                if (None$.MODULE$.equals(option)) {
                    Option<String> option2 = this.getStartStoreUniqueId();
                    Option<String> option3 = this.getEndStoreUniqueId();
                    Predef$.MODULE$.assert(!(option2 != null ? !option2.equals(option3) : option3 != null), (Function0 & Serializable)() -> "Start and end store unique IDs must be the same when not reading from snapshot");
                    readStateStore = this.provider().getReadStore(this.partition.sourceOptions().batchId() + 1L, this.getStartStoreUniqueId());
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    FromSnapshotOptions fromSnapshotOptions = (FromSnapshotOptions)some.value();
                    if (!(this.provider() instanceof SupportsFineGrainedReplay)) {
                        throw StateStoreErrors$.MODULE$.stateStoreProviderDoesNotSupportFineGrainedReplay(this.provider().getClass().toString());
                    }
                    readStateStore = ((SupportsFineGrainedReplay)((Object)this.provider())).replayReadStateFromSnapshot(fromSnapshotOptions.snapshotStartBatchId() + 1L, this.partition.sourceOptions().batchId() + 1L, this.getStartStoreUniqueId(), this.getEndStoreUniqueId());
                } else {
                    throw new MatchError(option);
                }
                this.store = readStateStore;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.store;
    }

    private ReadStateStore store() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.store$lzycompute();
        }
        return this.store;
    }

    private Iterator<InternalRow> iter$lzycompute() {
        StatePartitionReader statePartitionReader = this;
        synchronized (statePartitionReader) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Object object;
                String colFamilyName = (String)this.stateStoreColFamilySchemaOpt.map((Function1 & Serializable)x$4 -> x$4.colFamilyName()).getOrElse((Function0 & Serializable)() -> (String)$this.joinColFamilyOpt.getOrElse((Function0 & Serializable)() -> StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME()));
                if (this.stateVariableInfoOpt.isDefined()) {
                    TransformWithStateVariableInfo stateVariableInfo = (TransformWithStateVariableInfo)this.stateVariableInfoOpt.get();
                    Enumeration.Value stateVarType = stateVariableInfo.stateVariableType();
                    object = SchemaUtil$.MODULE$.processStateEntries(stateVarType, colFamilyName, this.store(), this.keySchema(), this.partition.partition(), this.partition.sourceOptions());
                } else {
                    object = this.store().iterator(colFamilyName).map((Function1 & Serializable)pair -> SchemaUtil$.MODULE$.unifyStateRowPair((Tuple2<UnsafeRow, UnsafeRow>)new Tuple2((Object)pair.key(), (Object)pair.value()), $this.partition.partition()));
                }
                this.iter = object;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.iter;
    }

    @Override
    public Iterator<InternalRow> iter() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.iter$lzycompute();
        }
        return this.iter;
    }

    @Override
    public void close() {
        this.store().release();
        super.close();
    }

    public StatePartitionReader(StateStoreConf storeConf, SerializableConfiguration hadoopConf, StateStoreInputPartition partition, StructType schema, KeyStateEncoderSpec keyStateEncoderSpec, Option<TransformWithStateVariableInfo> stateVariableInfoOpt, Option<StateStoreColFamilySchema> stateStoreColFamilySchemaOpt, Option<StateSchemaProvider> stateSchemaProviderOpt, Option<String> joinColFamilyOpt) {
        this.partition = partition;
        this.stateVariableInfoOpt = stateVariableInfoOpt;
        this.stateStoreColFamilySchemaOpt = stateStoreColFamilySchemaOpt;
        this.joinColFamilyOpt = joinColFamilyOpt;
        super(storeConf, hadoopConf, partition, schema, keyStateEncoderSpec, stateVariableInfoOpt, stateStoreColFamilySchemaOpt, stateSchemaProviderOpt, joinColFamilyOpt);
    }
}

