/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate;

import java.io.Serializable;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.MapStatePartitionKeyExtractor;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.MapTTLStatePartitionKeyExtractor;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.StateStoreColumnFamilySchemaUtils$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.StateVariableType$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TTLStatePartitionKeyExtractor;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TimerStatePartitionKeyExtractor;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateVariableInfo;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.timers.TimerStateUtils$;
import org.apache.spark.sql.execution.streaming.state.NoopStatePartitionKeyExtractor;
import org.apache.spark.sql.execution.streaming.state.OfflineStateRepartitionErrors$;
import org.apache.spark.sql.execution.streaming.state.StatePartitionKeyExtractor;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;

public final class TransformWithStatePartitionKeyExtractorFactory$ {
    public static final TransformWithStatePartitionKeyExtractorFactory$ MODULE$ = new TransformWithStatePartitionKeyExtractorFactory$();

    public StatePartitionKeyExtractor create(String storeName, String colFamilyName, StructType stateKeySchema, TransformWithStateVariableInfo stateVariableInfo) {
        String string = storeName;
        String string2 = StateStoreId$.MODULE$.DEFAULT_STORE_NAME();
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "Store name must be default");
        String string3 = colFamilyName;
        String string4 = StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME();
        Predef$.MODULE$.require(string3 == null ? string4 != null : !string3.equals(string4), (Function0 & Serializable)() -> "Use non-default CF");
        if (stateVariableInfo.ttlEnabled()) {
            return this.createForTTL(colFamilyName, stateKeySchema, stateVariableInfo);
        }
        return this.createForStateVarType(colFamilyName, stateKeySchema, stateVariableInfo);
    }

    private StatePartitionKeyExtractor createForTTL(String colFamilyName, StructType stateKeySchema, TransformWithStateVariableInfo stateVariableInfo) {
        if (StateStoreColumnFamilySchemaUtils$.MODULE$.isTtlColFamilyName(colFamilyName)) {
            boolean bl;
            String stateName;
            String string = stateName = StateStoreColumnFamilySchemaUtils$.MODULE$.getStateNameFromTtlColFamily(colFamilyName);
            String string2 = stateVariableInfo.stateName();
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "State name must match");
            Enumeration.Value value = stateVariableInfo.stateVariableType();
            Enumeration.Value value2 = StateVariableType$.MODULE$.MapState();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                return new MapTTLStatePartitionKeyExtractor(stateKeySchema);
            }
            Enumeration.Value value4 = StateVariableType$.MODULE$.ListState();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = StateVariableType$.MODULE$.ValueState();
                Enumeration.Value value7 = value;
                bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
            }
            if (bl) {
                return new TTLStatePartitionKeyExtractor(stateKeySchema);
            }
            throw OfflineStateRepartitionErrors$.MODULE$.unsupportedTransformWithStateVarTypeError("", stateVariableInfo.stateVariableType().toString(), stateVariableInfo.ttlEnabled(), colFamilyName);
        }
        if (StateStoreColumnFamilySchemaUtils$.MODULE$.isMinExpiryIndexCFName(colFamilyName)) {
            String stateName;
            String string = stateName = StateStoreColumnFamilySchemaUtils$.MODULE$.getStateNameFromMinExpiryIndexCFName(colFamilyName);
            String string3 = stateVariableInfo.stateName();
            Predef$.MODULE$.require(!(string != null ? !string.equals(string3) : string3 != null), (Function0 & Serializable)() -> "State name must match");
            return new NoopStatePartitionKeyExtractor(stateKeySchema);
        }
        if (StateStoreColumnFamilySchemaUtils$.MODULE$.isCountIndexCFName(colFamilyName)) {
            String stateName;
            String string = stateName = StateStoreColumnFamilySchemaUtils$.MODULE$.getStateNameFromCountIndexCFName(colFamilyName);
            String string4 = stateVariableInfo.stateName();
            Predef$.MODULE$.require(!(string != null ? !string.equals(string4) : string4 != null), (Function0 & Serializable)() -> "State name must match");
            return new NoopStatePartitionKeyExtractor(stateKeySchema);
        }
        return this.createForStateVarType(colFamilyName, stateKeySchema, stateVariableInfo);
    }

    private StatePartitionKeyExtractor createForStateVarType(String colFamilyName, StructType stateKeySchema, TransformWithStateVariableInfo stateVariableInfo) {
        boolean bl;
        Enumeration.Value value = stateVariableInfo.stateVariableType();
        Enumeration.Value value2 = StateVariableType$.MODULE$.ListState();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = StateVariableType$.MODULE$.ValueState();
            Enumeration.Value value5 = value;
            bl = !(value4 != null ? !value4.equals(value5) : value5 != null);
        }
        if (bl) {
            return new NoopStatePartitionKeyExtractor(stateKeySchema);
        }
        Enumeration.Value value6 = StateVariableType$.MODULE$.MapState();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return new MapStatePartitionKeyExtractor(stateKeySchema);
        }
        Enumeration.Value value8 = StateVariableType$.MODULE$.TimerState();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            Predef$.MODULE$.require(TimerStateUtils$.MODULE$.isTimerCFName(colFamilyName), (Function0 & Serializable)() -> "Column family name must be for a timer: " + colFamilyName);
            return new TimerStatePartitionKeyExtractor(stateKeySchema, TimerStateUtils$.MODULE$.isTimerSecondaryIndexCF(colFamilyName));
        }
        throw OfflineStateRepartitionErrors$.MODULE$.unsupportedTransformWithStateVarTypeError("", stateVariableInfo.stateVariableType().toString(), stateVariableInfo.ttlEnabled(), colFamilyName);
    }

    private TransformWithStatePartitionKeyExtractorFactory$() {
    }
}

