/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.pipelines;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SparkException;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005-4AAC\u0006\u00011!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0013!\u0003BB!\u0001A\u0003%Q\u0005C\u0003C\u0001\u0011\u00051\tC\u0003N\u0001\u0011\u0005a\nC\u0003U\u0001\u0011\u0005Q\u000bC\u0003Y\u0001\u0011\u0005\u0011\fC\u0003_\u0001\u0011\u0005q\fC\u0003j\u0001\u0011\u0005!NA\u000bECR\fg\r\\8x\u000fJ\f\u0007\u000f\u001b*fO&\u001cHO]=\u000b\u00051i\u0011!\u00039ja\u0016d\u0017N\\3t\u0015\tqq\"A\u0004d_:tWm\u0019;\u000b\u0005A\t\u0012aA:rY*\u0011!cE\u0001\u0006gB\f'o\u001b\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001I\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002\u0017\u0005qA-\u0019;bM2|wo\u0012:ba\"\u001cX#A\u0013\u0011\t\u0019jsFO\u0007\u0002O)\u0011\u0001&K\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u0016,\u0003\u0011)H/\u001b7\u000b\u00031\nAA[1wC&\u0011af\n\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u0001\u00198\u001d\t\tT\u0007\u0005\u0002375\t1G\u0003\u00025/\u00051AH]8pizJ!AN\u000e\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003mm\u0001\"aO \u000e\u0003qR!!\u0010 \u0002\u000b\u001d\u0014\u0018\r\u001d5\u000b\u00051y\u0011B\u0001!=\u0005a9%/\u00199i%\u0016<\u0017n\u001d;sCRLwN\\\"p]R,\u0007\u0010^\u0001\u0010I\u0006$\u0018M\u001a7po\u001e\u0013\u0018\r\u001d5tA\u0005\u00192M]3bi\u0016$\u0015\r^1gY><xI]1qQR!q\u0006\u0012$I\u0011\u0015)E\u00011\u00010\u00039!WMZ1vYR\u001c\u0015\r^1m_\u001eDQa\u0012\u0003A\u0002=\nq\u0002Z3gCVdG\u000fR1uC\n\f7/\u001a\u0005\u0006\u0013\u0012\u0001\rAS\u0001\u000fI\u00164\u0017-\u001e7u'Fd7i\u001c8g!\u0011\u00014jL\u0018\n\u00051K$aA'ba\u0006\u0001r-\u001a;ECR\fg\r\\8x\u000fJ\f\u0007\u000f\u001b\u000b\u0003\u001fJ\u00032A\u0007);\u0013\t\t6D\u0001\u0004PaRLwN\u001c\u0005\u0006'\u0016\u0001\raL\u0001\bOJ\f\u0007\u000f[%e\u0003]9W\r\u001e#bi\u00064Gn\\<He\u0006\u0004\bn\u0014:UQJ|w\u000f\u0006\u0002;-\")qK\u0002a\u0001_\u0005yA-\u0019;bM2|wo\u0012:ba\"LE-A\tee>\u0004H)\u0019;bM2|wo\u0012:ba\"$\"AW/\u0011\u0005iY\u0016B\u0001/\u001c\u0005\u0011)f.\u001b;\t\u000bM;\u0001\u0019A\u0018\u0002)\u001d,G/\u00117m\t\u0006$\u0018M\u001a7po\u001e\u0013\u0018\r\u001d5t+\u0005\u0001\u0007cA1gu9\u0011!\r\u001a\b\u0003e\rL\u0011\u0001H\u0005\u0003Kn\tq\u0001]1dW\u0006<W-\u0003\u0002hQ\n\u00191+Z9\u000b\u0005\u0015\\\u0012!\u00063s_B\fE\u000e\u001c#bi\u00064Gn\\<He\u0006\u0004\bn\u001d\u000b\u00025\u0002")
public class DataflowGraphRegistry {
    private final ConcurrentHashMap<String, GraphRegistrationContext> dataflowGraphs = new ConcurrentHashMap();

    private ConcurrentHashMap<String, GraphRegistrationContext> dataflowGraphs() {
        return this.dataflowGraphs;
    }

    public String createDataflowGraph(String defaultCatalog, String defaultDatabase, Map<String, String> defaultSqlConf) {
        String graphId = UUID.randomUUID().toString();
        this.dataflowGraphs().put(graphId, new GraphRegistrationContext(defaultCatalog, defaultDatabase, defaultSqlConf));
        return graphId;
    }

    public Option<GraphRegistrationContext> getDataflowGraph(String graphId) {
        return Option$.MODULE$.apply((Object)this.dataflowGraphs().get(graphId));
    }

    public GraphRegistrationContext getDataflowGraphOrThrow(String dataflowGraphId) {
        return (GraphRegistrationContext)this.getDataflowGraph(dataflowGraphId).getOrElse((Function0 & Serializable)() -> {
            throw new SparkException("DATAFLOW_GRAPH_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"graphId"), (Object)dataflowGraphId)})), null);
        });
    }

    public void dropDataflowGraph(String graphId) {
        this.dataflowGraphs().remove(graphId);
    }

    public Seq<GraphRegistrationContext> getAllDataflowGraphs() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.dataflowGraphs().values()).asScala().toSeq();
    }

    public void dropAllDataflowGraphs() {
        this.dataflowGraphs().clear();
    }
}

