/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NamespaceListFluent<A extends NamespaceListFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private ArrayList<NamespaceBuilder> items = new ArrayList();
    private String kind;
    private ListMetaBuilder metadata;

    public NamespaceListFluent() {
    }

    public NamespaceListFluent(NamespaceList instance) {
        this.copyInstance(instance);
    }

    public A addAllToItems(Collection<Namespace> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (Namespace item : items) {
            NamespaceBuilder builder = new NamespaceBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public ItemsNested<A> addNewItemLike(Namespace item) {
        return new ItemsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToItems(Namespace ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (Namespace item : items) {
            NamespaceBuilder builder = new NamespaceBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToItems(int index, Namespace item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        NamespaceBuilder builder = new NamespaceBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(index, builder);
        }
        return (A)((Object)this);
    }

    public Namespace buildFirstItem() {
        return this.items.get(0).build();
    }

    public Namespace buildItem(int index) {
        return this.items.get(index).build();
    }

    public List<Namespace> buildItems() {
        return this.items != null ? NamespaceListFluent.build(this.items) : null;
    }

    public Namespace buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public Namespace buildMatchingItem(Predicate<NamespaceBuilder> predicate) {
        for (NamespaceBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    protected void copyInstance(NamespaceList instance) {
        NamespaceList namespaceList = instance = instance != null ? instance : new NamespaceList();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withItems(instance.getItems());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "items"));
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "items"));
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "items"));
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<NamespaceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "items"));
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ListMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespaceListFluent that = (NamespaceListFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals((Object)this.metadata, (Object)that.metadata)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMatchingItem(Predicate<NamespaceBuilder> predicate) {
        for (NamespaceBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.items, this.kind, this.metadata, this.additionalProperties});
    }

    public A removeAllFromItems(Collection<Namespace> items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (Namespace item : items) {
            NamespaceBuilder builder = new NamespaceBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromItems(Namespace ... items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (Namespace item : items) {
            NamespaceBuilder builder = new NamespaceBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromItems(Predicate<NamespaceBuilder> predicate) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        Iterator<NamespaceBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            NamespaceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ItemsNested<A> setNewItemLike(int index, Namespace item) {
        return new ItemsNested(index, item);
    }

    public A setToItems(int index, Namespace item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        NamespaceBuilder builder = new NamespaceBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(builder);
            this.items.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append((Object)this.metadata);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public A withItems(List<Namespace> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (Namespace item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)((Object)this);
    }

    public A withItems(Namespace ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove((Object)"items");
        }
        if (items != null) {
            for (Namespace item : items) {
                this.addToItems(item);
            }
        }
        return (A)((Object)this);
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public A withMetadata(ListMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove((Object)this.metadata);
        }
        return (A)((Object)this);
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNested(item);
    }

    public class MetadataNested<N>
    extends ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ListMetaBuilder builder;

        MetadataNested(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        public N and() {
            return (N)NamespaceListFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNested<N>
    extends NamespaceFluent<ItemsNested<N>>
    implements Nested<N> {
        NamespaceBuilder builder;
        int index;

        ItemsNested(int index, Namespace item) {
            this.index = index;
            this.builder = new NamespaceBuilder(this, item);
        }

        public N and() {
            return (N)NamespaceListFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }
}

