/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceColumnDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceColumnDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceColumnDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceSubresources;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceSubresourcesBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceSubresourcesFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceValidation;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceValidationBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceValidationFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.SelectableField;
import io.fabric8.kubernetes.api.model.apiextensions.v1.SelectableFieldBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.SelectableFieldFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CustomResourceDefinitionVersionFluent<A extends CustomResourceDefinitionVersionFluent<A>>
extends BaseFluent<A> {
    private ArrayList<CustomResourceColumnDefinitionBuilder> additionalPrinterColumns = new ArrayList();
    private Map<String, Object> additionalProperties;
    private Boolean deprecated;
    private String deprecationWarning;
    private String name;
    private CustomResourceValidationBuilder schema;
    private ArrayList<SelectableFieldBuilder> selectableFields = new ArrayList();
    private Boolean served;
    private Boolean storage;
    private CustomResourceSubresourcesBuilder subresources;

    public CustomResourceDefinitionVersionFluent() {
    }

    public CustomResourceDefinitionVersionFluent(CustomResourceDefinitionVersion instance) {
        this.copyInstance(instance);
    }

    public A addAllToAdditionalPrinterColumns(Collection<CustomResourceColumnDefinition> items) {
        if (this.additionalPrinterColumns == null) {
            this.additionalPrinterColumns = new ArrayList();
        }
        for (CustomResourceColumnDefinition item : items) {
            CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
            this._visitables.get((Object)"additionalPrinterColumns").add(builder);
            this.additionalPrinterColumns.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSelectableFields(Collection<SelectableField> items) {
        if (this.selectableFields == null) {
            this.selectableFields = new ArrayList();
        }
        for (SelectableField item : items) {
            SelectableFieldBuilder builder = new SelectableFieldBuilder(item);
            this._visitables.get((Object)"selectableFields").add(builder);
            this.selectableFields.add(builder);
        }
        return (A)((Object)this);
    }

    public AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumn() {
        return new AdditionalPrinterColumnsNested(-1, null);
    }

    public AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumnLike(CustomResourceColumnDefinition item) {
        return new AdditionalPrinterColumnsNested(-1, item);
    }

    public SelectableFieldsNested<A> addNewSelectableField() {
        return new SelectableFieldsNested(-1, null);
    }

    public A addNewSelectableField(String jsonPath) {
        return this.addToSelectableFields(new SelectableField(jsonPath));
    }

    public SelectableFieldsNested<A> addNewSelectableFieldLike(SelectableField item) {
        return new SelectableFieldsNested(-1, item);
    }

    public A addToAdditionalPrinterColumns(CustomResourceColumnDefinition ... items) {
        if (this.additionalPrinterColumns == null) {
            this.additionalPrinterColumns = new ArrayList();
        }
        for (CustomResourceColumnDefinition item : items) {
            CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
            this._visitables.get((Object)"additionalPrinterColumns").add(builder);
            this.additionalPrinterColumns.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalPrinterColumns(int index, CustomResourceColumnDefinition item) {
        if (this.additionalPrinterColumns == null) {
            this.additionalPrinterColumns = new ArrayList();
        }
        CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
        if (index < 0 || index >= this.additionalPrinterColumns.size()) {
            this._visitables.get((Object)"additionalPrinterColumns").add(builder);
            this.additionalPrinterColumns.add(builder);
        } else {
            this._visitables.get((Object)"additionalPrinterColumns").add(builder);
            this.additionalPrinterColumns.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToSelectableFields(SelectableField ... items) {
        if (this.selectableFields == null) {
            this.selectableFields = new ArrayList();
        }
        for (SelectableField item : items) {
            SelectableFieldBuilder builder = new SelectableFieldBuilder(item);
            this._visitables.get((Object)"selectableFields").add(builder);
            this.selectableFields.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToSelectableFields(int index, SelectableField item) {
        if (this.selectableFields == null) {
            this.selectableFields = new ArrayList();
        }
        SelectableFieldBuilder builder = new SelectableFieldBuilder(item);
        if (index < 0 || index >= this.selectableFields.size()) {
            this._visitables.get((Object)"selectableFields").add(builder);
            this.selectableFields.add(builder);
        } else {
            this._visitables.get((Object)"selectableFields").add(builder);
            this.selectableFields.add(index, builder);
        }
        return (A)((Object)this);
    }

    public CustomResourceColumnDefinition buildAdditionalPrinterColumn(int index) {
        return this.additionalPrinterColumns.get(index).build();
    }

    public List<CustomResourceColumnDefinition> buildAdditionalPrinterColumns() {
        return this.additionalPrinterColumns != null ? CustomResourceDefinitionVersionFluent.build(this.additionalPrinterColumns) : null;
    }

    public CustomResourceColumnDefinition buildFirstAdditionalPrinterColumn() {
        return this.additionalPrinterColumns.get(0).build();
    }

    public SelectableField buildFirstSelectableField() {
        return this.selectableFields.get(0).build();
    }

    public CustomResourceColumnDefinition buildLastAdditionalPrinterColumn() {
        return this.additionalPrinterColumns.get(this.additionalPrinterColumns.size() - 1).build();
    }

    public SelectableField buildLastSelectableField() {
        return this.selectableFields.get(this.selectableFields.size() - 1).build();
    }

    public CustomResourceColumnDefinition buildMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
        for (CustomResourceColumnDefinitionBuilder item : this.additionalPrinterColumns) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public SelectableField buildMatchingSelectableField(Predicate<SelectableFieldBuilder> predicate) {
        for (SelectableFieldBuilder item : this.selectableFields) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public CustomResourceValidation buildSchema() {
        return this.schema != null ? this.schema.build() : null;
    }

    public SelectableField buildSelectableField(int index) {
        return this.selectableFields.get(index).build();
    }

    public List<SelectableField> buildSelectableFields() {
        return this.selectableFields != null ? CustomResourceDefinitionVersionFluent.build(this.selectableFields) : null;
    }

    public CustomResourceSubresources buildSubresources() {
        return this.subresources != null ? this.subresources.build() : null;
    }

    protected void copyInstance(CustomResourceDefinitionVersion instance) {
        CustomResourceDefinitionVersion customResourceDefinitionVersion = instance = instance != null ? instance : new CustomResourceDefinitionVersion();
        if (instance != null) {
            this.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns());
            this.withDeprecated(instance.getDeprecated());
            this.withDeprecationWarning(instance.getDeprecationWarning());
            this.withName(instance.getName());
            this.withSchema(instance.getSchema());
            this.withSelectableFields(instance.getSelectableFields());
            this.withServed(instance.getServed());
            this.withStorage(instance.getStorage());
            this.withSubresources(instance.getSubresources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AdditionalPrinterColumnsNested<A> editAdditionalPrinterColumn(int index) {
        if (this.additionalPrinterColumns.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "additionalPrinterColumns"));
        }
        return this.setNewAdditionalPrinterColumnLike(index, this.buildAdditionalPrinterColumn(index));
    }

    public AdditionalPrinterColumnsNested<A> editFirstAdditionalPrinterColumn() {
        if (this.additionalPrinterColumns.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "additionalPrinterColumns"));
        }
        return this.setNewAdditionalPrinterColumnLike(0, this.buildAdditionalPrinterColumn(0));
    }

    public SelectableFieldsNested<A> editFirstSelectableField() {
        if (this.selectableFields.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "selectableFields"));
        }
        return this.setNewSelectableFieldLike(0, this.buildSelectableField(0));
    }

    public AdditionalPrinterColumnsNested<A> editLastAdditionalPrinterColumn() {
        int index = this.additionalPrinterColumns.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "additionalPrinterColumns"));
        }
        return this.setNewAdditionalPrinterColumnLike(index, this.buildAdditionalPrinterColumn(index));
    }

    public SelectableFieldsNested<A> editLastSelectableField() {
        int index = this.selectableFields.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "selectableFields"));
        }
        return this.setNewSelectableFieldLike(index, this.buildSelectableField(index));
    }

    public AdditionalPrinterColumnsNested<A> editMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.additionalPrinterColumns.size(); ++i) {
            if (!predicate.test(this.additionalPrinterColumns.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "additionalPrinterColumns"));
        }
        return this.setNewAdditionalPrinterColumnLike(index, this.buildAdditionalPrinterColumn(index));
    }

    public SelectableFieldsNested<A> editMatchingSelectableField(Predicate<SelectableFieldBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.selectableFields.size(); ++i) {
            if (!predicate.test(this.selectableFields.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "selectableFields"));
        }
        return this.setNewSelectableFieldLike(index, this.buildSelectableField(index));
    }

    public SchemaNested<A> editOrNewSchema() {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(new CustomResourceValidationBuilder().build()));
    }

    public SchemaNested<A> editOrNewSchemaLike(CustomResourceValidation item) {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(item));
    }

    public SubresourcesNested<A> editOrNewSubresources() {
        return this.withNewSubresourcesLike(Optional.ofNullable(this.buildSubresources()).orElse(new CustomResourceSubresourcesBuilder().build()));
    }

    public SubresourcesNested<A> editOrNewSubresourcesLike(CustomResourceSubresources item) {
        return this.withNewSubresourcesLike(Optional.ofNullable(this.buildSubresources()).orElse(item));
    }

    public SchemaNested<A> editSchema() {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(null));
    }

    public SelectableFieldsNested<A> editSelectableField(int index) {
        if (this.selectableFields.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "selectableFields"));
        }
        return this.setNewSelectableFieldLike(index, this.buildSelectableField(index));
    }

    public SubresourcesNested<A> editSubresources() {
        return this.withNewSubresourcesLike(Optional.ofNullable(this.buildSubresources()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceDefinitionVersionFluent that = (CustomResourceDefinitionVersionFluent)((Object)o);
        if (!Objects.equals(this.additionalPrinterColumns, that.additionalPrinterColumns)) {
            return false;
        }
        if (!Objects.equals(this.deprecated, that.deprecated)) {
            return false;
        }
        if (!Objects.equals(this.deprecationWarning, that.deprecationWarning)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.schema, (Object)that.schema)) {
            return false;
        }
        if (!Objects.equals(this.selectableFields, that.selectableFields)) {
            return false;
        }
        if (!Objects.equals(this.served, that.served)) {
            return false;
        }
        if (!Objects.equals(this.storage, that.storage)) {
            return false;
        }
        if (!Objects.equals((Object)this.subresources, (Object)that.subresources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public String getDeprecationWarning() {
        return this.deprecationWarning;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getServed() {
        return this.served;
    }

    public Boolean getStorage() {
        return this.storage;
    }

    public boolean hasAdditionalPrinterColumns() {
        return this.additionalPrinterColumns != null && !this.additionalPrinterColumns.isEmpty();
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDeprecated() {
        return this.deprecated != null;
    }

    public boolean hasDeprecationWarning() {
        return this.deprecationWarning != null;
    }

    public boolean hasMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
        for (CustomResourceColumnDefinitionBuilder item : this.additionalPrinterColumns) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingSelectableField(Predicate<SelectableFieldBuilder> predicate) {
        for (SelectableFieldBuilder item : this.selectableFields) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasSchema() {
        return this.schema != null;
    }

    public boolean hasSelectableFields() {
        return this.selectableFields != null && !this.selectableFields.isEmpty();
    }

    public boolean hasServed() {
        return this.served != null;
    }

    public boolean hasStorage() {
        return this.storage != null;
    }

    public boolean hasSubresources() {
        return this.subresources != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalPrinterColumns, this.deprecated, this.deprecationWarning, this.name, this.schema, this.selectableFields, this.served, this.storage, this.subresources, this.additionalProperties});
    }

    public A removeAllFromAdditionalPrinterColumns(Collection<CustomResourceColumnDefinition> items) {
        if (this.additionalPrinterColumns == null) {
            return (A)((Object)this);
        }
        for (CustomResourceColumnDefinition item : items) {
            CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
            this._visitables.get((Object)"additionalPrinterColumns").remove((Object)builder);
            this.additionalPrinterColumns.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSelectableFields(Collection<SelectableField> items) {
        if (this.selectableFields == null) {
            return (A)((Object)this);
        }
        for (SelectableField item : items) {
            SelectableFieldBuilder builder = new SelectableFieldBuilder(item);
            this._visitables.get((Object)"selectableFields").remove((Object)builder);
            this.selectableFields.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalPrinterColumns(CustomResourceColumnDefinition ... items) {
        if (this.additionalPrinterColumns == null) {
            return (A)((Object)this);
        }
        for (CustomResourceColumnDefinition item : items) {
            CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
            this._visitables.get((Object)"additionalPrinterColumns").remove((Object)builder);
            this.additionalPrinterColumns.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromSelectableFields(SelectableField ... items) {
        if (this.selectableFields == null) {
            return (A)((Object)this);
        }
        for (SelectableField item : items) {
            SelectableFieldBuilder builder = new SelectableFieldBuilder(item);
            this._visitables.get((Object)"selectableFields").remove((Object)builder);
            this.selectableFields.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAdditionalPrinterColumns(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
        if (this.additionalPrinterColumns == null) {
            return (A)((Object)this);
        }
        Iterator<CustomResourceColumnDefinitionBuilder> each = this.additionalPrinterColumns.iterator();
        List visitables = this._visitables.get((Object)"additionalPrinterColumns");
        while (each.hasNext()) {
            CustomResourceColumnDefinitionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSelectableFields(Predicate<SelectableFieldBuilder> predicate) {
        if (this.selectableFields == null) {
            return (A)((Object)this);
        }
        Iterator<SelectableFieldBuilder> each = this.selectableFields.iterator();
        List visitables = this._visitables.get((Object)"selectableFields");
        while (each.hasNext()) {
            SelectableFieldBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public AdditionalPrinterColumnsNested<A> setNewAdditionalPrinterColumnLike(int index, CustomResourceColumnDefinition item) {
        return new AdditionalPrinterColumnsNested(index, item);
    }

    public SelectableFieldsNested<A> setNewSelectableFieldLike(int index, SelectableField item) {
        return new SelectableFieldsNested(index, item);
    }

    public A setToAdditionalPrinterColumns(int index, CustomResourceColumnDefinition item) {
        if (this.additionalPrinterColumns == null) {
            this.additionalPrinterColumns = new ArrayList();
        }
        CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
        if (index < 0 || index >= this.additionalPrinterColumns.size()) {
            this._visitables.get((Object)"additionalPrinterColumns").add(builder);
            this.additionalPrinterColumns.add(builder);
        } else {
            this._visitables.get((Object)"additionalPrinterColumns").add(builder);
            this.additionalPrinterColumns.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSelectableFields(int index, SelectableField item) {
        if (this.selectableFields == null) {
            this.selectableFields = new ArrayList();
        }
        SelectableFieldBuilder builder = new SelectableFieldBuilder(item);
        if (index < 0 || index >= this.selectableFields.size()) {
            this._visitables.get((Object)"selectableFields").add(builder);
            this.selectableFields.add(builder);
        } else {
            this._visitables.get((Object)"selectableFields").add(builder);
            this.selectableFields.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalPrinterColumns != null && !this.additionalPrinterColumns.isEmpty()) {
            sb.append("additionalPrinterColumns:");
            sb.append(this.additionalPrinterColumns);
            sb.append(",");
        }
        if (this.deprecated != null) {
            sb.append("deprecated:");
            sb.append(this.deprecated);
            sb.append(",");
        }
        if (this.deprecationWarning != null) {
            sb.append("deprecationWarning:");
            sb.append(this.deprecationWarning);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.schema != null) {
            sb.append("schema:");
            sb.append((Object)this.schema);
            sb.append(",");
        }
        if (this.selectableFields != null && !this.selectableFields.isEmpty()) {
            sb.append("selectableFields:");
            sb.append(this.selectableFields);
            sb.append(",");
        }
        if (this.served != null) {
            sb.append("served:");
            sb.append(this.served);
            sb.append(",");
        }
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(this.storage);
            sb.append(",");
        }
        if (this.subresources != null) {
            sb.append("subresources:");
            sb.append((Object)this.subresources);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAdditionalPrinterColumns(List<CustomResourceColumnDefinition> additionalPrinterColumns) {
        if (this.additionalPrinterColumns != null) {
            this._visitables.get((Object)"additionalPrinterColumns").clear();
        }
        if (additionalPrinterColumns != null) {
            this.additionalPrinterColumns = new ArrayList();
            for (CustomResourceColumnDefinition item : additionalPrinterColumns) {
                this.addToAdditionalPrinterColumns(item);
            }
        } else {
            this.additionalPrinterColumns = null;
        }
        return (A)((Object)this);
    }

    public A withAdditionalPrinterColumns(CustomResourceColumnDefinition ... additionalPrinterColumns) {
        if (this.additionalPrinterColumns != null) {
            this.additionalPrinterColumns.clear();
            this._visitables.remove((Object)"additionalPrinterColumns");
        }
        if (additionalPrinterColumns != null) {
            for (CustomResourceColumnDefinition item : additionalPrinterColumns) {
                this.addToAdditionalPrinterColumns(item);
            }
        }
        return (A)((Object)this);
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDeprecated() {
        return this.withDeprecated(true);
    }

    public A withDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return (A)((Object)this);
    }

    public A withDeprecationWarning(String deprecationWarning) {
        this.deprecationWarning = deprecationWarning;
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public SchemaNested<A> withNewSchema() {
        return new SchemaNested(null);
    }

    public SchemaNested<A> withNewSchemaLike(CustomResourceValidation item) {
        return new SchemaNested(item);
    }

    public SubresourcesNested<A> withNewSubresources() {
        return new SubresourcesNested(null);
    }

    public SubresourcesNested<A> withNewSubresourcesLike(CustomResourceSubresources item) {
        return new SubresourcesNested(item);
    }

    public A withSchema(CustomResourceValidation schema) {
        this._visitables.remove((Object)"schema");
        if (schema != null) {
            this.schema = new CustomResourceValidationBuilder(schema);
            this._visitables.get((Object)"schema").add(this.schema);
        } else {
            this.schema = null;
            this._visitables.get((Object)"schema").remove((Object)this.schema);
        }
        return (A)((Object)this);
    }

    public A withSelectableFields(List<SelectableField> selectableFields) {
        if (this.selectableFields != null) {
            this._visitables.get((Object)"selectableFields").clear();
        }
        if (selectableFields != null) {
            this.selectableFields = new ArrayList();
            for (SelectableField item : selectableFields) {
                this.addToSelectableFields(item);
            }
        } else {
            this.selectableFields = null;
        }
        return (A)((Object)this);
    }

    public A withSelectableFields(SelectableField ... selectableFields) {
        if (this.selectableFields != null) {
            this.selectableFields.clear();
            this._visitables.remove((Object)"selectableFields");
        }
        if (selectableFields != null) {
            for (SelectableField item : selectableFields) {
                this.addToSelectableFields(item);
            }
        }
        return (A)((Object)this);
    }

    public A withServed() {
        return this.withServed(true);
    }

    public A withServed(Boolean served) {
        this.served = served;
        return (A)((Object)this);
    }

    public A withStorage() {
        return this.withStorage(true);
    }

    public A withStorage(Boolean storage) {
        this.storage = storage;
        return (A)((Object)this);
    }

    public A withSubresources(CustomResourceSubresources subresources) {
        this._visitables.remove((Object)"subresources");
        if (subresources != null) {
            this.subresources = new CustomResourceSubresourcesBuilder(subresources);
            this._visitables.get((Object)"subresources").add(this.subresources);
        } else {
            this.subresources = null;
            this._visitables.get((Object)"subresources").remove((Object)this.subresources);
        }
        return (A)((Object)this);
    }

    public class SubresourcesNested<N>
    extends CustomResourceSubresourcesFluent<SubresourcesNested<N>>
    implements Nested<N> {
        CustomResourceSubresourcesBuilder builder;

        SubresourcesNested(CustomResourceSubresources item) {
            this.builder = new CustomResourceSubresourcesBuilder(this, item);
        }

        public N and() {
            return (N)CustomResourceDefinitionVersionFluent.this.withSubresources(this.builder.build());
        }

        public N endSubresources() {
            return this.and();
        }
    }

    public class SelectableFieldsNested<N>
    extends SelectableFieldFluent<SelectableFieldsNested<N>>
    implements Nested<N> {
        SelectableFieldBuilder builder;
        int index;

        SelectableFieldsNested(int index, SelectableField item) {
            this.index = index;
            this.builder = new SelectableFieldBuilder(this, item);
        }

        public N and() {
            return (N)CustomResourceDefinitionVersionFluent.this.setToSelectableFields(this.index, this.builder.build());
        }

        public N endSelectableField() {
            return this.and();
        }
    }

    public class SchemaNested<N>
    extends CustomResourceValidationFluent<SchemaNested<N>>
    implements Nested<N> {
        CustomResourceValidationBuilder builder;

        SchemaNested(CustomResourceValidation item) {
            this.builder = new CustomResourceValidationBuilder(this, item);
        }

        public N and() {
            return (N)CustomResourceDefinitionVersionFluent.this.withSchema(this.builder.build());
        }

        public N endSchema() {
            return this.and();
        }
    }

    public class AdditionalPrinterColumnsNested<N>
    extends CustomResourceColumnDefinitionFluent<AdditionalPrinterColumnsNested<N>>
    implements Nested<N> {
        CustomResourceColumnDefinitionBuilder builder;
        int index;

        AdditionalPrinterColumnsNested(int index, CustomResourceColumnDefinition item) {
            this.index = index;
            this.builder = new CustomResourceColumnDefinitionBuilder(this, item);
        }

        public N and() {
            return (N)CustomResourceDefinitionVersionFluent.this.setToAdditionalPrinterColumns(this.index, this.builder.build());
        }

        public N endAdditionalPrinterColumn() {
            return this.and();
        }
    }
}

