/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelOutputStream.class);
    private ChannelHandlerContext chc;
    private int bufSize;
    private String id;
    private ByteBuf buf;
    private byte[] singleByte = new byte[1];
    private boolean closed = false;
    private final Object writeMonitor = new Object();
    private final int maxPendingWrites;
    private volatile int pendingWrites = 0;
    private ChannelFutureListener writeListener = new ChannelFutureListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ChannelFuture future) {
            ChannelOutputStream.this.pendingWrites--;
            if (future.isCancelled()) {
                LOG.error("Write cancelled on ID " + ChannelOutputStream.this.id);
            } else if (!future.isSuccess()) {
                LOG.error("Write error on ID " + ChannelOutputStream.this.id, future.cause());
            }
            Object object = ChannelOutputStream.this.writeMonitor;
            synchronized (object) {
                ChannelOutputStream.this.writeMonitor.notifyAll();
            }
        }
    };
    private ChannelFutureListener closeListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) {
            if (future.isCancelled()) {
                LOG.error("Close cancelled on ID " + ChannelOutputStream.this.id);
            } else if (!future.isSuccess()) {
                LOG.error("Close failed on ID " + ChannelOutputStream.this.id, future.cause());
            }
        }
    };

    public ChannelOutputStream(ChannelHandlerContext chc, String id, int bufSize, int maxOutstandingWrites) {
        this.chc = chc;
        this.id = id;
        this.bufSize = bufSize;
        this.buf = chc.alloc().buffer(bufSize);
        this.maxPendingWrites = maxOutstandingWrites;
    }

    @Override
    public void write(int b) throws IOException {
        this.singleByte[0] = (byte)b;
        this.write(this.singleByte, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int currentOffset = off;
        int bytesRemaining = len;
        while (bytesRemaining + this.buf.readableBytes() > this.bufSize) {
            int iterationLen = this.bufSize - this.buf.readableBytes();
            this.writeInternal(b, currentOffset, iterationLen);
            currentOffset += iterationLen;
            bytesRemaining -= iterationLen;
        }
        if (bytesRemaining > 0) {
            this.writeInternal(b, currentOffset, bytesRemaining);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.buf.isReadable()) {
            this.writeToChannel();
        }
        this.chc.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed: " + this.id);
        }
        try {
            this.flush();
        }
        catch (IOException err) {
            LOG.error("Error flushing stream before close", (Throwable)err);
        }
        this.closed = true;
        this.waitForWritesToFinish(0);
        try {
            this.chc.close().addListener((GenericFutureListener)this.closeListener);
        }
        finally {
            this.buf.release();
            this.buf = null;
            this.chc = null;
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForWritesToFinish(int desiredWriteCount) throws IOException {
        Object object = this.writeMonitor;
        synchronized (object) {
            while (this.pendingWrites > desiredWriteCount) {
                try {
                    this.writeMonitor.wait();
                }
                catch (InterruptedException ie) {
                    throw new IOException("Interrupted while waiting for write operations to finish for " + this.id);
                }
            }
        }
    }

    private void writeToChannel() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed: " + this.id);
        }
        this.waitForWritesToFinish(this.maxPendingWrites - 1);
        ++this.pendingWrites;
        this.chc.writeAndFlush((Object)this.buf.copy()).addListener((GenericFutureListener)this.writeListener);
        this.buf.clear();
    }

    private void writeInternal(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed: " + this.id);
        }
        this.buf.writeBytes(b, off, len);
        if (this.buf.readableBytes() >= this.bufSize) {
            this.writeToChannel();
        }
    }
}

