/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SetOperation;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNodeTag;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class TypeCoercionValidation$
implements QueryErrorsBase {
    public static final TypeCoercionValidation$ MODULE$ = new TypeCoercionValidation$();
    private static final TreeNodeTag<BoxedUnit> DATA_TYPE_MISMATCH_ERROR;

    static {
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)MODULE$);
        QueryErrorsBase.$init$(MODULE$);
        DATA_TYPE_MISMATCH_ERROR = new TreeNodeTag("dataTypeMismatchError");
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    private TreeNodeTag<BoxedUnit> DATA_TYPE_MISMATCH_ERROR() {
        return DATA_TYPE_MISMATCH_ERROR;
    }

    public Nothing$ failOnTypeCheckResult(Expression e, Option<LogicalPlan> operator) {
        TypeCheckResult typeCheckResult = e.checkInputDataTypes();
        if (typeCheckResult instanceof TypeCheckResult.DataTypeMismatch) {
            TypeCheckResult.DataTypeMismatch dataTypeMismatch = (TypeCheckResult.DataTypeMismatch)typeCheckResult;
            e.setTagValue(this.DATA_TYPE_MISMATCH_ERROR(), BoxedUnit.UNIT);
            return package$.MODULE$.AnalysisErrorAt(e).dataTypeMismatch(e, dataTypeMismatch);
        }
        if (typeCheckResult instanceof TypeCheckResult.TypeCheckFailure) {
            TypeCheckResult.TypeCheckFailure typeCheckFailure = (TypeCheckResult.TypeCheckFailure)typeCheckResult;
            String message = typeCheckFailure.message();
            e.setTagValue(this.DATA_TYPE_MISMATCH_ERROR(), BoxedUnit.UNIT);
            String extraHint = (String)operator.map((Function1 & Serializable)x$1 -> MODULE$.getHintForExpressionCoercion((LogicalPlan)x$1)).getOrElse((Function0 & Serializable)() -> "");
            return package$.MODULE$.AnalysisErrorAt(e).failAnalysis("DATATYPE_MISMATCH.TYPE_CHECK_FAILURE_WITH_HINT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)this.toSQLExpr(e)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)message), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)extraHint)}))));
        }
        if (typeCheckResult instanceof TypeCheckResult.InvalidFormat) {
            TypeCheckResult.InvalidFormat invalidFormat = (TypeCheckResult.InvalidFormat)typeCheckResult;
            return package$.MODULE$.AnalysisErrorAt(e).invalidFormat(invalidFormat);
        }
        throw new MatchError((Object)typeCheckResult);
    }

    public Option<LogicalPlan> failOnTypeCheckResult$default$2() {
        return None$.MODULE$;
    }

    public String getHintForOperatorCoercion(LogicalPlan plan2) {
        BooleanRef issueFixedIfAnsiOff;
        block1: {
            if (!SQLConf$.MODULE$.get().ansiEnabled()) {
                return "";
            }
            LogicalPlan nonAnsiPlan = this.getDefaultTypeCoercionPlan(plan2);
            issueFixedIfAnsiOff = BooleanRef.create((boolean)true);
            LogicalPlan logicalPlan = nonAnsiPlan;
            if (!(logicalPlan instanceof Union ? true : logicalPlan instanceof SetOperation) || nonAnsiPlan.children().length() <= 1) break block1;
            Seq ref = TypeCoercionValidation$.dataTypes$1((LogicalPlan)nonAnsiPlan.children().head());
            Function2<DataType, DataType, Object> dataTypesAreCompatibleFn = this.getDataTypesAreCompatibleFn(nonAnsiPlan);
            ((IterableOnceOps)((IterableOps)nonAnsiPlan.children().tail()).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                TypeCoercionValidation$.$anonfun$getHintForOperatorCoercion$2(ref, dataTypesAreCompatibleFn, issueFixedIfAnsiOff, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        return this.extraHintMessage(issueFixedIfAnsiOff.elem);
    }

    public Function2<DataType, DataType, Object> getDataTypesAreCompatibleFn(LogicalPlan plan2) {
        boolean isUnion = plan2 instanceof Union;
        if (isUnion) {
            return (Function2 & Serializable)(dt1, dt2) -> BoxesRunTime.boxToBoolean((boolean)DataType$.MODULE$.equalsStructurally(dt1, dt2, true));
        }
        return (Function2 & Serializable)(dt1, dt2) -> BoxesRunTime.boxToBoolean((boolean)TypeCoercionValidation$.$anonfun$getDataTypesAreCompatibleFn$2(dt1, dt2));
    }

    private String getHintForExpressionCoercion(LogicalPlan plan2) {
        if (!SQLConf$.MODULE$.get().ansiEnabled()) {
            return "";
        }
        LogicalPlan nonAnsiPlan = this.getDefaultTypeCoercionPlan(plan2);
        BooleanRef issueFixedIfAnsiOff = BooleanRef.create((boolean)true);
        this.getAllExpressions(nonAnsiPlan).foreach((Function1 & Serializable)x$3 -> {
            x$3.foreachUp((Function1 & Serializable)x0$1 -> {
                TypeCoercionValidation$.$anonfun$getHintForExpressionCoercion$2(issueFixedIfAnsiOff$2, x0$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return this.extraHintMessage(issueFixedIfAnsiOff.elem);
    }

    private LogicalPlan getDefaultTypeCoercionPlan(LogicalPlan plan2) {
        return (LogicalPlan)TypeCoercion$.MODULE$.typeCoercionRules().foldLeft((Object)plan2, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                LogicalPlan p = (LogicalPlan)tuple2._1();
                Rule rule = (Rule)tuple2._2();
                return rule.apply(p);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private String extraHintMessage(boolean issueFixedIfAnsiOff) {
        if (issueFixedIfAnsiOff) {
            return "\nTo fix the error, you might need to add explicit type casts. If necessary set " + SQLConf$.MODULE$.ANSI_ENABLED().key() + " to false to bypass this error.";
        }
        return "";
    }

    private Seq<Expression> getAllExpressions(LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)logicalPlan;
            return (Seq)aggregate.aggregateExpressions().$plus$plus(aggregate.groupingExpressions());
        }
        return plan2.expressions();
    }

    private static final Seq dataTypes$1(LogicalPlan plan2) {
        return (Seq)plan2.output().map((Function1 & Serializable)x$2 -> x$2.dataType());
    }

    public static final /* synthetic */ void $anonfun$getHintForOperatorCoercion$3(Function2 dataTypesAreCompatibleFn$1, BooleanRef issueFixedIfAnsiOff$1, Tuple2 x0$2) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$2;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
            DataType dt2;
            DataType dt1 = (DataType)tuple2._1();
            if (!BoxesRunTime.unboxToBoolean((Object)dataTypesAreCompatibleFn$1.apply((Object)dt1, (Object)(dt2 = (DataType)tuple2._2())))) {
                issueFixedIfAnsiOff$1.elem = false;
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple22);
    }

    public static final /* synthetic */ void $anonfun$getHintForOperatorCoercion$2(Seq ref$1, Function2 dataTypesAreCompatibleFn$1, BooleanRef issueFixedIfAnsiOff$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            LogicalPlan child = (LogicalPlan)tuple2._1();
            ((IterableOnceOps)((IterableOps)TypeCoercionValidation$.dataTypes$1(child).zip((IterableOnce)ref$1)).zipWithIndex()).foreach((Function1 & Serializable)x0$2 -> {
                TypeCoercionValidation$.$anonfun$getHintForOperatorCoercion$3(dataTypesAreCompatibleFn$1, issueFixedIfAnsiOff$1, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getDataTypesAreCompatibleFn$2(DataType dt1, DataType dt2) {
        return TypeCoercion$.MODULE$.findWiderTypeForTwo(dt1.asNullable(), dt2.asNullable()).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$getHintForExpressionCoercion$2(BooleanRef issueFixedIfAnsiOff$2, Expression x0$1) {
        Expression expression;
        Expression expression2 = x0$1;
        if (expression2 != null && (expression = expression2).containsTag(MODULE$.DATA_TYPE_MISMATCH_ERROR()) && expression.checkInputDataTypes().isFailure()) {
            TypeCheckResult typeCheckResult = expression.checkInputDataTypes();
            if (!(typeCheckResult instanceof TypeCheckResult.TypeCheckFailure ? true : typeCheckResult instanceof TypeCheckResult.DataTypeMismatch)) {
                throw new MatchError((Object)typeCheckResult);
            }
            issueFixedIfAnsiOff$2.elem = false;
            return;
        }
    }

    private TypeCoercionValidation$() {
    }
}

