/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LengthOfJsonArray$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.json.JsonExpressionUtils;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(jsonArray) - Returns the number of elements in the outermost JSON array.", arguments="\n    Arguments:\n      * jsonArray - A JSON array. `NULL` is returned in case of any other valid JSON string,\n          `NULL` or an invalid JSON.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('[1,2,3,4]');\n        4\n      > SELECT _FUNC_('[1,2,3,{\"f1\":1,\"f2\":[5,6]},4]');\n        5\n      > SELECT _FUNC_('[1,2');\n        NULL\n  ", group="json_funcs", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001\u0002\u000e\u001c\u0001\"B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\")1\n\u0001C\u0001\u0019\")q\n\u0001C!!\")!\f\u0001C!7\")q\f\u0001C!A\")A\r\u0001C!K\")a\u000e\u0001C)_\")!\u000f\u0001C!\r\"91\u000fAA\u0001\n\u0003!\bb\u0002<\u0001#\u0003%\ta\u001e\u0005\n\u0003\u000b\u0001\u0011\u0011!C!\u0003\u000fA\u0011\"a\u0006\u0001\u0003\u0003%\t!!\u0007\t\u0013\u0005\u0005\u0002!!A\u0005\u0002\u0005\r\u0002\"CA\u0018\u0001\u0005\u0005I\u0011IA\u0019\u0011%\ty\u0004AA\u0001\n\u0003\t\t\u0005C\u0005\u0002F\u0001\t\t\u0011\"\u0011\u0002H!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0013QJ\u0004\n\u0003oZ\u0012\u0011!E\u0001\u0003s2\u0001BG\u000e\u0002\u0002#\u0005\u00111\u0010\u0005\u0007\u0017R!\t!a%\t\u0013\u0005UE#!A\u0005F\u0005]\u0005\"CAM)\u0005\u0005I\u0011QAN\u0011%\ty\nFA\u0001\n\u0003\u000b\t\u000bC\u0005\u0002.R\t\t\u0011\"\u0003\u00020\n\tB*\u001a8hi\"|eMS:p]\u0006\u0013(/Y=\u000b\u0005qi\u0012aC3yaJ,7o]5p]NT!AH\u0010\u0002\u0011\r\fG/\u00197zgRT!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u0015.aMJ\u0004C\u0001\u0016,\u001b\u0005Y\u0012B\u0001\u0017\u001c\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u0016/\u0013\ty3DA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"AK\u0019\n\u0005IZ\"A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u0004\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002;\u0005:\u00111\b\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}\u001d\na\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0005\u0005+\u0014a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!Q\u001b\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003\u001d\u0003\"A\u000b%\n\u0005%[\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na\u0001P5oSRtDCA'O!\tQ\u0003\u0001C\u0003F\u0007\u0001\u0007q)\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0015\t\u0004uI#\u0016BA*E\u0005\r\u0019V-\u001d\t\u0003+bk\u0011A\u0016\u0006\u0003/~\tQ\u0001^=qKNL!!\u0017,\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003q\u0003\"!V/\n\u0005y3&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016,\u0012!\u0019\t\u0003i\tL!aY\u001b\u0003\u000f\t{w\u000e\\3b]\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003\u0019\u0004\"aZ6\u000f\u0005!L\u0007C\u0001\u001f6\u0013\tQW'\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u000166\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0011Q\n\u001d\u0005\u0006c\"\u0001\raR\u0001\t]\u0016<8\t[5mI\u0006Y!/\u001a9mC\u000e,W.\u001a8u\u0003\u0011\u0019w\u000e]=\u0015\u00055+\bbB#\u000b!\u0003\u0005\raR\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005A(FA$zW\u0005Q\bcA>\u0002\u00025\tAP\u0003\u0002~}\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u007fV\n!\"\u00198o_R\fG/[8o\u0013\r\t\u0019\u0001 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\nA!\u00111BA\u000b\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011\u0001\u00027b]\u001eT!!a\u0005\u0002\t)\fg/Y\u0005\u0004Y\u00065\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u000e!\r!\u0014QD\u0005\u0004\u0003?)$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0013\u0003W\u00012\u0001NA\u0014\u0013\r\tI#\u000e\u0002\u0004\u0003:L\b\"CA\u0017\u001d\u0005\u0005\t\u0019AA\u000e\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0007\t\u0007\u0003k\tY$!\n\u000e\u0005\u0005]\"bAA\u001dk\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u0012q\u0007\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002b\u0003\u0007B\u0011\"!\f\u0011\u0003\u0003\u0005\r!!\n\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0013\tI\u0005C\u0005\u0002.E\t\t\u00111\u0001\u0002\u001c\u00051Q-];bYN$2!YA(\u0011%\tiCEA\u0001\u0002\u0004\t)\u0003K\f\u0001\u0003'\nI&a\u0017\u0002`\u0005\u0005\u0014QMA4\u0003W\ni'!\u001d\u0002tA\u0019!&!\u0016\n\u0007\u0005]3DA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005u\u0013aT0G+:\u001bu\f\u000b6t_:\f%O]1zS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002rW/\u001c2fe\u0002zg\rI3mK6,g\u000e^:!S:\u0004C\u000f[3!_V$XM]7pgR\u0004#jU(OA\u0005\u0014(/Y=/\u0003%\t'oZ;nK:$8/\t\u0002\u0002d\u0005\tIC\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!UN|g.\u0011:sCf\u0004S\u0006I!!\u0015N{e\nI1se\u0006Lh\u0006\t1O+2c\u0005\rI5tAI,G/\u001e:oK\u0012\u0004\u0013N\u001c\u0011dCN,\u0007e\u001c4!C:L\be\u001c;iKJ\u0004c/\u00197jI\u0002R5k\u0014(!gR\u0014\u0018N\\4-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u0019(V\u00192\u0003\u0007e\u001c:!C:\u0004\u0013N\u001c<bY&$\u0007ES*P\u001d:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011N\u0001\u0002\\)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CseW\u0019-e1\u001aD\u0006N/(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Om\u000bDF\r\u00174Ym\u0014c-\r\u0012;c1\u0012cM\r\u0012;7Vbc'X?-iu;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!k)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CseW\u0019-e\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005=\u0014A\u00036t_:|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011QO\u0001\u0006g9\nd\u0006M\u0001\u0012\u0019\u0016tw\r\u001e5PM*\u001bxN\\!se\u0006L\bC\u0001\u0016\u0015'\u0015!\u0012QPAE!\u0019\ty(!\"H\u001b6\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u0007+\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u000f\u000b\tIA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!a#\u0002\u00126\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t\"\u0001\u0002j_&\u00191)!$\u0015\u0005\u0005e\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0011!B1qa2LHcA'\u0002\u001e\")Qi\u0006a\u0001\u000f\u00069QO\\1qa2LH\u0003BAR\u0003S\u0003B\u0001NAS\u000f&\u0019\u0011qU\u001b\u0003\r=\u0003H/[8o\u0011!\tY\u000bGA\u0001\u0002\u0004i\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u0017\t\u0005\u0003\u0017\t\u0019,\u0003\u0003\u00026\u00065!AB(cU\u0016\u001cG\u000f")
public class LengthOfJsonArray
extends UnaryExpression
implements ExpectsInputTypes,
RuntimeReplaceable,
Serializable {
    private final Expression child;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Expression> unapply(LengthOfJsonArray x$0) {
        return LengthOfJsonArray$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<LengthOfJsonArray, A> g) {
        return LengthOfJsonArray$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, LengthOfJsonArray> compose(Function1<A$, Expression> g) {
        return LengthOfJsonArray$.MODULE$.compose(g);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        LengthOfJsonArray lengthOfJsonArray = this;
        synchronized (lengthOfJsonArray) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if (!this.bitmap$0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "json_array_length";
    }

    @Override
    public LengthOfJsonArray withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    @Override
    public Expression replacement() {
        return new StaticInvoke(JsonExpressionUtils.class, this.dataType(), "lengthOfJsonArray", (Seq<Expression>)new .colon.colon((Object)this.child(), (List)Nil$.MODULE$), this.inputTypes(), StaticInvoke$.MODULE$.apply$default$6(), StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8(), StaticInvoke$.MODULE$.apply$default$9());
    }

    public LengthOfJsonArray copy(Expression child) {
        return new LengthOfJsonArray(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "LengthOfJsonArray";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LengthOfJsonArray;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LengthOfJsonArray)) return false;
        boolean bl = true;
        if (!bl) return false;
        LengthOfJsonArray lengthOfJsonArray = (LengthOfJsonArray)x$1;
        Expression expression = this.child();
        Expression expression2 = lengthOfJsonArray.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!lengthOfJsonArray.canEqual(this)) return false;
        return true;
    }

    public LengthOfJsonArray(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        RuntimeReplaceable.$init$(this);
        Statics.releaseFence();
    }
}

