/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.types;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$StoreAssignmentPolicy$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.CharType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.FixedLength;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MaxLength;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NoConstraint$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StringConstraint;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.VarcharType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class DataTypeUtils$ {
    public static final DataTypeUtils$ MODULE$ = new DataTypeUtils$();
    private static final Regex SparkGeneratedName = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("col\\d+"));

    public boolean sameType(DataType left, DataType right) {
        return left.sameType(right);
    }

    public boolean equalsIgnoreNullability(DataType left, DataType right) {
        return DataType$.MODULE$.equalsIgnoreNullability(left, right);
    }

    public boolean equalsIgnoreCaseAndNullability(DataType from, DataType to) {
        return DataType$.MODULE$.equalsIgnoreCaseAndNullability(from, to);
    }

    public boolean equalsIgnoreCaseNullabilityAndCollation(DataType from, DataType to) {
        Tuple2 tuple2;
        block9: {
            while (true) {
                if ((tuple2 = new Tuple2((Object)from, (Object)to)) != null) {
                    DataType dataType = (DataType)tuple2._1();
                    DataType dataType2 = (DataType)tuple2._2();
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType fromElement = arrayType.elementType();
                        if (dataType2 instanceof ArrayType) {
                            DataType toElement;
                            ArrayType arrayType2 = (ArrayType)dataType2;
                            to = toElement = arrayType2.elementType();
                            from = fromElement;
                            continue;
                        }
                    }
                }
                if (tuple2 == null) break block9;
                DataType dataType = (DataType)tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (!(dataType instanceof MapType)) break block9;
                MapType mapType = (MapType)dataType;
                DataType fromKey = mapType.keyType();
                DataType fromValue = mapType.valueType();
                if (!(dataType3 instanceof MapType)) break block9;
                MapType mapType2 = (MapType)dataType3;
                DataType toKey = mapType2.keyType();
                DataType toValue = mapType2.valueType();
                if (!this.equalsIgnoreCaseNullabilityAndCollation(fromKey, toKey)) break;
                to = toValue;
                from = fromValue;
            }
            return false;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fromFields = structType.fields();
                if (dataType4 instanceof StructType) {
                    StructType structType2 = (StructType)dataType4;
                    StructField[] toFields = structType2.fields();
                    return fromFields.length == toFields.length && ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])fromFields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])toFields))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.$anonfun$equalsIgnoreCaseNullabilityAndCollation$1(x0$1)));
                }
            }
        }
        if (tuple2 != null && tuple2._1() instanceof StringType && tuple2._2() instanceof StringType) {
            return true;
        }
        if (tuple2 != null) {
            DataType fromDataType = (DataType)tuple2._1();
            DataType toDataType = (DataType)tuple2._2();
            DataType dataType = fromDataType;
            DataType dataType5 = toDataType;
            return !(dataType != null ? !dataType.equals(dataType5) : dataType5 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    private Regex SparkGeneratedName() {
        return SparkGeneratedName;
    }

    private boolean isSparkGeneratedName(String name) {
        Option option;
        String string = name;
        return string != null && !(option = this.SparkGeneratedName().unapplySeq((CharSequence)string)).isEmpty();
    }

    public boolean canWrite(String tableName, DataType write, DataType read, boolean byName, Function2<String, String, Object> resolver, String context, Enumeration.Value storeAssignmentPolicy, Function1<String, BoxedUnit> addError) {
        Tuple2 tuple2;
        while (true) {
            DataType r;
            DataType w;
            if ((tuple2 = new Tuple2((Object)write, (Object)read)) != null) {
                DataType wArr = (DataType)tuple2._1();
                DataType rArr = (DataType)tuple2._2();
                if (wArr instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)wArr;
                    if (rArr instanceof ArrayType) {
                        ArrayType arrayType2 = (ArrayType)rArr;
                        boolean typesCompatible = this.canWrite(tableName, arrayType.elementType(), arrayType2.elementType(), byName, resolver, context + ".element", storeAssignmentPolicy, addError);
                        if (arrayType.containsNull() && !arrayType2.containsNull()) {
                            throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableNullableArrayElementsError(tableName, context);
                        }
                        return typesCompatible;
                    }
                }
            }
            if (tuple2 != null) {
                DataType wMap = (DataType)tuple2._1();
                DataType rMap = (DataType)tuple2._2();
                if (wMap instanceof MapType) {
                    MapType mapType = (MapType)wMap;
                    if (rMap instanceof MapType) {
                        MapType mapType2 = (MapType)rMap;
                        boolean keyCompatible = this.canWrite(tableName, mapType.keyType(), mapType2.keyType(), byName, resolver, context + ".key", storeAssignmentPolicy, addError);
                        boolean valueCompatible = this.canWrite(tableName, mapType.valueType(), mapType2.valueType(), byName, resolver, context + ".value", storeAssignmentPolicy, addError);
                        if (mapType.valueContainsNull() && !mapType2.valueContainsNull()) {
                            throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableNullableMapValuesError(tableName, context);
                        }
                        return keyCompatible && valueCompatible;
                    }
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType2 = (DataType)tuple2._2();
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] writeFields = structType.fields();
                    if (dataType2 instanceof StructType) {
                        StructType structType2 = (StructType)dataType2;
                        StructField[] readFields = structType2.fields();
                        BooleanRef fieldCompatible = BooleanRef.create((boolean)true);
                        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])readFields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])writeFields))))), (Function1 & Serializable)x0$1 -> {
                            DataTypeUtils$.$anonfun$canWrite$1(resolver, context, tableName, byName, storeAssignmentPolicy, addError, fieldCompatible, x0$1);
                            return BoxedUnit.UNIT;
                        });
                        if (readFields.length > writeFields.length) {
                            String missingFieldsStr = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])readFields), readFields.length - writeFields.length)), (Function1 & Serializable)f -> String.valueOf(TypeUtils$.MODULE$.toSQLId(f.name())), ClassTag$.MODULE$.apply(String.class))).mkString(", ");
                            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(missingFieldsStr))) {
                                throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableStructMissingFieldsError(tableName, context, missingFieldsStr);
                            }
                        } else if (writeFields.length > readFields.length) {
                            String extraFieldsStr = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])writeFields), writeFields.length - readFields.length)), (Function1 & Serializable)f -> String.valueOf(TypeUtils$.MODULE$.toSQLId(f.name())), ClassTag$.MODULE$.apply(String.class))).mkString(", ");
                            throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableExtraStructFieldsError(tableName, context, extraFieldsStr);
                        }
                        return fieldCompatible.elem;
                    }
                }
            }
            if (tuple2 != null) {
                DataType w2 = (DataType)tuple2._1();
                DataType r2 = (DataType)tuple2._2();
                if (w2 instanceof AtomicType) {
                    AtomicType atomicType = (AtomicType)w2;
                    if (r2 instanceof AtomicType) {
                        AtomicType atomicType2 = (AtomicType)r2;
                        Enumeration.Value value = storeAssignmentPolicy;
                        Enumeration.Value value2 = SQLConf$StoreAssignmentPolicy$.MODULE$.STRICT();
                        if (!(value != null ? !value.equals(value2) : value2 != null)) {
                            if (!Cast$.MODULE$.canUpCast((DataType)atomicType, (DataType)atomicType2)) {
                                throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableCannotSafelyCastError(tableName, context, atomicType.catalogString(), atomicType2.catalogString());
                            }
                            return true;
                        }
                    }
                }
            }
            if (tuple2 != null && tuple2._1() instanceof NullType) {
                Enumeration.Value value = storeAssignmentPolicy;
                Enumeration.Value value3 = SQLConf$StoreAssignmentPolicy$.MODULE$.ANSI();
                if (!(value != null ? !value.equals(value3) : value3 != null)) {
                    return true;
                }
            }
            if (tuple2 != null) {
                DataType w3 = (DataType)tuple2._1();
                DataType r3 = (DataType)tuple2._2();
                if (w3 instanceof AtomicType) {
                    AtomicType atomicType = (AtomicType)w3;
                    if (r3 instanceof AtomicType) {
                        AtomicType atomicType3 = (AtomicType)r3;
                        Enumeration.Value value = storeAssignmentPolicy;
                        Enumeration.Value value4 = SQLConf$StoreAssignmentPolicy$.MODULE$.ANSI();
                        if (!(value != null ? !value.equals(value4) : value4 != null)) {
                            if (!Cast$.MODULE$.canANSIStoreAssign((DataType)atomicType, (DataType)atomicType3)) {
                                throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableCannotSafelyCastError(tableName, context, atomicType.catalogString(), atomicType3.catalogString());
                            }
                            return true;
                        }
                    }
                }
            }
            if (tuple2 != null && this.sameType(w = (DataType)tuple2._1(), r = (DataType)tuple2._2()) && !(w instanceof NullType)) {
                return true;
            }
            if (tuple2 != null) {
                DataType w4 = (DataType)tuple2._1();
                DataType r4 = (DataType)tuple2._2();
                if (w4 instanceof UserDefinedType && !(r4 instanceof UserDefinedType)) {
                    read = r4;
                    write = ((UserDefinedType)w4).sqlType();
                    continue;
                }
            }
            if (tuple2 == null) break;
            DataType w5 = (DataType)tuple2._1();
            DataType r5 = (DataType)tuple2._2();
            if (!(r5 instanceof UserDefinedType) || w5 instanceof UserDefinedType) break;
            read = ((UserDefinedType)r5).sqlType();
            write = w5;
        }
        if (tuple2 != null) {
            DataType w = (DataType)tuple2._1();
            DataType r = (DataType)tuple2._2();
            throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableCannotSafelyCastError(tableName, context, w.catalogString(), r.catalogString());
        }
        throw new MatchError((Object)tuple2);
    }

    public AttributeReference toAttribute(StructField field) {
        String x$1 = field.name();
        DataType x$2 = field.dataType();
        boolean x$3 = field.nullable();
        Metadata x$4 = field.metadata();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public Seq<AttributeReference> toAttributes(StructType schema) {
        return (Seq)schema.map((Function1 & Serializable)field -> MODULE$.toAttribute((StructField)field));
    }

    public StructType fromAttributes(Seq<Attribute> attributes) {
        return StructType$.MODULE$.apply((Seq)attributes.map((Function1 & Serializable)a -> new StructField(a.name(), a.dataType(), a.nullable(), a.metadata())));
    }

    public DecimalType fromLiteral(Literal literal) {
        Object object = literal.value();
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return DecimalType$.MODULE$.fromDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply((int)s)));
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return DecimalType$.MODULE$.fromDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(n)));
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return DecimalType$.MODULE$.fromDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(l)));
        }
        return DecimalType$.MODULE$.forType(literal.dataType());
    }

    public Seq<Seq<String>> extractAllFieldPaths(StructType schema, Seq<String> basePath) {
        return (Seq)schema.flatMap((Function1 & Serializable)field -> {
            Seq fieldPath = (Seq)basePath.$colon$plus((Object)field.name());
            DataType dataType = field.dataType();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                Seq seq = fieldPath;
                return (IterableOnce)MODULE$.extractAllFieldPaths(structType, (Seq<String>)fieldPath).$plus$colon((Object)seq);
            }
            return new .colon.colon((Object)fieldPath, (List)Nil$.MODULE$);
        });
    }

    public Seq<String> extractAllFieldPaths$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Seq<Seq<String>> extractLeafFieldPaths(StructType schema, Seq<String> basePath) {
        return (Seq)schema.flatMap((Function1 & Serializable)field -> {
            Seq fieldPath = (Seq)basePath.$colon$plus((Object)field.name());
            DataType dataType = field.dataType();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                return MODULE$.extractLeafFieldPaths(structType, (Seq<String>)fieldPath);
            }
            return new .colon.colon((Object)fieldPath, (List)Nil$.MODULE$);
        });
    }

    public Seq<String> extractLeafFieldPaths$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public boolean areSameBaseType(StringType s1, StringType s2) {
        Tuple2 tuple2 = new Tuple2((Object)s1.constraint(), (Object)s2.constraint());
        if (tuple2 != null) {
            StringConstraint stringConstraint = (StringConstraint)tuple2._1();
            StringConstraint stringConstraint2 = (StringConstraint)tuple2._2();
            if (NoConstraint$.MODULE$.equals(stringConstraint) && NoConstraint$.MODULE$.equals(stringConstraint2)) {
                return true;
            }
        }
        if (tuple2 != null) {
            StringConstraint stringConstraint = (StringConstraint)tuple2._1();
            StringConstraint stringConstraint3 = (StringConstraint)tuple2._2();
            if (stringConstraint instanceof FixedLength && stringConstraint3 instanceof FixedLength) {
                return true;
            }
        }
        if (tuple2 != null) {
            StringConstraint stringConstraint = (StringConstraint)tuple2._1();
            StringConstraint stringConstraint4 = (StringConstraint)tuple2._2();
            if (stringConstraint instanceof MaxLength && stringConstraint4 instanceof MaxLength) {
                return true;
            }
        }
        return false;
    }

    public DataType replaceDefaultStringCharAndVarcharTypes(DataType dataType, String collation) {
        return dataType.transformRecursively((PartialFunction)new Serializable(collation){
            private static final long serialVersionUID = 0L;
            private final String collation$1;

            public final <A1 extends DataType, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                StringType stringType;
                VarcharType varcharType;
                CharType charType;
                A1 A1 = x1;
                if (A1 instanceof CharType && DataTypeUtils$.MODULE$.isDefaultStringCharOrVarcharType((DataType)(charType = (CharType)A1))) {
                    return (B1)CharType$.MODULE$.apply(charType.length(), this.collation$1);
                }
                if (A1 instanceof VarcharType && DataTypeUtils$.MODULE$.isDefaultStringCharOrVarcharType((DataType)(varcharType = (VarcharType)A1))) {
                    return (B1)VarcharType$.MODULE$.apply(varcharType.length(), this.collation$1);
                }
                if (A1 instanceof StringType && DataTypeUtils$.MODULE$.isDefaultStringCharOrVarcharType((DataType)(stringType = (StringType)A1))) {
                    return (B1)StringType$.MODULE$.apply(this.collation$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(DataType x1) {
                StringType stringType;
                VarcharType varcharType;
                CharType charType;
                DataType dataType = x1;
                if (dataType instanceof CharType && DataTypeUtils$.MODULE$.isDefaultStringCharOrVarcharType((DataType)(charType = (CharType)dataType))) {
                    return true;
                }
                if (dataType instanceof VarcharType && DataTypeUtils$.MODULE$.isDefaultStringCharOrVarcharType((DataType)(varcharType = (VarcharType)dataType))) {
                    return true;
                }
                return dataType instanceof StringType && DataTypeUtils$.MODULE$.isDefaultStringCharOrVarcharType((DataType)(stringType = (StringType)dataType));
            }
            {
                this.collation$1 = collation$1;
            }
        });
    }

    public boolean isDefaultStringCharOrVarcharType(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof CharType) {
            CharType charType = (CharType)dataType2;
            return charType.collation().isEmpty();
        }
        if (dataType2 instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType2;
            return varcharType.collation().isEmpty();
        }
        if (dataType2 instanceof StringType) {
            StringType stringType = (StringType)dataType2;
            return stringType == StringType$.MODULE$;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$equalsIgnoreCaseNullabilityAndCollation$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField l = (StructField)tuple2._1();
            StructField r = (StructField)tuple2._2();
            return l.name().equalsIgnoreCase(r.name()) && MODULE$.equalsIgnoreCaseNullabilityAndCollation(l.dataType(), r.dataType());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$canWrite$1(Function2 resolver$1, String context$1, String tableName$1, boolean byName$1, Enumeration.Value storeAssignmentPolicy$1, Function1 addError$1, BooleanRef fieldCompatible$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (tuple22 != null) {
                StructField rField = (StructField)tuple22._1();
                StructField wField = (StructField)tuple22._2();
                boolean nameMatch = BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)wField.name(), (Object)rField.name())) || MODULE$.isSparkGeneratedName(wField.name());
                String fieldContext = context$1 + "." + rField.name();
                boolean typesCompatible = MODULE$.canWrite(tableName$1, wField.dataType(), rField.dataType(), byName$1, (Function2<String, String, Object>)resolver$1, fieldContext, storeAssignmentPolicy$1, (Function1<String, BoxedUnit>)addError$1);
                if (byName$1 && !nameMatch) {
                    throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableUnexpectedColumnNameError(tableName$1, context$1, i, rField.name(), wField.name());
                }
                if (!rField.nullable() && wField.nullable()) {
                    throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableNullableColumnError(tableName$1, fieldContext);
                }
                if (!typesCompatible) {
                    fieldCompatible$1.elem = false;
                    return;
                }
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private DataTypeUtils$() {
    }
}

