/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.catalyst.expressions.Encode;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.CharsetProvider$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Encode$
implements Serializable {
    public static final Encode$ MODULE$ = new Encode$();

    public Encode apply(Expression value, Expression charset) {
        return new Encode(value, charset);
    }

    public byte[] encode(UTF8String input, UTF8String charset, boolean legacyCharsets, boolean legacyErrorAction) {
        byte[] byArray;
        String toCharset = charset.toString();
        if ("UTF-8".equalsIgnoreCase(toCharset) && input.isValid()) {
            return input.getBytes();
        }
        CharsetEncoder encoder = CharsetProvider$.MODULE$.newEncoder(toCharset, legacyCharsets, legacyErrorAction, CharsetProvider$.MODULE$.newEncoder$default$4());
        if (input.numBytes() == 0) {
            return input.getBytes();
        }
        try {
            ByteBuffer bb = encoder.encode(CharBuffer.wrap(input.toString()));
            byArray = JavaUtils.bufferToArray((ByteBuffer)bb);
        }
        catch (CharacterCodingException characterCodingException) {
            throw QueryExecutionErrors$.MODULE$.malformedCharacterCoding("encode", toCharset);
        }
        return byArray;
    }

    public Encode apply(Expression str, Expression charset, boolean legacyCharsets, boolean legacyErrorAction) {
        return new Encode(str, charset, legacyCharsets, legacyErrorAction);
    }

    public Option<Tuple4<Expression, Expression, Object, Object>> unapply(Encode x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.str(), (Object)x$0.charset(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.legacyCharsets()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.legacyErrorAction())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Encode$.class);
    }

    private Encode$() {
    }
}

