/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.DeleteResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ListResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ResetProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.spark.ErrorMessageFormat$;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkThrowableHelper$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.apache.spark.util.SparkExitCode$;
import org.apache.spark.util.SparkStringUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@ScalaSignature(bytes="\u0006\u0005\u0005UvA\u0002\u0011\"\u0011\u0003\u0019SF\u0002\u00040C!\u00051\u0005\r\u0005\u0006{\u0005!\ta\u0010\u0005\b\u0001\u0006\u0011\r\u0011\"\u0003B\u0011\u0019Q\u0015\u0001)A\u0005\u0005\"91*\u0001b\u0001\n\u0013a\u0005BB,\u0002A\u0003%Q\nC\u0004Y\u0003\t\u0007IQB-\t\ru\u000b\u0001\u0015!\u0004[\u0011\u001dq\u0016\u00011A\u0005\n}CqaY\u0001A\u0002\u0013%A\r\u0003\u0004k\u0003\u0001\u0006K\u0001\u0019\u0005\u0006W\u0006!\t\u0001\u001c\u0005\u0006[\u0006!\tA\u001c\u0005\u0006c\u0006!\tA\u001d\u0005\u0006q\u0006!\t\u0001\u001c\u0005\u0006s\u0006!IA\u001f\u0005\b\u0003#\tA\u0011BA\n\r\u0019y\u0013\u0005A\u0012\u0002,!1QH\u0005C\u0001\u0003sA\u0011\"!\u0010\u0013\u0005\u0004%I!a\u0010\t\u000f\u0005\u0005#\u0003)A\u0005{\"I\u0011\u0011\u0005\nC\u0002\u0013%\u00111\t\u0005\t\u0003'\u0012\u0002\u0015!\u0003\u0002F!I\u0011Q\u000b\nC\u0002\u0013%\u0011q\u000b\u0005\t\u0003G\u0012\u0002\u0015!\u0003\u0002Z!9\u0011Q\r\n\u0005B\u0005\u001d\u0004BBA=%\u0011\u0005A\u000eC\u0004\u0002|I!\t%! \t\u000f\u0005\r%\u0003\"\u0011\u0002\u0006\"9\u0011q\u0013\n\u0005B\u0005e\u0005\u0002CAU%\u0011\u00051%a+\u0002#M\u0003\u0018M]6T#2\u001bE*\u0013#sSZ,'O\u0003\u0002#G\u0005aA\u000f\u001b:jMR\u001cXM\u001d<fe*\u0011A%J\u0001\u0005Q&4XM\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u0004\"AL\u0001\u000e\u0003\u0005\u0012\u0011c\u00159be.\u001c\u0016\u000bT\"M\u0013\u0012\u0013\u0018N^3s'\r\t\u0011g\u000e\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005aZT\"A\u001d\u000b\u0005i:\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005qJ$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tQ&\u0001\u0004qe>l\u0007\u000f^\u000b\u0002\u0005B\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u0005Y\u0006twMC\u0001H\u0003\u0011Q\u0017M^1\n\u0005%#%AB*ue&tw-A\u0004qe>l\u0007\u000f\u001e\u0011\u0002\u001f\r|g\u000e^5ok\u0016$\u0007K]8naR,\u0012!\u0014\t\u0003\u001dVs!aT*\u0011\u0005A\u001bT\"A)\u000b\u0005Is\u0014A\u0002\u001fs_>$h(\u0003\u0002Ug\u00051\u0001K]3eK\u001aL!!\u0013,\u000b\u0005Q\u001b\u0014\u0001E2p]RLg.^3e!J|W\u000e\u001d;!\u0003a\u0019\u0006+\u0011*L?\"\u000bEiT(Q?B\u0013v\nU0Q%\u00163\u0015\nW\u000b\u00025>\t1,I\u0001]\u00035\u0019\b/\u0019:l]!\fGm\\8q]\u0005I2\u000bU!S\u0017~C\u0015\tR(P!~\u0003&k\u0014)`!J+e)\u0013-!\u0003!)\u00070\u001b;D_\u0012,W#\u00011\u0011\u0005I\n\u0017B\u000124\u0005\rIe\u000e^\u0001\rKbLGoQ8eK~#S-\u001d\u000b\u0003K\"\u0004\"A\r4\n\u0005\u001d\u001c$\u0001B+oSRDq!\u001b\u0006\u0002\u0002\u0003\u0007\u0001-A\u0002yIE\n\u0011\"\u001a=ji\u000e{G-\u001a\u0011\u0002)%t7\u000f^1mYNKwM\\1m\u0011\u0006tG\r\\3s)\u0005)\u0017\u0001B3ySR$\"!Z8\t\u000bAl\u0001\u0019\u00011\u0002\t\r|G-Z\u0001\u0005[\u0006Lg\u000e\u0006\u0002fg\")AO\u0004a\u0001k\u0006!\u0011M]4t!\r\u0011d/T\u0005\u0003oN\u0012Q!\u0011:sCf\f!\u0002\u001d:j]R,6/Y4f\u0003y\u0019Gn\\:f\u0011&4XmU3tg&|gn\u0015;bi\u0016Lem\u0015;beR,G\r\u0006\u0002fw\")A\u0010\u0005a\u0001{\u0006)1\u000f^1uKB\u0019a0!\u0004\u000e\u0003}TA!!\u0001\u0002\u0004\u000591/Z:tS>t'\u0002BA\u0003\u0003\u000f\t!!\u001d7\u000b\u0007\u0011\nIAC\u0002\u0002\f%\na\u0001[1e_>\u0004\u0018bAA\b\u007f\na1+Z:tS>t7\u000b^1uK\u0006\u0019r-\u001a;D_6l\u0017M\u001c3D_6\u0004H.\u001a;feR\u0011\u0011Q\u0003\t\u0005eY\f9\u0002\u0005\u0003\u0002\u001a\u0005\u001dRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0013\r|W\u000e\u001d7fi\u0016\u0014(\u0002BA\u0011\u0003G\tqaY8og>dWM\u0003\u0002\u0002&\u0005)!\u000e\\5oK&!\u0011\u0011FA\u000e\u0005%\u0019u.\u001c9mKR,'o\u0005\u0003\u0013\u0003[9\u0004\u0003BA\u0018\u0003ki!!!\r\u000b\t\u0005M\u0012qA\u0001\u0004G2L\u0017\u0002BA\u001c\u0003c\u0011\u0011b\u00117j\tJLg/\u001a:\u0015\u0005\u0005m\u0002C\u0001\u0018\u0013\u00031\u0019Xm]:j_:\u001cF/\u0019;f+\u0005i\u0018!D:fgNLwN\\*uCR,\u0007%\u0006\u0002\u0002FA!\u0011qIA'\u001d\rq\u0018\u0011J\u0005\u0004\u0003\u0017z\u0018\u0001D*fgNLwN\\*uCR,\u0017\u0002BA(\u0003#\u0012\u0011\u0002T8h\u0011\u0016d\u0007/\u001a:\u000b\u0007\u0005-s0\u0001\u0005d_:\u001cx\u000e\\3!\u0003\u0011\u0019wN\u001c4\u0016\u0005\u0005e\u0003\u0003BA.\u0003?j!!!\u0018\u000b\t\u0005U\u0013\u0011B\u0005\u0005\u0003C\niFA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0006G>tg\rI\u0001\u0011g\u0016$\b*\u001b<f-\u0006\u0014\u0018.\u00192mKN$2!ZA5\u0011\u001d\tYG\u0007a\u0001\u0003[\nQ\u0002[5wKZ\u000b'/[1cY\u0016\u001c\bCBA8\u0003kjU*\u0004\u0002\u0002r)\u0019\u00111\u000f$\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003o\n\tHA\u0002NCB\f1\u0003\u001d:j]Rl\u0015m\u001d;fe\u0006sG-\u00119q\u0013\u0012\f!\u0002\u001d:pG\u0016\u001c8oQ7e)\r\u0001\u0017q\u0010\u0005\u0007\u0003\u0003c\u0002\u0019A'\u0002\u0007\rlG-A\u0007qe>\u001cWm]:SK\u0006$WM\u001d\u000b\u0004A\u0006\u001d\u0005bBAE;\u0001\u0007\u00111R\u0001\u0002eB!\u0011QRAJ\u001b\t\tyIC\u0002\u0002\u0012\u001a\u000b!![8\n\t\u0005U\u0015q\u0012\u0002\u000f\u0005V4g-\u001a:fIJ+\u0017\rZ3s\u0003-\u0001(o\\2fgNd\u0015N\\3\u0015\u000b\u0001\fY*a(\t\r\u0005ue\u00041\u0001N\u0003\u0011a\u0017N\\3\t\u000f\u0005\u0005f\u00041\u0001\u0002$\u0006\t\u0012\r\u001c7po&sG/\u001a:skB$\u0018N\\4\u0011\u0007I\n)+C\u0002\u0002(N\u0012qAQ8pY\u0016\fg.\u0001\bta2LGoU3nS\u000e{Gn\u001c8\u0015\t\u00055\u00161\u0017\t\u0006\u0003_\ny+T\u0005\u0005\u0003c\u000b\tH\u0001\u0003MSN$\bBBAO?\u0001\u0007Q\n")
public class SparkSQLCLIDriver
extends CliDriver
implements Logging {
    private final SessionState sessionState;
    private final SessionState.LogHelper org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console;
    private final Configuration conf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void printUsage() {
        SparkSQLCLIDriver$.MODULE$.printUsage();
    }

    public static void main(String[] args) {
        SparkSQLCLIDriver$.MODULE$.main(args);
    }

    public static void exit(int code) {
        SparkSQLCLIDriver$.MODULE$.exit(code);
    }

    public static void installSignalHandler() {
        SparkSQLCLIDriver$.MODULE$.installSignalHandler();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SessionState sessionState() {
        return this.sessionState;
    }

    public SessionState.LogHelper org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console() {
        return this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console;
    }

    private Configuration conf() {
        return this.conf;
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        CollectionConverters$.MODULE$.MapHasAsScala(hiveVariables).asScala().foreach((Function1 & Serializable)kv -> {
            SparkSQLCLIDriver.$anonfun$setHiveVariables$1(kv);
            return BoxedUnit.UNIT;
        });
    }

    public void printMasterAndAppId() {
        String master = SparkSQLEnv$.MODULE$.sparkContext().master();
        String appId = SparkSQLEnv$.MODULE$.sparkContext().applicationId();
        SparkSQLEnv$.MODULE$.sparkContext().uiWebUrl().foreach((Function1 & Serializable)webUrl -> {
            SparkSQLCLIDriver.$anonfun$printMasterAndAppId$1(this, webUrl);
            return BoxedUnit.UNIT;
        });
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Spark master: " + master + ", Application Id: " + appId);
    }

    public int processCmd(String cmd) {
        int ret;
        block19: {
            String cmd_trimmed = cmd.trim();
            String cmd_lower = cmd_trimmed.toLowerCase(Locale.ROOT);
            String[] tokens = cmd_trimmed.split("\\s+");
            String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
            if (cmd_lower.equals("quit") || cmd_lower.equals("exit")) {
                SparkSQLCLIDriver$.MODULE$.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$closeHiveSessionStateIfStarted(this.sessionState());
                SparkSQLCLIDriver$.MODULE$.exit(SparkExitCode$.MODULE$.EXIT_SUCCESS());
            }
            if (tokens[0].toLowerCase(Locale.ROOT).equals("source") || cmd_trimmed.startsWith("!")) {
                long startTimeNs = System.nanoTime();
                super.processCmd(cmd);
                long endTimeNs = System.nanoTime();
                double timeTaken = (double)TimeUnit.NANOSECONDS.toMillis(endTimeNs - startTimeNs) / 1000.0;
                this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Time taken: " + timeTaken + " seconds");
                return 0;
            }
            ret = 0;
            HiveConf hconf = (HiveConf)this.conf();
            CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)hconf);
            if (proc == null) break block19;
            if (proc instanceof Driver || proc instanceof SetProcessor || proc instanceof AddResourceProcessor || proc instanceof ListResourceProcessor || proc instanceof DeleteResourceProcessor || proc instanceof ResetProcessor) {
                SparkSQLDriver driver = new SparkSQLDriver(SparkSQLDriver$.MODULE$.$lessinit$greater$default$1());
                driver.init();
                PrintStream out = this.sessionState().out;
                PrintStream err = this.sessionState().err;
                long startTimeNs = System.nanoTime();
                if (this.sessionState().getIsVerbose()) {
                    out.println(cmd);
                }
                try {
                    driver.run(cmd);
                }
                catch (Throwable t) {
                    boolean shouldPrintStackTrace;
                    String string;
                    ret = 1;
                    Enumeration.Value format = SparkSQLEnv$.MODULE$.sparkSession().sessionState().conf().errorMessageFormat();
                    Throwable throwable = t;
                    if (throwable instanceof SparkThrowable) {
                        Throwable throwable2 = throwable;
                        string = SparkThrowableHelper$.MODULE$.getMessage(throwable2, format);
                    } else {
                        string = t.getMessage();
                    }
                    String msg = string;
                    err.println(msg);
                    Enumeration.Value value = format;
                    Enumeration.Value value2 = ErrorMessageFormat$.MODULE$.DEBUG();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        v2 = true;
                    } else {
                        Throwable throwable3;
                        String sqlState;
                        Throwable throwable4;
                        Enumeration.Value value4 = ErrorMessageFormat$.MODULE$.PRETTY();
                        Enumeration.Value value5 = value;
                        v2 = !(value4 != null ? !value4.equals(value5) : value5 != null) ? ((throwable4 = t) instanceof SparkThrowable ? (sqlState = ((SparkThrowable)(throwable3 = throwable4)).getSqlState()) == null || sqlState.startsWith("XX") : true) : (shouldPrintStackTrace = false);
                    }
                    if (shouldPrintStackTrace && !this.sessionState().getIsSilent()) {
                        t.printStackTrace(err);
                    }
                    driver.close();
                    return ret;
                }
                long endTimeNs = System.nanoTime();
                double timeTaken = (double)TimeUnit.NANOSECONDS.toMillis(endTimeNs - startTimeNs) / 1000.0;
                ArrayList res = new ArrayList();
                if (HiveConf.getBoolVar((Configuration)this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER) || SparkSQLEnv$.MODULE$.sparkSession().sessionState().conf().cliPrintHeader()) {
                    Option$.MODULE$.apply((Object)driver.getSchema().getFieldSchemas()).foreach((Function1 & Serializable)fields -> {
                        out.println(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(fields).asScala().map((Function1 & Serializable)x$6 -> x$6.getName())).mkString("\t"));
                        return BoxedUnit.UNIT;
                    });
                }
                IntRef counter = IntRef.create((int)0);
                try {
                    while (!out.checkError() && driver.getResults(res)) {
                        CollectionConverters$.MODULE$.ListHasAsScala(res).asScala().foreach((Function1 & Serializable)l -> {
                            SparkSQLCLIDriver.$anonfun$processCmd$3(counter, out, l);
                            return BoxedUnit.UNIT;
                        });
                        res.clear();
                    }
                }
                catch (IOException e) {
                    err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Failed with exception " + e.getClass().getName() + ": " + e.getMessage() + "\n                   |" + Utils$.MODULE$.stringifyException((Throwable)e) + "\n                 ")));
                    ret = 1;
                }
                int cret = driver.close();
                if (ret == 0) {
                    ret = cret;
                }
                String responseMsg = "Time taken: " + timeTaken + " seconds";
                if (counter.elem != 0) {
                    responseMsg = responseMsg + ", Fetched " + counter.elem + " row(s)";
                }
                err.println(responseMsg);
                driver.destroy();
            } else {
                if (this.sessionState().getIsVerbose()) {
                    this.sessionState().out.println(tokens[0] + " " + cmd_1);
                }
                ret = proc.run(cmd_1).getResponseCode();
            }
        }
        return ret;
    }

    public int processReader(BufferedReader r) {
        StringBuilder qsb = new StringBuilder();
        String line = r.readLine();
        while (line != null) {
            Object object = !line.trim().startsWith("--") ? qsb.append(line + "\n") : BoxedUnit.UNIT;
            line = r.readLine();
        }
        return this.processLine(qsb.toString());
    }

    public int processLine(String line, boolean allowInterrupting) {
        int n;
        Object object = new Object();
        try {
            SignalHandler oldSignal = null;
            Signal interruptSignal = null;
            if (allowInterrupting) {
                interruptSignal = new Signal("INT");
                oldSignal = Signal.handle(interruptSignal, new SignalHandler(this){
                    private boolean interruptRequested;
                    private final /* synthetic */ SparkSQLCLIDriver $outer;

                    private boolean interruptRequested() {
                        return this.interruptRequested;
                    }

                    private void interruptRequested_$eq(boolean x$1) {
                        this.interruptRequested = x$1;
                    }

                    public void handle(Signal signal) {
                        boolean initialRequest = !this.interruptRequested();
                        this.interruptRequested_$eq(true);
                        if (!initialRequest) {
                            this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Exiting the JVM");
                            SparkSQLCLIDriver$.MODULE$.exit(SparkExitCode$.MODULE$.ERROR_COMMAND_NOT_FOUND());
                        }
                        this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Interrupting... Be patient, this might take some time.");
                        this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Press Ctrl+C again to kill JVM");
                        HiveInterruptUtils.interrupt();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.interruptRequested = false;
                    }
                });
            }
            try {
                IntRef lastRet = IntRef.create((int)0);
                Buffer commands = CollectionConverters$.MODULE$.ListHasAsScala(this.splitSemiColon(line)).asScala();
                ObjectRef command = ObjectRef.create((Object)"");
                commands.foreach((Function1 & Serializable)oneCmd -> {
                    SparkSQLCLIDriver.$anonfun$processLine$1(this, command, lastRet, object, oneCmd);
                    return BoxedUnit.UNIT;
                });
                CommandProcessorFactory.clean((HiveConf)((HiveConf)this.conf()));
                n = lastRet.elem;
            }
            catch (Throwable throwable) {
                if (oldSignal != null && interruptSignal != null) {
                    Signal.handle(interruptSignal, oldSignal);
                }
                throw throwable;
            }
            if (oldSignal != null && interruptSignal != null) {
                Signal.handle(interruptSignal, oldSignal);
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    public List<String> splitSemiColon(String line) {
        BooleanRef insideSingleQuote = BooleanRef.create((boolean)false);
        BooleanRef insideDoubleQuote = BooleanRef.create((boolean)false);
        BooleanRef insideSimpleComment = BooleanRef.create((boolean)false);
        IntRef bracketedCommentLevel = IntRef.create((int)0);
        BooleanRef escape = BooleanRef.create((boolean)false);
        IntRef beginIndex = IntRef.create((int)0);
        BooleanRef leavingBracketedComment = BooleanRef.create((boolean)false);
        BooleanRef isStatement = BooleanRef.create((boolean)false);
        ArrayList<String> ret = new ArrayList<String>();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), line.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            if (leavingBracketedComment$1.elem) {
                --bracketedCommentLevel$1.elem;
                leavingBracketedComment$1.elem = false;
            }
            if (line.charAt(index) == '\'' && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel)) {
                if (!escape$1.elem && !insideDoubleQuote$1.elem) {
                    insideSingleQuote$1.elem = !insideSingleQuote$1.elem;
                }
            } else if (line.charAt(index) == '\"' && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel)) {
                if (!escape$1.elem && !insideSingleQuote$1.elem) {
                    insideDoubleQuote$1.elem = !insideDoubleQuote$1.elem;
                }
            } else if (line.charAt(index) == '-') {
                boolean hasNext;
                boolean bl = hasNext = index + 1 < line.length();
                if (!insideDoubleQuote$1.elem && !insideSingleQuote$1.elem && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel) && hasNext && line.charAt(index + 1) == '-') {
                    insideSimpleComment$1.elem = true;
                }
            } else if (line.charAt(index) == ';') {
                if (!(insideSingleQuote$1.elem || insideDoubleQuote$1.elem || SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel))) {
                    Object object = isStatement$1.elem ? BoxesRunTime.boxToBoolean((boolean)ret.add(line.substring(beginIndex$1.elem, index))) : BoxedUnit.UNIT;
                    beginIndex$1.elem = index + 1;
                    isStatement$1.elem = false;
                }
            } else if (line.charAt(index) == '\n') {
                if (!escape$1.elem) {
                    insideSimpleComment$1.elem = false;
                }
            } else if (line.charAt(index) == '/' && !insideSimpleComment$1.elem) {
                boolean hasNext;
                boolean bl = hasNext = index + 1 < line.length();
                if (!insideSingleQuote$1.elem && !insideDoubleQuote$1.elem) {
                    if (SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel) && line.charAt(index - 1) == '*') {
                        leavingBracketedComment$1.elem = true;
                    } else if (hasNext && line.charAt(index + 1) == '*') {
                        ++bracketedCommentLevel$1.elem;
                    }
                }
            }
            if (escape$1.elem) {
                escape$1.elem = false;
            } else if (line.charAt(index) == '\\') {
                escape$1.elem = true;
            }
            isStatement$1.elem = SparkSQLCLIDriver.statementInProgress$1(index, isStatement, beginIndex, line, insideSimpleComment, bracketedCommentLevel);
        });
        boolean endOfBracketedComment = leavingBracketedComment.elem && bracketedCommentLevel.elem == 1;
        Object object = !endOfBracketedComment && (isStatement.elem || SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel)) ? BoxesRunTime.boxToBoolean((boolean)ret.add(line.substring(beginIndex.elem))) : BoxedUnit.UNIT;
        return ret;
    }

    public static final /* synthetic */ void $anonfun$setHiveVariables$1(Tuple2 kv) {
        SparkSQLEnv$.MODULE$.sparkSession().sessionState().conf().setConfString((String)kv._1(), (String)kv._2());
    }

    public static final /* synthetic */ void $anonfun$printMasterAndAppId$1(SparkSQLCLIDriver $this, String webUrl) {
        $this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Spark Web UI available at " + webUrl);
    }

    public static final /* synthetic */ void $anonfun$processCmd$3(IntRef counter$1, PrintStream out$1, String l) {
        ++counter$1.elem;
        out$1.println(l);
    }

    public static final /* synthetic */ void $anonfun$processLine$1(SparkSQLCLIDriver $this, ObjectRef command$1, IntRef lastRet$1, Object nonLocalReturnKey1$1, String oneCmd) {
        if (oneCmd.endsWith("\\")) {
            command$1.elem = (String)command$1.elem + StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(oneCmd), 1) + ";";
            return;
        }
        command$1.elem = (String)command$1.elem + oneCmd;
        if (!SparkStringUtils$.MODULE$.isBlank((String)command$1.elem)) {
            int ret = $this.processCmd((String)command$1.elem);
            command$1.elem = "";
            lastRet$1.elem = ret;
            boolean ignoreErrors = HiveConf.getBoolVar((Configuration)$this.conf(), (HiveConf.ConfVars)HiveConf.getConfVars((String)"hive.cli.errors.ignore"));
            if (ret != 0 && !ignoreErrors) {
                CommandProcessorFactory.clean((HiveConf)((HiveConf)$this.conf()));
                throw new NonLocalReturnControl.mcI.sp(nonLocalReturnKey1$1, ret);
            }
            return;
        }
    }

    private static final boolean insideBracketedComment$1(IntRef bracketedCommentLevel$1) {
        return bracketedCommentLevel$1.elem > 0;
    }

    private static final boolean insideComment$1(BooleanRef insideSimpleComment$1, IntRef bracketedCommentLevel$1) {
        return insideSimpleComment$1.elem || SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel$1);
    }

    private static final boolean statementInProgress$1(int index, BooleanRef isStatement$1, IntRef beginIndex$1, String line$1, BooleanRef insideSimpleComment$1, IntRef bracketedCommentLevel$1) {
        return isStatement$1.elem || !SparkSQLCLIDriver.insideComment$1(insideSimpleComment$1, bracketedCommentLevel$1) && index > beginIndex$1.elem && !String.valueOf(BoxesRunTime.boxToCharacter((char)line$1.charAt(index))).trim().isEmpty();
    }

    public SparkSQLCLIDriver() {
        block0: {
            Logging.$init$((Logging)this);
            this.sessionState = SessionState.get();
            this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console = new SessionState.LogHelper(this.log());
            this.conf = this.sessionState().getConf();
            SparkSQLEnv$.MODULE$.init();
            if (!this.sessionState().getIsSilent()) break block0;
            SparkSQLEnv$.MODULE$.sparkContext().setLogLevel("warn");
        }
    }
}

